/*
 * Decompiled with CFR 0.152.
 */
package kamon.instrumentation.kafka.client;

import com.typesafe.config.Config;
import kamon.Kamon$;
import kamon.context.Context;
import kamon.context.Storage;
import kamon.instrumentation.kafka.client.ConsumedRecordData;
import kamon.instrumentation.kafka.client.KafkaInstrumentation;
import kamon.instrumentation.kafka.client.KafkaInstrumentation$Syntax$;
import kamon.trace.Span;
import kamon.trace.Span$;
import kamon.trace.SpanBuilder;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Serializable;
import scala.runtime.BoxedUnit;
import scala.util.control.NonFatal$;

public final class KafkaInstrumentation$ {
    public static final KafkaInstrumentation$ MODULE$;
    private volatile KafkaInstrumentation.Settings kamon$instrumentation$kafka$client$KafkaInstrumentation$$_settings;

    static {
        new KafkaInstrumentation$();
    }

    private KafkaInstrumentation.Settings kamon$instrumentation$kafka$client$KafkaInstrumentation$$_settings() {
        return this.kamon$instrumentation$kafka$client$KafkaInstrumentation$$_settings;
    }

    public void kamon$instrumentation$kafka$client$KafkaInstrumentation$$_settings_$eq(KafkaInstrumentation.Settings x$1) {
        this.kamon$instrumentation$kafka$client$KafkaInstrumentation$$_settings = x$1;
    }

    public KafkaInstrumentation.Settings settings() {
        return this.kamon$instrumentation$kafka$client$KafkaInstrumentation$$_settings();
    }

    public KafkaInstrumentation.Settings kamon$instrumentation$kafka$client$KafkaInstrumentation$$readSettings(Config config) {
        Config kafkaConfig = config.getConfig("kamon.instrumentation.kafka.client");
        return new KafkaInstrumentation.Settings(kafkaConfig.getBoolean("tracing.start-trace-on-producer"), kafkaConfig.getBoolean("tracing.continue-trace-on-consumer"), kafkaConfig.getBoolean("tracing.use-delayed-spans"));
    }

    public <K, V> Context extractContext(ConsumerRecord<K, V> consumerRecord) {
        return KafkaInstrumentation$Syntax$.MODULE$.context$extension(this.Syntax(consumerRecord));
    }

    public ConsumerRecord<?, ?> Syntax(ConsumerRecord<?, ?> cr) {
        return cr;
    }

    public <T> T runWithConsumerSpan(ConsumerRecord<?, ?> record2, Function0<T> f) {
        return this.runWithConsumerSpan(record2, "consumer.process", true, f);
    }

    public <T> T runWithConsumerSpan(ConsumerRecord<?, ?> record2, String operationName2, Function0<T> f) {
        return this.runWithConsumerSpan(record2, operationName2, true, f);
    }

    /*
     * WARNING - void declaration
     */
    public <T> T runWithConsumerSpan(ConsumerRecord<?, ?> record2, String operationName2, boolean finishSpan, Function0<T> f) {
        Object object;
        Storage.Scope scope;
        block6: {
            Context incomingContext = KafkaInstrumentation$Syntax$.MODULE$.context$extension(this.Syntax(record2));
            Context operationContext = incomingContext.nonEmpty() ? incomingContext : Kamon$.MODULE$.currentContext();
            Span span = this.consumerSpan(record2, operationName2);
            scope = Kamon$.MODULE$.storeContext(operationContext.withEntry(Span$.MODULE$.Key(), (Object)span));
            try {
                object = f.apply();
                if (!finishSpan) break block6;
            }
            catch (Throwable throwable) {
                void var7_7;
                try {
                    Throwable throwable2 = throwable;
                    Option option = NonFatal$.MODULE$.unapply(throwable2);
                    if (option.isEmpty()) {
                        throw throwable;
                    }
                    Throwable t = (Throwable)option.get();
                    var7_7.fail(t.getMessage(), t);
                    throw t;
                }
                catch (Throwable throwable3) {
                    void var8_8;
                    if (finishSpan) {
                        var7_7.finish();
                    }
                    var8_8.close();
                    throw throwable3;
                }
            }
            span.finish();
        }
        scope.close();
        return (T)object;
    }

    public Span consumerSpan(ConsumerRecord<?, ?> record2) {
        return this.consumerSpan(record2, "consumer.process");
    }

    public Span consumerSpan(ConsumerRecord<?, ?> record2, String operationName2) {
        Object object;
        SpanBuilder consumerSpan2 = Kamon$.MODULE$.consumerSpanBuilder(operationName2, "kafka.consumer").tag("kafka.topic", record2.topic()).tag("kafka.partition", (long)record2.partition()).tag("kafka.offset", record2.offset()).tag("kafka.timestamp", record2.timestamp()).tag("kafka.timestamp-type", record2.timestampType().name);
        Option$.MODULE$.apply(record2.key()).foreach((Function1)new Serializable(consumerSpan2){
            public static final long serialVersionUID = 0L;
            private final SpanBuilder consumerSpan$1;

            public final SpanBuilder apply(Object k) {
                return this.consumerSpan$1.tag("kafka.key", k.toString());
            }
            {
                this.consumerSpan$1 = consumerSpan$1;
            }
        });
        if (record2 instanceof ConsumedRecordData) {
            ConsumedRecordData consumerRecordData = (ConsumedRecordData)record2;
            Context incomingContext = consumerRecordData.incomingContext();
            Span incomingSpan = (Span)incomingContext.get(Span$.MODULE$.Key());
            consumerSpan2.tag("kafka.group-id", (String)consumerRecordData.consumerInfo().groupId().getOrElse((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "unknown";
                }
            })).tag("kafka.client-id", consumerRecordData.consumerInfo().clientId()).tag("kafka.poll-time", consumerRecordData.nanosSincePollStart());
            object = incomingSpan.isEmpty() ? BoxedUnit.UNIT : (this.settings().continueTraceOnConsumer() ? consumerSpan2.asChildOf(incomingSpan) : consumerSpan2.link(incomingSpan, (Span.Link$.Kind)Span.Link$.Kind$.FollowsFrom$.MODULE$));
        } else {
            object = BoxedUnit.UNIT;
        }
        return this.settings().useDelayedSpans() ? consumerSpan2.delay(Kamon$.MODULE$.clock().toInstant(record2.timestamp() * 1000000L)).start() : consumerSpan2.start();
    }

    private KafkaInstrumentation$() {
        MODULE$ = this;
        this.kamon$instrumentation$kafka$client$KafkaInstrumentation$$_settings = this.kamon$instrumentation$kafka$client$KafkaInstrumentation$$readSettings(Kamon$.MODULE$.config());
        Kamon$.MODULE$.onReconfigure((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(Config newConfig) {
                KafkaInstrumentation$.MODULE$.kamon$instrumentation$kafka$client$KafkaInstrumentation$$_settings_$eq(KafkaInstrumentation$.MODULE$.kamon$instrumentation$kafka$client$KafkaInstrumentation$$readSettings(newConfig));
            }
        });
    }
}

