/*
 * Decompiled with CFR 0.152.
 */
package kamon.instrumentation.system.host;

import com.typesafe.config.Config;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import kamon.Kamon$;
import kamon.instrumentation.system.host.HostMetrics;
import kamon.module.Module;
import kamon.module.ModuleFactory;
import kamon.module.ScheduledAction;
import kamon.tag.TagSet;
import kamon.tag.TagSet$;
import kamon.util.Filter;
import kamon.util.Filter$;
import oshi.SystemInfo;
import oshi.hardware.CentralProcessor;
import oshi.hardware.GlobalMemory;
import oshi.hardware.HWDiskStore;
import oshi.hardware.HardwareAbstractionLayer;
import oshi.hardware.NetworkIF;
import oshi.software.os.OSFileStore;
import oshi.software.os.OperatingSystem;
import scala.Array$;
import scala.Function1;
import scala.Product;
import scala.Serializable;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.concurrent.ExecutionContext;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\rmf\u0001B\u0001\u0003\u0001-\u0011A\u0003S8ti6+GO]5dg\u000e{G\u000e\\3di>\u0014(BA\u0002\u0005\u0003\u0011Awn\u001d;\u000b\u0005\u00151\u0011AB:zgR,WN\u0003\u0002\b\u0011\u0005y\u0011N\\:ueVlWM\u001c;bi&|gNC\u0001\n\u0003\u0015Y\u0017-\\8o\u0007\u0001\u00192\u0001\u0001\u0007\u0013!\ti\u0001#D\u0001\u000f\u0015\u0005y\u0011!B:dC2\f\u0017BA\t\u000f\u0005\u0019\te.\u001f*fMB\u00111CF\u0007\u0002))\u0011Q\u0003C\u0001\u0007[>$W\u000f\\3\n\u0005]!\"aD*dQ\u0016$W\u000f\\3e\u0003\u000e$\u0018n\u001c8\t\u0011e\u0001!\u0011!Q\u0001\ni\t!!Z2\u0011\u0005mqR\"\u0001\u000f\u000b\u0005uq\u0011AC2p]\u000e,(O]3oi&\u0011q\u0004\b\u0002\u0011\u000bb,7-\u001e;j_:\u001cuN\u001c;fqRDQ!\t\u0001\u0005\u0002\t\na\u0001P5oSRtDCA\u0012&!\t!\u0003!D\u0001\u0003\u0011\u0015I\u0002\u00051\u0001\u001b\u0011\u001d9\u0003A1A\u0005\n!\n1bX2p]\u001aLw\rU1uQV\t\u0011\u0006\u0005\u0002+_5\t1F\u0003\u0002-[\u0005!A.\u00198h\u0015\u0005q\u0013\u0001\u00026bm\u0006L!\u0001M\u0016\u0003\rM#(/\u001b8h\u0011\u0019\u0011\u0004\u0001)A\u0005S\u0005aqlY8oM&<\u0007+\u0019;iA!9A\u0007\u0001a\u0001\n\u0013)\u0014aE0mCN$\u0018J\u001c4sKF,XM\u001c;US\u000e\\W#\u0001\u001c\u0011\u0005]RT\"\u0001\u001d\u000b\u0005ej\u0013\u0001\u0002;j[\u0016L!a\u000f\u001d\u0003\u000f%s7\u000f^1oi\"9Q\b\u0001a\u0001\n\u0013q\u0014aF0mCN$\u0018J\u001c4sKF,XM\u001c;US\u000e\\w\fJ3r)\ty$\t\u0005\u0002\u000e\u0001&\u0011\u0011I\u0004\u0002\u0005+:LG\u000fC\u0004Dy\u0005\u0005\t\u0019\u0001\u001c\u0002\u0007a$\u0013\u0007\u0003\u0004F\u0001\u0001\u0006KAN\u0001\u0015?2\f7\u000f^%oMJ,\u0017/^3oiRK7m\u001b\u0011\t\u000f\u001d\u0003\u0001\u0019!C\u0005\u0011\u0006Iql]3ui&twm]\u000b\u0002\u0013B\u0011!j\u001b\b\u0003I-;Q\u0001\u0014\u0002\t\u00025\u000bA\u0003S8ti6+GO]5dg\u000e{G\u000e\\3di>\u0014\bC\u0001\u0013O\r\u0015\t!\u0001#\u0001P'\tqE\u0002C\u0003\"\u001d\u0012\u0005\u0011\u000bF\u0001N\r\u0011\u0019f\n\u0001+\u0003\u000f\u0019\u000b7\r^8ssN\u0019!\u000bD+\u0011\u0005M1\u0016BA,\u0015\u00055iu\u000eZ;mK\u001a\u000b7\r^8ss\")\u0011E\u0015C\u00013R\t!\f\u0005\u0002\\%6\ta\nC\u0003^%\u0012\u0005c,\u0001\u0004de\u0016\fG/\u001a\u000b\u0003?\n\u0004\"a\u00051\n\u0005\u0005$\"AB'pIVdW\rC\u0003d9\u0002\u0007A-\u0001\u0005tKR$\u0018N\\4t!\t)\u0007N\u0004\u0002\u0014M&\u0011q\rF\u0001\u000e\u001b>$W\u000f\\3GC\u000e$xN]=\n\u0005%T'\u0001C*fiRLgnZ:\u000b\u0005\u001d$b\u0001B5O\u00012\u001cBa\u001b\u0007naB\u0011QB\\\u0005\u0003_:\u0011q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002\u000ec&\u0011!O\u0004\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0005\ti.\u0014)\u001a!C\u0001k\u0006\tBO]1dW\u0016$\u0017J\u001c;fe\u001a\f7-Z:\u0016\u0003Y\u0004\"a\u001e>\u000e\u0003aT!!\u001f\u0005\u0002\tU$\u0018\u000e\\\u0005\u0003wb\u0014aAR5mi\u0016\u0014\b\u0002C?l\u0005#\u0005\u000b\u0011\u0002<\u0002%Q\u0014\u0018mY6fI&sG/\u001a:gC\u000e,7\u000f\t\u0005\t\u007f.\u0014)\u001a!C\u0001k\u0006iAO]1dW\u0016$Wj\\;oiND\u0011\"a\u0001l\u0005#\u0005\u000b\u0011\u0002<\u0002\u001dQ\u0014\u0018mY6fI6{WO\u001c;tA!1\u0011e\u001bC\u0001\u0003\u000f!b!!\u0003\u0002\f\u00055\u0001CA.l\u0011\u0019!\u0018Q\u0001a\u0001m\"1q0!\u0002A\u0002YD\u0011\"!\u0005l\u0003\u0003%\t!a\u0005\u0002\t\r|\u0007/\u001f\u000b\u0007\u0003\u0013\t)\"a\u0006\t\u0011Q\fy\u0001%AA\u0002YD\u0001b`A\b!\u0003\u0005\rA\u001e\u0005\n\u00037Y\u0017\u0013!C\u0001\u0003;\tabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002 )\u001aa/!\t,\u0005\u0005\r\u0002\u0003BA\u0013\u0003_i!!a\n\u000b\t\u0005%\u00121F\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!\f\u000f\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003c\t9CA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016D\u0011\"!\u000el#\u0003%\t!!\b\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%e!A\u0011\u0011H6\u0002\u0002\u0013\u0005\u0003&A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e\u001f\u0005\n\u0003{Y\u0017\u0011!C\u0001\u0003\u007f\tA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!!\u0011\u0011\u00075\t\u0019%C\u0002\u0002F9\u00111!\u00138u\u0011%\tIe[A\u0001\n\u0003\tY%\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u00055\u00131\u000b\t\u0004\u001b\u0005=\u0013bAA)\u001d\t\u0019\u0011I\\=\t\u0013\r\u000b9%!AA\u0002\u0005\u0005\u0003\"CA,W\u0006\u0005I\u0011IA-\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAA.!\u0019\ti&a\u0019\u0002N5\u0011\u0011q\f\u0006\u0004\u0003Cr\u0011AC2pY2,7\r^5p]&!\u0011QMA0\u0005!IE/\u001a:bi>\u0014\b\"CA5W\u0006\u0005I\u0011AA6\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BA7\u0003g\u00022!DA8\u0013\r\t\tH\u0004\u0002\b\u0005>|G.Z1o\u0011%\u0019\u0015qMA\u0001\u0002\u0004\ti\u0005C\u0005\u0002x-\f\t\u0011\"\u0011\u0002z\u0005A\u0001.Y:i\u0007>$W\r\u0006\u0002\u0002B!I\u0011QP6\u0002\u0002\u0013\u0005\u0013qP\u0001\ti>\u001cFO]5oOR\t\u0011\u0006C\u0005\u0002\u0004.\f\t\u0011\"\u0011\u0002\u0006\u00061Q-];bYN$B!!\u001c\u0002\b\"I1)!!\u0002\u0002\u0003\u0007\u0011QJ\u0004\n\u0003\u0017s\u0015\u0011!E\u0001\u0003\u001b\u000b\u0001bU3ui&twm\u001d\t\u00047\u0006=e\u0001C5O\u0003\u0003E\t!!%\u0014\u000b\u0005=\u00151\u00139\u0011\u0011\u0005U\u00151\u0014<w\u0003\u0013i!!a&\u000b\u0007\u0005ee\"A\u0004sk:$\u0018.\\3\n\t\u0005u\u0015q\u0013\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\u0014\u0004bB\u0011\u0002\u0010\u0012\u0005\u0011\u0011\u0015\u000b\u0003\u0003\u001bC!\"! \u0002\u0010\u0006\u0005IQIA@\u0011)\t9+a$\u0002\u0002\u0013\u0005\u0015\u0011V\u0001\u0006CB\u0004H.\u001f\u000b\u0007\u0003\u0013\tY+!,\t\rQ\f)\u000b1\u0001w\u0011\u0019y\u0018Q\u0015a\u0001m\"Q\u0011\u0011WAH\u0003\u0003%\t)a-\u0002\u000fUt\u0017\r\u001d9msR!\u0011QWAa!\u0015i\u0011qWA^\u0013\r\tIL\u0004\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u000b5\tiL\u001e<\n\u0007\u0005}fB\u0001\u0004UkBdWM\r\u0005\u000b\u0003\u0007\fy+!AA\u0002\u0005%\u0011a\u0001=%a!Q\u0011qYAH\u0003\u0003%I!!3\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0003\u0017\u00042AKAg\u0013\r\tym\u000b\u0002\u0007\u001f\nTWm\u0019;\t\u0013\u0005M\u0007\u00011A\u0005\n\u0005U\u0017!D0tKR$\u0018N\\4t?\u0012*\u0017\u000fF\u0002@\u0003/D\u0001bQAi\u0003\u0003\u0005\r!\u0013\u0005\b\u00037\u0004\u0001\u0015)\u0003J\u0003)y6/\u001a;uS:<7\u000f\t\u0015\u0005\u00033\fy\u000eE\u0002\u000e\u0003CL1!a9\u000f\u0005!1x\u000e\\1uS2,\u0007\"CAt\u0001\t\u0007I\u0011BAu\u0003IyfM]3rk\u0016tGoQ8mY\u0016\u001cGo\u001c:\u0016\u0005\u0005-\b\u0003BAw\u0003_l\u0011\u0001\u0001\u0004\u0007\u0003c\u0004A!a=\u0003-\u0019\u0013X-];f]R\u001cu\u000e\u001c7fGRLwN\u001c+bg.\u001cR!a<\r\u0003k\u0004B!!<\u0002x\u001aI\u0011\u0011 \u0001\u0011\u0002G\u0005\u00111 \u0002\u000f\u0007>dG.Z2uS>tG+Y:l'\r\t9\u0010\u0004\u0005\t\u0003\u007f\f9P\"\u0001\u0003\u0002\u0005\u0019!/\u001e8\u0015\u0003}B\u0001B!\u0002\u0002x\u001a\u0005!\u0011A\u0001\bG2,\u0017M\\;q\u0011\u001d\t\u0013q\u001eC\u0001\u0005\u0013!\"!a;\t\u0015\t5\u0011q\u001eb\u0001\n\u0013\u0011y!\u0001\u0007`I\u00164\u0017-\u001e7u)\u0006<7/\u0006\u0002\u0003\u0012A!!1\u0003B\r\u001b\t\u0011)BC\u0002\u0003\u0018!\t1\u0001^1h\u0013\u0011\u0011YB!\u0006\u0003\rQ\u000bwmU3u\u0011%\u0011y\"a<!\u0002\u0013\u0011\t\"A\u0007`I\u00164\u0017-\u001e7u)\u0006<7\u000f\t\u0005\u000b\u0005G\tyO1A\u0005\n\t\u0015\u0012aC0tsN$X-\\%oM>,\"Aa\n\u0011\t\t%\"qF\u0007\u0003\u0005WQ!A!\f\u0002\t=\u001c\b.[\u0005\u0005\u0005c\u0011YC\u0001\u0006TsN$X-\\%oM>D\u0011B!\u000e\u0002p\u0002\u0006IAa\n\u0002\u0019}\u001b\u0018p\u001d;f[&sgm\u001c\u0011\t\u0015\te\u0012q\u001eb\u0001\n\u0013\u0011Y$\u0001\u0003`Q\u0006dWC\u0001B\u001f!\u0011\u0011yD!\u0012\u000e\u0005\t\u0005#\u0002\u0002B\"\u0005W\t\u0001\u0002[1sI^\f'/Z\u0005\u0005\u0005\u000f\u0012\tE\u0001\rICJ$w/\u0019:f\u0003\n\u001cHO]1di&|g\u000eT1zKJD\u0011Ba\u0013\u0002p\u0002\u0006IA!\u0010\u0002\u000b}C\u0017\r\u001c\u0011\t\u0015\t=\u0013q\u001eb\u0001\n\u0013\u0011\t&A\b`GB,\u0018J\\:ueVlWM\u001c;t+\t\u0011\u0019\u0006\u0005\u0003\u0003V\tEd\u0002\u0002B,\u0005[rAA!\u0017\u0003l9!!1\fB5\u001d\u0011\u0011iFa\u001a\u000f\t\t}#QM\u0007\u0003\u0005CR1Aa\u0019\u000b\u0003\u0019a$o\\8u}%\t\u0011\"\u0003\u0002\b\u0011%\u0011QAB\u0005\u0003\u0007\u0011I1Aa\u001c\u0003\u0003-Aun\u001d;NKR\u0014\u0018nY:\n\t\tM$Q\u000f\u0002\u000f\u0007B,\u0018J\\:ueVlWM\u001c;t\u0015\r\u0011yG\u0001\u0005\n\u0005s\ny\u000f)A\u0005\u0005'\n\u0001cX2qk&s7\u000f\u001e:v[\u0016tGo\u001d\u0011\t\u0015\tu\u0014q\u001ea\u0001\n\u0013\u0011y(A\t`aJ,go\u00119v\u0019>\fG\rV5dWN,\"A!!\u0011\u000b5\u0011\u0019Ia\"\n\u0007\t\u0015eBA\u0003BeJ\f\u0017\u0010E\u0002\u000e\u0005\u0013K1Aa#\u000f\u0005\u0011auN\\4\t\u0015\t=\u0015q\u001ea\u0001\n\u0013\u0011\t*A\u000b`aJ,go\u00119v\u0019>\fG\rV5dWN|F%Z9\u0015\u0007}\u0012\u0019\nC\u0005D\u0005\u001b\u000b\t\u00111\u0001\u0003\u0002\"I!qSAxA\u0003&!\u0011Q\u0001\u0013?B\u0014XM^\"qk2{\u0017\r\u001a+jG.\u001c\b\u0005\u0003\u0005\u0002\u0000\u0006=H\u0011\u0001B\u0001\u0011!\u0011)!a<\u0005\u0002\t\u0005\u0001\u0002\u0003BP\u0003_$IA!\u0001\u0002\u001dI,7m\u001c:e\u0007B,Xk]1hK\"A!1UAx\t\u0013\u0011)+A\u0005uS\u000e\\7\u000fR5gMRA!q\u0011BT\u0005W\u0013y\u000b\u0003\u0005\u0003*\n\u0005\u0006\u0019\u0001BA\u0003!\u0001(/\u001a<j_V\u001c\b\u0002\u0003BW\u0005C\u0003\rA!!\u0002\u000f\r,(O]3oi\"A!\u0011\u0017BQ\u0001\u0004\u0011\u0019,\u0001\u0005uS\u000e\\G+\u001f9f!\u0011\u0011)La1\u000f\t\t]&q\u0018\b\u0005\u0005s\u0013iL\u0004\u0003\u0003`\tm\u0016B\u0001B\u0017\u0013\u0011\u0011\u0019Ea\u000b\n\t\t\u0005'\u0011I\u0001\u0011\u0007\u0016tGO]1m!J|7-Z:t_JLAA!2\u0003H\nAA+[2l)f\u0004XM\u0003\u0003\u0003B\n\u0005\u0003\u0002\u0003Bf\u0001\u0001\u0006I!a;\u0002'}3'/Z9vK:$8i\u001c7mK\u000e$xN\u001d\u0011\t\u0013\t=\u0007A1A\u0005\n\tE\u0017\u0001F0j]\u001a\u0014X-];f]R\u001cu\u000e\u001c7fGR|'/\u0006\u0002\u0003TB!\u0011Q\u001eBk\r\u0019\u00119\u000e\u0001\u0003\u0003Z\nA\u0012J\u001c4sKF,XM\u001c;D_2dWm\u0019;j_:$\u0016m]6\u0014\u000b\tUG\"!>\t\u000f\u0005\u0012)\u000e\"\u0001\u0003^R\u0011!1\u001b\u0005\u000b\u0005\u001b\u0011)N1A\u0005\n\t=\u0001\"\u0003B\u0010\u0005+\u0004\u000b\u0011\u0002B\t\u0011)\u0011\u0019C!6C\u0002\u0013%!Q\u0005\u0005\n\u0005k\u0011)\u000e)A\u0005\u0005OA!B!\u000f\u0003V\n\u0007I\u0011\u0002B\u001e\u0011%\u0011YE!6!\u0002\u0013\u0011i\u0004\u0003\u0006\u0003n\nU'\u0019!C\u0005\u0005_\f1aX8t+\t\u0011\t\u0010\u0005\u0003\u0003t\nuXB\u0001B{\u0015\u0011\u00119P!?\u0002\u0005=\u001c(\u0002\u0002B~\u0005W\t\u0001b]8gi^\f'/Z\u0005\u0005\u0005\u007f\u0014)PA\bPa\u0016\u0014\u0018\r^5oONK8\u000f^3n\u0011%\u0019\u0019A!6!\u0002\u0013\u0011\t0\u0001\u0003`_N\u0004\u0003BCB\u0004\u0005+\u0014\r\u0011\"\u0003\u0004\n\u0005\u0011r,\\3n_JL\u0018J\\:ueVlWM\u001c;t+\t\u0019Y\u0001\u0005\u0003\u0003V\r5\u0011\u0002BB\b\u0005k\u0012\u0011#T3n_JL\u0018J\\:ueVlWM\u001c;t\u0011%\u0019\u0019B!6!\u0002\u0013\u0019Y!A\n`[\u0016lwN]=J]N$(/^7f]R\u001c\b\u0005\u0003\u0006\u0004\u0018\tU'\u0019!C\u0005\u00073\t\u0001cX:xCBLen\u001d;sk6,g\u000e^:\u0016\u0005\rm\u0001\u0003\u0002B+\u0007;IAaa\b\u0003v\ty1k^1q\u0013:\u001cHO];nK:$8\u000fC\u0005\u0004$\tU\u0007\u0015!\u0003\u0004\u001c\u0005\trl]<ba&s7\u000f\u001e:v[\u0016tGo\u001d\u0011\t\u0015\r\u001d\"Q\u001bb\u0001\n\u0013\u0019I#A\f`Y>\fG-\u0011<fe\u0006<W-\u00138tiJ,X.\u001a8ugV\u001111\u0006\t\u0005\u0005+\u001ai#\u0003\u0003\u00040\tU$A\u0006'pC\u0012\fe/\u001a:bO\u0016Len\u001d;sk6,g\u000e^:\t\u0013\rM\"Q\u001bQ\u0001\n\r-\u0012\u0001G0m_\u0006$\u0017I^3sC\u001e,\u0017J\\:ueVlWM\u001c;tA!Q1q\u0007Bk\u0005\u0004%Ia!\u000f\u00027}3\u0017\u000e\\3TsN$X-\\+tC\u001e,\u0017J\\:ueVlWM\u001c;t+\t\u0019Y\u0004\u0005\u0003\u0003V\ru\u0012\u0002BB \u0005k\u0012qc\u0015;pe\u0006<W-T8v]RLen\u001d;sk6,g\u000e^:\t\u0013\r\r#Q\u001bQ\u0001\n\rm\u0012\u0001H0gS2,7+_:uK6,6/Y4f\u0013:\u001cHO];nK:$8\u000f\t\u0005\u000b\u0007\u000f\u0012)N1A\u0005\n\r%\u0013AH0gS2,7+_:uK6\f5\r^5wSRL\u0018J\\:ueVlWM\u001c;t+\t\u0019Y\u0005\u0005\u0003\u0003V\r5\u0013\u0002BB(\u0005k\u0012\u0001d\u0015;pe\u0006<W\rR3wS\u000e,\u0017J\\:ueVlWM\u001c;t\u0011%\u0019\u0019F!6!\u0002\u0013\u0019Y%A\u0010`M&dWmU=ti\u0016l\u0017i\u0019;jm&$\u00180\u00138tiJ,X.\u001a8ug\u0002B!ba\u0016\u0003V\n\u0007I\u0011BB-\u0003myf.\u001a;x_J\\\u0017i\u0019;jm&$\u00180\u00138tiJ,X.\u001a8ugV\u001111\f\t\u0005\u0005+\u001ai&\u0003\u0003\u0004`\tU$A\u0007(fi^|'o[!di&4\u0018\u000e^=J]N$(/^7f]R\u001c\b\"CB2\u0005+\u0004\u000b\u0011BB.\u0003qyf.\u001a;x_J\\\u0017i\u0019;jm&$\u00180\u00138tiJ,X.\u001a8ug\u0002B\u0001\"a@\u0003V\u0012\u0005!\u0011\u0001\u0005\t\u0005\u000b\u0011)\u000e\"\u0001\u0003\u0002!A11\u000eBk\t\u0013\u0011\t!A\tsK\u000e|'\u000fZ'f[>\u0014\u00180V:bO\u0016D\u0001ba\u001c\u0003V\u0012%!\u0011A\u0001\u0012e\u0016\u001cwN\u001d3M_\u0006$\u0017I^3sC\u001e,\u0007\u0002CB:\u0005+$IA!\u0001\u0002%I,7m\u001c:e'R|'/Y4f+N\fw-\u001a\u0005\t\u0007o\u0012)\u000e\"\u0003\u0004z\u0005IAo\u001c)fe\u000e,g\u000e\u001e\u000b\u0007\u0005\u000f\u001bYha \t\u0011\ru4Q\u000fa\u0001\u0005\u000f\u000bQA^1mk\u0016D\u0001b!!\u0004v\u0001\u0007!qQ\u0001\u0006i>$\u0018\r\u001c\u0005\t\u0007\u000b\u0013)\u000e\"\u0003\u0003\u0002\u0005)\"/Z2pe\u0012\u001cFo\u001c:bO\u0016\f5\r^5wSRL\b\u0002CBE\u0005+$IA!\u0001\u0002+I,7m\u001c:e\u001d\u0016$xo\u001c:l\u0003\u000e$\u0018N^5us\"A1Q\u0012\u0001!\u0002\u0013\u0011\u0019.A\u000b`S:4'/Z9vK:$8i\u001c7mK\u000e$xN\u001d\u0011\t\u000f\u0005}\b\u0001\"\u0011\u0003\u0002!911\u0013\u0001\u0005B\t\u0005\u0011\u0001B:u_BDqaa&\u0001\t\u0003\u001aI*A\u0006sK\u000e|gNZ5hkJ,GcA \u0004\u001c\"A1QTBK\u0001\u0004\u0019y*A\u0005oK^\u001cuN\u001c4jOB!1\u0011UBX\u001b\t\u0019\u0019K\u0003\u0003\u0004&\u000e\u001d\u0016AB2p]\u001aLwM\u0003\u0003\u0004*\u000e-\u0016\u0001\u0003;za\u0016\u001c\u0018MZ3\u000b\u0005\r5\u0016aA2p[&!1\u0011WBR\u0005\u0019\u0019uN\u001c4jO\"91Q\u0017\u0001\u0005\n\r]\u0016\u0001\u0004:fC\u0012\u001cV\r\u001e;j]\u001e\u001cHcA%\u0004:\"A1QUBZ\u0001\u0004\u0019y\n")
public class HostMetricsCollector
implements ScheduledAction {
    private final String _configPath;
    private Instant _lastInfrequentTick = Instant.now();
    private volatile Settings kamon$instrumentation$system$host$HostMetricsCollector$$_settings = this.readSettings(Kamon$.MODULE$.config());
    private final FrequentCollectionTask _frequentCollector = new FrequentCollectionTask();
    private final InfrequentCollectionTask _infrequentCollector = new InfrequentCollectionTask();

    private String _configPath() {
        return this._configPath;
    }

    private Instant _lastInfrequentTick() {
        return this._lastInfrequentTick;
    }

    private void _lastInfrequentTick_$eq(Instant x$1) {
        this._lastInfrequentTick = x$1;
    }

    public Settings kamon$instrumentation$system$host$HostMetricsCollector$$_settings() {
        return this.kamon$instrumentation$system$host$HostMetricsCollector$$_settings;
    }

    private void kamon$instrumentation$system$host$HostMetricsCollector$$_settings_$eq(Settings x$1) {
        this.kamon$instrumentation$system$host$HostMetricsCollector$$_settings = x$1;
    }

    private FrequentCollectionTask _frequentCollector() {
        return this._frequentCollector;
    }

    private InfrequentCollectionTask _infrequentCollector() {
        return this._infrequentCollector;
    }

    public void run() {
        this._frequentCollector().run();
        if (Duration.between(this._lastInfrequentTick(), Instant.now()).getSeconds() >= 10L) {
            this._infrequentCollector().run();
            this._lastInfrequentTick_$eq(Instant.now());
        }
    }

    public void stop() {
        this._frequentCollector().cleanup();
        this._infrequentCollector().cleanup();
    }

    public void reconfigure(Config newConfig) {
        this.kamon$instrumentation$system$host$HostMetricsCollector$$_settings_$eq(this.readSettings(newConfig));
    }

    private Settings readSettings(Config config) {
        Config hostConfig = config.getConfig(this._configPath());
        return new Settings(Filter$.MODULE$.from(hostConfig.getConfig("network.tracked-interfaces")), Filter$.MODULE$.from(hostConfig.getConfig("storage.tracked-mount-types")));
    }

    public HostMetricsCollector(ExecutionContext ec) {
        this._configPath = "kamon.instrumentation.system.host";
    }

    public static class Factory
    implements ModuleFactory {
        public Module create(ModuleFactory.Settings settings) {
            return new HostMetricsCollector(settings.executionContext());
        }
    }

    public static class Settings
    implements Product,
    Serializable {
        private final Filter trackedInterfaces;
        private final Filter trackedMounts;

        public Filter trackedInterfaces() {
            return this.trackedInterfaces;
        }

        public Filter trackedMounts() {
            return this.trackedMounts;
        }

        public Settings copy(Filter trackedInterfaces, Filter trackedMounts) {
            return new Settings(trackedInterfaces, trackedMounts);
        }

        public Filter copy$default$1() {
            return this.trackedInterfaces();
        }

        public Filter copy$default$2() {
            return this.trackedMounts();
        }

        public String productPrefix() {
            return "Settings";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Filter filter;
            int n = x$1;
            switch (n) {
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
                case 1: {
                    filter = this.trackedMounts();
                    break;
                }
                case 0: {
                    filter = this.trackedInterfaces();
                }
            }
            return filter;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof Settings;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof Settings)) return false;
            boolean bl = true;
            if (!bl) return false;
            Settings settings = (Settings)x$1;
            Filter filter = this.trackedInterfaces();
            Filter filter2 = settings.trackedInterfaces();
            if (filter == null) {
                if (filter2 != null) {
                    return false;
                }
            } else if (!filter.equals(filter2)) return false;
            Filter filter3 = this.trackedMounts();
            Filter filter4 = settings.trackedMounts();
            if (filter3 == null) {
                if (filter4 != null) {
                    return false;
                }
            } else if (!filter3.equals(filter4)) return false;
            if (!settings.canEqual(this)) return false;
            return true;
        }

        public Settings(Filter trackedInterfaces, Filter trackedMounts) {
            this.trackedInterfaces = trackedInterfaces;
            this.trackedMounts = trackedMounts;
            Product.class.$init$((Product)this);
        }
    }

    public interface CollectionTask {
        public void run();

        public void cleanup();
    }

    public class FrequentCollectionTask
    implements CollectionTask {
        private final TagSet _defaultTags;
        private final SystemInfo _systemInfo;
        private final HardwareAbstractionLayer _hal;
        private final HostMetrics.CpuInstruments _cpuInstruments;
        private long[] _prevCpuLoadTicks;

        private TagSet _defaultTags() {
            return this._defaultTags;
        }

        private SystemInfo _systemInfo() {
            return this._systemInfo;
        }

        private HardwareAbstractionLayer _hal() {
            return this._hal;
        }

        private HostMetrics.CpuInstruments _cpuInstruments() {
            return this._cpuInstruments;
        }

        private long[] _prevCpuLoadTicks() {
            return this._prevCpuLoadTicks;
        }

        private void _prevCpuLoadTicks_$eq(long[] x$1) {
            this._prevCpuLoadTicks = x$1;
        }

        @Override
        public void run() {
            this.recordCpuUsage();
        }

        @Override
        public void cleanup() {
            this._cpuInstruments().remove();
        }

        private void recordCpuUsage() {
            if (this._prevCpuLoadTicks().length > 0) {
                long[] previousTicks = this._prevCpuLoadTicks();
                long[] currentTicks = this._hal().getProcessor().getSystemCpuLoadTicks();
                long user = this.ticksDiff(previousTicks, currentTicks, CentralProcessor.TickType.USER);
                long nice = this.ticksDiff(previousTicks, currentTicks, CentralProcessor.TickType.NICE);
                long system = this.ticksDiff(previousTicks, currentTicks, CentralProcessor.TickType.SYSTEM);
                long idle = this.ticksDiff(previousTicks, currentTicks, CentralProcessor.TickType.IDLE);
                long iowait = this.ticksDiff(previousTicks, currentTicks, CentralProcessor.TickType.IOWAIT);
                long irq = this.ticksDiff(previousTicks, currentTicks, CentralProcessor.TickType.IRQ);
                long softirq = this.ticksDiff(previousTicks, currentTicks, CentralProcessor.TickType.SOFTIRQ);
                long steal = this.ticksDiff(previousTicks, currentTicks, CentralProcessor.TickType.STEAL);
                long total = user + nice + system + idle + iowait + irq + softirq + steal;
                this._cpuInstruments().user().record(this.toPercent$1(user, total));
                this._cpuInstruments().system().record(this.toPercent$1(system, total));
                this._cpuInstruments().iowait().record(this.toPercent$1(iowait, total));
                this._cpuInstruments().idle().record(this.toPercent$1(idle, total));
                this._cpuInstruments().stolen().record(this.toPercent$1(steal, total));
                this._cpuInstruments().combined().record(this.toPercent$1(user + system + nice + iowait, total));
                this._prevCpuLoadTicks_$eq(currentTicks);
            } else {
                this._prevCpuLoadTicks_$eq(this._hal().getProcessor().getSystemCpuLoadTicks());
            }
        }

        private long ticksDiff(long[] previous, long[] current, CentralProcessor.TickType tickType) {
            return package$.MODULE$.max(current[tickType.getIndex()] - previous[tickType.getIndex()], 0L);
        }

        public /* synthetic */ HostMetricsCollector kamon$instrumentation$system$host$HostMetricsCollector$FrequentCollectionTask$$$outer() {
            return HostMetricsCollector.this;
        }

        private final long toPercent$1(long value, long total$1) {
            return (long)(100.0 * (double)value / (double)total$1);
        }

        public FrequentCollectionTask() {
            if (HostMetricsCollector.this == null) {
                throw null;
            }
            this._defaultTags = TagSet$.MODULE$.of("component", "host");
            this._systemInfo = new SystemInfo();
            this._hal = this._systemInfo().getHardware();
            this._cpuInstruments = new HostMetrics.CpuInstruments(this._defaultTags());
            this._prevCpuLoadTicks = (long[])Array$.MODULE$.ofDim(0, ClassTag$.MODULE$.Long());
        }
    }

    public class InfrequentCollectionTask
    implements CollectionTask {
        private final TagSet _defaultTags;
        private final SystemInfo _systemInfo;
        private final HardwareAbstractionLayer _hal;
        private final OperatingSystem _os;
        private final HostMetrics.MemoryInstruments _memoryInstruments;
        private final HostMetrics.SwapInstruments _swapInstruments;
        private final HostMetrics.LoadAverageInstruments _loadAverageInstruments;
        private final HostMetrics.StorageMountInstruments kamon$instrumentation$system$host$HostMetricsCollector$InfrequentCollectionTask$$_fileSystemUsageInstruments;
        private final HostMetrics.StorageDeviceInstruments kamon$instrumentation$system$host$HostMetricsCollector$InfrequentCollectionTask$$_fileSystemActivityInstruments;
        private final HostMetrics.NetworkActivityInstruments kamon$instrumentation$system$host$HostMetricsCollector$InfrequentCollectionTask$$_networkActivityInstruments;

        private TagSet _defaultTags() {
            return this._defaultTags;
        }

        private SystemInfo _systemInfo() {
            return this._systemInfo;
        }

        private HardwareAbstractionLayer _hal() {
            return this._hal;
        }

        private OperatingSystem _os() {
            return this._os;
        }

        private HostMetrics.MemoryInstruments _memoryInstruments() {
            return this._memoryInstruments;
        }

        private HostMetrics.SwapInstruments _swapInstruments() {
            return this._swapInstruments;
        }

        private HostMetrics.LoadAverageInstruments _loadAverageInstruments() {
            return this._loadAverageInstruments;
        }

        public HostMetrics.StorageMountInstruments kamon$instrumentation$system$host$HostMetricsCollector$InfrequentCollectionTask$$_fileSystemUsageInstruments() {
            return this.kamon$instrumentation$system$host$HostMetricsCollector$InfrequentCollectionTask$$_fileSystemUsageInstruments;
        }

        public HostMetrics.StorageDeviceInstruments kamon$instrumentation$system$host$HostMetricsCollector$InfrequentCollectionTask$$_fileSystemActivityInstruments() {
            return this.kamon$instrumentation$system$host$HostMetricsCollector$InfrequentCollectionTask$$_fileSystemActivityInstruments;
        }

        public HostMetrics.NetworkActivityInstruments kamon$instrumentation$system$host$HostMetricsCollector$InfrequentCollectionTask$$_networkActivityInstruments() {
            return this.kamon$instrumentation$system$host$HostMetricsCollector$InfrequentCollectionTask$$_networkActivityInstruments;
        }

        @Override
        public void run() {
            this.recordMemoryUsage();
            this.recordLoadAverage();
            this.recordStorageUsage();
            this.recordStorageActivity();
            this.recordNetworkActivity();
        }

        @Override
        public void cleanup() {
            this._memoryInstruments().remove();
            this._swapInstruments().remove();
            this._loadAverageInstruments().remove();
            this.kamon$instrumentation$system$host$HostMetricsCollector$InfrequentCollectionTask$$_fileSystemUsageInstruments().remove();
            this.kamon$instrumentation$system$host$HostMetricsCollector$InfrequentCollectionTask$$_fileSystemActivityInstruments().remove();
            this.kamon$instrumentation$system$host$HostMetricsCollector$InfrequentCollectionTask$$_networkActivityInstruments().remove();
        }

        private void recordMemoryUsage() {
            GlobalMemory memory = this._hal().getMemory();
            long totalMemory = memory.getTotal();
            long availableMemory = memory.getAvailable();
            long usedMemory = totalMemory - availableMemory;
            this._memoryInstruments().total().update((double)totalMemory);
            this._memoryInstruments().free().update((double)availableMemory);
            this._memoryInstruments().used().update((double)usedMemory);
            this._memoryInstruments().usage().update((double)this.kamon$instrumentation$system$host$HostMetricsCollector$InfrequentCollectionTask$$toPercent(usedMemory, totalMemory));
            long usedSwap = memory.getVirtualMemory().getSwapUsed();
            long totalSwap = memory.getVirtualMemory().getSwapTotal();
            this._swapInstruments().total().update((double)totalSwap);
            this._swapInstruments().used().update((double)usedSwap);
            this._swapInstruments().usage().update((double)this.kamon$instrumentation$system$host$HostMetricsCollector$InfrequentCollectionTask$$toPercent(usedSwap, totalSwap));
            this._swapInstruments().free().update((double)(totalSwap - usedSwap));
        }

        private void recordLoadAverage() {
            double[] loadAverage = this._hal().getProcessor().getSystemLoadAverage(3);
            Object object = loadAverage[0] >= 0.0 ? this._loadAverageInstruments().oneMinute().update(loadAverage[0]) : BoxedUnit.UNIT;
            Object object2 = loadAverage[1] >= 0.0 ? this._loadAverageInstruments().fiveMinutes().update(loadAverage[1]) : BoxedUnit.UNIT;
            if (loadAverage[2] >= 0.0) {
                this._loadAverageInstruments().fifteenMinutes().update(loadAverage[2]);
            }
        }

        private void recordStorageUsage() {
            List fileStores = this._os().getFileSystem().getFileStores();
            ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(fileStores).asScala()).foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ InfrequentCollectionTask $outer;

                public final Object apply(OSFileStore fs) {
                    BoxedUnit boxedUnit;
                    if (this.$outer.kamon$instrumentation$system$host$HostMetricsCollector$InfrequentCollectionTask$$$outer().kamon$instrumentation$system$host$HostMetricsCollector$$_settings().trackedMounts().accept(fs.getType())) {
                        HostMetrics.StorageMountInstruments.MountInstruments mountInstruments2 = this.$outer.kamon$instrumentation$system$host$HostMetricsCollector$InfrequentCollectionTask$$_fileSystemUsageInstruments().mountInstruments(fs.getMount());
                        long totalSpace = fs.getTotalSpace();
                        long usedSpace = totalSpace - fs.getUsableSpace();
                        mountInstruments2.free().update((double)fs.getUsableSpace());
                        mountInstruments2.total().update((double)totalSpace);
                        mountInstruments2.used().update((double)usedSpace);
                        boxedUnit = mountInstruments2.usage().update((double)this.$outer.kamon$instrumentation$system$host$HostMetricsCollector$InfrequentCollectionTask$$toPercent(usedSpace, totalSpace));
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    return boxedUnit;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
        }

        public long kamon$instrumentation$system$host$HostMetricsCollector$InfrequentCollectionTask$$toPercent(long value, long total) {
            return (long)(100.0 * (double)value / (double)total);
        }

        private void recordStorageActivity() {
            List devices = this._hal().getDiskStores();
            ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(devices).asScala()).foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ InfrequentCollectionTask $outer;

                public final void apply(HWDiskStore device) {
                    if (!device.getPartitions().isEmpty()) {
                        HostMetrics.StorageDeviceInstruments.DeviceInstruments deviceInstruments2 = this.$outer.kamon$instrumentation$system$host$HostMetricsCollector$InfrequentCollectionTask$$_fileSystemActivityInstruments().deviceInstruments(device.getName());
                        deviceInstruments2.reads().diff(device.getReads());
                        deviceInstruments2.writes().diff(device.getWrites());
                        deviceInstruments2.readBytes().diff(device.getReadBytes());
                        deviceInstruments2.writeBytes().diff(device.getWriteBytes());
                    }
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
        }

        private void recordNetworkActivity() {
            List interfaces = this._hal().getNetworkIFs();
            ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(interfaces).asScala()).foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ InfrequentCollectionTask $outer;

                public final void apply(NetworkIF networkIF) {
                    if (this.$outer.kamon$instrumentation$system$host$HostMetricsCollector$InfrequentCollectionTask$$$outer().kamon$instrumentation$system$host$HostMetricsCollector$$_settings().trackedInterfaces().accept(networkIF.getName())) {
                        networkIF.updateAttributes();
                        HostMetrics.NetworkActivityInstruments.InterfaceInstruments interfaceInstruments2 = this.$outer.kamon$instrumentation$system$host$HostMetricsCollector$InfrequentCollectionTask$$_networkActivityInstruments().interfaceInstruments(networkIF.getName());
                        interfaceInstruments2.receivedBytes().diff(networkIF.getBytesRecv());
                        interfaceInstruments2.sentBytes().diff(networkIF.getBytesSent());
                        interfaceInstruments2.sentPackets().diff(networkIF.getPacketsSent());
                        interfaceInstruments2.receivedPackets().diff(networkIF.getPacketsRecv());
                        interfaceInstruments2.sendErrorPackets().diff(networkIF.getOutErrors());
                        interfaceInstruments2.receiveErrorPackets().diff(networkIF.getInErrors());
                    }
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
        }

        public /* synthetic */ HostMetricsCollector kamon$instrumentation$system$host$HostMetricsCollector$InfrequentCollectionTask$$$outer() {
            return HostMetricsCollector.this;
        }

        public InfrequentCollectionTask() {
            if (HostMetricsCollector.this == null) {
                throw null;
            }
            this._defaultTags = TagSet$.MODULE$.of("component", "host");
            this._systemInfo = new SystemInfo();
            this._hal = this._systemInfo().getHardware();
            this._os = this._systemInfo().getOperatingSystem();
            this._memoryInstruments = new HostMetrics.MemoryInstruments(this._defaultTags());
            this._swapInstruments = new HostMetrics.SwapInstruments(this._defaultTags());
            this._loadAverageInstruments = new HostMetrics.LoadAverageInstruments(this._defaultTags());
            this.kamon$instrumentation$system$host$HostMetricsCollector$InfrequentCollectionTask$$_fileSystemUsageInstruments = new HostMetrics.StorageMountInstruments(this._defaultTags());
            this.kamon$instrumentation$system$host$HostMetricsCollector$InfrequentCollectionTask$$_fileSystemActivityInstruments = new HostMetrics.StorageDeviceInstruments(this._defaultTags());
            this.kamon$instrumentation$system$host$HostMetricsCollector$InfrequentCollectionTask$$_networkActivityInstruments = new HostMetrics.NetworkActivityInstruments(this._defaultTags());
        }
    }
}

