/*
 * Decompiled with CFR 0.152.
 */
package kamon.instrumentation.system.process;

import com.sun.jna.Platform;
import com.typesafe.config.Config;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kamon.Kamon$;
import kamon.instrumentation.system.process.ProcessMetrics;
import kamon.instrumentation.system.process.ProcessMetricsCollector$MetricsCollectionTask$;
import kamon.metric.Gauge;
import kamon.metric.Timer;
import kamon.module.Module;
import kamon.module.ModuleFactory;
import kamon.module.ScheduledAction;
import kamon.tag.TagSet;
import kamon.tag.TagSet$;
import oshi.SystemInfo;
import oshi.hardware.HardwareAbstractionLayer;
import oshi.software.os.OSProcess;
import oshi.software.os.OperatingSystem;
import oshi.util.FileUtil;
import oshi.util.ParseUtil;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.concurrent.ExecutionContext;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\tmc\u0001B\u0001\u0003\u0001-\u0011q\u0003\u0015:pG\u0016\u001c8/T3ue&\u001c7oQ8mY\u0016\u001cGo\u001c:\u000b\u0005\r!\u0011a\u00029s_\u000e,7o\u001d\u0006\u0003\u000b\u0019\taa]=ti\u0016l'BA\u0004\t\u0003=Ign\u001d;sk6,g\u000e^1uS>t'\"A\u0005\u0002\u000b-\fWn\u001c8\u0004\u0001M\u0019\u0001\u0001\u0004\n\u0011\u00055\u0001R\"\u0001\b\u000b\u0003=\tQa]2bY\u0006L!!\u0005\b\u0003\r\u0005s\u0017PU3g!\t\u0019b#D\u0001\u0015\u0015\t)\u0002\"\u0001\u0004n_\u0012,H.Z\u0005\u0003/Q\u0011qbU2iK\u0012,H.\u001a3BGRLwN\u001c\u0005\t3\u0001\u0011\t\u0011)A\u00055\u0005\u0011Qm\u0019\t\u00037yi\u0011\u0001\b\u0006\u0003;9\t!bY8oGV\u0014(/\u001a8u\u0013\tyBD\u0001\tFq\u0016\u001cW\u000f^5p]\u000e{g\u000e^3yi\")\u0011\u0005\u0001C\u0001E\u00051A(\u001b8jiz\"\"aI\u0013\u0011\u0005\u0011\u0002Q\"\u0001\u0002\t\u000be\u0001\u0003\u0019\u0001\u000e\t\u000f\u001d\u0002!\u0019!C\u0005Q\u0005\u0019r\f[5dGV\u0004\u0018J\u001c;feZ\fG\u000eU1uQV\t\u0011\u0006\u0005\u0002+_5\t1F\u0003\u0002-[\u0005!A.\u00198h\u0015\u0005q\u0013\u0001\u00026bm\u0006L!\u0001M\u0016\u0003\rM#(/\u001b8h\u0011\u0019\u0011\u0004\u0001)A\u0005S\u0005!r\f[5dGV\u0004\u0018J\u001c;feZ\fG\u000eU1uQ\u0002Bq\u0001\u000e\u0001C\u0002\u0013%Q'\u0001\u0007`I\u00164\u0017-\u001e7u)\u0006<7/F\u00017!\t9$(D\u00019\u0015\tI\u0004\"A\u0002uC\u001eL!a\u000f\u001d\u0003\rQ\u000bwmU3u\u0011\u0019i\u0004\u0001)A\u0005m\u0005iq\fZ3gCVdG\u000fV1hg\u0002Bqa\u0010\u0001C\u0002\u0013%\u0001)\u0001\f`aJ|7-Z:t\u0007B,\u0018J\\:ueVlWM\u001c;t+\u0005\t\u0005C\u0001\"Q\u001d\t\u0019eJ\u0004\u0002E\u001b:\u0011Q\t\u0014\b\u0003\r.s!a\u0012&\u000e\u0003!S!!\u0013\u0006\u0002\rq\u0012xn\u001c;?\u0013\u0005I\u0011BA\u0004\t\u0013\t)a!\u0003\u0002\u0004\t%\u0011qJA\u0001\u000f!J|7-Z:t\u001b\u0016$(/[2t\u0013\t\t&K\u0001\nQe>\u001cWm]:J]N$(/^7f]R\u001c(BA(\u0003\u0011\u0019!\u0006\u0001)A\u0005\u0003\u00069r\f\u001d:pG\u0016\u001c8o\u00119v\u0013:\u001cHO];nK:$8\u000f\t\u0005\b-\u0002\u0011\r\u0011\"\u0003X\u0003=y6m\u001c7mK\u000e$\u0018n\u001c8UCN\\W#\u0001-\u0011\u0005eSV\"\u0001\u0001\u0007\tm\u0003A\u0001\u0018\u0002\u0016\u001b\u0016$(/[2t\u0007>dG.Z2uS>tG+Y:l'\tQF\u0002C\u0003\"5\u0012\u0005a\fF\u0001Y\u0011\u001d\u0001'L1A\u0005\n\u0005\f1bX:zgR,W.\u00138g_V\t!\r\u0005\u0002dM6\tAMC\u0001f\u0003\u0011y7\u000f[5\n\u0005\u001d$'AC*zgR,W.\u00138g_\"1\u0011N\u0017Q\u0001\n\t\fAbX:zgR,W.\u00138g_\u0002Bqa\u001b.C\u0002\u0013%A.\u0001\u0003`Q\u0006dW#A7\u0011\u00059\fX\"A8\u000b\u0005A$\u0017\u0001\u00035be\u0012<\u0018M]3\n\u0005I|'\u0001\u0007%be\u0012<\u0018M]3BEN$(/Y2uS>tG*Y=fe\"1AO\u0017Q\u0001\n5\fQa\u00185bY\u0002BqA\u001e.C\u0002\u0013%q/A\u0002`_N,\u0012\u0001\u001f\t\u0003szl\u0011A\u001f\u0006\u0003wr\f!a\\:\u000b\u0005u$\u0017\u0001C:pMR<\u0018M]3\n\u0005}T(aD(qKJ\fG/\u001b8h'f\u001cH/Z7\t\u000f\u0005\r!\f)A\u0005q\u0006!ql\\:!\u0011%\t9A\u0017b\u0001\n\u0013\tI!\u0001\u0003`a&$WCAA\u0006!\ri\u0011QB\u0005\u0004\u0003\u001fq!aA%oi\"A\u00111\u0003.!\u0002\u0013\tY!A\u0003`a&$\u0007\u0005C\u0005\u0002\u0018i\u0013\r\u0011\"\u0003\u0002\u001a\u0005yq\f\u001d:pG\u0016\u001c8o\u001c:D_VtG/\u0006\u0002\u0002\u001cA\u0019Q\"!\b\n\u0007\u0005}aB\u0001\u0004E_V\u0014G.\u001a\u0005\t\u0003GQ\u0006\u0015!\u0003\u0002\u001c\u0005\u0001r\f\u001d:pG\u0016\u001c8o\u001c:D_VtG\u000f\t\u0005\n\u0003OQ\u0006\u0019!C\u0005\u0003S\tqc\u00189sKZLw.^:Qe>\u001cWm]:DaV$\u0016.\\3\u0016\u0005\u0005-\u0002#B\u0007\u0002.\u0005E\u0012bAA\u0018\u001d\t)\u0011I\u001d:bsB\u0019Q\"a\r\n\u0007\u0005UbB\u0001\u0003M_:<\u0007\"CA\u001d5\u0002\u0007I\u0011BA\u001e\u0003my\u0006O]3wS>,8\u000f\u0015:pG\u0016\u001c8o\u00119v)&lWm\u0018\u0013fcR!\u0011QHA\"!\ri\u0011qH\u0005\u0004\u0003\u0003r!\u0001B+oSRD!\"!\u0012\u00028\u0005\u0005\t\u0019AA\u0016\u0003\rAH%\r\u0005\t\u0003\u0013R\u0006\u0015)\u0003\u0002,\u0005Ar\f\u001d:fm&|Wo\u001d)s_\u000e,7o]\"qkRKW.\u001a\u0011\t\u000f\u00055#\f\"\u0001\u0002P\u0005\u0019!/\u001e8\u0015\u0005\u0005u\u0002bBA*5\u0012\u0005\u0011qJ\u0001\bG2,\u0017M\\;q\u0011\u001d\t9F\u0017C\u0005\u0003\u001f\n\u0001C]3d_J$\u0007K]8dKN\u001c8\t];\t\u000f\u0005m#\f\"\u0003\u0002P\u0005!\"/Z2pe\u0012\u0004&o\\2fgN,F*[7jiNDq!a\u0018\u0001A\u0003%\u0001,\u0001\t`G>dG.Z2uS>tG+Y:lA!I\u00111\r\u0001C\u0002\u0013%\u0011QM\u0001\u000f?\"L7mY;q\u001b>t\u0017\u000e^8s+\t\t9\u0007E\u0002Z\u0003S2a!a\u001b\u0001\u0005\u00055$!\u0004%jG\u000e,\b/T8oSR|'o\u0005\u0003\u0002j\u0005=\u0004c\u0001\u0016\u0002r%\u0019\u00111O\u0016\u0003\rQC'/Z1e\u0011-\t9(!\u001b\u0003\u0002\u0003\u0006I!!\u001f\u0002!!L7mY;q)&lW-T3ue&\u001c\u0007\u0003BA>\u0003\u0003k!!! \u000b\u0007\u0005}\u0004\"\u0001\u0004nKR\u0014\u0018nY\u0005\u0005\u0003\u0007\u000biHA\u0003US6,'\u000fC\u0006\u0002\b\u0006%$\u0011!Q\u0001\n\u0005%\u0015\u0001\u00033ve\u0006$\u0018n\u001c8\u0011\t\u0005-\u0015\u0011S\u0007\u0003\u0003\u001bS1!a$.\u0003\u0011!\u0018.\\3\n\t\u0005M\u0015Q\u0012\u0002\t\tV\u0014\u0018\r^5p]\"9\u0011%!\u001b\u0005\u0002\u0005]ECBA4\u00033\u000bY\n\u0003\u0005\u0002x\u0005U\u0005\u0019AA=\u0011!\t9)!&A\u0002\u0005%\u0005BCAP\u0003S\u0002\r\u0011\"\u0003\u0002\"\u0006aq\f[5dGV\u0004h*\u00198pgV\u0011\u0011\u0011\u0007\u0005\u000b\u0003K\u000bI\u00071A\u0005\n\u0005\u001d\u0016\u0001E0iS\u000e\u001cW\u000f\u001d(b]>\u001cx\fJ3r)\u0011\ti$!+\t\u0015\u0005\u0015\u00131UA\u0001\u0002\u0004\t\t\u0004C\u0005\u0002.\u0006%\u0004\u0015)\u0003\u00022\u0005iq\f[5dGV\u0004h*\u00198pg\u0002BC!a+\u00022B\u0019Q\"a-\n\u0007\u0005UfB\u0001\u0005w_2\fG/\u001b7f\u0011)\tI,!\u001bA\u0002\u0013%\u00111X\u0001\u0007?\u0012|'+\u001e8\u0016\u0005\u0005u\u0006cA\u0007\u0002@&\u0019\u0011\u0011\u0019\b\u0003\u000f\t{w\u000e\\3b]\"Q\u0011QYA5\u0001\u0004%I!a2\u0002\u0015}#wNU;o?\u0012*\u0017\u000f\u0006\u0003\u0002>\u0005%\u0007BCA#\u0003\u0007\f\t\u00111\u0001\u0002>\"I\u0011QZA5A\u0003&\u0011QX\u0001\b?\u0012|'+\u001e8!Q\u0011\tY-!-\t\u0011\u00055\u0013\u0011\u000eC!\u0003\u001fB\u0001\"!6\u0002j\u0011\u0005\u0011q[\u0001\u0007e\u0016\u001cwN\u001d3\u0015\r\u0005u\u0012\u0011\\Ao\u0011!\tY.a5A\u0002\u0005E\u0012!\u0002<bYV,\u0007\u0002CAp\u0003'\u0004\r!!\r\u0002G\u0015D\b/Z2uK\u0012Le\u000e^3sm\u0006d')\u001a;xK\u0016tg+\u00197vKN\u000bW\u000e\u001d7fg\"A\u00111]A5\t\u0003\ty%A\u0005uKJl\u0017N\\1uK\"A\u0011q]A5\t\u0003\tI/\u0001\bva\u0012\fG/Z%oi\u0016\u0014h/\u00197\u0015\t\u0005u\u00121\u001e\u0005\t\u0003\u000f\u000b)\u000f1\u0001\u0002\n\"A\u0011q\u001e\u0001!\u0002\u0013\t9'A\b`Q&\u001c7-\u001e9N_:LGo\u001c:!\u0011\u001d\ti\u0005\u0001C!\u0003\u001fBq!!>\u0001\t\u0003\ny%\u0001\u0003ti>\u0004\bbBA}\u0001\u0011\u0005\u00131`\u0001\fe\u0016\u001cwN\u001c4jOV\u0014X\r\u0006\u0003\u0002>\u0005u\b\u0002CA\u0000\u0003o\u0004\rA!\u0001\u0002\u00139,woQ8oM&<\u0007\u0003\u0002B\u0002\u0005#i!A!\u0002\u000b\t\t\u001d!\u0011B\u0001\u0007G>tg-[4\u000b\t\t-!QB\u0001\tif\u0004Xm]1gK*\u0011!qB\u0001\u0004G>l\u0017\u0002\u0002B\n\u0005\u000b\u0011aaQ8oM&<\u0007b\u0002B\f\u0001\u0011%!\u0011D\u0001\u0013gR\f'\u000f\u001e%jG\u000e,\b/T8oSR|'\u000f\u0006\u0002\u0002h\u001d9!Q\u0004\u0002\t\u0002\t}\u0011a\u0006)s_\u000e,7o]'fiJL7m]\"pY2,7\r^8s!\r!#\u0011\u0005\u0004\u0007\u0003\tA\tAa\t\u0014\u0007\t\u0005B\u0002C\u0004\"\u0005C!\tAa\n\u0015\u0005\t}aa\u0002B\u0016\u0005C\u0001!Q\u0006\u0002\b\r\u0006\u001cGo\u001c:z'\u0015\u0011I\u0003\u0004B\u0018!\r\u0019\"\u0011G\u0005\u0004\u0005g!\"!D'pIVdWMR1di>\u0014\u0018\u0010C\u0004\"\u0005S!\tAa\u000e\u0015\u0005\te\u0002\u0003\u0002B\u001e\u0005Si!A!\t\t\u0011\t}\"\u0011\u0006C!\u0005\u0003\naa\u0019:fCR,G\u0003\u0002B\"\u0005\u0013\u00022a\u0005B#\u0013\r\u00119\u0005\u0006\u0002\u0007\u001b>$W\u000f\\3\t\u0011\t-#Q\ba\u0001\u0005\u001b\n\u0001b]3ui&twm\u001d\t\u0005\u0005\u001f\u0012)FD\u0002\u0014\u0005#J1Aa\u0015\u0015\u00035iu\u000eZ;mK\u001a\u000b7\r^8ss&!!q\u000bB-\u0005!\u0019V\r\u001e;j]\u001e\u001c(b\u0001B*)\u0001")
public class ProcessMetricsCollector
implements ScheduledAction {
    private final String _hiccupIntervalPath;
    private final TagSet _defaultTags = TagSet$.MODULE$.of("component", "process");
    private final ProcessMetrics.ProcessInstruments kamon$instrumentation$system$process$ProcessMetricsCollector$$_processCpuInstruments = new ProcessMetrics.ProcessInstruments(this._defaultTags());
    private final MetricsCollectionTask _collectionTask = new MetricsCollectionTask();
    private final HiccupMonitor _hiccupMonitor = this.startHiccupMonitor();

    private String _hiccupIntervalPath() {
        return this._hiccupIntervalPath;
    }

    private TagSet _defaultTags() {
        return this._defaultTags;
    }

    public ProcessMetrics.ProcessInstruments kamon$instrumentation$system$process$ProcessMetricsCollector$$_processCpuInstruments() {
        return this.kamon$instrumentation$system$process$ProcessMetricsCollector$$_processCpuInstruments;
    }

    private MetricsCollectionTask _collectionTask() {
        return this._collectionTask;
    }

    private HiccupMonitor _hiccupMonitor() {
        return this._hiccupMonitor;
    }

    public void run() {
        this._collectionTask().run();
    }

    public void stop() {
        this._hiccupMonitor().terminate();
        this._collectionTask().cleanup();
    }

    public void reconfigure(Config newConfig) {
        this._hiccupMonitor().updateInterval(newConfig.getDuration(this._hiccupIntervalPath()));
    }

    /*
     * WARNING - void declaration
     */
    private HiccupMonitor startHiccupMonitor() {
        void var2_2;
        Duration interval = Kamon$.MODULE$.config().getDuration(this._hiccupIntervalPath());
        HiccupMonitor monitorThread = new HiccupMonitor(this, this.kamon$instrumentation$system$process$ProcessMetricsCollector$$_processCpuInstruments().hiccups(), interval);
        monitorThread.setDaemon(true);
        monitorThread.setName("hiccup-monitor");
        monitorThread.start();
        return var2_2;
    }

    public ProcessMetricsCollector(ExecutionContext ec) {
        this._hiccupIntervalPath = "kamon.instrumentation.system.process.hiccup-monitor-interval";
    }

    public static class Factory
    implements ModuleFactory {
        public Module create(ModuleFactory.Settings settings) {
            return new ProcessMetricsCollector(settings.executionContext());
        }
    }

    public final class HiccupMonitor
    extends Thread {
        private final Timer hiccupTimeMetric;
        private volatile long _hiccupNanos;
        private volatile boolean _doRun;

        private long _hiccupNanos() {
            return this._hiccupNanos;
        }

        private void _hiccupNanos_$eq(long x$1) {
            this._hiccupNanos = x$1;
        }

        private boolean _doRun() {
            return this._doRun;
        }

        private void _doRun_$eq(boolean x$1) {
            this._doRun = x$1;
        }

        @Override
        public void run() {
            LongRef shortestObservedDelta = LongRef.create((long)Long.MAX_VALUE);
            while (this._doRun()) {
                long hiccupTime = this.hic$1(this._hiccupNanos(), shortestObservedDelta);
                this.record(hiccupTime, this._hiccupNanos());
            }
        }

        public void record(long value, long expectedIntervalBetweenValueSamples) {
            this.hiccupTimeMetric.record(value);
            if (expectedIntervalBetweenValueSamples > 0L) {
                for (long missingValue = value - expectedIntervalBetweenValueSamples; missingValue >= expectedIntervalBetweenValueSamples; missingValue -= expectedIntervalBetweenValueSamples) {
                    this.hiccupTimeMetric.record(missingValue);
                }
            }
        }

        public void terminate() {
            this._doRun_$eq(false);
        }

        public void updateInterval(Duration duration) {
            this._hiccupNanos_$eq(duration.toNanos());
        }

        private final long hic$1(long resolution, LongRef shortestObservedDelta$1) {
            long start2 = System.nanoTime();
            TimeUnit.NANOSECONDS.sleep(resolution);
            long delta = System.nanoTime() - start2;
            if (delta < shortestObservedDelta$1.elem) {
                shortestObservedDelta$1.elem = delta;
            }
            return delta - shortestObservedDelta$1.elem;
        }

        public HiccupMonitor(ProcessMetricsCollector $outer, Timer hiccupTimeMetric, Duration duration) {
            this.hiccupTimeMetric = hiccupTimeMetric;
            this._hiccupNanos = duration.toNanos();
            this._doRun = true;
        }
    }

    public class MetricsCollectionTask {
        private final SystemInfo _systemInfo;
        private final HardwareAbstractionLayer _hal;
        private final OperatingSystem _os;
        private final int kamon$instrumentation$system$process$ProcessMetricsCollector$MetricsCollectionTask$$_pid;
        private final double _processorCount;
        private long[] _previousProcessCpuTime;

        private SystemInfo _systemInfo() {
            return this._systemInfo;
        }

        private HardwareAbstractionLayer _hal() {
            return this._hal;
        }

        private OperatingSystem _os() {
            return this._os;
        }

        public int kamon$instrumentation$system$process$ProcessMetricsCollector$MetricsCollectionTask$$_pid() {
            return this.kamon$instrumentation$system$process$ProcessMetricsCollector$MetricsCollectionTask$$_pid;
        }

        private double _processorCount() {
            return this._processorCount;
        }

        private long[] _previousProcessCpuTime() {
            return this._previousProcessCpuTime;
        }

        private void _previousProcessCpuTime_$eq(long[] x$1) {
            this._previousProcessCpuTime = x$1;
        }

        public void run() {
            this.recordProcessCpu();
            this.recordProcessULimits();
        }

        public void cleanup() {
            this.kamon$instrumentation$system$process$ProcessMetricsCollector$MetricsCollectionTask$$$outer().kamon$instrumentation$system$process$ProcessMetricsCollector$$_processCpuInstruments().remove();
        }

        private void recordProcessCpu() {
            BoxedUnit boxedUnit;
            OSProcess process2 = this._os().getProcess(this.kamon$instrumentation$system$process$ProcessMetricsCollector$MetricsCollectionTask$$_pid());
            long[] previous = this._previousProcessCpuTime();
            long[] current = new long[]{process2.getKernelTime(), process2.getUserTime(), process2.getUpTime()};
            if (Predef$.MODULE$.longArrayOps(previous).nonEmpty()) {
                long kernelTime = package$.MODULE$.max(0L, current[0] - previous[0]);
                long userTime = package$.MODULE$.max(0L, current[1] - previous[1]);
                long totalTime = package$.MODULE$.max(0L, current[2] - previous[2]);
                this.kamon$instrumentation$system$process$ProcessMetricsCollector$MetricsCollectionTask$$$outer().kamon$instrumentation$system$process$ProcessMetricsCollector$$_processCpuInstruments().user().record(this.toPercent$1(userTime, totalTime));
                this.kamon$instrumentation$system$process$ProcessMetricsCollector$MetricsCollectionTask$$$outer().kamon$instrumentation$system$process$ProcessMetricsCollector$$_processCpuInstruments().system().record(this.toPercent$1(kernelTime, totalTime));
                boxedUnit = this.kamon$instrumentation$system$process$ProcessMetricsCollector$MetricsCollectionTask$$$outer().kamon$instrumentation$system$process$ProcessMetricsCollector$$_processCpuInstruments().combined().record(this.toPercent$1(userTime + kernelTime, totalTime));
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            this._previousProcessCpuTime_$eq(current);
        }

        private void recordProcessULimits() {
            OSProcess process2 = this._os().getProcess(this.kamon$instrumentation$system$process$ProcessMetricsCollector$MetricsCollectionTask$$_pid());
            this.kamon$instrumentation$system$process$ProcessMetricsCollector$MetricsCollectionTask$$$outer().kamon$instrumentation$system$process$ProcessMetricsCollector$$_processCpuInstruments().openFilesCurrent().update((double)Math.max(process2.getOpenFiles(), 0L));
            Try$.MODULE$.apply((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ MetricsCollectionTask $outer;

                public final Object apply() {
                    BoxedUnit boxedUnit;
                    if (Platform.isLinux()) {
                        List allLimits = FileUtil.readFile((String)String.format(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"/proc/", "/limits"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.kamon$instrumentation$system$process$ProcessMetricsCollector$MetricsCollectionTask$$_pid())})), new Object[0]));
                        boxedUnit = ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)allLimits).asScala()).find((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final boolean apply(String x$1) {
                                return x$1.toLowerCase().startsWith("max open files");
                            }
                        }).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ MetricsCollectionTask$$anonfun$recordProcessULimits$1 $outer;

                            public final Gauge apply(String openFilesLimitLine) {
                                int openFilesLimit = ParseUtil.getNthIntValue((String)openFilesLimitLine, (int)1);
                                return this.$outer.kamon$instrumentation$system$process$ProcessMetricsCollector$MetricsCollectionTask$$anonfun$$$outer().kamon$instrumentation$system$process$ProcessMetricsCollector$MetricsCollectionTask$$$outer().kamon$instrumentation$system$process$ProcessMetricsCollector$$_processCpuInstruments().openFilesLimit().update((double)openFilesLimit);
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        });
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    return boxedUnit;
                }

                public /* synthetic */ MetricsCollectionTask kamon$instrumentation$system$process$ProcessMetricsCollector$MetricsCollectionTask$$anonfun$$$outer() {
                    return this.$outer;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
        }

        public /* synthetic */ ProcessMetricsCollector kamon$instrumentation$system$process$ProcessMetricsCollector$MetricsCollectionTask$$$outer() {
            return ProcessMetricsCollector.this;
        }

        private final long toPercent$1(long value, long totalTime$1) {
            return totalTime$1 > 0L ? (long)(100.0 * (double)value / (double)totalTime$1 / this._processorCount()) : 0L;
        }

        public MetricsCollectionTask() {
            if (ProcessMetricsCollector.this == null) {
                throw null;
            }
            this._systemInfo = new SystemInfo();
            this._hal = this._systemInfo().getHardware();
            this._os = this._systemInfo().getOperatingSystem();
            this.kamon$instrumentation$system$process$ProcessMetricsCollector$MetricsCollectionTask$$_pid = this._os().getProcessId();
            this._processorCount = this._hal().getProcessor().getLogicalProcessorCount();
            this._previousProcessCpuTime = (long[])Array$.MODULE$.empty(ClassTag$.MODULE$.Long());
        }
    }
}

