/*
 * Decompiled with CFR 0.152.
 */
package kamon.okhttp3.instrumentation;

import com.typesafe.config.Config;
import java.util.List;
import kamon.Kamon$;
import kamon.instrumentation.http.HttpClientInstrumentation;
import kamon.instrumentation.http.HttpClientInstrumentation$;
import kamon.instrumentation.http.HttpMessage;
import okhttp3.Headers;
import okhttp3.Request;
import okhttp3.Response;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;

public final class KamonOkHttpTracing$ {
    public static final KamonOkHttpTracing$ MODULE$;
    private final Config httpClientConfig;
    private final HttpClientInstrumentation instrumentation;

    static {
        new KamonOkHttpTracing$();
    }

    private Config httpClientConfig() {
        return this.httpClientConfig;
    }

    private HttpClientInstrumentation instrumentation() {
        return this.instrumentation;
    }

    public HttpClientInstrumentation.RequestHandler<Request> withNewSpan(Request request) {
        return this.instrumentation().createHandler(this.getRequestBuilder(request), Kamon$.MODULE$.currentContext());
    }

    public Response successContinuation(HttpClientInstrumentation.RequestHandler<Request> requestHandler, Response response) {
        requestHandler.processResponse(this.toKamonResponse(response));
        return response;
    }

    public void failureContinuation(HttpClientInstrumentation.RequestHandler<Request> requestHandler, Throwable error) {
        requestHandler.span().fail(error);
        requestHandler.span().finish();
    }

    public HttpMessage.RequestBuilder<Request> getRequestBuilder(Request request) {
        return new HttpMessage.RequestBuilder<Request>(request){
            private final Map<String, String> _headers;
            private final Request request$1;

            private Map<String, String> _headers() {
                return this._headers;
            }

            public Option<String> read(String header) {
                return Option$.MODULE$.apply((Object)this.request$1.header(header));
            }

            public scala.collection.immutable.Map<String, String> readAll() {
                return ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(this.request$1.headers().toMultimap()).asScala()).mapValues((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(List<String> values) {
                        return values.get(0);
                    }
                }).toMap(Predef$.MODULE$.$conforms());
            }

            public String url() {
                return this.request$1.url().toString();
            }

            public String path() {
                return this.request$1.url().uri().getPath();
            }

            public String method() {
                return this.request$1.method();
            }

            public String host() {
                return this.request$1.url().host();
            }

            public int port() {
                return this.request$1.url().port();
            }

            public void write(String header, String value) {
                this._headers().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)header), (Object)value));
            }

            public Request build() {
                Headers.Builder newHeadersMap = this.request$1.headers().newBuilder();
                this._headers().foreach((Function1)new Serializable(this, newHeadersMap){
                    public static final long serialVersionUID = 0L;
                    private final Headers.Builder newHeadersMap$1;

                    public final Headers.Builder apply(Tuple2<String, String> x0$1) {
                        Tuple2<String, String> tuple2 = x0$1;
                        if (tuple2 != null) {
                            String key = (String)tuple2._1();
                            String value = (String)tuple2._2();
                            Headers.Builder builder = this.newHeadersMap$1.add(key, value);
                            return builder;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        this.newHeadersMap$1 = newHeadersMap$1;
                    }
                });
                return this.request$1.newBuilder().headers(newHeadersMap.build()).build();
            }
            {
                this.request$1 = request$1;
                this._headers = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
            }
        };
    }

    public HttpMessage.Response toKamonResponse(Response response) {
        return new HttpMessage.Response(response){
            private final Response response$1;

            public int statusCode() {
                return this.response$1.code();
            }
            {
                this.response$1 = response$1;
            }
        };
    }

    private KamonOkHttpTracing$() {
        MODULE$ = this;
        this.httpClientConfig = Kamon$.MODULE$.config().getConfig("kamon.instrumentation.okhttp.http-client");
        this.instrumentation = HttpClientInstrumentation$.MODULE$.from(this.httpClientConfig(), "okhttp-client");
    }
}

