/*
 * Decompiled with CFR 0.152.
 */
package kamon.runtime;

import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import kamon.lib.net.bytebuddy.agent.ByteBuddyAgent;
import kamon.runtime.attacher.BuildInfo$;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.runtime.BoxedUnit;
import scala.util.control.NonFatal$;

public final class Attacher$ {
    public static final Attacher$ MODULE$;
    private final String _instrumentationClassLoaderProp;

    static {
        new Attacher$();
    }

    private String _instrumentationClassLoaderProp() {
        return this._instrumentationClassLoaderProp;
    }

    public void attach() {
        Option<ClassLoader> springBootClassLoader = this.findSpringBootJarLauncherClassLoader();
        if (this.isKanelaLoaded()) {
            springBootClassLoader.foreach((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final void apply(ClassLoader sbClassLoader) {
                    Attacher$.MODULE$.withInstrumentationClassLoader(sbClassLoader, new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final void apply() {
                            this.apply$mcV$sp();
                        }

                        public void apply$mcV$sp() {
                            Attacher$.MODULE$.kamon$runtime$Attacher$$reloadKanela();
                        }
                    });
                }
            });
        } else {
            InputStream embeddedAgentFile = this.getClass().getClassLoader().getResourceAsStream(BuildInfo$.MODULE$.kanelaAgentJarName());
            Path temporaryAgentFile = Files.createTempFile(BuildInfo$.MODULE$.kanelaAgentJarName(), ".jar", new FileAttribute[0]);
            Files.copy(embeddedAgentFile, temporaryAgentFile, StandardCopyOption.REPLACE_EXISTING);
            this.withInstrumentationClassLoader((ClassLoader)springBootClassLoader.orNull(Predef$.MODULE$.$conforms()), (Function0)new Serializable(temporaryAgentFile){
                public static final long serialVersionUID = 0L;
                private final Path temporaryAgentFile$1;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    ByteBuddyAgent.attach(this.temporaryAgentFile$1.toFile(), Attacher$.MODULE$.kamon$runtime$Attacher$$pid());
                }
                {
                    this.temporaryAgentFile$1 = temporaryAgentFile$1;
                }
            });
            try {
                temporaryAgentFile.toFile().deleteOnExit();
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (option.isEmpty()) {
                    throw throwable;
                }
                Throwable t = (Throwable)option.get();
                LoggerFactory.getLogger(this.getClass()).warn("Failed to mark the temporary Kanela Agent file for deletion after exiting the JVM", t);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    private boolean isKanelaLoaded() {
        boolean bl;
        boolean isLoadedProperty = Boolean.parseBoolean(System.getProperty("kanela.loaded"));
        try {
            bl = Class.forName("kanela.agent.Kanela", false, ClassLoader.getSystemClassLoader()) != null;
        }
        catch (Throwable throwable) {
            bl = false;
        }
        boolean hasKanelaClasses = bl;
        return hasKanelaClasses && isLoadedProperty;
    }

    private Option<ClassLoader> findSpringBootJarLauncherClassLoader() {
        return Option$.MODULE$.apply((Object)Thread.currentThread().getContextClassLoader()).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(ClassLoader cl) {
                String string = cl.getClass().getName();
                String string2 = "org.springframework.boot.loader.LaunchedURLClassLoader";
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
        });
    }

    public void kamon$runtime$Attacher$$reloadKanela() {
        Class.forName("kanela.agent.Kanela", true, ClassLoader.getSystemClassLoader()).getDeclaredMethod("reload", new Class[0]).invoke(null, new Object[0]);
    }

    public String kamon$runtime$Attacher$$pid() {
        String jvm = ManagementFactory.getRuntimeMXBean().getName();
        return jvm.substring(0, jvm.indexOf(64));
    }

    public <T> T withInstrumentationClassLoader(ClassLoader classLoader, Function0<T> thunk) {
        try {
            Object object = classLoader == null ? BoxedUnit.UNIT : System.getProperties().put(this._instrumentationClassLoaderProp(), classLoader);
            return (T)thunk.apply();
        }
        finally {
            System.getProperties().remove(this._instrumentationClassLoaderProp());
        }
    }

    private Attacher$() {
        MODULE$ = this;
        this._instrumentationClassLoaderProp = "kanela.instrumentation.classLoader";
    }
}

