/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.statement;

import java.util.ArrayList;
import java.util.List;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.StatementVisitor;
import net.sf.jsqlparser.statement.select.PlainSelect;

public final class SetStatement
implements Statement {
    private String effectParameter;
    private final List<NameExpr> values = new ArrayList<NameExpr>();

    public SetStatement() {
    }

    public SetStatement(String name2, List<Expression> value) {
        this.add(name2, value, true);
    }

    public void add(String name2, List<Expression> value, boolean useEqual) {
        this.values.add(new NameExpr(name2, value, useEqual));
    }

    public void remove(int idx) {
        this.values.remove(idx);
    }

    public int getCount() {
        return this.values.size();
    }

    public boolean isUseEqual(int idx) {
        return this.values.get(idx).useEqual;
    }

    public boolean isUseEqual() {
        return this.isUseEqual(0);
    }

    public SetStatement withUseEqual(int idx, boolean useEqual) {
        this.setUseEqual(idx, useEqual);
        return this;
    }

    public SetStatement setUseEqual(int idx, boolean useEqual) {
        this.values.get(idx).useEqual = useEqual;
        return this;
    }

    public SetStatement withUseEqual(boolean useEqual) {
        this.setUseEqual(useEqual);
        return this;
    }

    public SetStatement setUseEqual(boolean useEqual) {
        return this.setUseEqual(0, useEqual);
    }

    public String getName() {
        return this.getName(0);
    }

    public String getName(int idx) {
        return this.values.get(idx).name;
    }

    public void setName(String name2) {
        this.setName(0, name2);
    }

    public void setName(int idx, String name2) {
        this.values.get(idx).name = name2;
    }

    public List<Expression> getExpressions(int idx) {
        return this.values.get(idx).expressions;
    }

    public List<Expression> getExpressions() {
        return this.getExpressions(0);
    }

    public void setExpressions(int idx, List<Expression> expressions) {
        this.values.get(idx).expressions = expressions;
    }

    public void setExpressions(List<Expression> expressions) {
        this.setExpressions(0, expressions);
    }

    private String toString(NameExpr ne) {
        return ne.name + (ne.useEqual ? " = " : " ") + PlainSelect.getStringList(ne.expressions, true, false);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("SET ");
        if (this.effectParameter != null) {
            b.append(this.effectParameter).append(" ");
        }
        boolean addComma = false;
        for (NameExpr ne : this.values) {
            if (addComma) {
                b.append(", ");
            } else {
                addComma = true;
            }
            b.append(this.toString(ne));
        }
        return b.toString();
    }

    @Override
    public void accept(StatementVisitor statementVisitor) {
        statementVisitor.visit(this);
    }

    public String getEffectParameter() {
        return this.effectParameter;
    }

    public void setEffectParameter(String effectParameter) {
        this.effectParameter = effectParameter;
    }

    public SetStatement withEffectParameter(String effectParameter) {
        this.effectParameter = effectParameter;
        return this;
    }

    static class NameExpr {
        private String name;
        private List<Expression> expressions;
        private boolean useEqual;

        public NameExpr(String name2, List<Expression> expressions, boolean useEqual) {
            this.name = name2;
            this.expressions = expressions;
            this.useEqual = useEqual;
        }
    }
}

