/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.statement.create.synonym;

import java.util.ArrayList;
import java.util.List;
import net.sf.jsqlparser.schema.Synonym;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.StatementVisitor;

public class CreateSynonym
implements Statement {
    private boolean orReplace;
    private boolean publicSynonym;
    public Synonym synonym;
    private List<String> forList = new ArrayList<String>();

    public void setSynonym(Synonym synonym) {
        this.synonym = synonym;
    }

    public Synonym getSynonym() {
        return this.synonym;
    }

    public boolean isOrReplace() {
        return this.orReplace;
    }

    public void setOrReplace(boolean orReplace) {
        this.orReplace = orReplace;
    }

    public boolean isPublicSynonym() {
        return this.publicSynonym;
    }

    public void setPublicSynonym(boolean publicSynonym) {
        this.publicSynonym = publicSynonym;
    }

    public void setForList(List<String> forList) {
        this.forList = forList;
    }

    public List<String> getForList() {
        return this.forList;
    }

    public String getFor() {
        StringBuilder b = new StringBuilder();
        for (String name2 : this.forList) {
            if (b.length() > 0) {
                b.append(".");
            }
            b.append(name2);
        }
        return b.toString();
    }

    @Override
    public void accept(StatementVisitor statementVisitor) {
        statementVisitor.visit(this);
    }

    public String toString() {
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append("CREATE ");
        if (this.orReplace) {
            sqlBuilder.append("OR REPLACE ");
        }
        if (this.publicSynonym) {
            sqlBuilder.append("PUBLIC ");
        }
        sqlBuilder.append("SYNONYM " + this.synonym);
        sqlBuilder.append(' ');
        sqlBuilder.append("FOR " + this.getFor());
        return sqlBuilder.toString();
    }

    public CreateSynonym withSynonym(Synonym synonym) {
        this.setSynonym(synonym);
        return this;
    }
}

