/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.statement.replace;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.operators.relational.ItemsList;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.StatementVisitor;
import net.sf.jsqlparser.statement.select.PlainSelect;

public class Replace
implements Statement {
    private Table table;
    private List<Column> columns;
    private ItemsList itemsList;
    private List<Expression> expressions;
    private boolean useValues = true;
    private boolean useIntoTables = false;

    @Override
    public void accept(StatementVisitor statementVisitor) {
        statementVisitor.visit(this);
    }

    public Table getTable() {
        return this.table;
    }

    public void setTable(Table name2) {
        this.table = name2;
    }

    public boolean isUseIntoTables() {
        return this.useIntoTables;
    }

    public void setUseIntoTables(boolean useIntoTables) {
        this.useIntoTables = useIntoTables;
    }

    public List<Column> getColumns() {
        return this.columns;
    }

    public ItemsList getItemsList() {
        return this.itemsList;
    }

    public void setColumns(List<Column> list) {
        this.columns = list;
    }

    public void setItemsList(ItemsList list) {
        this.itemsList = list;
    }

    public List<Expression> getExpressions() {
        return this.expressions;
    }

    public void setExpressions(List<Expression> list) {
        this.expressions = list;
    }

    public boolean isUseValues() {
        return this.useValues;
    }

    public void setUseValues(boolean useValues) {
        this.useValues = useValues;
    }

    public String toString() {
        StringBuilder sql = new StringBuilder();
        sql.append("REPLACE ");
        if (this.isUseIntoTables()) {
            sql.append("INTO ");
        }
        sql.append(this.table);
        if (this.expressions != null && this.columns != null) {
            sql.append(" SET ");
            int s2 = this.columns.size();
            for (int i = 0; i < s2; ++i) {
                sql.append(this.columns.get(i)).append("=").append(this.expressions.get(i));
                sql.append(i < s2 - 1 ? ", " : "");
            }
        } else if (this.columns != null) {
            sql.append(" ").append(PlainSelect.getStringList(this.columns, true, true));
        }
        if (this.itemsList != null) {
            if (this.useValues) {
                sql.append(" VALUES");
            }
            sql.append(" ").append(this.itemsList);
        }
        return sql.toString();
    }

    public Replace withUseValues(boolean useValues) {
        this.setUseValues(useValues);
        return this;
    }

    public Replace withUseIntoTables(boolean useIntoTables) {
        this.setUseIntoTables(useIntoTables);
        return this;
    }

    public Replace withTable(Table table) {
        this.setTable(table);
        return this;
    }

    public Replace withColumns(List<Column> columns) {
        this.setColumns(columns);
        return this;
    }

    public Replace withItemsList(ItemsList itemsList) {
        this.setItemsList(itemsList);
        return this;
    }

    public Replace withExpressions(List<Expression> expressions) {
        this.setExpressions(expressions);
        return this;
    }

    public Replace addColumns(Column ... columns) {
        List collection = Optional.ofNullable(this.getColumns()).orElseGet(ArrayList::new);
        Collections.addAll(collection, columns);
        return this.withColumns(collection);
    }

    public Replace addColumns(Collection<? extends Column> columns) {
        List collection = Optional.ofNullable(this.getColumns()).orElseGet(ArrayList::new);
        collection.addAll(columns);
        return this.withColumns(collection);
    }

    public Replace addExpressions(Expression ... expressions) {
        List collection = Optional.ofNullable(this.getExpressions()).orElseGet(ArrayList::new);
        Collections.addAll(collection, expressions);
        return this.withExpressions(collection);
    }

    public Replace addExpressions(Collection<? extends Expression> expressions) {
        List collection = Optional.ofNullable(this.getExpressions()).orElseGet(ArrayList::new);
        collection.addAll(expressions);
        return this.withExpressions(collection);
    }

    public <E extends ItemsList> E getItemsList(Class<E> type) {
        return (E)((ItemsList)type.cast(this.getItemsList()));
    }
}

