/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.statement.select;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.expression.operators.relational.ItemsList;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.SelectBody;
import net.sf.jsqlparser.statement.select.SelectItem;
import net.sf.jsqlparser.statement.select.SelectVisitor;
import net.sf.jsqlparser.statement.select.SubSelect;

public class WithItem
implements SelectBody {
    private String name;
    private List<SelectItem> withItemList;
    private ItemsList itemsList;
    private boolean useValues = true;
    private boolean useBracketsForValues = false;
    private SubSelect subSelect;
    private boolean recursive;

    public ItemsList getItemsList() {
        return this.itemsList;
    }

    public void setItemsList(ItemsList list) {
        this.itemsList = list;
    }

    public boolean isUseValues() {
        return this.useValues;
    }

    public void setUseValues(boolean useValues) {
        this.useValues = useValues;
    }

    public WithItem withItemsList(ItemsList itemsList) {
        this.setItemsList(itemsList);
        return this;
    }

    public WithItem withUseValues(boolean useValues) {
        this.setUseValues(useValues);
        return this;
    }

    public boolean isUsingBracketsForValues() {
        return this.useBracketsForValues;
    }

    public void setUseBracketsForValues(boolean useBracketsForValues) {
        this.useBracketsForValues = useBracketsForValues;
    }

    public WithItem withUseBracketsForValues(boolean useBracketsForValues) {
        this.setUseBracketsForValues(useBracketsForValues);
        return this;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name2) {
        this.name = name2;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    public void setRecursive(boolean recursive) {
        this.recursive = recursive;
    }

    public SubSelect getSubSelect() {
        return this.subSelect.withUseBrackets(false);
    }

    public void setSubSelect(SubSelect subSelect) {
        this.subSelect = subSelect.withUseBrackets(false);
    }

    public List<SelectItem> getWithItemList() {
        return this.withItemList;
    }

    public void setWithItemList(List<SelectItem> withItemList) {
        this.withItemList = withItemList;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.recursive ? "RECURSIVE " : "");
        builder.append(this.name);
        builder.append(this.withItemList != null ? " " + PlainSelect.getStringList(this.withItemList, true, true) : "");
        builder.append(" AS ");
        if (this.useValues) {
            builder.append("(VALUES ");
            ExpressionList expressionList = (ExpressionList)this.itemsList;
            builder.append(PlainSelect.getStringList(expressionList.getExpressions(), true, this.useBracketsForValues));
            builder.append(")");
        } else {
            builder.append(this.subSelect.isUseBrackets() ? "" : "(");
            builder.append(this.subSelect);
            builder.append(this.subSelect.isUseBrackets() ? "" : ")");
        }
        return builder.toString();
    }

    @Override
    public void accept(SelectVisitor visitor) {
        visitor.visit(this);
    }

    public WithItem withName(String name2) {
        this.setName(name2);
        return this;
    }

    public WithItem withWithItemList(List<SelectItem> withItemList) {
        this.setWithItemList(withItemList);
        return this;
    }

    public WithItem withSubSelect(SubSelect subSelect) {
        this.setSubSelect(subSelect);
        return this;
    }

    public WithItem withRecursive(boolean recursive) {
        this.setRecursive(recursive);
        return this;
    }

    public WithItem addWithItemList(SelectItem ... withItemList) {
        List collection = Optional.ofNullable(this.getWithItemList()).orElseGet(ArrayList::new);
        Collections.addAll(collection, withItemList);
        return this.withWithItemList(collection);
    }

    public WithItem addWithItemList(Collection<? extends SelectItem> withItemList) {
        List collection = Optional.ofNullable(this.getWithItemList()).orElseGet(ArrayList::new);
        collection.addAll(withItemList);
        return this.withWithItemList(collection);
    }
}

