/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.util.validation.feature;

import java.util.EnumSet;
import java.util.Set;
import net.sf.jsqlparser.parser.feature.Feature;
import net.sf.jsqlparser.util.validation.feature.FeatureSetValidation;
import net.sf.jsqlparser.util.validation.feature.H2Version;
import net.sf.jsqlparser.util.validation.feature.MariaDbVersion;
import net.sf.jsqlparser.util.validation.feature.MySqlVersion;
import net.sf.jsqlparser.util.validation.feature.OracleVersion;
import net.sf.jsqlparser.util.validation.feature.PostgresqlVersion;
import net.sf.jsqlparser.util.validation.feature.SQLVersion;
import net.sf.jsqlparser.util.validation.feature.SqlServerVersion;
import net.sf.jsqlparser.util.validation.feature.Version;

public enum DatabaseType implements FeatureSetValidation,
Version
{
    ANSI_SQL("ANSI SQL", (Version[])SQLVersion.values()),
    ORACLE(OracleVersion.values()),
    MYSQL(MySqlVersion.values()),
    SQLSERVER(SqlServerVersion.values()),
    MARIADB(MariaDbVersion.values()),
    POSTGRESQL(PostgresqlVersion.values()),
    H2(H2Version.values());

    public static final DatabaseType[] DATABASES;
    private String name;
    private Version[] versions;

    private DatabaseType(Version ... versions) {
        this.versions = versions;
    }

    private DatabaseType(String name2, Version ... versions) {
        this.name = name2;
        this.versions = versions;
    }

    public static DatabaseType get(String jdbcIdentifier) {
        return DatabaseType.valueOf(jdbcIdentifier.toUpperCase());
    }

    @Override
    public String getName() {
        return this.name == null ? this.name() : this.name;
    }

    @Override
    public Set<Feature> getFeatures() {
        if (this.versions.length > 0) {
            return this.versions[this.versions.length - 1].getFeatures();
        }
        return EnumSet.noneOf(Feature.class);
    }

    @Override
    public String getVersionString() {
        if (this.versions.length > 0) {
            return this.versions[this.versions.length - 1].getVersionString();
        }
        return null;
    }

    static {
        DATABASES = new DatabaseType[]{ORACLE, MYSQL, SQLSERVER, MARIADB, POSTGRESQL, H2};
    }
}

