/*
 * Decompiled with CFR 0.152.
 */
package kamon.instrumentation.akka.instrumentations;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import java.io.Serializable;
import kamon.Kamon$;
import kamon.instrumentation.akka.AkkaInstrumentation;
import kamon.instrumentation.akka.AkkaInstrumentation$;
import kamon.instrumentation.akka.AkkaMetrics;
import kamon.instrumentation.akka.AkkaMetrics$;
import kamon.instrumentation.akka.instrumentations.ActorCellInfo;
import kamon.instrumentation.akka.instrumentations.ActorCellInfo$;
import kamon.instrumentation.akka.instrumentations.ActorMonitor;
import kamon.instrumentation.akka.instrumentations.HasGroupPath;
import kamon.util.Filter;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;

public final class ActorMonitor$ {
    public static ActorMonitor$ MODULE$;

    static {
        new ActorMonitor$();
    }

    public ActorMonitor from(Object actorCell, ActorRef ref, ActorRef parent, ActorSystem system) {
        ActorMonitor actorMonitor;
        ActorCellInfo cell = ActorCellInfo$.MODULE$.from(actorCell, ref, parent, system);
        AkkaInstrumentation.Settings settings = AkkaInstrumentation$.MODULE$.settings();
        boolean isTraced = Kamon$.MODULE$.filter(AkkaInstrumentation$.MODULE$.TraceActorFilterName()).accept(cell.path());
        boolean startsTrace = settings.safeActorStartTraceFilter().accept(cell.path());
        boolean participatesInTracing = isTraced || startsTrace;
        String autoGroupingPath = this.resolveAutoGroupingPath(cell.actorOrRouterClass(), ref, parent, system.name());
        if (cell.isRouter()) {
            actorMonitor = new ActorMonitor.ContextPropagationOnly(cell, participatesInTracing, false);
        } else {
            Seq<String> configuredMatchingGroups;
            boolean isTracked;
            Filter trackedFilter = cell.isRouter() || cell.isRoutee() ? Kamon$.MODULE$.filter(AkkaInstrumentation$.MODULE$.TrackRouterFilterName()) : settings.safeActorTrackFilter();
            boolean bl = isTracked = !cell.isRootSupervisor() && trackedFilter.accept(cell.path());
            Object object = cell.isRootSupervisor() ? Nil$.MODULE$ : ((configuredMatchingGroups = AkkaInstrumentation$.MODULE$.matchingActorGroups(cell.path())).isEmpty() && !isTracked && settings.autoGrouping() && !cell.isRouter() && !cell.isRoutee() ? (!trackedFilter.excludes(cell.path()) && Kamon$.MODULE$.filter(AkkaInstrumentation$.MODULE$.TrackAutoGroupFilterName()).accept(autoGroupingPath) ? new .colon.colon((Object)AkkaMetrics$.MODULE$.forGroup(autoGroupingPath, system.name()), (List)Nil$.MODULE$) : List$.MODULE$.empty()) : (Seq)configuredMatchingGroups.map((Function1 & Serializable & scala.Serializable)groupName -> AkkaMetrics$.MODULE$.forGroup((String)groupName, cell.systemName()), Seq$.MODULE$.canBuildFrom()));
            Nil$ trackingGroups = object;
            actorMonitor = cell.isRoutee() && isTracked ? this.createRouteeMonitor(cell, (Seq<AkkaMetrics.ActorGroupInstruments>)trackingGroups) : this.createRegularActorMonitor(cell, isTracked, participatesInTracing, (Seq<AkkaMetrics.ActorGroupInstruments>)trackingGroups);
        }
        ActorMonitor.ContextPropagationOnly monitor = actorMonitor;
        return ActorMonitor$.traceWrap$1(monitor, participatesInTracing, cell, startsTrace);
    }

    private ActorMonitor createRegularActorMonitor(ActorCellInfo cellInfo, boolean isTracked, boolean participatesInTracing, Seq<AkkaMetrics.ActorGroupInstruments> groupMetrics) {
        ActorMonitor actorMonitor;
        if (isTracked || !groupMetrics.isEmpty()) {
            None$ actorMetrics = !isTracked ? None$.MODULE$ : new Some((Object)AkkaMetrics$.MODULE$.forActor(cellInfo.path(), cellInfo.systemName(), cellInfo.dispatcherName(), cellInfo.actorOrRouterClass().getName()));
            actorMonitor = new ActorMonitor.TrackedActor((Option<AkkaMetrics.ActorInstruments>)actorMetrics, groupMetrics, cellInfo);
        } else {
            actorMonitor = new ActorMonitor.ContextPropagationOnly(cellInfo, participatesInTracing, true);
        }
        return actorMonitor;
    }

    private ActorMonitor createRouteeMonitor(ActorCellInfo cellInfo, Seq<AkkaMetrics.ActorGroupInstruments> groupMetrics) {
        AkkaMetrics.RouterInstruments routerMetrics = AkkaMetrics$.MODULE$.forRouter(cellInfo.path(), cellInfo.systemName(), cellInfo.dispatcherName(), cellInfo.actorOrRouterClass().getName(), (String)cellInfo.routeeClass().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getName()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "Unknown"));
        return new ActorMonitor.TrackedRoutee(routerMetrics, groupMetrics, cellInfo);
    }

    private String resolveAutoGroupingPath(Class<?> actorClass, ActorRef ref, ActorRef parent, String systemName) {
        String string;
        String parentPath;
        String name = ref.path().name();
        int elementCount = ref.path().elements().size();
        String string2 = parentPath = parent instanceof HasGroupPath ? ((HasGroupPath)parent).groupPath() : "";
        if (elementCount == 1) {
            String string3 = name;
            String string4 = "/";
            string = !(string3 != null ? !string3.equals(string4) : string4 != null) ? "" : new StringBuilder(1).append(systemName).append("/").append(name).toString();
        } else {
            string = ActorCellInfo$.MODULE$.simpleClassName(actorClass);
        }
        String refGroupName = string;
        String refGroupPath = parentPath.isEmpty() ? refGroupName : new StringBuilder(1).append(parentPath).append("/").append(refGroupName).toString();
        ((HasGroupPath)ref).setGroupPath(refGroupPath);
        return refGroupPath;
    }

    private static final ActorMonitor traceWrap$1(ActorMonitor monitor, boolean participatesInTracing$1, ActorCellInfo cell$1, boolean startsTrace$1) {
        return participatesInTracing$1 ? new ActorMonitor.TracedMonitor(cell$1, startsTrace$1, monitor) : monitor;
    }

    private ActorMonitor$() {
        MODULE$ = this;
    }
}

