/*
 * Decompiled with CFR 0.152.
 */
package kamon.instrumentation.akka.http;

import akka.http.scaladsl.marshalling.Marshaller;
import akka.http.scaladsl.marshalling.Marshaller$;
import akka.http.scaladsl.marshalling.ToResponseMarshallable;
import akka.http.scaladsl.marshalling.ToResponseMarshallable$;
import akka.http.scaladsl.model.HttpHeader;
import akka.http.scaladsl.model.HttpResponse;
import akka.http.scaladsl.model.RequestEntity;
import akka.http.scaladsl.model.StatusCode;
import akka.http.scaladsl.model.StatusCodes;
import akka.http.scaladsl.model.Uri;
import akka.http.scaladsl.server.Directive;
import akka.http.scaladsl.server.Directive$;
import akka.http.scaladsl.server.RequestContext;
import akka.http.scaladsl.server.StandardRoute;
import akka.http.scaladsl.server.StandardRoute$;
import akka.http.scaladsl.server.directives.CompleteOrRecoverWithMagnet;
import akka.http.scaladsl.server.directives.OnSuccessMagnet;
import akka.http.scaladsl.server.util.Tuple$;
import akka.http.scaladsl.server.util.Tupler;
import akka.http.scaladsl.util.FastFuture;
import akka.http.scaladsl.util.FastFuture$;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.regex.Pattern;
import kamon.Kamon$;
import kamon.instrumentation.akka.http.HasMatchingContext;
import kamon.instrumentation.akka.http.LastAutomaticOperationNameEdit$;
import kamon.trace.Span;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple1;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

public final class ResolveOperationNameOnRouteInterceptor$ {
    public static ResolveOperationNameOnRouteInterceptor$ MODULE$;

    static {
        new ResolveOperationNameOnRouteInterceptor$();
    }

    public StandardRoute complete(Function0<ToResponseMarshallable> m3) {
        return StandardRoute$.MODULE$.apply((Function1 & Serializable & scala.Serializable)x$2 -> MODULE$.kamon$instrumentation$akka$http$ResolveOperationNameOnRouteInterceptor$$resolveOperationName((RequestContext)x$2).complete((ToResponseMarshallable)m3.apply()));
    }

    public <T> StandardRoute complete(StatusCode status, Function0<T> v, Marshaller<T, RequestEntity> m3) {
        return StandardRoute$.MODULE$.apply((Function1 & Serializable & scala.Serializable)x$3 -> MODULE$.kamon$instrumentation$akka$http$ResolveOperationNameOnRouteInterceptor$$resolveOperationName((RequestContext)x$3).complete(ToResponseMarshallable$.MODULE$.apply((Object)new Tuple2((Object)status, v.apply()), Marshaller$.MODULE$.fromStatusCodeAndValue((Function1)Predef$.MODULE$.$conforms(), m3))));
    }

    public <T> StandardRoute complete(StatusCode status, scala.collection.immutable.Seq<HttpHeader> headers, Function0<T> v, Marshaller<T, RequestEntity> m3) {
        return this.complete((Function0<ToResponseMarshallable>)(Function0 & Serializable & scala.Serializable)() -> ToResponseMarshallable$.MODULE$.apply((Object)new Tuple3((Object)status, (Object)headers, v.apply()), Marshaller$.MODULE$.fromStatusCodeAndHeadersAndValue(m3)));
    }

    public StandardRoute redirect(Uri uri, StatusCodes.Redirection redirectionType) {
        return StandardRoute$.MODULE$.apply((Function1 & Serializable & scala.Serializable)x$4 -> MODULE$.kamon$instrumentation$akka$http$ResolveOperationNameOnRouteInterceptor$$resolveOperationName((RequestContext)x$4).redirect(uri, redirectionType));
    }

    public StandardRoute failWith(Throwable error) {
        Kamon$.MODULE$.currentSpan().fail(error);
        return StandardRoute$.MODULE$.apply((Function1 & Serializable & scala.Serializable)x$5 -> MODULE$.kamon$instrumentation$akka$http$ResolveOperationNameOnRouteInterceptor$$resolveOperationName((RequestContext)x$5).fail(error));
    }

    public <T> Directive<Tuple1<Try<T>>> onComplete(Function0<Future<T>> future) {
        return Directive$.MODULE$.apply((Function1 & Serializable & scala.Serializable)inner -> (Function1 & Serializable & scala.Serializable)ctx -> {
            MODULE$.kamon$instrumentation$akka$http$ResolveOperationNameOnRouteInterceptor$$resolveOperationName((RequestContext)ctx);
            return FastFuture$.MODULE$.transformWith$extension0(FastFuture.EnhancedFuture$.MODULE$.fast$extension(FastFuture$.MODULE$.EnhancedFuture((Future)future.apply())), (Function1 & Serializable & scala.Serializable)t -> (Future)((Function1)inner.apply((Object)new Tuple1(t))).apply(ctx), (ExecutionContext)ctx.executionContext());
        }, Tuple$.MODULE$.forTuple1());
    }

    public <T> OnSuccessMagnet apply(Function0<Future<T>> future, Tupler<T> tupler) {
        return new OnSuccessMagnet(future, tupler){
            private final Directive<Object> directive;
            private final Function0 future$2;
            private final Tupler tupler$1;

            public Directive<Object> directive() {
                return this.directive;
            }
            {
                this.future$2 = future$2;
                this.tupler$1 = tupler$1;
                this.directive = Directive$.MODULE$.apply((Function1 & Serializable & scala.Serializable)inner -> (Function1 & Serializable & scala.Serializable)ctx -> {
                    ResolveOperationNameOnRouteInterceptor$.MODULE$.kamon$instrumentation$akka$http$ResolveOperationNameOnRouteInterceptor$$resolveOperationName((RequestContext)ctx);
                    return FastFuture$.MODULE$.flatMap$extension(FastFuture.EnhancedFuture$.MODULE$.fast$extension(FastFuture$.MODULE$.EnhancedFuture((Future)$this.future$2.apply())), (Function1 & Serializable & scala.Serializable)t -> (Future)((Function1)inner.apply($this.tupler$1.apply(t))).apply(ctx), (ExecutionContext)ctx.executionContext());
                }, tupler$1.OutIsTuple());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$directive$3(kamon.instrumentation.akka.http.ResolveOperationNameOnRouteInterceptor$$anon$1 scala.Function1 akka.http.scaladsl.server.RequestContext java.lang.Object ), $anonfun$directive$2(kamon.instrumentation.akka.http.ResolveOperationNameOnRouteInterceptor$$anon$1 scala.Function1 akka.http.scaladsl.server.RequestContext ), $anonfun$directive$1(kamon.instrumentation.akka.http.ResolveOperationNameOnRouteInterceptor$$anon$1 scala.Function1 )}, serializedLambda);
            }
        };
    }

    public <T> CompleteOrRecoverWithMagnet apply(Function0<Future<T>> future, Marshaller<T, HttpResponse> m3) {
        return new CompleteOrRecoverWithMagnet(future, m3){
            private final Directive<Tuple1<Throwable>> directive;
            private final Function0 future$3;
            private final Marshaller m$4;

            public Directive<Tuple1<Throwable>> directive() {
                return this.directive;
            }
            {
                this.future$3 = future$3;
                this.m$4 = m$4;
                this.directive = Directive$.MODULE$.apply((Function1 & Serializable & scala.Serializable)inner -> (Function1 & Serializable & scala.Serializable)ctx -> {
                    ResolveOperationNameOnRouteInterceptor$.MODULE$.kamon$instrumentation$akka$http$ResolveOperationNameOnRouteInterceptor$$resolveOperationName((RequestContext)ctx);
                    return FastFuture$.MODULE$.transformWith$extension0(FastFuture.EnhancedFuture$.MODULE$.fast$extension(FastFuture$.MODULE$.EnhancedFuture((Future)$this.future$3.apply())), (Function1 & Serializable & scala.Serializable)x0$1 -> {
                        Future future;
                        if (x0$1 instanceof Success) {
                            Object res = ((Success)x0$1).value();
                            future = ctx.complete(ToResponseMarshallable$.MODULE$.apply(res, $this.m$4));
                        } else if (x0$1 instanceof Failure) {
                            Throwable error = ((Failure)x0$1).exception();
                            future = (Future)((Function1)inner.apply((Object)new Tuple1((Object)error))).apply(ctx);
                        } else {
                            throw new MatchError(x0$1);
                        }
                        return future;
                    }, (ExecutionContext)ctx.executionContext());
                }, Tuple$.MODULE$.forTuple1());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$directive$6(kamon.instrumentation.akka.http.ResolveOperationNameOnRouteInterceptor$$anon$2 akka.http.scaladsl.server.RequestContext scala.Function1 scala.util.Try ), $anonfun$directive$5(kamon.instrumentation.akka.http.ResolveOperationNameOnRouteInterceptor$$anon$2 scala.Function1 akka.http.scaladsl.server.RequestContext ), $anonfun$directive$4(kamon.instrumentation.akka.http.ResolveOperationNameOnRouteInterceptor$$anon$2 scala.Function1 )}, serializedLambda);
            }
        };
    }

    public RequestContext kamon$instrumentation$akka$http$ResolveOperationNameOnRouteInterceptor$$resolveOperationName(RequestContext requestContext) {
        ((Option)Kamon$.MODULE$.currentContext().get(LastAutomaticOperationNameEdit$.MODULE$.Key())).foreach((Function1 & Serializable & scala.Serializable)lastEdit -> {
            Span currentSpan = Kamon$.MODULE$.currentSpan();
            if (lastEdit.allowAutomaticChanges()) {
                String string = currentSpan.operationName();
                String string2 = lastEdit.operationName();
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    String operationName = ((Seq)((TraversableLike)((HasMatchingContext)requestContext).matchingContext().reverse()).map((Function1 & Serializable & scala.Serializable)matching -> MODULE$.singleMatch((HasMatchingContext.PathMatchingContext)matching), Seq$.MODULE$.canBuildFrom())).mkString("");
                    if (new StringOps(Predef$.MODULE$.augmentString(operationName)).nonEmpty()) {
                        currentSpan.name(operationName).takeSamplingDecision();
                        lastEdit.operationName_$eq(operationName);
                        return BoxedUnit.UNIT;
                    }
                    return BoxedUnit.UNIT;
                }
                lastEdit.allowAutomaticChanges_$eq(false);
                return BoxedUnit.UNIT;
            }
            return currentSpan.takeSamplingDecision();
        });
        return requestContext;
    }

    private String singleMatch(HasMatchingContext.PathMatchingContext matching) {
        String string;
        String rest = matching.matched().pathRest().toString();
        int consumedCount = matching.fullPath().length() - rest.length();
        String consumedSegment = matching.fullPath().substring(0, consumedCount);
        Object object = matching.matched().extractions();
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
        if (!(boxedUnit != null ? !boxedUnit.equals(object) : object != null)) {
            string = consumedSegment;
        } else if (object instanceof Product) {
            string = (String)((TraversableOnce)((List)((Product)object).productIterator().toList().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Nil$ nil$;
                if (x0$1 instanceof Some) {
                    Object x = ((Some)x0$1).value();
                    nil$ = new .colon.colon((Object)x.toString(), (List)Nil$.MODULE$);
                } else if (None$.MODULE$.equals(x0$1)) {
                    nil$ = Nil$.MODULE$;
                } else if (x0$1 instanceof Long) {
                    long l = BoxesRunTime.unboxToLong((Object)x0$1);
                    nil$ = new .colon.colon((Object)Long.toString(l), (List)new .colon.colon((Object)RichLong$.MODULE$.toHexString$extension(Predef$.MODULE$.longWrapper(l)), (List)Nil$.MODULE$));
                } else if (x0$1 instanceof Integer) {
                    int n = BoxesRunTime.unboxToInt((Object)x0$1);
                    nil$ = new .colon.colon((Object)Integer.toString(n), (List)new .colon.colon((Object)RichInt$.MODULE$.toHexString$extension(Predef$.MODULE$.intWrapper(n)), (List)Nil$.MODULE$));
                } else if (x0$1 instanceof Object) {
                    nil$ = new .colon.colon((Object)x0$1.toString(), (List)Nil$.MODULE$);
                } else {
                    throw new MatchError(x0$1);
                }
                return nil$;
            }, List$.MODULE$.canBuildFrom())).flatten((Function1)Predef$.MODULE$.$conforms())).fold((Object)consumedSegment, (Function2 & Serializable & scala.Serializable)(full, value) -> {
                String r = new StringBuilder(14).append("(?i)(^|/)").append(Pattern.quote(value)).append("($|/)").toString();
                return full.replaceFirst(r, "$1{}$2");
            });
        } else {
            throw new MatchError(object);
        }
        return string;
    }

    private ResolveOperationNameOnRouteInterceptor$() {
        MODULE$ = this;
    }
}

