/*
 * Decompiled with CFR 0.152.
 */
package kamon.instrumentation.cassandra.metrics;

import kamon.instrumentation.cassandra.CassandraInstrumentation;
import kamon.instrumentation.cassandra.CassandraInstrumentation$;
import kamon.instrumentation.cassandra.CassandraInstrumentation$Tags$;
import kamon.instrumentation.cassandra.NodeConnectionPoolMetrics;
import kamon.instrumentation.cassandra.SessionMetrics;
import kamon.instrumentation.trace.SpanTagger$;
import kamon.trace.Span;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015a\u0001B\f\u0019\u0001\u0005B\u0001\u0002\u000b\u0001\u0003\u0002\u0003\u0006I!\u000b\u0005\u0006s\u0001!\tA\u000f\u0005\b}\u0001\u0011\r\u0011\"\u0001@\u0011\u00199\u0005\u0001)A\u0005\u0001\"9\u0001\n\u0001b\u0001\n\u0003I\u0005BB)\u0001A\u0003%!\nC\u0003S\u0001\u0011\u00051\u000bC\u0003`\u0001\u0011\u0005\u0001\rC\u0003e\u0001\u0011\u0005Q\rC\u0003l\u0001\u0011\u0005A\u000eC\u0003n\u0001\u0011\u0005A\u000eC\u0003o\u0001\u0011\u0005A\u000eC\u0003p\u0001\u0011\u0005A\u000eC\u0003q\u0001\u0011\u0005A\u000eC\u0003r\u0001\u0011\u0005A\u000eC\u0003s\u0001\u0011\u0005A\u000eC\u0003t\u0001\u0011\u0005A\u000eC\u0003u\u0001\u0011\u0005A\u000eC\u0003v\u0001\u0011\u0005a\u000fC\u0003}\u0001\u0011\u0005A\u000eC\u0003~\u0001\u0011\u0005a\u0010\u0003\u0004\u0002\u0004\u0001!\t\u0001\u001c\u0002\f\u001d>$W-T8oSR|'O\u0003\u0002\u001a5\u00059Q.\u001a;sS\u000e\u001c(BA\u000e\u001d\u0003%\u0019\u0017m]:b]\u0012\u0014\u0018M\u0003\u0002\u001e=\u0005y\u0011N\\:ueVlWM\u001c;bi&|gNC\u0001 \u0003\u0015Y\u0017-\\8o\u0007\u0001\u0019\"\u0001\u0001\u0012\u0011\u0005\r2S\"\u0001\u0013\u000b\u0003\u0015\nQa]2bY\u0006L!a\n\u0013\u0003\r\u0005s\u0017PU3g\u0003\u0011qw\u000eZ3\u0011\u0005)2dBA\u00165\u001d\ta3G\u0004\u0002.e9\u0011a&M\u0007\u0002_)\u0011\u0001\u0007I\u0001\u0007yI|w\u000e\u001e \n\u0003}I!!\b\u0010\n\u0005ma\u0012BA\u001b\u001b\u0003a\u0019\u0015m]:b]\u0012\u0014\u0018-\u00138tiJ,X.\u001a8uCRLwN\\\u0005\u0003oa\u0012AAT8eK*\u0011QGG\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005mj\u0004C\u0001\u001f\u0001\u001b\u0005A\u0002\"\u0002\u0015\u0003\u0001\u0004I\u0013AD:fgNLwN\\'fiJL7m]\u000b\u0002\u0001B\u0011\u0011\t\u0012\b\u0003W\tK!a\u0011\u000e\u0002\u001dM+7o]5p]6+GO]5dg&\u0011QI\u0012\u0002\u0013'\u0016\u001c8/[8o\u0013:\u001cHO];nK:$8O\u0003\u0002D5\u0005y1/Z:tS>tW*\u001a;sS\u000e\u001c\b%A\u0006q_>dW*\u001a;sS\u000e\u001cX#\u0001&\u0011\u0005-seBA\u0016M\u0013\ti%$A\rO_\u0012,7i\u001c8oK\u000e$\u0018n\u001c8Q_>dW*\u001a;sS\u000e\u001c\u0018BA(Q\u0005uqu\u000eZ3D_:tWm\u0019;j_:\u0004vn\u001c7J]N$(/^7f]R\u001c(BA'\u001b\u00031\u0001xn\u001c7NKR\u0014\u0018nY:!\u00035\t\u0007\u000f\u001d7z\u001d>$W\rV1hgR\u0011Ak\u0016\t\u0003GUK!A\u0016\u0013\u0003\tUs\u0017\u000e\u001e\u0005\u00061\u001e\u0001\r!W\u0001\u0005gB\fg\u000e\u0005\u0002[;6\t1L\u0003\u0002]=\u0005)AO]1dK&\u0011al\u0017\u0002\u0005'B\fg.\u0001\nq_>dW*\u001a;sS\u000e\u001cXI\\1cY\u0016$W#A1\u0011\u0005\r\u0012\u0017BA2%\u0005\u001d\u0011un\u001c7fC:\f\u0011cY8o]\u0016\u001cG/[8og>\u0003XM\\3e)\t!f\rC\u0003h\u0013\u0001\u0007\u0001.A\u0003d_VtG\u000f\u0005\u0002$S&\u0011!\u000e\n\u0002\u0004\u0013:$\u0018\u0001E2p]:,7\r^5p]\u000ecwn]3e)\u0005!\u0016aC2mS\u0016tG/\u0012:s_J\f1b]3sm\u0016\u0014XI\u001d:pe\u0006)!/\u001a;ss\u00069A/[7f_V$\u0018\u0001D2b]\u000e,G\u000e\\1uS>t\u0017\u0001F:qK\u000e,H.\u0019;jm\u0016,\u00050Z2vi&|g.\u0001\tfq\u0016\u001cW\u000f^5p]N#\u0018M\u001d;fI\u0006\tR\r_3dkRLwN\\\"p[BdW\r^3\u0002)I,7m\u001c:e\u0013:4E.[4iiN\u000bW\u000e\u001d7f)\t!v\u000fC\u0003y'\u0001\u0007\u00110A\u0003wC2,X\r\u0005\u0002$u&\u00111\u0010\n\u0002\u0005\u0019>tw-A\td_:tWm\u0019;j_:$&/Y:iK\u0012\fAB]3d_J$'i\u001c:s_^$\"\u0001V@\t\r\u0005\u0005Q\u00031\u0001z\u0003\u0015q\u0017M\\8t\u0003\u001d\u0019G.Z1okB\u0004")
public class NodeMonitor {
    private final CassandraInstrumentation.Node node;
    private final SessionMetrics.SessionInstruments sessionMetrics;
    private final NodeConnectionPoolMetrics.NodeConnectionPoolInstruments poolMetrics;

    public SessionMetrics.SessionInstruments sessionMetrics() {
        return this.sessionMetrics;
    }

    public NodeConnectionPoolMetrics.NodeConnectionPoolInstruments poolMetrics() {
        return this.poolMetrics;
    }

    public void applyNodeTags(Span span) {
        SpanTagger$.MODULE$.tag(span, CassandraInstrumentation$Tags$.MODULE$.DC(), this.node.dc(), CassandraInstrumentation$.MODULE$.settings().dcTagMode());
        SpanTagger$.MODULE$.tag(span, CassandraInstrumentation$Tags$.MODULE$.Rack(), this.node.rack(), CassandraInstrumentation$.MODULE$.settings().rackTagMode());
        SpanTagger$.MODULE$.tag(span, CassandraInstrumentation$Tags$.MODULE$.Node(), this.node.address(), CassandraInstrumentation$.MODULE$.settings().nodeTagMode());
    }

    public boolean poolMetricsEnabled() {
        return this.poolMetrics() != null;
    }

    public void connectionsOpened(int count) {
        this.sessionMetrics().openConnections().increment((long)count);
        if (this.poolMetricsEnabled()) {
            this.poolMetrics().openConnections().increment((long)count);
        }
    }

    public void connectionClosed() {
        this.sessionMetrics().openConnections().decrement();
        if (this.poolMetricsEnabled()) {
            this.poolMetrics().openConnections().decrement();
        }
    }

    public void clientError() {
        this.sessionMetrics().clientErrors().increment();
        if (this.poolMetricsEnabled()) {
            this.poolMetrics().clientErrors().increment();
        }
    }

    public void serverError() {
        this.sessionMetrics().serverErrors().increment();
        if (this.poolMetricsEnabled()) {
            this.poolMetrics().serverErrors().increment();
        }
    }

    public void retry() {
        this.sessionMetrics().retries().increment();
    }

    public void timeout() {
        this.sessionMetrics().timeouts().increment();
        if (this.poolMetricsEnabled()) {
            this.poolMetrics().timeouts().increment();
        }
    }

    public void cancellation() {
        this.sessionMetrics().canceled().increment();
        if (this.poolMetricsEnabled()) {
            this.poolMetrics().canceled().increment();
        }
    }

    public void speculativeExecution() {
        this.sessionMetrics().speculations().increment();
        if (this.poolMetricsEnabled()) {
            this.poolMetrics().triggeredSpeculations().increment();
        }
    }

    public void executionStarted() {
        this.sessionMetrics().inFlightRequests().increment();
    }

    public void executionComplete() {
        this.sessionMetrics().inFlightRequests().decrement();
    }

    public void recordInFlightSample(long value) {
        if (this.poolMetricsEnabled()) {
            this.poolMetrics().inFlight().record(value);
        }
    }

    public void connectionTrashed() {
        this.sessionMetrics().trashedConnections().increment();
    }

    public void recordBorrow(long nanos) {
        this.sessionMetrics().borrow().record(nanos);
        if (this.poolMetricsEnabled()) {
            this.poolMetrics().borrow().record(nanos);
        }
    }

    public void cleanup() {
        if (this.poolMetrics() != null) {
            this.poolMetrics().remove();
        }
    }

    public NodeMonitor(CassandraInstrumentation.Node node) {
        this.node = node;
        this.sessionMetrics = new SessionMetrics.SessionInstruments();
        this.poolMetrics = CassandraInstrumentation$.MODULE$.settings().trackNodeConnectionPoolMetrics() ? new NodeConnectionPoolMetrics.NodeConnectionPoolInstruments(node) : null;
    }
}

