/*
 * Decompiled with CFR 0.152.
 */
package kamon.instrumentation.executor;

import java.util.Collection;
import java.util.concurrent.Callable;
import kamon.Kamon;
import kamon.context.Context;
import kamon.context.Storage;
import kamon.instrumentation.executor.CaptureContextOnSubmitAdvices;
import kanela.agent.api.instrumentation.InstrumentationBuilder;
import kanela.agent.bootstrap.context.ContextHandler;
import kanela.agent.bootstrap.context.ContextProvider;
import kanela.agent.libs.net.bytebuddy.matcher.ElementMatcher;

public final class CaptureContextOnSubmitInstrumentation
extends InstrumentationBuilder {
    public CaptureContextOnSubmitInstrumentation() {
        ContextHandler.setContextProvider((ContextProvider)new KamonContextProvider());
        this.onSubTypesOf(new String[]{"java.util.concurrent.Executor"}).advise(this.method("execute").and((ElementMatcher)this.withArgument(Runnable.class)), CaptureContextOnSubmitAdvices.RunnableWrapperAdvisor.class);
        this.onSubTypesOf(new String[]{"java.util.concurrent.ExecutorService"}).advise(this.method("submit").and((ElementMatcher)this.withArgument(Runnable.class)), CaptureContextOnSubmitAdvices.RunnableWrapperAdvisor.class).advise(this.method("submit").and((ElementMatcher)this.withArgument(Callable.class)), CaptureContextOnSubmitAdvices.CallableWrapperAdvisor.class).advise(this.anyMethods(new String[]{"invokeAny", "invokeAll"}).and((ElementMatcher)this.withArgument(Collection.class)), CaptureContextOnSubmitAdvices.CallableCollectionWrapperAdvisor.class);
        this.onSubTypesOf(new String[]{"java.util.concurrent.ScheduledExecutorService"}).advise(this.method("schedule").and((ElementMatcher)this.withArgument(0, Runnable.class)), CaptureContextOnSubmitAdvices.RunnableWrapperAdvisor.class).advise(this.method("schedule").and((ElementMatcher)this.withArgument(0, Callable.class)), CaptureContextOnSubmitAdvices.CallableWrapperAdvisor.class);
    }

    private static class KamonContextProvider
    implements ContextProvider {
        private KamonContextProvider() {
        }

        public Runnable wrapInContextAware(Runnable runnable) {
            return new ContextAwareRunnable(runnable);
        }

        public <A> Callable wrapInContextAware(Callable<A> callable) {
            return new ContextAwareCallable<A>(callable);
        }
    }

    private static class ContextAwareCallable<A>
    implements Callable<A> {
        private final Callable<A> underlying;
        private final Context context = Kamon.currentContext();

        ContextAwareCallable(Callable<A> callable) {
            this.underlying = callable;
        }

        @Override
        public A call() throws Exception {
            try (Storage.Scope scope = Kamon.storeContext((Context)this.context);){
                A a = this.underlying.call();
                return a;
            }
        }
    }

    private static class ContextAwareRunnable
    implements Runnable {
        private final Runnable underlying;
        private final Context context = Kamon.currentContext();

        ContextAwareRunnable(Runnable runnable) {
            this.underlying = runnable;
        }

        @Override
        public void run() {
            try (Storage.Scope scope = Kamon.storeContext((Context)this.context);){
                this.underlying.run();
            }
        }
    }
}

