/*
 * Decompiled with CFR 0.152.
 */
package kamon.instrumentation.jdbc;

import com.typesafe.config.Config;
import kamon.ClassLoading$;
import kamon.Kamon$;
import kamon.instrumentation.jdbc.JdbcInstrumentation;
import kamon.instrumentation.jdbc.utils.LoggingSupport;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Serializable;
import scala.collection.JavaConverters$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;

public final class JdbcInstrumentation$
implements LoggingSupport {
    public static JdbcInstrumentation$ MODULE$;
    private volatile JdbcInstrumentation.Settings _settings;
    private final Logger logger;

    static {
        new JdbcInstrumentation$();
    }

    @Override
    public void logInfo(Function0<String> msg) {
        LoggingSupport.logInfo$(this, msg);
    }

    @Override
    public void logWarn(Function0<String> msg) {
        LoggingSupport.logWarn$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        LoggingSupport.logError$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg, Function0<Throwable> exc) {
        LoggingSupport.logError$(this, msg, exc);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        LoggingSupport.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        LoggingSupport.logTrace$(this, msg);
    }

    @Override
    public Logger logger() {
        return this.logger;
    }

    @Override
    public void kamon$instrumentation$jdbc$utils$LoggingSupport$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    private JdbcInstrumentation.Settings _settings() {
        return this._settings;
    }

    private void _settings_$eq(JdbcInstrumentation.Settings x$1) {
        this._settings = x$1;
    }

    public void onStatementFinish(String statement, long elapsedTimeNanos) {
        if (elapsedTimeNanos >= this._settings().slowStatementThresholdNanos()) {
            this._settings().slowStatementProcessors().foreach((Function1 & java.io.Serializable & Serializable)x$1 -> {
                x$1.process(statement, elapsedTimeNanos, JdbcInstrumentation$.MODULE$._settings().slowStatementThresholdNanos());
                return BoxedUnit.UNIT;
            });
        }
    }

    public void onStatementFailure(String statement, Throwable error) {
        this._settings().failedStatementProcessors().foreach((Function1 & java.io.Serializable & Serializable)x$2 -> {
            x$2.process(statement, error);
            return BoxedUnit.UNIT;
        });
    }

    private JdbcInstrumentation.Settings readSettings(Config config) {
        Config jdbcConfig = config.getConfig("kamon.instrumentation.jdbc");
        List slowStatementProcessors = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(jdbcConfig.getStringList("statements.slow.processors")).asScala()).map((Function1 & java.io.Serializable & Serializable)fqcn -> (JdbcInstrumentation.SlowStatementProcessor)ClassLoading$.MODULE$.createInstance(fqcn, ClassTag$.MODULE$.apply(JdbcInstrumentation.SlowStatementProcessor.class)), Buffer$.MODULE$.canBuildFrom())).toList();
        List failedStatementProcessors = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(jdbcConfig.getStringList("statements.failed.processors")).asScala()).map((Function1 & java.io.Serializable & Serializable)fqcn -> (JdbcInstrumentation.FailedStatementProcessor)ClassLoading$.MODULE$.createInstance(fqcn, ClassTag$.MODULE$.apply(JdbcInstrumentation.FailedStatementProcessor.class)), Buffer$.MODULE$.canBuildFrom())).toList();
        return new JdbcInstrumentation.Settings(jdbcConfig.getDuration("statements.slow.threshold").toNanos(), (List<JdbcInstrumentation.SlowStatementProcessor>)slowStatementProcessors, (List<JdbcInstrumentation.FailedStatementProcessor>)failedStatementProcessors);
    }

    private JdbcInstrumentation$() {
        MODULE$ = this;
        LoggingSupport.$init$(this);
        this._settings = this.readSettings(Kamon$.MODULE$.config());
        Kamon$.MODULE$.onReconfigure((Function1 & java.io.Serializable & Serializable)newConfig -> {
            JdbcInstrumentation$.MODULE$._settings_$eq(JdbcInstrumentation$.MODULE$.readSettings(newConfig));
            return BoxedUnit.UNIT;
        });
    }
}

