/*
 * Decompiled with CFR 0.152.
 */
package kamon.instrumentation.pekko.http;

import com.typesafe.config.Config;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.atomic.AtomicLong;
import kamon.Kamon$;
import kamon.instrumentation.http.HttpServerInstrumentation;
import kamon.instrumentation.http.HttpServerInstrumentation$;
import kamon.instrumentation.pekko.http.LastAutomaticOperationNameEdit$;
import kamon.instrumentation.pekko.http.PekkoHttpInstrumentation$;
import kamon.instrumentation.pekko.http.ServerFlowWrapper;
import kamon.instrumentation.pekko.http.ServerFlowWrapper$;
import kamon.instrumentation.pekko.http.ServerFlowWrapper$$anon$1$;
import kamon.instrumentation.pekko.http.ServerFlowWrapper$$anon$1$$anon$2$;
import kamon.trace.Span;
import kamon.util.CallingThreadExecutionContext$;
import org.apache.pekko.Done;
import org.apache.pekko.NotUsed;
import org.apache.pekko.http.scaladsl.model.HttpEntity;
import org.apache.pekko.http.scaladsl.model.HttpRequest;
import org.apache.pekko.http.scaladsl.model.HttpResponse;
import org.apache.pekko.http.scaladsl.model.ResponseEntity;
import org.apache.pekko.stream.Attributes;
import org.apache.pekko.stream.BidiShape;
import org.apache.pekko.stream.Inlet;
import org.apache.pekko.stream.Inlet$;
import org.apache.pekko.stream.Outlet;
import org.apache.pekko.stream.Outlet$;
import org.apache.pekko.stream.scaladsl.BidiFlow$;
import org.apache.pekko.stream.scaladsl.Flow;
import org.apache.pekko.stream.scaladsl.Flow$;
import org.apache.pekko.stream.scaladsl.Keep$;
import org.apache.pekko.stream.stage.GraphStage;
import org.apache.pekko.stream.stage.GraphStageLogic;
import org.apache.pekko.stream.stage.InHandler;
import org.apache.pekko.stream.stage.OutHandler;
import org.apache.pekko.util.ByteString;
import scala.Function0;
import scala.Function1;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.concurrent.TrieMap;
import scala.collection.concurrent.TrieMap$;
import scala.collection.mutable.Queue;
import scala.collection.mutable.Queue$;
import scala.concurrent.ExecutionContext;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

public final class ServerFlowWrapper$ {
    public static ServerFlowWrapper$ MODULE$;
    private final TrieMap<Object, HttpServerInstrumentation> _serverInstrumentations;
    private final TrieMap<Object, String> _defaultOperationNames;
    private final ServerFlowWrapper.Settings _defaultSettings;
    private volatile ServerFlowWrapper.Settings _wrapperSettings;

    static {
        new ServerFlowWrapper$();
    }

    private TrieMap<Object, HttpServerInstrumentation> _serverInstrumentations() {
        return this._serverInstrumentations;
    }

    private TrieMap<Object, String> _defaultOperationNames() {
        return this._defaultOperationNames;
    }

    private ServerFlowWrapper.Settings _defaultSettings() {
        return this._defaultSettings;
    }

    private ServerFlowWrapper.Settings _wrapperSettings() {
        return this._wrapperSettings;
    }

    private void _wrapperSettings_$eq(ServerFlowWrapper.Settings x$1) {
        this._wrapperSettings = x$1;
    }

    public Flow<HttpRequest, HttpResponse, NotUsed> apply(Flow<HttpRequest, HttpResponse, NotUsed> flow, String string, int port) {
        return BidiFlow$.MODULE$.fromGraph(this.wrapStage(this._wrapperSettings(), string, port)).join(flow);
    }

    public GraphStage<BidiShape<HttpRequest, HttpRequest, HttpResponse, HttpResponse>> wrapStage(ServerFlowWrapper.Settings settings, String string, int port) {
        return new GraphStage<BidiShape<HttpRequest, HttpRequest, HttpResponse, HttpResponse>>(settings, string, port){
            private final Config httpServerConfig;
            private final HttpServerInstrumentation httpServerInstrumentation;
            private final Inlet<HttpRequest> requestIn;
            private final Outlet<HttpRequest> requestOut;
            private final Inlet<HttpResponse> responseIn;
            private final Outlet<HttpResponse> responseOut;
            private final BidiShape<HttpRequest, HttpRequest, HttpResponse, HttpResponse> shape;

            public Config httpServerConfig() {
                return this.httpServerConfig;
            }

            public HttpServerInstrumentation httpServerInstrumentation() {
                return this.httpServerInstrumentation;
            }

            public Inlet<HttpRequest> requestIn() {
                return this.requestIn;
            }

            public Outlet<HttpRequest> requestOut() {
                return this.requestOut;
            }

            public Inlet<HttpResponse> responseIn() {
                return this.responseIn;
            }

            public Outlet<HttpResponse> responseOut() {
                return this.responseOut;
            }

            public BidiShape<HttpRequest, HttpRequest, HttpResponse, HttpResponse> shape() {
                return this.shape;
            }

            public GraphStageLogic createLogic(Attributes inheritedAttributes) {
                return new GraphStageLogic(this){
                    private final Queue<HttpServerInstrumentation.RequestHandler> kamon$instrumentation$pekko$http$ServerFlowWrapper$$anon$$anon$$_pendingRequests;
                    private final Instant _createdAt;
                    private int kamon$instrumentation$pekko$http$ServerFlowWrapper$$anon$$anon$$_completedRequests;
                    private final /* synthetic */ anon.1 $outer;

                    public Queue<HttpServerInstrumentation.RequestHandler> kamon$instrumentation$pekko$http$ServerFlowWrapper$$anon$$anon$$_pendingRequests() {
                        return this.kamon$instrumentation$pekko$http$ServerFlowWrapper$$anon$$anon$$_pendingRequests;
                    }

                    private Instant _createdAt() {
                        return this._createdAt;
                    }

                    public int kamon$instrumentation$pekko$http$ServerFlowWrapper$$anon$$anon$$_completedRequests() {
                        return this.kamon$instrumentation$pekko$http$ServerFlowWrapper$$anon$$anon$$_completedRequests;
                    }

                    public void kamon$instrumentation$pekko$http$ServerFlowWrapper$$anon$$anon$$_completedRequests_$eq(int x$1) {
                        this.kamon$instrumentation$pekko$http$ServerFlowWrapper$$anon$$anon$$_completedRequests = x$1;
                    }

                    public void preStart() {
                        this.$outer.httpServerInstrumentation().connectionOpened();
                    }

                    public void postStop() {
                        Duration connectionLifetime = Duration.between(this._createdAt(), Kamon$.MODULE$.clock().instant());
                        this.$outer.httpServerInstrumentation().connectionClosed(connectionLifetime, this.kamon$instrumentation$pekko$http$ServerFlowWrapper$$anon$$anon$$_completedRequests());
                    }

                    public /* synthetic */ anon.1 kamon$instrumentation$pekko$http$ServerFlowWrapper$$anon$$anon$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        super($outer.shape());
                        this.kamon$instrumentation$pekko$http$ServerFlowWrapper$$anon$$anon$$_pendingRequests = (Queue)Queue$.MODULE$.empty();
                        this._createdAt = Kamon$.MODULE$.clock().instant();
                        this.kamon$instrumentation$pekko$http$ServerFlowWrapper$$anon$$anon$$_completedRequests = 0;
                        this.setHandler($outer.requestIn(), new InHandler(this){
                            private final /* synthetic */ anon$1$$anon$2 $outer;

                            public void onUpstreamFailure(Throwable ex) throws Exception {
                                InHandler.onUpstreamFailure$((InHandler)this, (Throwable)ex);
                            }

                            public void onPush() {
                                HttpRequest request = (HttpRequest)this.$outer.grab(this.$outer.kamon$instrumentation$pekko$http$ServerFlowWrapper$$anon$$anon$$$outer().requestIn());
                                HttpServerInstrumentation.RequestHandler requestHandler = this.$outer.kamon$instrumentation$pekko$http$ServerFlowWrapper$$anon$$anon$$$outer().httpServerInstrumentation().createHandler(PekkoHttpInstrumentation$.MODULE$.toRequest(request), true).requestReceived();
                                String defaultOperationName = this.$outer.kamon$instrumentation$pekko$http$ServerFlowWrapper$$anon$$anon$$$outer().httpServerInstrumentation().settings().defaultOperationName();
                                Span requestSpan = requestHandler.span();
                                String string = requestSpan.operationName();
                                boolean allowAutomaticChanges = !(string != null ? !string.equals(defaultOperationName) : defaultOperationName != null);
                                this.$outer.kamon$instrumentation$pekko$http$ServerFlowWrapper$$anon$$anon$$_pendingRequests().enqueue((Seq)Predef$.MODULE$.wrapRefArray((Object[])new HttpServerInstrumentation.RequestHandler[]{requestHandler}));
                                Kamon$.MODULE$.storeContext(requestHandler.context().withEntry(LastAutomaticOperationNameEdit$.MODULE$.Key(), (Object)Option$.MODULE$.apply((Object)LastAutomaticOperationNameEdit$.MODULE$.apply(requestSpan.operationName(), allowAutomaticChanges))));
                                this.$outer.push(this.$outer.kamon$instrumentation$pekko$http$ServerFlowWrapper$$anon$$anon$$$outer().requestOut(), request);
                            }

                            public void onUpstreamFinish() {
                                this.$outer.complete(this.$outer.kamon$instrumentation$pekko$http$ServerFlowWrapper$$anon$$anon$$$outer().requestOut());
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                InHandler.$init$((InHandler)this);
                            }
                        });
                        this.setHandler($outer.requestOut(), new OutHandler(this){
                            private final /* synthetic */ anon$1$$anon$2 $outer;

                            public void onDownstreamFinish() throws Exception {
                                OutHandler.onDownstreamFinish$((OutHandler)this);
                            }

                            public void onPull() {
                                this.$outer.pull(this.$outer.kamon$instrumentation$pekko$http$ServerFlowWrapper$$anon$$anon$$$outer().requestIn());
                            }

                            public void onDownstreamFinish(Throwable t) {
                                this.$outer.cancel(this.$outer.kamon$instrumentation$pekko$http$ServerFlowWrapper$$anon$$anon$$$outer().requestIn(), t);
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                OutHandler.$init$((OutHandler)this);
                            }
                        });
                        this.setHandler($outer.responseIn(), new InHandler(this){
                            private final /* synthetic */ anon$1$$anon$2 $outer;

                            public void onUpstreamFailure(Throwable ex) throws Exception {
                                InHandler.onUpstreamFailure$((InHandler)this, (Throwable)ex);
                            }

                            public void onPush() {
                                ResponseEntity responseEntity;
                                HttpResponse response = (HttpResponse)this.$outer.grab(this.$outer.kamon$instrumentation$pekko$http$ServerFlowWrapper$$anon$$anon$$$outer().responseIn());
                                HttpServerInstrumentation.RequestHandler requestHandler = (HttpServerInstrumentation.RequestHandler)this.$outer.kamon$instrumentation$pekko$http$ServerFlowWrapper$$anon$$anon$$_pendingRequests().dequeue();
                                Span requestSpan = requestHandler.span();
                                HttpResponse responseWithContext = requestHandler.buildResponse(PekkoHttpInstrumentation$.MODULE$.toResponseBuilder(response), requestHandler.context());
                                if (response.status().intValue() == 404) {
                                    String string = requestSpan.operationName();
                                    String string2 = this.$outer.kamon$instrumentation$pekko$http$ServerFlowWrapper$$anon$$anon$$$outer().httpServerInstrumentation().settings().defaultOperationName();
                                    if (!(string != null ? !string.equals(string2) : string2 != null)) {
                                        requestSpan.name(this.$outer.kamon$instrumentation$pekko$http$ServerFlowWrapper$$anon$$anon$$$outer().httpServerInstrumentation().settings().unhandledOperationName()).takeSamplingDecision();
                                    }
                                }
                                if (responseWithContext.entity().isKnownEmpty()) {
                                    requestHandler.responseSent(0L);
                                    responseEntity = responseWithContext.entity();
                                } else {
                                    HttpEntity.Default default_;
                                    requestSpan.mark("http.response.ready");
                                    ResponseEntity responseEntity2 = responseWithContext.entity();
                                    if (responseEntity2 instanceof HttpEntity.Strict) {
                                        HttpEntity.Strict strict = (HttpEntity.Strict)responseEntity2;
                                        ByteString bs2 = strict.data();
                                        requestHandler.responseSent(bs2.size());
                                        default_ = strict;
                                    } else if (responseEntity2 instanceof HttpEntity.Default) {
                                        HttpEntity.Default default_2 = (HttpEntity.Default)responseEntity2;
                                        requestHandler.responseSent(default_2.contentLength());
                                        default_ = default_2;
                                    } else {
                                        AtomicLong responseSizeCounter = new AtomicLong(0L);
                                        default_ = responseWithContext.entity().transformDataBytes(((Flow)Flow$.MODULE$.apply().watchTermination(Keep$.MODULE$.right()).wireTap((Function1 & Serializable & scala.Serializable)bs -> {
                                            anon$1$$anon$2$$anon$5.$anonfun$onPush$1(responseSizeCounter, bs);
                                            return BoxedUnit.UNIT;
                                        })).mapMaterializedValue((Function1 & Serializable & scala.Serializable)f -> f.andThen((PartialFunction)new scala.Serializable(null, requestHandler, responseSizeCounter, requestSpan){
                                            public static final long serialVersionUID = 0L;
                                            private final HttpServerInstrumentation.RequestHandler requestHandler$1;
                                            private final AtomicLong responseSizeCounter$1;
                                            private final Span requestSpan$1;

                                            public final <A1 extends Try<Done>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                                                Object object;
                                                if (x1 instanceof Success) {
                                                    this.requestHandler$1.responseSent(this.responseSizeCounter$1.get());
                                                    object = BoxedUnit.UNIT;
                                                } else if (x1 instanceof Failure) {
                                                    Throwable e = ((Failure)x1).exception();
                                                    this.requestSpan$1.fail("Response entity stream failed", e);
                                                    this.requestHandler$1.responseSent(this.responseSizeCounter$1.get());
                                                    object = BoxedUnit.UNIT;
                                                } else {
                                                    object = function1.apply(x1);
                                                }
                                                return (B1)object;
                                            }

                                            public final boolean isDefinedAt(Try<Done> x1) {
                                                boolean bl = x1 instanceof Success ? true : x1 instanceof Failure;
                                                return bl;
                                            }
                                            {
                                                this.requestHandler$1 = requestHandler$1;
                                                this.responseSizeCounter$1 = responseSizeCounter$1;
                                                this.requestSpan$1 = requestSpan$1;
                                            }
                                        }, (ExecutionContext)CallingThreadExecutionContext$.MODULE$)));
                                    }
                                    responseEntity = default_;
                                }
                                ResponseEntity entity = responseEntity;
                                this.$outer.kamon$instrumentation$pekko$http$ServerFlowWrapper$$anon$$anon$$_completedRequests_$eq(this.$outer.kamon$instrumentation$pekko$http$ServerFlowWrapper$$anon$$anon$$_completedRequests() + 1);
                                this.$outer.push(this.$outer.kamon$instrumentation$pekko$http$ServerFlowWrapper$$anon$$anon$$$outer().responseOut(), responseWithContext.withEntity((org.apache.pekko.http.javadsl.model.ResponseEntity)entity));
                            }

                            public void onUpstreamFinish() {
                                this.$outer.completeStage();
                            }

                            public static final /* synthetic */ void $anonfun$onPush$1(AtomicLong responseSizeCounter$1, ByteString bs) {
                                responseSizeCounter$1.addAndGet(bs.size());
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                InHandler.$init$((InHandler)this);
                            }

                            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$onPush$1$adapted(java.util.concurrent.atomic.AtomicLong org.apache.pekko.util.ByteString ), $anonfun$onPush$2(kamon.instrumentation.http.HttpServerInstrumentation$RequestHandler java.util.concurrent.atomic.AtomicLong kamon.trace.Span scala.concurrent.Future )}, serializedLambda);
                            }
                        });
                        this.setHandler($outer.responseOut(), new OutHandler(this){
                            private final /* synthetic */ anon$1$$anon$2 $outer;

                            public void onDownstreamFinish() throws Exception {
                                OutHandler.onDownstreamFinish$((OutHandler)this);
                            }

                            public void onPull() {
                                this.$outer.pull(this.$outer.kamon$instrumentation$pekko$http$ServerFlowWrapper$$anon$$anon$$$outer().responseIn());
                            }

                            public void onDownstreamFinish(Throwable t) {
                                this.$outer.cancel(this.$outer.kamon$instrumentation$pekko$http$ServerFlowWrapper$$anon$$anon$$$outer().responseIn(), t);
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                OutHandler.$init$((OutHandler)this);
                            }
                        });
                    }
                };
            }
            {
                this.httpServerConfig = Kamon$.MODULE$.config().getConfig(settings$1.configPath());
                this.httpServerInstrumentation = HttpServerInstrumentation$.MODULE$.from(this.httpServerConfig(), settings$1.component(), interface$1, port$1);
                this.requestIn = Inlet$.MODULE$.create("request.in");
                this.requestOut = Outlet$.MODULE$.create("request.out");
                this.responseIn = Inlet$.MODULE$.create("response.in");
                this.responseOut = Outlet$.MODULE$.create("response.out");
                this.shape = new BidiShape(this.requestIn(), this.requestOut(), this.responseIn(), this.responseOut());
            }
        };
    }

    public void changeSettings(String component, String configPath) {
        this._wrapperSettings_$eq(new ServerFlowWrapper.Settings(component, configPath));
    }

    public void resetSettings() {
        this._wrapperSettings_$eq(this._defaultSettings());
    }

    public String defaultOperationName(int listenPort) {
        return (String)this._defaultOperationNames().getOrElseUpdate((Object)BoxesRunTime.boxToInteger((int)listenPort), (Function0 & Serializable & scala.Serializable)() -> (String)MODULE$._serverInstrumentations().get((Object)BoxesRunTime.boxToInteger((int)listenPort)).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.settings().defaultOperationName()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "http.server.request"));
    }

    private ServerFlowWrapper$() {
        MODULE$ = this;
        this._serverInstrumentations = TrieMap$.MODULE$.empty();
        this._defaultOperationNames = TrieMap$.MODULE$.empty();
        this._defaultSettings = new ServerFlowWrapper.Settings("pekko.http.server", "kamon.instrumentation.pekko.http.server");
        this._wrapperSettings = this._defaultSettings();
    }
}

