/*
 * Decompiled with CFR 0.152.
 */
package kamon.lib.com.sun.el;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import kamon.lib.com.sun.el.ValueExpressionLiteral;
import kamon.lib.com.sun.el.lang.ELSupport;
import kamon.lib.com.sun.el.lang.ExpressionBuilder;
import kamon.lib.com.sun.el.stream.StreamELResolver;
import kamon.lib.com.sun.el.util.MessageFactory;
import kamon.lib.javax.el.ELContext;
import kamon.lib.javax.el.ELException;
import kamon.lib.javax.el.ELResolver;
import kamon.lib.javax.el.ExpressionFactory;
import kamon.lib.javax.el.MethodExpression;
import kamon.lib.javax.el.ValueExpression;

public class ExpressionFactoryImpl
extends ExpressionFactory {
    private Properties properties;
    private boolean isBackwardCompatible22;

    public ExpressionFactoryImpl() {
    }

    public ExpressionFactoryImpl(Properties properties) {
        this.properties = properties;
        this.isBackwardCompatible22 = "true".equals(this.getProperty("kamon.lib.javax.el.bc2.2"));
    }

    public Object coerceToType(Object obj, Class type) {
        Object ret;
        try {
            ret = ELSupport.coerceToType(obj, type, this.isBackwardCompatible22);
        }
        catch (IllegalArgumentException ex) {
            throw new ELException(ex);
        }
        return ret;
    }

    public MethodExpression createMethodExpression(ELContext context, String expression, Class expectedReturnType, Class[] expectedParamTypes) {
        ExpressionBuilder builder = new ExpressionBuilder(expression, context);
        MethodExpression me = builder.createMethodExpression(expectedReturnType, expectedParamTypes);
        if (expectedParamTypes == null && !me.isParametersProvided()) {
            throw new NullPointerException(MessageFactory.get("error.method.nullParms"));
        }
        return me;
    }

    public ValueExpression createValueExpression(ELContext context, String expression, Class expectedType) {
        if (expectedType == null) {
            throw new NullPointerException(MessageFactory.get("error.value.expectedType"));
        }
        ExpressionBuilder builder = new ExpressionBuilder(expression, context);
        return builder.createValueExpression(expectedType);
    }

    public ValueExpression createValueExpression(Object instance, Class expectedType) {
        if (expectedType == null) {
            throw new NullPointerException(MessageFactory.get("error.value.expectedType"));
        }
        return new ValueExpressionLiteral(instance, expectedType);
    }

    public String getProperty(String key) {
        if (this.properties == null) {
            return null;
        }
        return this.properties.getProperty(key);
    }

    @Override
    public ELResolver getStreamELResolver() {
        return new StreamELResolver();
    }

    @Override
    public Map<String, Method> getInitFunctionMap() {
        HashMap<String, Method> funcs = new HashMap<String, Method>();
        return funcs;
    }
}

