/*
 * Decompiled with CFR 0.152.
 */
package kamon.runtime;

import java.io.InputStream;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import kamon.lib.net.bytebuddy.agent.ByteBuddyAgent;
import kamon.runtime.attacher.BuildInfo$;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.control.NonFatal$;

public final class Attacher$ {
    public static Attacher$ MODULE$;
    private final String _instrumentationClassLoaderProp;

    static {
        new Attacher$();
    }

    private String _instrumentationClassLoaderProp() {
        return this._instrumentationClassLoaderProp;
    }

    public void attach() {
        Option<ClassLoader> springBootClassLoader = this.findSpringBootJarLauncherClassLoader();
        if (this.isKanelaLoaded()) {
            springBootClassLoader.foreach((Function1 & Serializable & scala.Serializable)sbClassLoader -> {
                Attacher$.MODULE$.withInstrumentationClassLoader(sbClassLoader, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> Attacher$.MODULE$.reloadKanela());
                return BoxedUnit.UNIT;
            });
            return;
        }
        InputStream embeddedAgentFile = this.getClass().getClassLoader().getResourceAsStream(BuildInfo$.MODULE$.kanelaAgentJarName());
        Path temporaryAgentFile = Files.createTempFile(BuildInfo$.MODULE$.kanelaAgentJarName(), ".jar", new FileAttribute[0]);
        Files.copy(embeddedAgentFile, temporaryAgentFile, StandardCopyOption.REPLACE_EXISTING);
        this.withInstrumentationClassLoader((ClassLoader)springBootClassLoader.orNull(Predef$.MODULE$.$conforms()), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ByteBuddyAgent.attach(temporaryAgentFile.toFile(), MODULE$.pid()));
        try {
            temporaryAgentFile.toFile().deleteOnExit();
            return;
        }
        catch (Throwable throwable) {
            Option option = NonFatal$.MODULE$.unapply(throwable);
            if (!option.isEmpty()) {
                Throwable t = (Throwable)option.get();
                LoggerFactory.getLogger(this.getClass()).warn("Failed to mark the temporary Kanela Agent file for deletion after exiting the JVM", t);
                return;
            }
            throw throwable;
        }
    }

    private boolean isKanelaLoaded() {
        boolean bl;
        boolean isLoadedProperty = Boolean.parseBoolean(System.getProperty("kanela.loaded"));
        try {
            bl = Class.forName("kanela.agent.Kanela", false, ClassLoader.getSystemClassLoader()) != null;
        }
        catch (Throwable throwable) {
            bl = false;
        }
        return bl && isLoadedProperty;
    }

    private Option<ClassLoader> findSpringBootJarLauncherClassLoader() {
        return Option$.MODULE$.apply((Object)Thread.currentThread().getContextClassLoader()).filter((Function1 & Serializable & scala.Serializable)cl -> BoxesRunTime.boxToBoolean((boolean)Attacher$.$anonfun$findSpringBootJarLauncherClassLoader$1(cl)));
    }

    private void reloadKanela() {
        Class.forName("kanela.agent.Kanela", true, ClassLoader.getSystemClassLoader()).getDeclaredMethod("reload", new Class[0]).invoke(null, new Object[0]);
    }

    private String pid() {
        String jvm = ManagementFactory.getRuntimeMXBean().getName();
        return jvm.substring(0, jvm.indexOf(64));
    }

    public <T> T withInstrumentationClassLoader(ClassLoader classLoader, Function0<T> thunk) {
        Object object;
        try {
            if (classLoader != null) {
                System.getProperties().put(this._instrumentationClassLoaderProp(), classLoader);
            }
            object = thunk.apply();
        }
        finally {
            System.getProperties().remove(this._instrumentationClassLoaderProp());
        }
        return (T)object;
    }

    public static final /* synthetic */ boolean $anonfun$findSpringBootJarLauncherClassLoader$1(ClassLoader cl) {
        String string = cl.getClass().getName();
        String string2 = "org.springframework.boot.loader.LaunchedURLClassLoader";
        return string != null && string.equals(string2);
    }

    private Attacher$() {
        MODULE$ = this;
        this._instrumentationClassLoaderProp = "kanela.instrumentation.classLoader";
    }
}

