/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.remote.kamon.instrumentation.pekko.remote.internal.remote;

import java.nio.ByteBuffer;
import kamon.Kamon$;
import kamon.context.BinaryPropagation;
import kamon.context.Context;
import kamon.context.Context$;
import kamon.instrumentation.pekko.PekkoRemoteMetrics;
import kamon.instrumentation.pekko.PekkoRemoteMetrics$;
import kanela.agent.libs.net.bytebuddy.asm.Advice;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.remote.artery.EnvelopeBuffer;
import org.apache.pekko.remote.kamon.instrumentation.pekko.remote.internal.remote.DeserializeForArteryAdvice;
import scala.Array$;
import scala.reflect.ClassTag$;

public final class DeserializeForArteryAdvice$ {
    public static DeserializeForArteryAdvice$ MODULE$;
    private final ThreadLocal<Context> LastDeserializedContext;

    static {
        new DeserializeForArteryAdvice$();
    }

    public ThreadLocal<Context> LastDeserializedContext() {
        return this.LastDeserializedContext;
    }

    @Advice.OnMethodEnter
    public DeserializeForArteryAdvice.DeserializationInfo exit(@Advice.Argument(value=5) EnvelopeBuffer envelopeBuffer) {
        Context context;
        long startTime = System.nanoTime();
        ByteBuffer messageBuffer = envelopeBuffer.byteBuffer();
        int messageStart = messageBuffer.position();
        messageBuffer.mark();
        messageBuffer.position(messageBuffer.limit() - 4);
        int contextSize = messageBuffer.getInt();
        int contextStart = messageBuffer.limit() - (contextSize + 4);
        int messageSize = contextStart - messageStart;
        if (contextSize == 0) {
            context = Context$.MODULE$.Empty();
        } else {
            messageBuffer.position(contextStart).limit(contextStart + contextSize);
            context = Kamon$.MODULE$.defaultBinaryPropagation().read((Object)this.byteBufferReader(messageBuffer));
        }
        Context context2 = context;
        messageBuffer.reset();
        messageBuffer.limit(contextStart);
        return new DeserializeForArteryAdvice.DeserializationInfo(context2, startTime, messageSize);
    }

    @Advice.OnMethodExit(onThrowable=Throwable.class)
    public void exit(@Advice.Argument(value=0) ActorSystem system, @Advice.Argument(value=5) EnvelopeBuffer envelopeBuffer, @Advice.Enter DeserializeForArteryAdvice.DeserializationInfo deserializationInfo, @Advice.Thrown Throwable error) {
        if (error == null) {
            this.LastDeserializedContext().set(deserializationInfo.context());
            PekkoRemoteMetrics.SerializationInstruments instruments = PekkoRemoteMetrics$.MODULE$.serializationInstruments(system.name());
            instruments.deserializationTime().record(System.nanoTime() - deserializationInfo.timeStamp());
            instruments.inboundMessageSize().record(deserializationInfo.messageSize());
        }
    }

    public BinaryPropagation.ByteStreamReader byteBufferReader(ByteBuffer bb) {
        return new BinaryPropagation.ByteStreamReader(bb){
            private final ByteBuffer bb$2;

            public int available() {
                return this.bb$2.remaining();
            }

            public int read(byte[] target) {
                this.bb$2.get(target);
                return target.length;
            }

            public int read(byte[] target, int offset, int count) {
                this.bb$2.get(target, offset, count);
                return target.length;
            }

            /*
             * WARNING - void declaration
             */
            public byte[] readAll() {
                void var1_1;
                byte[] array = (byte[])Array$.MODULE$.ofDim(this.bb$2.remaining(), ClassTag$.MODULE$.Byte());
                this.bb$2.get(array);
                return var1_1;
            }
            {
                this.bb$2 = bb$2;
            }
        };
    }

    private DeserializeForArteryAdvice$() {
        MODULE$ = this;
        this.LastDeserializedContext = new ThreadLocal<Context>(){

            public Context initialValue() {
                return null;
            }
        };
    }
}

