/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.windows;

import com.sun.jna.platform.win32.COM.WbemcliUtil;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.data.windows.PerfCounterWildcardQuery;
import oshi.hardware.Sensors;
import oshi.util.platform.windows.WmiQueryHandler;
import oshi.util.platform.windows.WmiUtil;

public class WindowsSensors
implements Sensors {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(WindowsSensors.class);
    private static final String BASE_SENSOR_CLASS = "Sensor";
    private final transient WbemcliUtil.WmiQuery<OhmHardwareProperty> ohmHardwareQuery = new WbemcliUtil.WmiQuery<OhmHardwareProperty>("ROOT\\OpenHardwareMonitor", "Hardware WHERE HardwareType=\"CPU\"", OhmHardwareProperty.class);
    private final transient WbemcliUtil.WmiQuery<OhmHardwareProperty> owhVoltageQuery = new WbemcliUtil.WmiQuery<OhmHardwareProperty>("ROOT\\OpenHardwareMonitor", "Hardware WHERE SensorType=\"Voltage\"", OhmHardwareProperty.class);
    private final transient WbemcliUtil.WmiQuery<OhmSensorProperty> ohmSensorQuery = new WbemcliUtil.WmiQuery<OhmSensorProperty>("ROOT\\OpenHardwareMonitor", null, OhmSensorProperty.class);
    private final transient WbemcliUtil.WmiQuery<FanProperty> fanQuery = new WbemcliUtil.WmiQuery<FanProperty>("Win32_Fan", FanProperty.class);
    private final transient WbemcliUtil.WmiQuery<VoltProperty> voltQuery = new WbemcliUtil.WmiQuery<VoltProperty>("Win32_Processor", VoltProperty.class);
    private final transient PerfCounterWildcardQuery<ThermalZoneProperty> thermalZonePerfCounters = new PerfCounterWildcardQuery<ThermalZoneProperty>(ThermalZoneProperty.class, "Thermal Zone Information", "Win32_PerfRawData_Counters_ThermalZoneInformation WHERE Name LIKE \"%cpu%\"");
    private final transient WmiQueryHandler wmiQueryHandler = WmiQueryHandler.createInstance();

    @Override
    public double getCpuTemperature() {
        double tempC = 0.0;
        WbemcliUtil.WmiResult<OhmHardwareProperty> ohmHardware = this.wmiQueryHandler.queryWMI(this.ohmHardwareQuery);
        if (ohmHardware.getResultCount() > 0) {
            LOG.debug("Found Temperature data in Open Hardware Monitor");
            String cpuIdentifier = WmiUtil.getString(ohmHardware, OhmHardwareProperty.IDENTIFIER, 0);
            if (cpuIdentifier.length() > 0) {
                StringBuilder sb = new StringBuilder(BASE_SENSOR_CLASS);
                sb.append(" WHERE Parent = \"").append(cpuIdentifier);
                sb.append("\" AND SensorType=\"Temperature\"");
                this.ohmSensorQuery.setWmiClassName(sb.toString());
                WbemcliUtil.WmiResult<OhmSensorProperty> ohmSensors = this.wmiQueryHandler.queryWMI(this.ohmSensorQuery);
                if (ohmSensors.getResultCount() > 0) {
                    double sum = 0.0;
                    for (int i = 0; i < ohmSensors.getResultCount(); ++i) {
                        sum += (double)WmiUtil.getFloat(ohmSensors, OhmSensorProperty.VALUE, i);
                    }
                    tempC = sum / (double)ohmSensors.getResultCount();
                }
                if (tempC > 0.0) {
                    return tempC;
                }
            }
        }
        long tempK = 0L;
        Map<ThermalZoneProperty, List<Long>> valueListMap = this.thermalZonePerfCounters.queryValuesWildcard();
        List<Long> valueList = valueListMap.get(ThermalZoneProperty.TEMPERATURE);
        if (valueList != null && !valueList.isEmpty()) {
            LOG.debug("Found Temperature data in PDH or WMI Counter");
            tempK = valueList.get(0);
        }
        if (tempK > 2732L) {
            tempC = (double)tempK / 10.0 - 273.15;
        } else if (tempK > 274L) {
            tempC = (double)tempK - 273.0;
        }
        if (tempC < 0.0) {
            tempC = 0.0;
        }
        return tempC;
    }

    @Override
    public int[] getFanSpeeds() {
        WbemcliUtil.WmiResult<FanProperty> fan;
        WbemcliUtil.WmiResult<OhmHardwareProperty> ohmHardware = this.wmiQueryHandler.queryWMI(this.ohmHardwareQuery);
        if (ohmHardware.getResultCount() > 0) {
            LOG.debug("Found Fan data in Open Hardware Monitor");
            String cpuIdentifier = WmiUtil.getString(ohmHardware, OhmHardwareProperty.IDENTIFIER, 0);
            if (cpuIdentifier.length() > 0) {
                StringBuilder sb = new StringBuilder(BASE_SENSOR_CLASS);
                sb.append(" WHERE Parent = \"").append(cpuIdentifier);
                sb.append("\" AND SensorType=\"Fan\"");
                this.ohmSensorQuery.setWmiClassName(sb.toString());
                WbemcliUtil.WmiResult<OhmSensorProperty> ohmSensors = this.wmiQueryHandler.queryWMI(this.ohmSensorQuery);
                if (ohmSensors.getResultCount() > 0) {
                    int[] fanSpeeds = new int[ohmSensors.getResultCount()];
                    for (int i = 0; i < ohmSensors.getResultCount(); ++i) {
                        fanSpeeds[i] = (int)WmiUtil.getFloat(ohmSensors, OhmSensorProperty.VALUE, i);
                    }
                    return fanSpeeds;
                }
            }
        }
        if ((fan = this.wmiQueryHandler.queryWMI(this.fanQuery)).getResultCount() > 1) {
            LOG.debug("Found Fan data in WMI");
            int[] fanSpeeds = new int[fan.getResultCount()];
            for (int i = 0; i < fan.getResultCount(); ++i) {
                fanSpeeds[i] = (int)WmiUtil.getUint64(fan, FanProperty.DESIREDSPEED, i);
            }
            return fanSpeeds;
        }
        return new int[1];
    }

    @Override
    public double getCpuVoltage() {
        WbemcliUtil.WmiResult<VoltProperty> voltage;
        WbemcliUtil.WmiResult<OhmHardwareProperty> ohmHardware = this.wmiQueryHandler.queryWMI(this.owhVoltageQuery);
        if (ohmHardware.getResultCount() > 0) {
            LOG.debug("Found Voltage data in Open Hardware Monitor");
            String voltIdentifierStr = null;
            for (int i = 0; i < ohmHardware.getResultCount(); ++i) {
                String id = WmiUtil.getString(ohmHardware, OhmHardwareProperty.IDENTIFIER, i);
                if (!id.toLowerCase().contains("cpu")) continue;
                voltIdentifierStr = id;
                break;
            }
            if (voltIdentifierStr == null) {
                voltIdentifierStr = WmiUtil.getString(ohmHardware, OhmHardwareProperty.IDENTIFIER, 0);
            }
            StringBuilder sb = new StringBuilder(BASE_SENSOR_CLASS);
            sb.append(" WHERE Parent = \"").append(voltIdentifierStr);
            sb.append("\" AND SensorType=\"Voltage\"");
            this.ohmSensorQuery.setWmiClassName(sb.toString());
            WbemcliUtil.WmiResult<OhmSensorProperty> ohmSensors = this.wmiQueryHandler.queryWMI(this.ohmSensorQuery);
            if (ohmSensors.getResultCount() > 0) {
                return WmiUtil.getFloat(ohmSensors, OhmSensorProperty.VALUE, 0);
            }
        }
        if ((voltage = this.wmiQueryHandler.queryWMI(this.voltQuery)).getResultCount() > 1) {
            LOG.debug("Found Voltage data in WMI");
            int decivolts = WmiUtil.getUint16(voltage, VoltProperty.CURRENTVOLTAGE, 0);
            if (decivolts > 0) {
                if ((decivolts & 0x80) == 0) {
                    decivolts = WmiUtil.getUint32(voltage, VoltProperty.VOLTAGECAPS, 0);
                    if ((decivolts & 1) > 0) {
                        return 5.0;
                    }
                    if ((decivolts & 2) > 0) {
                        return 3.3;
                    }
                    if ((decivolts & 4) > 0) {
                        return 2.9;
                    }
                } else {
                    return (double)(decivolts & 0x7F) / 10.0;
                }
            }
        }
        return 0.0;
    }

    static enum ThermalZoneProperty implements PerfCounterWildcardQuery.PdhCounterWildcardProperty
    {
        NAME("*cpu*"),
        TEMPERATURE("Temperature");

        private final String counter;

        private ThermalZoneProperty(String counter) {
            this.counter = counter;
        }

        @Override
        public String getCounter() {
            return this.counter;
        }
    }

    static enum VoltProperty {
        CURRENTVOLTAGE,
        VOLTAGECAPS;

    }

    static enum FanProperty {
        DESIREDSPEED;

    }

    static enum OhmSensorProperty {
        VALUE;

    }

    static enum OhmHardwareProperty {
        IDENTIFIER;

    }
}

