/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.windows;

import com.sun.jna.platform.win32.COM.WbemcliUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oshi.hardware.common.AbstractSoundCard;
import oshi.util.platform.windows.WmiQueryHandler;
import oshi.util.platform.windows.WmiUtil;

public class WindowsSoundCard
extends AbstractSoundCard {
    public WindowsSoundCard(String kernelVersion, String name, String codec) {
        super(kernelVersion, name, codec);
    }

    private static String getAudioCardKernelVersion(int index, WbemcliUtil.WmiResult<SoundCardKernel> cardKernelQueryResult) {
        String audioCardKernel = WmiUtil.getString(cardKernelQueryResult, SoundCardKernel.DRIVERPROVIDERNAME, index) + " " + WmiUtil.getString(cardKernelQueryResult, SoundCardKernel.DEVICENAME, index) + " " + WmiUtil.getString(cardKernelQueryResult, SoundCardKernel.DRIVERNAME, index) + " " + WmiUtil.getString(cardKernelQueryResult, SoundCardKernel.DRIVERVERSION, index);
        return audioCardKernel;
    }

    public static List<WindowsSoundCard> getSoundCards() {
        WmiQueryHandler wmiQueryHandler = WmiQueryHandler.createInstance();
        Map<String, String> deviceManufacturerMap = WindowsSoundCard.getDeviceManufacturerMap(wmiQueryHandler);
        String driverQuery = WindowsSoundCard.createClause(deviceManufacturerMap);
        WbemcliUtil.WmiQuery<SoundCardKernel> cardKernelQuery = new WbemcliUtil.WmiQuery<SoundCardKernel>(driverQuery, SoundCardKernel.class);
        WbemcliUtil.WmiResult<SoundCardKernel> cardKernelQueryResult = wmiQueryHandler.queryWMI(cardKernelQuery);
        ArrayList<WindowsSoundCard> soundCards = new ArrayList<WindowsSoundCard>();
        for (int i = 0; i < cardKernelQueryResult.getResultCount(); ++i) {
            if (!deviceManufacturerMap.containsKey(WmiUtil.getString(cardKernelQueryResult, SoundCardKernel.DEVICENAME, i))) continue;
            soundCards.add(new WindowsSoundCard(WindowsSoundCard.getAudioCardKernelVersion(i, cardKernelQueryResult), WmiUtil.getString(cardKernelQueryResult, SoundCardKernel.DRIVERPROVIDERNAME, i) + " " + WmiUtil.getString(cardKernelQueryResult, SoundCardKernel.DEVICENAME, i), WmiUtil.getString(cardKernelQueryResult, SoundCardKernel.DEVICENAME, i)));
        }
        return soundCards;
    }

    private static Map<String, String> getDeviceManufacturerMap(WmiQueryHandler wmiQueryHandler) {
        HashMap<String, String> deviceManufacturerMap = new HashMap<String, String>();
        WbemcliUtil.WmiQuery<SoundCardName> soundCardQuery = new WbemcliUtil.WmiQuery<SoundCardName>("Win32_SoundDevice", SoundCardName.class);
        WbemcliUtil.WmiResult<SoundCardName> soundCardResult = wmiQueryHandler.queryWMI(soundCardQuery);
        for (int i = 0; i < soundCardResult.getResultCount(); ++i) {
            deviceManufacturerMap.put(WmiUtil.getString(soundCardResult, SoundCardName.NAME, i), WmiUtil.getString(soundCardResult, SoundCardName.MANUFACTURER, i));
        }
        return deviceManufacturerMap;
    }

    private static String createClause(Map<String, String> deviceManufacturerMap) {
        StringBuilder sb = new StringBuilder("Win32_PnPSignedDriver");
        boolean first = true;
        for (String key : deviceManufacturerMap.keySet()) {
            if (first) {
                sb.append(" WHERE");
                first = false;
            } else {
                sb.append(" OR");
            }
            sb.append(" DeviceName LIKE \"%").append(key).append("%\"");
        }
        return sb.toString();
    }

    static enum SoundCardKernel {
        DRIVERPROVIDERNAME,
        DRIVERNAME,
        DRIVERVERSION,
        DEVICENAME;

    }

    static enum SoundCardName {
        MANUFACTURER,
        NAME;

    }
}

