/*
 * Decompiled with CFR 0.152.
 */
package kamon.bundle;

import java.io.InputStream;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import kamon.bundle.BuildInfo$;
import kamon.lib.net.bytebuddy.agent.ByteBuddyAgent;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

public final class Bundle$ {
    public static final Bundle$ MODULE$ = new Bundle$();
    private static final String _instrumentationClassLoaderProp = "kanela.instrumentation.classLoader";

    private String _instrumentationClassLoaderProp() {
        return _instrumentationClassLoaderProp;
    }

    public void attach() {
        Option<ClassLoader> springBootClassLoader = this.findSpringBootJarLauncherClassLoader();
        if (this.isKanelaLoaded()) {
            springBootClassLoader.foreach((Function1 & Serializable)sbClassLoader -> {
                Bundle$.MODULE$.withInstrumentationClassLoader(sbClassLoader, (Function0)(JFunction0.mcV.sp & Serializable)() -> Bundle$.MODULE$.reloadKanela());
                return BoxedUnit.UNIT;
            });
        } else {
            InputStream embeddedAgentFile = this.getClass().getClassLoader().getResourceAsStream(BuildInfo$.MODULE$.kanelaAgentJarName());
            Path temporaryAgentFile = Files.createTempFile(BuildInfo$.MODULE$.kanelaAgentJarName(), ".jar", new FileAttribute[0]);
            Files.copy(embeddedAgentFile, temporaryAgentFile, StandardCopyOption.REPLACE_EXISTING);
            this.withInstrumentationClassLoader((ClassLoader)springBootClassLoader.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()), (Function0)(JFunction0.mcV.sp & Serializable)() -> ByteBuddyAgent.attach(temporaryAgentFile.toFile(), MODULE$.pid()));
        }
    }

    private boolean isKanelaLoaded() {
        boolean bl;
        boolean isLoadedProperty = Boolean.parseBoolean(System.getProperty("kanela.loaded"));
        try {
            bl = Class.forName("kanela.agent.Kanela", false, ClassLoader.getSystemClassLoader()) != null;
        }
        catch (Throwable throwable) {
            bl = false;
        }
        boolean hasKanelaClasses = bl;
        return hasKanelaClasses && isLoadedProperty;
    }

    private Option<ClassLoader> findSpringBootJarLauncherClassLoader() {
        return Option$.MODULE$.apply((Object)Thread.currentThread().getContextClassLoader()).filter((Function1 & Serializable)cl -> BoxesRunTime.boxToBoolean((boolean)Bundle$.$anonfun$findSpringBootJarLauncherClassLoader$1(cl)));
    }

    private void reloadKanela() {
        Class.forName("kanela.agent.Kanela", true, ClassLoader.getSystemClassLoader()).getDeclaredMethod("reload", new Class[0]).invoke(null, new Object[0]);
    }

    private String pid() {
        String jvm = ManagementFactory.getRuntimeMXBean().getName();
        return jvm.substring(0, jvm.indexOf(64));
    }

    public <T> T withInstrumentationClassLoader(ClassLoader classLoader, Function0<T> thunk) {
        Object object;
        try {
            Object object2 = classLoader != null ? System.getProperties().put(this._instrumentationClassLoaderProp(), classLoader) : BoxedUnit.UNIT;
            object = thunk.apply();
        }
        finally {
            System.getProperties().remove(this._instrumentationClassLoaderProp());
        }
        return (T)object;
    }

    public static final /* synthetic */ boolean $anonfun$findSpringBootJarLauncherClassLoader$1(ClassLoader cl) {
        String string = cl.getClass().getName();
        String string2 = "org.springframework.boot.loader.LaunchedURLClassLoader";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private Bundle$() {
    }
}

