/*
 * Decompiled with CFR 0.152.
 */
package kamon.instrumentation.jdbc;

import java.io.Serializable;
import java.time.Instant;
import kamon.Kamon$;
import kamon.instrumentation.jdbc.ConnectionPoolTelemetry;
import kamon.instrumentation.jdbc.DatabaseTags;
import kamon.instrumentation.jdbc.HasConnectionPoolTelemetry;
import kamon.instrumentation.jdbc.HasDatabaseTags;
import kamon.instrumentation.jdbc.JdbcMetrics$;
import kamon.instrumentation.jdbc.StatementMonitor;
import kamon.instrumentation.jdbc.utils.LoggingSupport;
import kamon.metric.RangeSampler;
import kamon.tag.Lookups$;
import kamon.tag.TagSet$;
import kamon.trace.SpanBuilder;
import kanela.agent.bootstrap.stack.CallStackDepth;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;

public final class StatementMonitor$
implements LoggingSupport {
    public static final StatementMonitor$ MODULE$ = new StatementMonitor$();
    private static Logger logger;

    static {
        LoggingSupport.$init$(MODULE$);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        LoggingSupport.logInfo$(this, msg);
    }

    @Override
    public void logWarn(Function0<String> msg) {
        LoggingSupport.logWarn$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        LoggingSupport.logError$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg, Function0<Throwable> exc) {
        LoggingSupport.logError$(this, msg, exc);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        LoggingSupport.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        LoggingSupport.logTrace$(this, msg);
    }

    @Override
    public Logger logger() {
        return logger;
    }

    @Override
    public void kamon$instrumentation$jdbc$utils$LoggingSupport$_setter_$logger_$eq(Logger x$1) {
        logger = x$1;
    }

    public Option<StatementMonitor.Invocation> start(Object statement, String sql, String statementType) {
        None$ none$;
        block8: {
            block5: {
                RangeSampler rangeSampler;
                DatabaseTags databaseTags;
                Instant startTimestamp;
                block7: {
                    Tuple2 tuple2;
                    block6: {
                        Tuple2 tuple22;
                        HasConnectionPoolTelemetry hasConnectionPoolTelemetry;
                        if (CallStackDepth.incrementFor((Object)statement) != 0) break block5;
                        startTimestamp = Kamon$.MODULE$.clock().instant();
                        Object object = statement;
                        if (object instanceof HasConnectionPoolTelemetry && (hasConnectionPoolTelemetry = (HasConnectionPoolTelemetry)object).connectionPoolTelemetry() != null && hasConnectionPoolTelemetry.connectionPoolTelemetry().get() != null) {
                            ConnectionPoolTelemetry poolTelemetry = hasConnectionPoolTelemetry.connectionPoolTelemetry().get();
                            tuple22 = new Tuple2((Object)poolTelemetry.instruments().inFlightStatements(), (Object)poolTelemetry.databaseTags());
                        } else {
                            HasDatabaseTags hasDatabaseTags;
                            tuple22 = object instanceof HasDatabaseTags && (hasDatabaseTags = (HasDatabaseTags)object).databaseTags() != null ? new Tuple2(JdbcMetrics$.MODULE$.InFlightStatements().withTags(hasDatabaseTags.databaseTags().metricTags()), (Object)hasDatabaseTags.databaseTags()) : new Tuple2((Object)JdbcMetrics$.MODULE$.InFlightStatements().withoutTags(), (Object)new DatabaseTags(TagSet$.MODULE$.Empty(), TagSet$.MODULE$.Empty()));
                        }
                        tuple2 = tuple22;
                        if (tuple2 == null) break block6;
                        RangeSampler inFlightRangeSampler = (RangeSampler)tuple2._1();
                        databaseTags = (DatabaseTags)tuple2._2();
                        if (inFlightRangeSampler == null) break block6;
                        rangeSampler = inFlightRangeSampler;
                        if (databaseTags != null) break block7;
                    }
                    throw new MatchError((Object)tuple2);
                }
                DatabaseTags databaseTags2 = databaseTags;
                Tuple2 tuple2 = new Tuple2((Object)rangeSampler, (Object)databaseTags2);
                Tuple2 tuple23 = tuple2;
                RangeSampler inFlightRangeSampler = (RangeSampler)tuple23._1();
                DatabaseTags databaseTags3 = (DatabaseTags)tuple23._2();
                SpanBuilder clientSpan = Kamon$.MODULE$.clientSpanBuilder(statementType, "jdbc").tag("db.statement", sql);
                databaseTags3.spanTags().iterator().foreach((Function1 & Serializable)t -> clientSpan.tag(t.key(), (String)databaseTags3.spanTags().get(Lookups$.MODULE$.coerce(t.key()))));
                databaseTags3.metricTags().iterator().foreach((Function1 & Serializable)t -> clientSpan.tagMetrics(t.key(), (String)databaseTags3.metricTags().get(Lookups$.MODULE$.coerce(t.key()))));
                inFlightRangeSampler.increment();
                none$ = new Some((Object)new StatementMonitor.Invocation(statement, clientSpan.start(startTimestamp), sql, startTimestamp, inFlightRangeSampler));
                break block8;
            }
            none$ = None$.MODULE$;
        }
        return none$;
    }

    private StatementMonitor$() {
    }
}

