/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.mac;

import com.sun.jna.platform.mac.IOKit;
import com.sun.jna.platform.mac.IOKitUtil;
import java.nio.charset.StandardCharsets;
import java.util.function.Supplier;
import oshi.hardware.common.AbstractFirmware;
import oshi.util.Memoizer;
import oshi.util.Util;

final class MacFirmware
extends AbstractFirmware {
    private final Supplier<EfiStrings> efi = Memoizer.memoize(this::queryEfi);

    MacFirmware() {
    }

    @Override
    public String getManufacturer() {
        return this.efi.get().manufacturer;
    }

    @Override
    public String getName() {
        return this.efi.get().name;
    }

    @Override
    public String getDescription() {
        return this.efi.get().description;
    }

    @Override
    public String getVersion() {
        return this.efi.get().version;
    }

    @Override
    public String getReleaseDate() {
        return this.efi.get().releaseDate;
    }

    private EfiStrings queryEfi() {
        String releaseDate = null;
        String manufacturer = null;
        String version = null;
        String name = null;
        String description = null;
        IOKit.IOService platformExpert = IOKitUtil.getMatchingService("IOPlatformExpertDevice");
        if (platformExpert != null) {
            IOKit.IOIterator iter = platformExpert.getChildIterator("IODeviceTree");
            if (iter != null) {
                IOKit.IORegistryEntry entry = iter.next();
                while (entry != null) {
                    switch (entry.getName()) {
                        case "rom": {
                            byte[] data = entry.getByteArrayProperty("vendor");
                            if (data != null) {
                                manufacturer = new String(data, StandardCharsets.UTF_8);
                            }
                            if ((data = entry.getByteArrayProperty("version")) != null) {
                                version = new String(data, StandardCharsets.UTF_8);
                            }
                            if ((data = entry.getByteArrayProperty("release-date")) == null) break;
                            releaseDate = new String(data, StandardCharsets.UTF_8);
                            break;
                        }
                        case "chosen": {
                            byte[] data = entry.getByteArrayProperty("booter-name");
                            if (data == null) break;
                            name = new String(data, StandardCharsets.UTF_8);
                            break;
                        }
                        case "efi": {
                            byte[] data = entry.getByteArrayProperty("firmware-abi");
                            if (data == null) break;
                            description = new String(data, StandardCharsets.UTF_8);
                            break;
                        }
                    }
                    entry.release();
                    entry = iter.next();
                }
                iter.release();
            }
            platformExpert.release();
        }
        return new EfiStrings(releaseDate, manufacturer, version, name, description);
    }

    private static final class EfiStrings {
        private final String releaseDate;
        private final String manufacturer;
        private final String version;
        private final String name;
        private final String description;

        private EfiStrings(String releaseDate, String manufacturer, String version, String name, String description) {
            this.releaseDate = Util.isBlank(releaseDate) ? "unknown" : releaseDate;
            this.manufacturer = Util.isBlank(manufacturer) ? "unknown" : manufacturer;
            this.version = Util.isBlank(version) ? "unknown" : version;
            this.name = Util.isBlank(name) ? "unknown" : name;
            this.description = Util.isBlank(description) ? "unknown" : description;
        }
    }
}

