/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.mac;

import com.sun.jna.Native;
import com.sun.jna.platform.mac.SystemB;
import com.sun.jna.ptr.IntByReference;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.hardware.common.AbstractVirtualMemory;
import oshi.util.Memoizer;
import oshi.util.ParseUtil;
import oshi.util.platform.mac.SysctlUtil;

public class MacVirtualMemory
extends AbstractVirtualMemory {
    private static final Logger LOG = LoggerFactory.getLogger(MacVirtualMemory.class);
    private final Supplier<SwapUsage> swapUsage = Memoizer.memoize(this::querySwapUsage, Memoizer.defaultExpiration());
    private final Supplier<VmStat> vmStat = Memoizer.memoize(this::queryVmStat, Memoizer.defaultExpiration());

    @Override
    public long getSwapUsed() {
        return this.swapUsage.get().used;
    }

    @Override
    public long getSwapTotal() {
        return this.swapUsage.get().total;
    }

    @Override
    public long getSwapPagesIn() {
        return this.vmStat.get().pagesIn;
    }

    @Override
    public long getSwapPagesOut() {
        return this.vmStat.get().pagesOut;
    }

    private SwapUsage querySwapUsage() {
        long swapUsed = 0L;
        long swapTotal = 0L;
        SystemB.XswUsage xswUsage = new SystemB.XswUsage();
        if (SysctlUtil.sysctl("vm.swapusage", xswUsage)) {
            swapUsed = xswUsage.xsu_used;
            swapTotal = xswUsage.xsu_total;
        }
        return new SwapUsage(swapTotal, swapUsed);
    }

    private VmStat queryVmStat() {
        long swapPagesIn = 0L;
        long swapPagesOut = 0L;
        SystemB.VMStatistics vmStats = new SystemB.VMStatistics();
        if (0 == SystemB.INSTANCE.host_statistics(SystemB.INSTANCE.mach_host_self(), 2, vmStats, new IntByReference(vmStats.size() / SystemB.INT_SIZE))) {
            swapPagesIn = ParseUtil.unsignedIntToLong(vmStats.pageins);
            swapPagesOut = ParseUtil.unsignedIntToLong(vmStats.pageouts);
        } else {
            LOG.error("Failed to get host VM info. Error code: {}", (Object)Native.getLastError());
        }
        return new VmStat(swapPagesIn, swapPagesOut);
    }

    private static final class VmStat {
        private final long pagesIn;
        private final long pagesOut;

        private VmStat(long pagesIn, long pagesOut) {
            this.pagesIn = pagesIn;
            this.pagesOut = pagesOut;
        }
    }

    private static final class SwapUsage {
        private final long total;
        private final long used;

        private SwapUsage(long total, long used) {
            this.total = total;
            this.used = used;
        }
    }
}

