/*
 * Decompiled with CFR 0.152.
 */
package kamon.annotation.instrumentation.cache;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import kamon.Kamon;
import kamon.annotation.api.Count;
import kamon.annotation.api.Gauge;
import kamon.annotation.api.Histogram;
import kamon.annotation.api.Time;
import kamon.annotation.api.Trace;
import kamon.annotation.api.TrackConcurrency;
import kamon.annotation.el.StringEvaluator;
import kamon.annotation.el.TagsEvaluator;
import kamon.metric.Counter;
import kamon.metric.DynamicRange;
import kamon.metric.Instrument;
import kamon.metric.MeasurementUnit;
import kamon.metric.Metric;
import kamon.metric.RangeSampler;
import kamon.metric.Timer;
import kamon.tag.TagSet;
import kamon.trace.SpanBuilder;
import kanela.agent.libs.net.jodah.expiringmap.ExpirationListener;
import kanela.agent.libs.net.jodah.expiringmap.ExpirationPolicy;
import kanela.agent.libs.net.jodah.expiringmap.ExpiringMap;
import kanela.agent.util.log.Logger;

public final class AnnotationCache {
    private static Map<MetricKey, Object> metrics = AnnotationCache.buildCache();

    private static Map<MetricKey, Object> buildCache() {
        return ExpiringMap.builder().expiration(1L, TimeUnit.MINUTES).expirationPolicy(ExpirationPolicy.ACCESSED).asyncExpirationListener(AnnotationCache.ExpirationListener()).build();
    }

    public static kamon.metric.Gauge getGauge(Method method, Object object, Class<?> clazz, String string, String string2) {
        MetricKey metricKey2 = MetricKey.from("Gauge", method, clazz);
        Gauge gauge = method.getAnnotation(Gauge.class);
        kamon.metric.Gauge gauge2 = (kamon.metric.Gauge)metrics.computeIfAbsent(metricKey2, metricKey -> (kamon.metric.Gauge)Kamon.gauge((String)gauge.name()).withoutTags());
        if (AnnotationCache.containsELExpression(gauge.name(), gauge.tags())) {
            return (kamon.metric.Gauge)metrics.computeIfPresent(metricKey2, (metricKey, object3) -> metricKey.cache.computeIfAbsent(object, object2 -> {
                String string3 = AnnotationCache.getOperationName(gauge.name(), object, clazz, string, string2);
                Map<String, Object> map = AnnotationCache.getTags(object, clazz, gauge.tags());
                if (map.isEmpty()) {
                    return Kamon.gauge((String)string3).withoutTags();
                }
                return Kamon.gauge((String)string3).withTags(TagSet.from(map));
            }));
        }
        return gauge2;
    }

    public static Counter getCounter(Method method, Object object, Class<?> clazz, String string, String string2) {
        MetricKey metricKey2 = MetricKey.from("Counter", method, clazz);
        Count count = method.getAnnotation(Count.class);
        String string3 = count.name().equals("") ? string + "." + string2 : count.name();
        Counter counter = (Counter)metrics.computeIfAbsent(metricKey2, metricKey -> (Counter)Kamon.counter((String)string3).withoutTags());
        if (AnnotationCache.containsELExpression(count.name(), count.tags())) {
            return (Counter)metrics.computeIfPresent(metricKey2, (metricKey, object3) -> metricKey.cache.computeIfAbsent(object, object2 -> {
                String string4 = AnnotationCache.getOperationName(string3, object, clazz, string, string2);
                Map<String, Object> map = AnnotationCache.getTags(object, clazz, count.tags());
                if (map.isEmpty()) {
                    return Kamon.counter((String)string4).withoutTags();
                }
                return Kamon.counter((String)string4).withTags(TagSet.from(map));
            }));
        }
        return counter;
    }

    public static kamon.metric.Histogram getHistogram(Method method, Object object, Class<?> clazz, String string, String string2) {
        MetricKey metricKey2 = MetricKey.from("Histogram", method, clazz);
        Histogram histogram = method.getAnnotation(Histogram.class);
        kamon.metric.Histogram histogram2 = (kamon.metric.Histogram)metrics.computeIfAbsent(metricKey2, metricKey -> (kamon.metric.Histogram)AnnotationCache.getHistogram(histogram, histogram.name()).withoutTags());
        if (AnnotationCache.containsELExpression(histogram.name(), histogram.tags())) {
            return (kamon.metric.Histogram)metrics.computeIfPresent(metricKey2, (metricKey, object3) -> metricKey.cache.computeIfAbsent(object, object2 -> {
                String string3 = AnnotationCache.getOperationName(histogram.name(), object, clazz, string, string2);
                Metric.Histogram histogram2 = AnnotationCache.getHistogram(histogram, string3);
                Map<String, Object> map = AnnotationCache.getTags(object, clazz, histogram.tags());
                if (map.isEmpty()) {
                    return histogram2.withoutTags();
                }
                return histogram2.withTags(TagSet.from(map));
            }));
        }
        return histogram2;
    }

    public static RangeSampler getRangeSampler(Method method, Object object, Class<?> clazz, String string, String string2) {
        MetricKey metricKey2 = MetricKey.from("Sampler", method, clazz);
        TrackConcurrency trackConcurrency = method.getAnnotation(TrackConcurrency.class);
        String string3 = trackConcurrency.name().equals("") ? string + "." + string2 : trackConcurrency.name();
        RangeSampler rangeSampler = (RangeSampler)metrics.computeIfAbsent(metricKey2, metricKey -> (RangeSampler)Kamon.rangeSampler((String)string3).withoutTags());
        if (AnnotationCache.containsELExpression(trackConcurrency.name(), trackConcurrency.tags())) {
            return (RangeSampler)metrics.computeIfPresent(metricKey2, (metricKey, object3) -> metricKey.cache.computeIfAbsent(object, object2 -> {
                String string4 = AnnotationCache.getOperationName(string3, object, clazz, string, string2);
                Map<String, Object> map = AnnotationCache.getTags(object, clazz, trackConcurrency.tags());
                if (map.isEmpty()) {
                    return Kamon.rangeSampler((String)string4).withoutTags();
                }
                return Kamon.rangeSampler((String)string4).withTags(TagSet.from(map));
            }));
        }
        return rangeSampler;
    }

    public static Timer getTimer(Method method, Object object, Class<?> clazz, String string, String string2) {
        MetricKey metricKey2 = MetricKey.from("Time", method, clazz);
        Time time = method.getAnnotation(Time.class);
        String string3 = time.name().equals("") ? string + "." + string2 : time.name();
        Timer timer = (Timer)metrics.computeIfAbsent(metricKey2, metricKey -> (Timer)Kamon.timer((String)string3).withoutTags());
        if (AnnotationCache.containsELExpression(time.name(), time.tags())) {
            return (Timer)metrics.computeIfPresent(metricKey2, (metricKey, object3) -> metricKey.cache.computeIfAbsent(object, object2 -> {
                String string4 = AnnotationCache.getOperationName(string3, object, clazz, string, string2);
                Map<String, Object> map = AnnotationCache.getTags(object, clazz, time.tags());
                if (map.isEmpty()) {
                    return Kamon.timer((String)string4).withoutTags();
                }
                return Kamon.timer((String)string4).withTags(TagSet.from(map));
            }));
        }
        return timer;
    }

    public static SpanBuilder getSpanBuilder(Method method, Object object2, Class<?> clazz, String string2, String string3) {
        String string4;
        Trace trace = method.getAnnotation(Trace.class);
        String string5 = string4 = trace.operationName().equals("") ? string2 + "." + string3 : trace.operationName();
        if (AnnotationCache.containsELExpression(trace.operationName(), trace.tags())) {
            String string6 = AnnotationCache.getOperationName(string4, object2, clazz, string2, string3);
            SpanBuilder spanBuilder = AnnotationCache.resolveBuilder(string6, trace.component(), trace.kind());
            Map<String, Object> map = AnnotationCache.getTags(object2, clazz, trace.tags());
            map.forEach((string, object) -> spanBuilder.tag(string, object.toString()));
            return spanBuilder;
        }
        return AnnotationCache.resolveBuilder(string4, trace.component(), trace.kind());
    }

    private static SpanBuilder resolveBuilder(String string, String string2, Trace.SpanKind spanKind) {
        switch (spanKind) {
            case Server: {
                return Kamon.serverSpanBuilder((String)string, (String)string2);
            }
            case Client: {
                return Kamon.clientSpanBuilder((String)string, (String)string2);
            }
            case Producer: {
                return Kamon.producerSpanBuilder((String)string, (String)string2);
            }
            case Consumer: {
                return Kamon.consumerSpanBuilder((String)string, (String)string2);
            }
            case Internal: {
                return Kamon.internalSpanBuilder((String)string, (String)string2);
            }
        }
        return Kamon.spanBuilder((String)string).tag("component", string2);
    }

    private static Metric.Histogram getHistogram(Histogram histogram, String string) {
        return Kamon.histogram((String)string, (MeasurementUnit)MeasurementUnit.none(), (DynamicRange)new DynamicRange(histogram.lowestDiscernibleValue(), histogram.highestTrackableValue(), histogram.precision()));
    }

    private static Map<String, Object> getTags(Object object, Class<?> clazz, String string) {
        Map<String, String> map = object != null ? TagsEvaluator.eval(object, string) : TagsEvaluator.eval(clazz, string);
        return Collections.unmodifiableMap(map);
    }

    private static String getOperationName(String string, Object object, Class<?> clazz, String string2, String string3) {
        String string4 = object != null ? StringEvaluator.evaluate(object, string) : StringEvaluator.evaluate(clazz, string);
        return string4.isEmpty() || string4.equals("unknown") ? string2 + "." + string3 : string4;
    }

    private static ExpirationListener<MetricKey, Object> ExpirationListener() {
        return (metricKey, object) -> {
            if (object instanceof Instrument) {
                ((Instrument)object).remove();
            }
            Logger.debug(() -> "Expiring key: " + metricKey + "with value" + object);
        };
    }

    private static boolean containsELExpression(String string, String string2) {
        return AnnotationCache.isEL(string) || AnnotationCache.isEL(string2);
    }

    private static boolean isEL(String string) {
        return string.contains("#{") || string.contains("${");
    }

    private static class MetricKey {
        private final String prefix;
        private final Method method;
        private final Class<?> clazz;
        public final Map<Object, Object> cache = new HashMap<Object, Object>();

        private MetricKey(String string, Method method, Class<?> clazz) {
            this.prefix = string;
            this.method = method;
            this.clazz = clazz;
        }

        public static MetricKey from(String string, Method method, Class<?> clazz) {
            return new MetricKey(string, method, clazz);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            MetricKey metricKey = (MetricKey)object;
            return Objects.equals(this.prefix, metricKey.prefix) && Objects.equals(this.method, metricKey.method) && Objects.equals(this.clazz, metricKey.clazz);
        }

        public int hashCode() {
            return Objects.hash(this.prefix, this.method, this.clazz);
        }
    }
}

