/*
 * Decompiled with CFR 0.152.
 */
package kamon.instrumentation.akka.http;

import akka.http.scaladsl.marshalling.Marshaller;
import akka.http.scaladsl.marshalling.ToResponseMarshallable;
import akka.http.scaladsl.marshalling.ToResponseMarshallable$;
import akka.http.scaladsl.model.HttpResponse;
import akka.http.scaladsl.model.StatusCodes;
import akka.http.scaladsl.model.Uri;
import akka.http.scaladsl.server.Directive;
import akka.http.scaladsl.server.Directive$;
import akka.http.scaladsl.server.RequestContext;
import akka.http.scaladsl.server.StandardRoute;
import akka.http.scaladsl.server.StandardRoute$;
import akka.http.scaladsl.server.directives.CompleteOrRecoverWithMagnet;
import akka.http.scaladsl.server.directives.OnSuccessMagnet;
import akka.http.scaladsl.server.util.Tuple$;
import akka.http.scaladsl.server.util.Tupler;
import akka.http.scaladsl.util.FastFuture;
import akka.http.scaladsl.util.FastFuture$;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.regex.Pattern;
import kamon.Kamon$;
import kamon.instrumentation.akka.http.HasMatchingContext;
import kamon.instrumentation.akka.http.LastAutomaticOperationNameEdit$;
import kamon.trace.Span;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple1;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

public final class ResolveOperationNameOnRouteInterceptor$ {
    public static final ResolveOperationNameOnRouteInterceptor$ MODULE$ = new ResolveOperationNameOnRouteInterceptor$();

    public StandardRoute complete(Function0<ToResponseMarshallable> m) {
        return StandardRoute$.MODULE$.apply((Function1 & Serializable)x$1 -> MODULE$.kamon$instrumentation$akka$http$ResolveOperationNameOnRouteInterceptor$$resolveOperationName((RequestContext)x$1).complete((ToResponseMarshallable)m.apply()));
    }

    public StandardRoute redirect(Uri uri, StatusCodes.Redirection redirectionType) {
        return StandardRoute$.MODULE$.apply((Function1 & Serializable)x$2 -> MODULE$.kamon$instrumentation$akka$http$ResolveOperationNameOnRouteInterceptor$$resolveOperationName((RequestContext)x$2).redirect(uri, redirectionType));
    }

    public StandardRoute failWith(Throwable error) {
        Kamon$.MODULE$.currentSpan().fail(error);
        return StandardRoute$.MODULE$.apply((Function1 & Serializable)x$3 -> MODULE$.kamon$instrumentation$akka$http$ResolveOperationNameOnRouteInterceptor$$resolveOperationName((RequestContext)x$3).fail(error));
    }

    public <T> Directive<Tuple1<Try<T>>> onComplete(Function0<Future<T>> future) {
        return Directive$.MODULE$.apply((Function1 & Serializable)inner -> (Function1 & Serializable)ctx -> {
            MODULE$.kamon$instrumentation$akka$http$ResolveOperationNameOnRouteInterceptor$$resolveOperationName((RequestContext)ctx);
            return FastFuture$.MODULE$.transformWith$extension(FastFuture.EnhancedFuture$.MODULE$.fast$extension(FastFuture$.MODULE$.EnhancedFuture((Future)future.apply())), (Function1 & Serializable)t -> (Future)((Function1)inner.apply((Object)new Tuple1(t))).apply(ctx), (ExecutionContext)ctx.executionContext());
        }, Tuple$.MODULE$.forTuple1());
    }

    public <T> OnSuccessMagnet apply(Function0<Future<T>> future, Tupler<T> tupler) {
        return new OnSuccessMagnet(future, tupler){
            private final Directive<Object> directive;
            private final Function0 future$2;
            private final Tupler tupler$1;

            public Directive<Object> directive() {
                return this.directive;
            }
            {
                this.future$2 = future$2;
                this.tupler$1 = tupler$1;
                this.directive = Directive$.MODULE$.apply((Function1 & Serializable)inner -> (Function1 & Serializable)ctx -> {
                    ResolveOperationNameOnRouteInterceptor$.MODULE$.kamon$instrumentation$akka$http$ResolveOperationNameOnRouteInterceptor$$resolveOperationName((RequestContext)ctx);
                    return FastFuture$.MODULE$.flatMap$extension(FastFuture.EnhancedFuture$.MODULE$.fast$extension(FastFuture$.MODULE$.EnhancedFuture((Future)$this.future$2.apply())), (Function1 & Serializable)t -> (Future)((Function1)inner.apply($this.tupler$1.apply(t))).apply(ctx), (ExecutionContext)ctx.executionContext());
                }, tupler$1.OutIsTuple());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$directive$1(kamon.instrumentation.akka.http.ResolveOperationNameOnRouteInterceptor$$anon$1 scala.Function1 ), $anonfun$directive$2(kamon.instrumentation.akka.http.ResolveOperationNameOnRouteInterceptor$$anon$1 scala.Function1 akka.http.scaladsl.server.RequestContext ), $anonfun$directive$3(kamon.instrumentation.akka.http.ResolveOperationNameOnRouteInterceptor$$anon$1 scala.Function1 akka.http.scaladsl.server.RequestContext java.lang.Object )}, serializedLambda);
            }
        };
    }

    public <T> CompleteOrRecoverWithMagnet apply(Function0<Future<T>> future, Marshaller<T, HttpResponse> m) {
        return new CompleteOrRecoverWithMagnet(future, m){
            private final Directive<Tuple1<Throwable>> directive;
            private final Function0 future$3;
            private final Marshaller m$2;

            public Directive<Tuple1<Throwable>> directive() {
                return this.directive;
            }
            {
                this.future$3 = future$3;
                this.m$2 = m$2;
                this.directive = Directive$.MODULE$.apply((Function1 & Serializable)inner -> (Function1 & Serializable)ctx -> {
                    ResolveOperationNameOnRouteInterceptor$.MODULE$.kamon$instrumentation$akka$http$ResolveOperationNameOnRouteInterceptor$$resolveOperationName((RequestContext)ctx);
                    return FastFuture$.MODULE$.transformWith$extension(FastFuture.EnhancedFuture$.MODULE$.fast$extension(FastFuture$.MODULE$.EnhancedFuture((Future)$this.future$3.apply())), (Function1 & Serializable)x0$1 -> {
                        Future future;
                        Try try_ = x0$1;
                        if (try_ instanceof Success) {
                            Success success = (Success)try_;
                            Object res = success.value();
                            future = ctx.complete(ToResponseMarshallable$.MODULE$.apply(res, $this.m$2));
                        } else if (try_ instanceof Failure) {
                            Failure failure = (Failure)try_;
                            Throwable error = failure.exception();
                            future = (Future)((Function1)inner.apply((Object)new Tuple1((Object)error))).apply(ctx);
                        } else {
                            throw new MatchError((Object)try_);
                        }
                        return future;
                    }, (ExecutionContext)ctx.executionContext());
                }, Tuple$.MODULE$.forTuple1());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$directive$4(kamon.instrumentation.akka.http.ResolveOperationNameOnRouteInterceptor$$anon$2 scala.Function1 ), $anonfun$directive$5(kamon.instrumentation.akka.http.ResolveOperationNameOnRouteInterceptor$$anon$2 scala.Function1 akka.http.scaladsl.server.RequestContext ), $anonfun$directive$6(kamon.instrumentation.akka.http.ResolveOperationNameOnRouteInterceptor$$anon$2 akka.http.scaladsl.server.RequestContext scala.Function1 scala.util.Try )}, serializedLambda);
            }
        };
    }

    public RequestContext kamon$instrumentation$akka$http$ResolveOperationNameOnRouteInterceptor$$resolveOperationName(RequestContext requestContext) {
        ((Option)Kamon$.MODULE$.currentContext().get(LastAutomaticOperationNameEdit$.MODULE$.Key())).foreach((Function1 & Serializable)lastEdit -> {
            Span span;
            Span currentSpan = Kamon$.MODULE$.currentSpan();
            if (lastEdit.allowAutomaticChanges()) {
                String string = currentSpan.operationName();
                String string2 = lastEdit.operationName();
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    Seq allMatches = (Seq)((IterableOps)((HasMatchingContext)requestContext).matchingContext().reverse()).map((Function1 & Serializable)matching -> MODULE$.singleMatch((HasMatchingContext.PathMatchingContext)matching));
                    String operationName = allMatches.mkString("");
                    if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(operationName))) {
                        currentSpan.name(operationName).takeSamplingDecision();
                        lastEdit.operationName_$eq(operationName);
                        span = BoxedUnit.UNIT;
                    } else {
                        span = BoxedUnit.UNIT;
                    }
                } else {
                    lastEdit.allowAutomaticChanges_$eq(false);
                    span = BoxedUnit.UNIT;
                }
            } else {
                span = currentSpan.takeSamplingDecision();
            }
            return span;
        });
        return requestContext;
    }

    private String singleMatch(HasMatchingContext.PathMatchingContext matching) {
        String string;
        String rest = matching.matched().pathRest().toString();
        int consumedCount = matching.fullPath().length() - rest.length();
        String consumedSegment = matching.fullPath().substring(0, consumedCount);
        Object object = matching.matched().extractions();
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
        Object object2 = object;
        if (!(boxedUnit != null ? !boxedUnit.equals(object2) : object2 != null)) {
            string = consumedSegment;
        } else if (object instanceof Product) {
            Object object3 = object;
            List values = ((Product)object3).productIterator().toList().map((Function1 & Serializable)x0$1 -> {
                Nil$ nil$;
                Object object = x0$1;
                if (object instanceof Some) {
                    Some some = (Some)object;
                    Object x = some.value();
                    nil$ = (List)new .colon.colon((Object)x.toString(), (List)Nil$.MODULE$);
                } else if (None$.MODULE$.equals(object)) {
                    nil$ = Nil$.MODULE$;
                } else if (object instanceof Long) {
                    long l = BoxesRunTime.unboxToLong((Object)object);
                    nil$ = (List)new .colon.colon((Object)((Object)BoxesRunTime.boxToLong((long)l)).toString(), (List)new .colon.colon((Object)RichLong$.MODULE$.toHexString$extension(Predef$.MODULE$.longWrapper(l)), (List)Nil$.MODULE$));
                } else if (object instanceof Integer) {
                    int n = BoxesRunTime.unboxToInt((Object)object);
                    nil$ = (List)new .colon.colon((Object)((Object)BoxesRunTime.boxToInteger((int)n)).toString(), (List)new .colon.colon((Object)RichInt$.MODULE$.toHexString$extension(Predef$.MODULE$.intWrapper(n)), (List)Nil$.MODULE$));
                } else if (object instanceof Object) {
                    Object object2 = object;
                    nil$ = (List)new .colon.colon((Object)object2.toString(), (List)Nil$.MODULE$);
                } else {
                    throw new MatchError(object);
                }
                return nil$;
            });
            string = (String)((IterableOnceOps)values.flatten(Predef$.MODULE$.$conforms())).fold((Object)consumedSegment, (Function2 & Serializable)(full, value) -> {
                String r = new StringBuilder(14).append("(?i)(^|/)").append(Pattern.quote(value)).append("($|/)").toString();
                return full.replaceFirst(r, "$1{}$2");
            });
        } else {
            throw new MatchError(object);
        }
        return string;
    }

    private ResolveOperationNameOnRouteInterceptor$() {
    }
}

