/*
 * Decompiled with CFR 0.152.
 */
package kamon.lib.com.sun.el;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import kamon.lib.com.sun.el.lang.EvaluationContext;
import kamon.lib.com.sun.el.lang.ExpressionBuilder;
import kamon.lib.com.sun.el.parser.Node;
import kamon.lib.com.sun.el.util.ReflectionUtil;
import kamon.lib.javax.el.ELContext;
import kamon.lib.javax.el.ELException;
import kamon.lib.javax.el.FunctionMapper;
import kamon.lib.javax.el.MethodExpression;
import kamon.lib.javax.el.MethodInfo;
import kamon.lib.javax.el.MethodNotFoundException;
import kamon.lib.javax.el.PropertyNotFoundException;
import kamon.lib.javax.el.VariableMapper;

public final class MethodExpressionImpl
extends MethodExpression
implements Externalizable {
    private Class expectedType;
    private String expr;
    private FunctionMapper fnMapper;
    private VariableMapper varMapper;
    private transient Node node;
    private Class[] paramTypes;

    public MethodExpressionImpl() {
    }

    public MethodExpressionImpl(String expr, Node node, FunctionMapper fnMapper, VariableMapper varMapper, Class expectedType, Class[] paramTypes) {
        this.expr = expr;
        this.node = node;
        this.fnMapper = fnMapper;
        this.varMapper = varMapper;
        this.expectedType = expectedType;
        this.paramTypes = paramTypes;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof MethodExpressionImpl) {
            MethodExpressionImpl me = (MethodExpressionImpl)obj;
            return this.getNode().equals(me.getNode());
        }
        return false;
    }

    @Override
    public String getExpressionString() {
        return this.expr;
    }

    @Override
    public MethodInfo getMethodInfo(ELContext context) throws PropertyNotFoundException, MethodNotFoundException, ELException {
        Node n = this.getNode();
        EvaluationContext ctx = new EvaluationContext(context, this.fnMapper, this.varMapper);
        return n.getMethodInfo(ctx, this.paramTypes);
    }

    private Node getNode() throws ELException {
        if (this.node == null) {
            this.node = ExpressionBuilder.createNode(this.expr);
        }
        return this.node;
    }

    @Override
    public int hashCode() {
        return this.getNode().hashCode();
    }

    @Override
    public Object invoke(ELContext context, Object[] params) throws PropertyNotFoundException, MethodNotFoundException, ELException {
        EvaluationContext ctx = new EvaluationContext(context, this.fnMapper, this.varMapper);
        ctx.notifyBeforeEvaluation(this.expr);
        Object obj = this.getNode().invoke(ctx, this.paramTypes, params);
        ctx.notifyAfterEvaluation(this.expr);
        return obj;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.expr = in.readUTF();
        String type = in.readUTF();
        if (!"".equals(type)) {
            this.expectedType = ReflectionUtil.forName(type);
        }
        this.paramTypes = ReflectionUtil.toTypeArray((String[])in.readObject());
        this.fnMapper = (FunctionMapper)in.readObject();
        this.varMapper = (VariableMapper)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.expr);
        out.writeUTF(this.expectedType != null ? this.expectedType.getName() : "");
        out.writeObject(ReflectionUtil.toTypeNameArray(this.paramTypes));
        out.writeObject(this.fnMapper);
        out.writeObject(this.varMapper);
    }

    @Override
    public boolean isLiteralText() {
        return false;
    }

    @Override
    public boolean isParametersProvided() {
        return this.getNode().isParametersProvided();
    }
}

