/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.Connection;
import com.datastax.driver.core.GuavaCompatibility;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import kamon.Kamon$;
import kamon.instrumentation.cassandra.metrics.HasPoolMetrics;
import kanela.agent.libs.net.bytebuddy.asm.Advice;

public final class BorrowAdvice$ {
    public static final BorrowAdvice$ MODULE$ = new BorrowAdvice$();

    @Advice.OnMethodEnter
    public long startBorrow(@Advice.This HasPoolMetrics poolMetrics) {
        return Kamon$.MODULE$.clock().nanos();
    }

    @Advice.OnMethodExit(suppress=Throwable.class, inline=false)
    public void onBorrowed(@Advice.Return ListenableFuture<Connection> connection, @Advice.Enter long start, @Advice.This HasPoolMetrics poolMetrics, @Advice.FieldValue(value="totalInFlight") AtomicInteger totalInflight) {
        GuavaCompatibility.INSTANCE.addCallback(connection, (FutureCallback)new FutureCallback<Connection>(poolMetrics, start){
            private final HasPoolMetrics poolMetrics$1;
            private final long start$1;

            public void onSuccess(Connection borrowedConnection) {
                this.poolMetrics$1.nodeMonitor().recordBorrow(Kamon$.MODULE$.clock().nanos() - this.start$1);
            }

            public void onFailure(Throwable t) {
            }
            {
                this.poolMetrics$1 = poolMetrics$1;
                this.start$1 = start$1;
            }
        });
    }

    private BorrowAdvice$() {
    }
}

