/*
 * Decompiled with CFR 0.152.
 */
package kamon.instrumentation.akka;

import java.io.Serializable;
import kamon.Kamon$;
import kamon.instrumentation.akka.AkkaMetrics;
import kamon.instrumentation.akka.instrumentations.ActorCellInfo$;
import kamon.metric.Metric;
import kamon.tag.TagSet;
import kamon.tag.TagSet$;
import scala.Function0;
import scala.collection.concurrent.TrieMap;
import scala.collection.concurrent.TrieMap$;
import scala.runtime.BoxedUnit;

public final class AkkaMetrics$ {
    public static final AkkaMetrics$ MODULE$ = new AkkaMetrics$();
    private static final TrieMap<String, AkkaMetrics.ActorGroupInstruments> _groupInstrumentsCache = TrieMap$.MODULE$.empty();
    private static final TrieMap<String, AkkaMetrics.ActorSystemInstruments> _systemInstrumentsCache = TrieMap$.MODULE$.empty();
    private static final Metric.Timer ActorTimeInMailbox = Kamon$.MODULE$.timer("akka.actor.time-in-mailbox", "Tracks the time since the instant a message is enqueued in an Actor's mailbox until it is dequeued for processing");
    private static final Metric.Timer ActorProcessingTime = Kamon$.MODULE$.timer("akka.actor.processing-time", "Tracks the time taken for the actor to process the receive function");
    private static final Metric.RangeSampler ActorMailboxSize = Kamon$.MODULE$.rangeSampler("akka.actor.mailbox-size", "Tracks the behavior of an Actor's mailbox size");
    private static final Metric.Counter ActorErrors = Kamon$.MODULE$.counter("akka.actor.errors", "Counts the number of processing errors experienced by an Actor");
    private static final Metric.Timer RouterRoutingTime = Kamon$.MODULE$.timer("akka.router.routing-time", "Tracks the time taken by a router to process its routing logic");
    private static final Metric.Timer RouterTimeInMailbox = Kamon$.MODULE$.timer("akka.router.time-in-mailbox", "Tracks the time since the instant a message is enqueued in a routee's mailbox until it is dequeued for processing");
    private static final Metric.Timer RouterProcessingTime = Kamon$.MODULE$.timer("akka.router.processing-time", "Tracks the time taken for a routee to process the receive function");
    private static final Metric.RangeSampler RouterPendingMessages = Kamon$.MODULE$.rangeSampler("akka.router.pending-messages", "Tracks the number of messages waiting to be processed across all routees");
    private static final Metric.RangeSampler RouterMembers = Kamon$.MODULE$.rangeSampler("akka.router.members", "Tracks the number of routees belonging to a router");
    private static final Metric.Counter RouterErrors = Kamon$.MODULE$.counter("akka.router.errors", "Counts the number of processing errors experienced by the routees of a router");
    private static final Metric.Timer GroupTimeInMailbox = Kamon$.MODULE$.timer("akka.group.time-in-mailbox", "Tracks the time since the instant a message is enqueued in a member's mailbox until it is dequeued for processing");
    private static final Metric.Timer GroupProcessingTime = Kamon$.MODULE$.timer("akka.group.processing-time", "Tracks the time taken for a member actor to process the receive function");
    private static final Metric.RangeSampler GroupPendingMessages = Kamon$.MODULE$.rangeSampler("akka.group.pending-messages", "Tracks the number of messages waiting to be processed across all members");
    private static final Metric.RangeSampler GroupMembers = Kamon$.MODULE$.rangeSampler("akka.group.members", "Tracks the number of routees belonging to a group");
    private static final Metric.Counter GroupErrors = Kamon$.MODULE$.counter("akka.group.errors", "Counts the number of processing errors experienced by the members of a group");
    private static final Metric.Counter SystemDeadLetters = Kamon$.MODULE$.counter("akka.system.dead-letters", "Counts the number of dead letters in an Actor System");
    private static final Metric.Counter SystemUnhandledMessages = Kamon$.MODULE$.counter("akka.system.unhandled-messages", "Counts the number of unhandled messages in an Actor System");
    private static final Metric.Counter SystemProcessedMessages = Kamon$.MODULE$.counter("akka.system.processed-messages", "Counts the number of processed messages in an Actor System");
    private static final Metric.RangeSampler SystemActiveActors = Kamon$.MODULE$.rangeSampler("akka.system.active-actors", "Tracks the number of active Actors in an Actor System");

    private TrieMap<String, AkkaMetrics.ActorGroupInstruments> _groupInstrumentsCache() {
        return _groupInstrumentsCache;
    }

    private TrieMap<String, AkkaMetrics.ActorSystemInstruments> _systemInstrumentsCache() {
        return _systemInstrumentsCache;
    }

    public Metric.Timer ActorTimeInMailbox() {
        return ActorTimeInMailbox;
    }

    public Metric.Timer ActorProcessingTime() {
        return ActorProcessingTime;
    }

    public Metric.RangeSampler ActorMailboxSize() {
        return ActorMailboxSize;
    }

    public Metric.Counter ActorErrors() {
        return ActorErrors;
    }

    public AkkaMetrics.ActorInstruments forActor(String path, String system, String dispatcher, Class<?> actorClass) {
        TagSet.Builder tags = TagSet$.MODULE$.builder().add("path", path).add("system", system).add("dispatcher", dispatcher);
        Object object = !ActorCellInfo$.MODULE$.isTyped(actorClass) ? tags.add("class", actorClass.getName()) : BoxedUnit.UNIT;
        return new AkkaMetrics.ActorInstruments(tags.build());
    }

    public Metric.Timer RouterRoutingTime() {
        return RouterRoutingTime;
    }

    public Metric.Timer RouterTimeInMailbox() {
        return RouterTimeInMailbox;
    }

    public Metric.Timer RouterProcessingTime() {
        return RouterProcessingTime;
    }

    public Metric.RangeSampler RouterPendingMessages() {
        return RouterPendingMessages;
    }

    public Metric.RangeSampler RouterMembers() {
        return RouterMembers;
    }

    public Metric.Counter RouterErrors() {
        return RouterErrors;
    }

    public AkkaMetrics.RouterInstruments forRouter(String path, String system, String dispatcher, Class<?> routerClass, String routeeClass) {
        TagSet.Builder tags = TagSet$.MODULE$.builder().add("path", path).add("system", system).add("dispatcher", dispatcher).add("routeeClass", routeeClass);
        Object object = !ActorCellInfo$.MODULE$.isTyped(routerClass) ? tags.add("routerClass", routerClass.getName()) : BoxedUnit.UNIT;
        return new AkkaMetrics.RouterInstruments(tags.build());
    }

    public Metric.Timer GroupTimeInMailbox() {
        return GroupTimeInMailbox;
    }

    public Metric.Timer GroupProcessingTime() {
        return GroupProcessingTime;
    }

    public Metric.RangeSampler GroupPendingMessages() {
        return GroupPendingMessages;
    }

    public Metric.RangeSampler GroupMembers() {
        return GroupMembers;
    }

    public Metric.Counter GroupErrors() {
        return GroupErrors;
    }

    public AkkaMetrics.ActorGroupInstruments forGroup(String group, String system) {
        return (AkkaMetrics.ActorGroupInstruments)this._groupInstrumentsCache().getOrElseUpdate((Object)new StringBuilder(1).append(system).append("/").append(group).toString(), (Function0 & Serializable)() -> {
            TagSet.Builder tags = TagSet$.MODULE$.builder().add("group", group).add("system", system);
            return new AkkaMetrics.ActorGroupInstruments(tags.build());
        });
    }

    public Metric.Counter SystemDeadLetters() {
        return SystemDeadLetters;
    }

    public Metric.Counter SystemUnhandledMessages() {
        return SystemUnhandledMessages;
    }

    public Metric.Counter SystemProcessedMessages() {
        return SystemProcessedMessages;
    }

    public Metric.RangeSampler SystemActiveActors() {
        return SystemActiveActors;
    }

    public AkkaMetrics.ActorSystemInstruments forSystem(String name) {
        return (AkkaMetrics.ActorSystemInstruments)((Object)this._systemInstrumentsCache().getOrElseUpdate((Object)name, (Function0 & Serializable)() -> new AkkaMetrics.ActorSystemInstruments(TagSet$.MODULE$.of("system", name))));
    }

    private AkkaMetrics$() {
    }
}

