/*
 * Decompiled with CFR 0.152.
 */
package kamon.instrumentation.pekko;

import java.io.Serializable;
import kamon.Kamon$;
import kamon.instrumentation.pekko.PekkoMetrics;
import kamon.instrumentation.pekko.instrumentations.ActorCellInfo$;
import kamon.metric.Metric;
import kamon.tag.TagSet;
import kamon.tag.TagSet$;
import scala.Function0;
import scala.collection.concurrent.TrieMap;
import scala.collection.concurrent.TrieMap$;
import scala.runtime.BoxedUnit;

public final class PekkoMetrics$ {
    public static final PekkoMetrics$ MODULE$ = new PekkoMetrics$();
    private static final TrieMap<String, PekkoMetrics.ActorGroupInstruments> _groupInstrumentsCache = TrieMap$.MODULE$.empty();
    private static final TrieMap<String, PekkoMetrics.ActorSystemInstruments> _systemInstrumentsCache = TrieMap$.MODULE$.empty();
    private static final Metric.Timer ActorTimeInMailbox = Kamon$.MODULE$.timer("pekko.actor.time-in-mailbox", "Tracks the time since the instant a message is enqueued in an Actor's mailbox until it is dequeued for processing");
    private static final Metric.Timer ActorProcessingTime = Kamon$.MODULE$.timer("pekko.actor.processing-time", "Tracks the time taken for the actor to process the receive function");
    private static final Metric.RangeSampler ActorMailboxSize = Kamon$.MODULE$.rangeSampler("pekko.actor.mailbox-size", "Tracks the behavior of an Actor's mailbox size");
    private static final Metric.Counter ActorErrors = Kamon$.MODULE$.counter("pekko.actor.errors", "Counts the number of processing errors experienced by an Actor");
    private static final Metric.Timer RouterRoutingTime = Kamon$.MODULE$.timer("pekko.router.routing-time", "Tracks the time taken by a router to process its routing logic");
    private static final Metric.Timer RouterTimeInMailbox = Kamon$.MODULE$.timer("pekko.router.time-in-mailbox", "Tracks the time since the instant a message is enqueued in a routee's mailbox until it is dequeued for processing");
    private static final Metric.Timer RouterProcessingTime = Kamon$.MODULE$.timer("pekko.router.processing-time", "Tracks the time taken for a routee to process the receive function");
    private static final Metric.RangeSampler RouterPendingMessages = Kamon$.MODULE$.rangeSampler("pekko.router.pending-messages", "Tracks the number of messages waiting to be processed across all routees");
    private static final Metric.RangeSampler RouterMembers = Kamon$.MODULE$.rangeSampler("pekko.router.members", "Tracks the number of routees belonging to a router");
    private static final Metric.Counter RouterErrors = Kamon$.MODULE$.counter("pekko.router.errors", "Counts the number of processing errors experienced by the routees of a router");
    private static final Metric.Timer GroupTimeInMailbox = Kamon$.MODULE$.timer("pekko.group.time-in-mailbox", "Tracks the time since the instant a message is enqueued in a member's mailbox until it is dequeued for processing");
    private static final Metric.Timer GroupProcessingTime = Kamon$.MODULE$.timer("pekko.group.processing-time", "Tracks the time taken for a member actor to process the receive function");
    private static final Metric.RangeSampler GroupPendingMessages = Kamon$.MODULE$.rangeSampler("pekko.group.pending-messages", "Tracks the number of messages waiting to be processed across all members");
    private static final Metric.RangeSampler GroupMembers = Kamon$.MODULE$.rangeSampler("pekko.group.members", "Tracks the number of routees belonging to a group");
    private static final Metric.Counter GroupErrors = Kamon$.MODULE$.counter("pekko.group.errors", "Counts the number of processing errors experienced by the members of a group");
    private static final Metric.Counter SystemDeadLetters = Kamon$.MODULE$.counter("pekko.system.dead-letters", "Counts the number of dead letters in an Actor System");
    private static final Metric.Counter SystemUnhandledMessages = Kamon$.MODULE$.counter("pekko.system.unhandled-messages", "Counts the number of unhandled messages in an Actor System");
    private static final Metric.Counter SystemProcessedMessages = Kamon$.MODULE$.counter("pekko.system.processed-messages", "Counts the number of processed messages in an Actor System");
    private static final Metric.RangeSampler SystemActiveActors = Kamon$.MODULE$.rangeSampler("pekko.system.active-actors", "Tracks the number of active Actors in an Actor System");

    private TrieMap<String, PekkoMetrics.ActorGroupInstruments> _groupInstrumentsCache() {
        return _groupInstrumentsCache;
    }

    private TrieMap<String, PekkoMetrics.ActorSystemInstruments> _systemInstrumentsCache() {
        return _systemInstrumentsCache;
    }

    public Metric.Timer ActorTimeInMailbox() {
        return ActorTimeInMailbox;
    }

    public Metric.Timer ActorProcessingTime() {
        return ActorProcessingTime;
    }

    public Metric.RangeSampler ActorMailboxSize() {
        return ActorMailboxSize;
    }

    public Metric.Counter ActorErrors() {
        return ActorErrors;
    }

    public PekkoMetrics.ActorInstruments forActor(String path, String system, String dispatcher, Class<?> actorClass) {
        TagSet.Builder tags = TagSet$.MODULE$.builder().add("path", path).add("system", system).add("dispatcher", dispatcher);
        Object object = !ActorCellInfo$.MODULE$.isTyped(actorClass) ? tags.add("class", actorClass.getName()) : BoxedUnit.UNIT;
        return new PekkoMetrics.ActorInstruments(tags.build());
    }

    public Metric.Timer RouterRoutingTime() {
        return RouterRoutingTime;
    }

    public Metric.Timer RouterTimeInMailbox() {
        return RouterTimeInMailbox;
    }

    public Metric.Timer RouterProcessingTime() {
        return RouterProcessingTime;
    }

    public Metric.RangeSampler RouterPendingMessages() {
        return RouterPendingMessages;
    }

    public Metric.RangeSampler RouterMembers() {
        return RouterMembers;
    }

    public Metric.Counter RouterErrors() {
        return RouterErrors;
    }

    public PekkoMetrics.RouterInstruments forRouter(String path, String system, String dispatcher, Class<?> routerClass, String routeeClass) {
        TagSet.Builder tags = TagSet$.MODULE$.builder().add("path", path).add("system", system).add("dispatcher", dispatcher).add("routeeClass", routeeClass);
        Object object = !ActorCellInfo$.MODULE$.isTyped(routerClass) ? tags.add("routerClass", routerClass.getName()) : BoxedUnit.UNIT;
        return new PekkoMetrics.RouterInstruments(tags.build());
    }

    public Metric.Timer GroupTimeInMailbox() {
        return GroupTimeInMailbox;
    }

    public Metric.Timer GroupProcessingTime() {
        return GroupProcessingTime;
    }

    public Metric.RangeSampler GroupPendingMessages() {
        return GroupPendingMessages;
    }

    public Metric.RangeSampler GroupMembers() {
        return GroupMembers;
    }

    public Metric.Counter GroupErrors() {
        return GroupErrors;
    }

    public PekkoMetrics.ActorGroupInstruments forGroup(String group, String system) {
        return (PekkoMetrics.ActorGroupInstruments)this._groupInstrumentsCache().getOrElseUpdate((Object)new StringBuilder(1).append(system).append("/").append(group).toString(), (Function0 & Serializable)() -> {
            TagSet.Builder tags = TagSet$.MODULE$.builder().add("group", group).add("system", system);
            return new PekkoMetrics.ActorGroupInstruments(tags.build());
        });
    }

    public Metric.Counter SystemDeadLetters() {
        return SystemDeadLetters;
    }

    public Metric.Counter SystemUnhandledMessages() {
        return SystemUnhandledMessages;
    }

    public Metric.Counter SystemProcessedMessages() {
        return SystemProcessedMessages;
    }

    public Metric.RangeSampler SystemActiveActors() {
        return SystemActiveActors;
    }

    public PekkoMetrics.ActorSystemInstruments forSystem(String name) {
        return (PekkoMetrics.ActorSystemInstruments)((Object)this._systemInstrumentsCache().getOrElseUpdate((Object)name, (Function0 & Serializable)() -> new PekkoMetrics.ActorSystemInstruments(TagSet$.MODULE$.of("system", name))));
    }

    private PekkoMetrics$() {
    }
}

