/*
 * Decompiled with CFR 0.152.
 */
package kamon.cassandra;

import com.datastax.driver.core.ExecutorQueueMetricsExtractor$;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.Session;
import java.util.concurrent.TimeUnit;
import kamon.Kamon$;
import kamon.cassandra.Cassandra$;
import kamon.cassandra.Metrics;
import kamon.cassandra.Metrics$;
import kamon.cassandra.Metrics$ExecutorQueueMetrics$;
import kamon.metric.Counter;
import kamon.metric.Histogram;
import kamon.metric.MeasurementUnit$;
import kamon.metric.RangeSampler;
import scala.Function1;
import scala.Serializable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;

public final class Metrics$ {
    public static final Metrics$ MODULE$;

    static {
        new Metrics$();
    }

    public RangeSampler inflight(String host) {
        return (RangeSampler)Kamon$.MODULE$.rangeSampler("cassandra.client-inflight").refine("target", host);
    }

    public Histogram inflightDriver(String host) {
        return (Histogram)Kamon$.MODULE$.histogram("cassandra.client-inflight-driver").refine("target", host);
    }

    public Histogram queryDuration() {
        return Kamon$.MODULE$.histogram("cassandra.query-duration", MeasurementUnit$.MODULE$.time().nanoseconds());
    }

    public Counter queryCount() {
        return Kamon$.MODULE$.counter("cassandra.query-count");
    }

    public Histogram connections(String host) {
        return (Histogram)Kamon$.MODULE$.histogram("cassandra.connection-pool-size").refine("target", host);
    }

    public Histogram trashedConnections(String host) {
        return (Histogram)Kamon$.MODULE$.histogram("cassandra.trashed-connections").refine("target", host);
    }

    public void recordQueryDuration(long start, long end) {
        this.queryDuration().record(end - start);
        this.queryCount().increment(1L);
        this.inflight("ALL").decrement();
    }

    public void from(Session session) {
        Metrics.ExecutorQueueMetrics metrics = Metrics$ExecutorQueueMetrics$.MODULE$.apply();
        Kamon$.MODULE$.scheduler().scheduleAtFixedRate(new Runnable(session, metrics){
            public final Session session$1;
            private final Metrics.ExecutorQueueMetrics metrics$1;

            public void run() {
                Session.State state = this.session$1.getState();
                ExecutorQueueMetricsExtractor$.MODULE$.from(this.session$1, this.metrics$1);
                ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(state.getConnectedHosts()).asScala()).foreach((Function1)new Serializable(this, state){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anon.1 $outer;
                    private final Session.State state$1;

                    public final void apply(Host host) {
                        String hostId = host.getAddress().getHostAddress();
                        int trashed = this.state$1.getTrashedConnections(host);
                        int openConnections = this.state$1.getOpenConnections(host);
                        int inflightCount = this.state$1.getInFlightQueries(host);
                        this.$outer.session$1.getCluster().getMetrics().getRegistry().getCounters();
                        Metrics$.MODULE$.trashedConnections(hostId).record((long)trashed);
                        Metrics$.MODULE$.inflightDriver(hostId).record((long)inflightCount);
                        Metrics$.MODULE$.connections(hostId).record((long)openConnections);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.state$1 = state$1;
                    }
                });
            }
            {
                this.session$1 = session$1;
                this.metrics$1 = metrics$1;
            }
        }, Cassandra$.MODULE$.samplingIntervalMillis(), Cassandra$.MODULE$.samplingIntervalMillis(), TimeUnit.MILLISECONDS);
    }

    private Metrics$() {
        MODULE$ = this;
    }
}

