/*
 * Decompiled with CFR 0.152.
 */
package kamon.cassandra.client;

import com.datastax.driver.core.AbstractSession;
import com.datastax.driver.core.CloseFuture;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.ResultSetFuture;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.SimpleStatement;
import com.datastax.driver.core.Statement;
import com.google.common.base.Function;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.nio.ByteBuffer;
import java.util.Map;
import kamon.Kamon$;
import kamon.cassandra.Metrics$;
import kamon.cassandra.client.package$;
import kamon.context.Context;
import kamon.trace.Span;
import kamon.trace.Span$;
import kamon.trace.SpanCustomizer;
import kamon.trace.SpanCustomizer$;
import kamon.trace.Tracer;
import scala.Function0;
import scala.MatchError;
import scala.Serializable;
import scala.reflect.ScalaSignature;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001}4A!\u0001\u0002\u0001\u0013\ta1*Y7p]N+7o]5p]*\u00111\u0001B\u0001\u0007G2LWM\u001c;\u000b\u0005\u00151\u0011!C2bgN\fg\u000e\u001a:b\u0015\u00059\u0011!B6b[>t7\u0001A\n\u0003\u0001)\u0001\"a\u0003\u000b\u000e\u00031Q!!\u0004\b\u0002\t\r|'/\u001a\u0006\u0003\u001fA\ta\u0001\u001a:jm\u0016\u0014(BA\t\u0013\u0003!!\u0017\r^1ti\u0006D(\"A\n\u0002\u0007\r|W.\u0003\u0002\u0016\u0019\ty\u0011IY:ue\u0006\u001cGoU3tg&|g\u000e\u0003\u0005\u0018\u0001\t\u0005\t\u0015!\u0003\u0019\u0003))h\u000eZ3sYfLgn\u001a\t\u0003\u0017eI!A\u0007\u0007\u0003\u000fM+7o]5p]\")A\u0004\u0001C\u0001;\u00051A(\u001b8jiz\"\"A\b\u0011\u0011\u0005}\u0001Q\"\u0001\u0002\t\u000b]Y\u0002\u0019\u0001\r\t\u000b\t\u0002A\u0011I\u0012\u0002#\u001d,G\u000fT8hO\u0016$7*Z=ta\u0006\u001cW\rF\u0001%!\t)3F\u0004\u0002'S5\tqEC\u0001)\u0003\u0015\u00198-\u00197b\u0013\tQs%\u0001\u0004Qe\u0016$WMZ\u0005\u0003Y5\u0012aa\u0015;sS:<'B\u0001\u0016(\u0011\u0015y\u0003\u0001\"\u00111\u0003\u0011Ig.\u001b;\u0015\u0003aAQA\r\u0001\u0005BM\n\u0011\"\u001b8ji\u0006\u001b\u0018P\\2\u0015\u0003Q\u00022!\u000e \u0019\u001b\u00051$BA\u001c9\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003si\nA!\u001e;jY*\u00111\bP\u0001\u0007G>lWn\u001c8\u000b\u0005u\u0012\u0012AB4p_\u001edW-\u0003\u0002@m\t\u0001B*[:uK:\f'\r\\3GkR,(/\u001a\u0005\u0006\u0003\u0002!\tEQ\u0001\raJ,\u0007/\u0019:f\u0003NLhn\u0019\u000b\u0004\u0007\u001eK\u0005cA\u001b?\tB\u00111\"R\u0005\u0003\r2\u0011\u0011\u0003\u0015:fa\u0006\u0014X\rZ*uCR,W.\u001a8u\u0011\u0015A\u0005\t1\u0001%\u0003\u0015\tX/\u001a:z\u0011\u0015Q\u0005\t1\u0001L\u00035\u0019Wo\u001d;p[B\u000b\u0017\u0010\\8bIB!A\n\u0015\u0013S\u001b\u0005i%BA\u001dO\u0015\u0005y\u0015\u0001\u00026bm\u0006L!!U'\u0003\u00075\u000b\u0007\u000f\u0005\u0002T-6\tAK\u0003\u0002V\u001d\u0006\u0019a.[8\n\u0005]#&A\u0003\"zi\u0016\u0014UO\u001a4fe\")\u0011\f\u0001C!5\u0006aQ\r_3dkR,\u0017i]=oGR\u00111L\u0018\t\u0003\u0017qK!!\u0018\u0007\u0003\u001fI+7/\u001e7u'\u0016$h)\u001e;ve\u0016DQa\u0018-A\u0002\u0001\f\u0011b\u001d;bi\u0016lWM\u001c;\u0011\u0005-\t\u0017B\u00012\r\u0005%\u0019F/\u0019;f[\u0016tG\u000fC\u0003e\u0001\u0011\u0005S-\u0001\u0006dY>\u001cX-Q:z]\u000e$\u0012A\u001a\t\u0003\u0017\u001dL!\u0001\u001b\u0007\u0003\u0017\rcwn]3GkR,(/\u001a\u0005\u0006U\u0002!\te[\u0001\tSN\u001cEn\\:fIR\tA\u000e\u0005\u0002'[&\u0011an\n\u0002\b\u0005>|G.Z1o\u0011\u0015\u0001\b\u0001\"\u0011r\u0003)9W\r^\"mkN$XM\u001d\u000b\u0002eB\u00111b]\u0005\u0003i2\u0011qa\u00117vgR,'\u000fC\u0003w\u0001\u0011\u0005s/\u0001\u0005hKR\u001cF/\u0019;f)\u0005A\bCA=}\u001d\tY!0\u0003\u0002|\u0019\u000591+Z:tS>t\u0017BA?\u007f\u0005\u0015\u0019F/\u0019;f\u0015\tYH\u0002")
public class KamonSession
extends AbstractSession {
    public final Session kamon$cassandra$client$KamonSession$$underlying;

    public String getLoggedKeyspace() {
        return this.kamon$cassandra$client$KamonSession$$underlying.getLoggedKeyspace();
    }

    public Session init() {
        return new KamonSession(this.kamon$cassandra$client$KamonSession$$underlying.init());
    }

    public ListenableFuture<Session> initAsync() {
        return Futures.transform((ListenableFuture)this.kamon$cassandra$client$KamonSession$$underlying.initAsync(), (Function)new Function<Session, Session>(this){

            public Session apply(Session session) {
                return new KamonSession(session);
            }
        });
    }

    public ListenableFuture<PreparedStatement> prepareAsync(String query, Map<String, ByteBuffer> customPayload) {
        SimpleStatement statement = new SimpleStatement(query);
        statement.setOutgoingPayload(customPayload);
        return this.kamon$cassandra$client$KamonSession$$underlying.prepareAsync((RegularStatement)statement);
    }

    /*
     * WARNING - void declaration
     */
    public ResultSetFuture executeAsync(Statement statement) {
        long start = System.nanoTime();
        Context currentContext = Kamon$.MODULE$.currentContext();
        Span parentSpan = (Span)currentContext.get(Span$.MODULE$.ContextKey());
        Tracer.SpanBuilder clientSpanBuilder = Kamon$.MODULE$.buildSpan(package$.MODULE$.getSpanName(statement)).asChildOf(parentSpan).withMetricTag("span.kind", "client").withTag("http.url", this.kamon$cassandra$client$KamonSession$$underlying.getCluster().getClusterName()).withTag("cassandra.query", package$.MODULE$.getQuery(statement)).withTag("cassandra.keyspace", statement.getKeyspace());
        Span clientSpan = ((SpanCustomizer)currentContext.get(SpanCustomizer$.MODULE$.ContextKey())).customize(clientSpanBuilder).start();
        Statement statementWithSpan = package$.MODULE$.attachSpanToStatement(clientSpan, statement);
        Try try_ = Try$.MODULE$.apply((Function0)new Serializable(this, statementWithSpan){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KamonSession $outer;
            private final Statement statementWithSpan$1;

            public final ResultSetFuture apply() {
                return this.$outer.kamon$cassandra$client$KamonSession$$underlying.executeAsync(this.statementWithSpan$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.statementWithSpan$1 = statementWithSpan$1;
            }
        });
        if (try_ instanceof Success) {
            ResultSetFuture resultSetFuture;
            ResultSetFuture resultSetFuture2;
            Success success = (Success)try_;
            ResultSetFuture future = resultSetFuture2 = (resultSetFuture = (ResultSetFuture)success.value());
            Metrics$.MODULE$.inflight("ALL");
            Futures.addCallback((ListenableFuture)future, (FutureCallback)new FutureCallback<ResultSet>(this, start, clientSpan){
                private final long start$1;
                private final Span clientSpan$1;

                public void onSuccess(ResultSet result) {
                    Metrics$.MODULE$.recordQueryDuration(this.start$1, System.nanoTime());
                    this.clientSpan$1.finish();
                }

                public void onFailure(Throwable cause) {
                    Metrics$.MODULE$.recordQueryDuration(this.start$1, System.nanoTime());
                    this.clientSpan$1.addError(cause.getMessage(), cause);
                    this.clientSpan$1.finish();
                }
                {
                    this.start$1 = start$1;
                    this.clientSpan$1 = clientSpan$1;
                }
            });
            return future;
        }
        if (try_ instanceof Failure) {
            void var7_6;
            Failure failure = (Failure)try_;
            Throwable cause = failure.exception();
            var7_6.addError(cause.getMessage(), cause);
            var7_6.finish();
            throw cause;
        }
        throw new MatchError((Object)try_);
    }

    public CloseFuture closeAsync() {
        return this.kamon$cassandra$client$KamonSession$$underlying.closeAsync();
    }

    public boolean isClosed() {
        return this.kamon$cassandra$client$KamonSession$$underlying.isClosed();
    }

    public Cluster getCluster() {
        return this.kamon$cassandra$client$KamonSession$$underlying.getCluster();
    }

    public Session.State getState() {
        return this.kamon$cassandra$client$KamonSession$$underlying.getState();
    }

    public KamonSession(Session underlying) {
        this.kamon$cassandra$client$KamonSession$$underlying = underlying;
        Metrics$.MODULE$.from(underlying);
    }
}

