/*
 * Decompiled with CFR 0.152.
 */
package kamon.datadog;

import com.typesafe.config.Config;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.time.Duration;
import java.util.Locale;
import kamon.Kamon$;
import kamon.datadog.DatadogAPIReporter$;
import kamon.datadog.DatadogAPIReporter$QuoteInterp$;
import kamon.datadog.package;
import kamon.metric.Distribution;
import kamon.metric.Instrument;
import kamon.metric.MeasurementUnit;
import kamon.metric.MeasurementUnit$;
import kamon.metric.Metric;
import kamon.metric.MetricSnapshot;
import kamon.metric.PeriodSnapshot;
import kamon.module.MetricReporter;
import kamon.tag.Tag;
import kamon.tag.TagSet;
import kamon.util.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001\r\u0015c\u0001B\u0001\u0003\u0001\u001d\u0011!\u0003R1uC\u0012|w-\u0011)J%\u0016\u0004xN\u001d;fe*\u00111\u0001B\u0001\bI\u0006$\u0018\rZ8h\u0015\u0005)\u0011!B6b[>t7\u0001A\n\u0004\u0001!q\u0001CA\u0005\r\u001b\u0005Q!\"A\u0006\u0002\u000bM\u001c\u0017\r\\1\n\u00055Q!AB!osJ+g\r\u0005\u0002\u0010%5\t\u0001C\u0003\u0002\u0012\t\u00051Qn\u001c3vY\u0016L!a\u0005\t\u0003\u001d5+GO]5d%\u0016\u0004xN\u001d;fe\"AQ\u0003\u0001BA\u0002\u0013%a#A\u0007d_:4\u0017nZ;sCRLwN\\\u000b\u0002/A\u0011\u0001D\u000f\b\u00033\u0001r!AG\u0010\u000f\u0005mqR\"\u0001\u000f\u000b\u0005u1\u0011A\u0002\u001fs_>$h(C\u0001\u0006\u0013\t\u0019AaB\u0003\"\u0005!%!%\u0001\nECR\fGm\\4B!&\u0013V\r]8si\u0016\u0014\bCA\u0012%\u001b\u0005\u0011a!B\u0001\u0003\u0011\u0013)3C\u0001\u0013\t\u0011\u00159C\u0005\"\u0001)\u0003\u0019a\u0014N\\5u}Q\t!\u0005C\u0004+I\t\u0007I\u0011A\u0016\u0002\u000b\r|WO\u001c;\u0016\u00031\u0002\"!\f\u001a\u000e\u00039R!a\f\u0019\u0002\t1\fgn\u001a\u0006\u0002c\u0005!!.\u0019<b\u0013\t\u0019dF\u0001\u0004TiJLgn\u001a\u0005\u0007k\u0011\u0002\u000b\u0011\u0002\u0017\u0002\r\r|WO\u001c;!\u0011\u001d9DE1A\u0005\u0002-\nQaZ1vO\u0016Da!\u000f\u0013!\u0002\u0013a\u0013AB4bk\u001e,\u0007E\u0002\u0003<I\u0001c$!D\"p]\u001aLw-\u001e:bi&|gn\u0005\u0003;\u0011u\u0002\u0005CA\u0005?\u0013\ty$BA\u0004Qe>$Wo\u0019;\u0011\u0005%\t\u0015B\u0001\"\u000b\u00051\u0019VM]5bY&T\u0018M\u00197f\u0011!!%H!f\u0001\n\u0003)\u0015A\u00035uiB\u001cuN\u001c4jOV\ta\t\u0005\u0002H\u001d6\t\u0001J\u0003\u0002J\u0015\u000611m\u001c8gS\u001eT!a\u0013'\u0002\u0011QL\b/Z:bM\u0016T\u0011!T\u0001\u0004G>l\u0017BA(I\u0005\u0019\u0019uN\u001c4jO\"A\u0011K\u000fB\tB\u0003%a)A\u0006iiR\u00048i\u001c8gS\u001e\u0004\u0003\u0002C*;\u0005+\u0007I\u0011\u0001+\u0002\u0011QLW.Z+oSR,\u0012!\u0016\t\u0003-fk\u0011a\u0016\u0006\u00031\u0012\ta!\\3ue&\u001c\u0017B\u0001.X\u0005=iU-Y:ve\u0016lWM\u001c;V]&$\b\u0002\u0003/;\u0005#\u0005\u000b\u0011B+\u0002\u0013QLW.Z+oSR\u0004\u0003\u0002\u00030;\u0005+\u0007I\u0011\u0001+\u0002\u001f%tgm\u001c:nCRLwN\\+oSRD\u0001\u0002\u0019\u001e\u0003\u0012\u0003\u0006I!V\u0001\u0011S:4wN]7bi&|g.\u00168ji\u0002B\u0001B\u0019\u001e\u0003\u0016\u0004%\taY\u0001\nKb$(/\u0019+bON,\u0012\u0001\u001a\t\u0004K*lgB\u00014i\u001d\tYr-C\u0001\f\u0013\tI'\"A\u0004qC\u000e\\\u0017mZ3\n\u0005-d'aA*fc*\u0011\u0011N\u0003\t\u0005\u00139\u0004\b/\u0003\u0002p\u0015\t1A+\u001e9mKJ\u0002\"!\u001d;\u000f\u0005%\u0011\u0018BA:\u000b\u0003\u0019\u0001&/\u001a3fM&\u00111'\u001e\u0006\u0003g*A\u0001b\u001e\u001e\u0003\u0012\u0003\u0006I\u0001Z\u0001\u000bKb$(/\u0019+bON\u0004\u0003\u0002C=;\u0005+\u0007I\u0011\u0001>\u0002\u0013Q\fwMR5mi\u0016\u0014X#A>\u0011\u0005q|X\"A?\u000b\u0005y$\u0011\u0001B;uS2L1!!\u0001~\u0005\u00191\u0015\u000e\u001c;fe\"I\u0011Q\u0001\u001e\u0003\u0012\u0003\u0006Ia_\u0001\u000bi\u0006<g)\u001b7uKJ\u0004\u0003BB\u0014;\t\u0003\tI\u0001\u0006\u0007\u0002\f\u0005=\u0011\u0011CA\n\u0003+\t9\u0002E\u0002\u0002\u000eij\u0011\u0001\n\u0005\u0007\t\u0006\u001d\u0001\u0019\u0001$\t\rM\u000b9\u00011\u0001V\u0011\u0019q\u0016q\u0001a\u0001+\"1!-a\u0002A\u0002\u0011Da!_A\u0004\u0001\u0004Y\b\"CA\u000eu\u0005\u0005I\u0011AA\u000f\u0003\u0011\u0019w\u000e]=\u0015\u0019\u0005-\u0011qDA\u0011\u0003G\t)#a\n\t\u0011\u0011\u000bI\u0002%AA\u0002\u0019C\u0001bUA\r!\u0003\u0005\r!\u0016\u0005\t=\u0006e\u0001\u0013!a\u0001+\"A!-!\u0007\u0011\u0002\u0003\u0007A\r\u0003\u0005z\u00033\u0001\n\u00111\u0001|\u0011%\tYCOI\u0001\n\u0003\ti#\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005=\"f\u0001$\u00022-\u0012\u00111\u0007\t\u0005\u0003k\ty$\u0004\u0002\u00028)!\u0011\u0011HA\u001e\u0003%)hn\u00195fG.,GMC\u0002\u0002>)\t!\"\u00198o_R\fG/[8o\u0013\u0011\t\t%a\u000e\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\rC\u0005\u0002Fi\n\n\u0011\"\u0001\u0002H\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012TCAA%U\r)\u0016\u0011\u0007\u0005\n\u0003\u001bR\u0014\u0013!C\u0001\u0003\u000f\nabY8qs\u0012\"WMZ1vYR$3\u0007C\u0005\u0002Ri\n\n\u0011\"\u0001\u0002T\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\"TCAA+U\r!\u0017\u0011\u0007\u0005\n\u00033R\u0014\u0013!C\u0001\u00037\nabY8qs\u0012\"WMZ1vYR$S'\u0006\u0002\u0002^)\u001a10!\r\t\u0011\u0005\u0005$(!A\u0005B-\nQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&D\b\"CA3u\u0005\u0005I\u0011AA4\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\tI\u0007E\u0002\n\u0003WJ1!!\u001c\u000b\u0005\rIe\u000e\u001e\u0005\n\u0003cR\u0014\u0011!C\u0001\u0003g\na\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002v\u0005m\u0004cA\u0005\u0002x%\u0019\u0011\u0011\u0010\u0006\u0003\u0007\u0005s\u0017\u0010\u0003\u0006\u0002~\u0005=\u0014\u0011!a\u0001\u0003S\n1\u0001\u001f\u00132\u0011%\t\tIOA\u0001\n\u0003\n\u0019)A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\t)\t\u0005\u0004\u0002\b\u00065\u0015QO\u0007\u0003\u0003\u0013S1!a#\u000b\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003\u001f\u000bII\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0011%\t\u0019JOA\u0001\n\u0003\t)*\u0001\u0005dC:,\u0015/^1m)\u0011\t9*!(\u0011\u0007%\tI*C\u0002\u0002\u001c*\u0011qAQ8pY\u0016\fg\u000e\u0003\u0006\u0002~\u0005E\u0015\u0011!a\u0001\u0003kB\u0011\"!);\u0003\u0003%\t%a)\u0002\u0011!\f7\u000f[\"pI\u0016$\"!!\u001b\t\u0013\u0005\u001d&(!A\u0005B\u0005%\u0016\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u00031B\u0011\"!,;\u0003\u0003%\t%a,\u0002\r\u0015\fX/\u00197t)\u0011\t9*!-\t\u0015\u0005u\u00141VA\u0001\u0002\u0004\t)hB\u0005\u00026\u0012\n\t\u0011#\u0001\u00028\u0006i1i\u001c8gS\u001e,(/\u0019;j_:\u0004B!!\u0004\u0002:\u001aA1\bJA\u0001\u0012\u0003\tYlE\u0003\u0002:\u0006u\u0006\tE\u0006\u0002@\u0006\u0015g)V+ew\u0006-QBAAa\u0015\r\t\u0019MC\u0001\beVtG/[7f\u0013\u0011\t9-!1\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>tW\u0007C\u0004(\u0003s#\t!a3\u0015\u0005\u0005]\u0006BCAT\u0003s\u000b\t\u0011\"\u0012\u0002*\"Q\u0011\u0011[A]\u0003\u0003%\t)a5\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0019\u0005-\u0011Q[Al\u00033\fY.!8\t\r\u0011\u000by\r1\u0001G\u0011\u0019\u0019\u0016q\u001aa\u0001+\"1a,a4A\u0002UCaAYAh\u0001\u0004!\u0007BB=\u0002P\u0002\u00071\u0010\u0003\u0006\u0002b\u0006e\u0016\u0011!CA\u0003G\fq!\u001e8baBd\u0017\u0010\u0006\u0003\u0002f\u0006E\b#B\u0005\u0002h\u0006-\u0018bAAu\u0015\t1q\n\u001d;j_:\u0004\u0002\"CAw\rV+Fm_\u0005\u0004\u0003_T!A\u0002+va2,W\u0007\u0003\u0006\u0002t\u0006}\u0017\u0011!a\u0001\u0003\u0017\t1\u0001\u001f\u00131\u0011)\t90!/\u0002\u0002\u0013%\u0011\u0011`\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0002|B\u0019Q&!@\n\u0007\u0005}hF\u0001\u0004PE*,7\r\u001e\u0004\u0007\u0005\u0007!3A!\u0002\u0003\u0017E+x\u000e^3J]R,'\u000f]\n\u0005\u0005\u0003\u00119\u0001E\u0002\n\u0005\u0013I1Aa\u0003\u000b\u0005\u0019\te.\u001f,bY\"Y!q\u0002B\u0001\u0005\u000b\u0007I\u0011\u0001B\t\u0003\t\u00198-\u0006\u0002\u0003\u0014A\u0019\u0011B!\u0006\n\u0007\t]!BA\u0007TiJLgnZ\"p]R,\u0007\u0010\u001e\u0005\f\u00057\u0011\tA!A!\u0002\u0013\u0011\u0019\"A\u0002tG\u0002Bqa\nB\u0001\t\u0003\u0011y\u0002\u0006\u0003\u0003\"\t\r\u0002\u0003BA\u0007\u0005\u0003A\u0001Ba\u0004\u0003\u001e\u0001\u0007!1\u0003\u0005\t\u0005O\u0011\t\u0001\"\u0001\u0003*\u0005)\u0011/^8uKR\u0019\u0001Oa\u000b\t\u0011\t5\"Q\u0005a\u0001\u0005_\tA!\u0019:hgB)\u0011B!\r\u0002v%\u0019!1\u0007\u0006\u0003\u0015q\u0012X\r]3bi\u0016$g\b\u0003\u0006\u0002\"\n\u0005\u0011\u0011!C!\u0003GC!\"!,\u0003\u0002\u0005\u0005I\u0011\tB\u001d)\u0011\t9Ja\u000f\t\u0015\u0005u$qGA\u0001\u0002\u0004\t)\bC\u0005\u0003@\u0011\n\t\u0011b\u0001\u0003B\u0005Y\u0011+^8uK&sG/\u001a:q)\u0011\u0011\tCa\u0011\t\u0011\t=!Q\ba\u0001\u0005'AqAa\u0012%\t\u0003\u0011I%A\tsK\u0006$7i\u001c8gS\u001e,(/\u0019;j_:$B!a\u0003\u0003L!1\u0011J!\u0012A\u0002\u0019;\u0011Ba\u0010%\u0003\u0003E\tAa\u0014\u0011\t\u00055!\u0011\u000b\u0004\n\u0005\u0007!\u0013\u0011!E\u0001\u0005'\u001a2A!\u0015\t\u0011\u001d9#\u0011\u000bC\u0001\u0005/\"\"Aa\u0014\t\u0011\tm#\u0011\u000bC\u0003\u0005;\nq\"];pi\u0016$S\r\u001f;f]NLwN\u001c\u000b\u0005\u0005?\u0012\u0019\u0007F\u0002q\u0005CB\u0001B!\f\u0003Z\u0001\u0007!q\u0006\u0005\t\u0005K\u0012I\u00061\u0001\u0003\"\u0005)A\u0005\u001e5jg\"Q!\u0011\u000eB)\u0003\u0003%)Aa\u001b\u0002%!\f7\u000f[\"pI\u0016$S\r\u001f;f]NLwN\u001c\u000b\u0005\u0003G\u0013i\u0007\u0003\u0005\u0003f\t\u001d\u0004\u0019\u0001B\u0011\u0011)\u0011\tH!\u0015\u0002\u0002\u0013\u0015!1O\u0001\u0011KF,\u0018\r\\:%Kb$XM\\:j_:$BA!\u001e\u0003zQ!\u0011q\u0013B<\u0011)\tiHa\u001c\u0002\u0002\u0003\u0007\u0011Q\u000f\u0005\t\u0005K\u0012y\u00071\u0001\u0003\"!Q!Q\u0010\u0001\u0003\u0002\u0004%IAa \u0002#\r|gNZ5hkJ\fG/[8o?\u0012*\u0017\u000f\u0006\u0003\u0003\u0002\n\u001d\u0005cA\u0005\u0003\u0004&\u0019!Q\u0011\u0006\u0003\tUs\u0017\u000e\u001e\u0005\n\u0003{\u0012Y(!AA\u0002]A\u0011Ba#\u0001\u0005\u0003\u0005\u000b\u0015B\f\u0002\u001d\r|gNZ5hkJ\fG/[8oA!\"!\u0011\u0012BH!\rI!\u0011S\u0005\u0004\u0005'S!\u0001\u0003<pY\u0006$\u0018\u000e\\3\t\u0015\t]\u0005A!a\u0001\n\u0013\u0011I*\u0001\u0006iiR\u00048\t\\5f]R,\"Aa'\u0011\t\tu%\u0011\u0015\b\u0004G\t}\u0015BA5\u0003\u0013\u0011\u0011\u0019K!*\u0003\u0015!#H\u000f]\"mS\u0016tGO\u0003\u0002j\u0005!Q!\u0011\u0016\u0001\u0003\u0002\u0004%IAa+\u0002\u001d!$H\u000f]\"mS\u0016tGo\u0018\u0013fcR!!\u0011\u0011BW\u0011)\tiHa*\u0002\u0002\u0003\u0007!1\u0014\u0005\u000b\u0005c\u0003!\u0011!Q!\n\tm\u0015a\u00035uiB\u001cE.[3oi\u0002BCAa,\u0003\u0010\"1q\u0005\u0001C\u0001\u0005o#bA!/\u0003<\nu\u0006CA\u0012\u0001\u0011\u0019)\"Q\u0017a\u0001/!A!q\u0013B[\u0001\u0004\u0011Y\nC\u0005\u0003B\u0002\u0011\r\u0011\"\u0003\u0003D\u00061An\\4hKJ,\"A!2\u0011\t\t\u001d'\u0011[\u0007\u0003\u0005\u0013TAAa3\u0003N\u0006)1\u000f\u001c45U*\u0011!qZ\u0001\u0004_J<\u0017\u0002\u0002Bj\u0005\u0013\u0014a\u0001T8hO\u0016\u0014\b\u0002\u0003Bl\u0001\u0001\u0006IA!2\u0002\u000f1|wmZ3sA!I!1\u001c\u0001C\u0002\u0013%!Q\\\u0001\bgfl'm\u001c7t+\t\u0011y\u000e\u0005\u0003\u0003b\n\u001dXB\u0001Br\u0015\r\u0011)\u000fM\u0001\u0005i\u0016DH/\u0003\u0003\u0003j\n\r(\u0001\u0006#fG&l\u0017\r\u001c$pe6\fGoU=nE>d7\u000f\u0003\u0005\u0003n\u0002\u0001\u000b\u0011\u0002Bp\u0003!\u0019\u00180\u001c2pYN\u0004\u0003\"\u0003By\u0001\t\u0007I\u0011\u0002Bz\u0003-1\u0018\r\\;f\r>\u0014X.\u0019;\u0016\u0005\tU\b\u0003\u0002Bq\u0005oLAA!?\u0003d\niA)Z2j[\u0006dgi\u001c:nCRD\u0001B!@\u0001A\u0003%!Q_\u0001\rm\u0006dW/\u001a$pe6\fG\u000f\t\u0005\b\u0007\u0003\u0001A\u0011IB\u0002\u0003\u0011\u0019Ho\u001c9\u0015\u0005\t\u0005\u0005bBB\u0004\u0001\u0011\u00053\u0011B\u0001\fe\u0016\u001cwN\u001c4jOV\u0014X\r\u0006\u0003\u0003\u0002\u000e-\u0001BB%\u0004\u0006\u0001\u0007a\tC\u0004\u0004\u0010\u0001!\te!\u0005\u0002)I,\u0007o\u001c:u!\u0016\u0014\u0018n\u001c3T]\u0006\u00048\u000f[8u)\u0011\u0011\tia\u0005\t\u0011\rU1Q\u0002a\u0001\u0007/\t\u0001b\u001d8baNDw\u000e\u001e\t\u0004-\u000ee\u0011bAB\u000e/\nq\u0001+\u001a:j_\u0012\u001cf.\u00199tQ>$\b\u0002CB\u0010\u0001\u0011\u0005!a!\t\u0002!\t,\u0018\u000e\u001c3SKF,Xm\u001d;C_\u0012LH\u0003BB\u0012\u0007_\u0001R!CB\u0013\u0007SI1aa\n\u000b\u0005\u0015\t%O]1z!\rI11F\u0005\u0004\u0007[Q!\u0001\u0002\"zi\u0016D\u0001b!\u0006\u0004\u001e\u0001\u00071q\u0003\u0005\b\u0007g\u0001A\u0011BB\u001b\u0003\u0015\u00198-\u00197f)\u0019\u00199d!\u0010\u0004BA\u0019\u0011b!\u000f\n\u0007\rm\"B\u0001\u0004E_V\u0014G.\u001a\u0005\t\u0007\u007f\u0019\t\u00041\u0001\u00048\u0005)a/\u00197vK\"911IB\u0019\u0001\u0004)\u0016\u0001B;oSR\u0004")
public class DatadogAPIReporter
implements MetricReporter {
    private volatile Configuration kamon$datadog$DatadogAPIReporter$$configuration;
    private volatile package.HttpClient httpClient;
    private final Logger logger;
    private final DecimalFormatSymbols symbols;
    private final DecimalFormat kamon$datadog$DatadogAPIReporter$$valueFormat;

    public static Configuration readConfiguration(Config config) {
        return DatadogAPIReporter$.MODULE$.readConfiguration(config);
    }

    public static StringContext QuoteInterp(StringContext stringContext) {
        return DatadogAPIReporter$.MODULE$.QuoteInterp(stringContext);
    }

    public static String gauge() {
        return DatadogAPIReporter$.MODULE$.gauge();
    }

    public static String count() {
        return DatadogAPIReporter$.MODULE$.count();
    }

    public Configuration kamon$datadog$DatadogAPIReporter$$configuration() {
        return this.kamon$datadog$DatadogAPIReporter$$configuration;
    }

    private void kamon$datadog$DatadogAPIReporter$$configuration_$eq(Configuration x$1) {
        this.kamon$datadog$DatadogAPIReporter$$configuration = x$1;
    }

    private package.HttpClient httpClient() {
        return this.httpClient;
    }

    private void httpClient_$eq(package.HttpClient x$1) {
        this.httpClient = x$1;
    }

    private Logger logger() {
        return this.logger;
    }

    private DecimalFormatSymbols symbols() {
        return this.symbols;
    }

    public DecimalFormat kamon$datadog$DatadogAPIReporter$$valueFormat() {
        return this.kamon$datadog$DatadogAPIReporter$$valueFormat;
    }

    public void stop() {
        this.logger().info("Stopped the Datadog API reporter.");
    }

    public void reconfigure(Config config) {
        Configuration newConfiguration = DatadogAPIReporter$.MODULE$.readConfiguration(config);
        this.kamon$datadog$DatadogAPIReporter$$configuration_$eq(newConfiguration);
        this.httpClient_$eq(new package.HttpClient(this.kamon$datadog$DatadogAPIReporter$$configuration().httpConfig(), false));
    }

    public void reportPeriodSnapshot(PeriodSnapshot snapshot) {
        Try<String> try_;
        block4: {
            block3: {
                block2: {
                    try_ = this.httpClient().doPost("application/json; charset=utf-8", this.buildRequestBody(snapshot));
                    if (!(try_ instanceof Failure)) break block2;
                    Failure failure = (Failure)try_;
                    Throwable e = failure.exception();
                    this.logger().error(e.getMessage());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block3;
                }
                if (!(try_ instanceof Success)) break block4;
                Success success = (Success)try_;
                String response = (String)success.value();
                this.logger().trace(response);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw new MatchError(try_);
    }

    public byte[] buildRequestBody(PeriodSnapshot snapshot) {
        String timestamp = ((Object)BoxesRunTime.boxToLong((long)snapshot.from().getEpochSecond())).toString();
        String host = Kamon$.MODULE$.environment().host();
        long interval = Math.round((double)Duration.between(snapshot.from(), snapshot.to()).toMillis() / 1000.0);
        java.lang.StringBuilder seriesBuilder = new java.lang.StringBuilder();
        snapshot.counters().foreach((Function1)new Serializable(this, timestamp, host, interval, seriesBuilder){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DatadogAPIReporter $outer;
            public final String timestamp$1;
            public final String host$1;
            public final long interval$1;
            public final java.lang.StringBuilder seriesBuilder$1;

            public final void apply(MetricSnapshot<Metric.Settings.ForValueInstrument, Object> snap) {
                snap.instruments().foreach((Function1)new Serializable(this, snap){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$buildRequestBody$1 $outer;
                    private final MetricSnapshot snap$1;

                    public final void apply(Instrument.Snapshot<Object> instrument) {
                        this.$outer.kamon$datadog$DatadogAPIReporter$$anonfun$$$outer().kamon$datadog$DatadogAPIReporter$$addMetric$1(this.snap$1.name(), this.$outer.kamon$datadog$DatadogAPIReporter$$anonfun$$$outer().kamon$datadog$DatadogAPIReporter$$valueFormat().format(this.$outer.kamon$datadog$DatadogAPIReporter$$anonfun$$$outer().kamon$datadog$DatadogAPIReporter$$scale(BoxesRunTime.unboxToLong((Object)instrument.value()), ((Metric.Settings.ForValueInstrument)this.snap$1.settings()).unit())), DatadogAPIReporter$.MODULE$.count(), instrument.tags(), this.$outer.timestamp$1, this.$outer.host$1, this.$outer.interval$1, this.$outer.seriesBuilder$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.snap$1 = snap$1;
                    }
                });
            }

            public /* synthetic */ DatadogAPIReporter kamon$datadog$DatadogAPIReporter$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.timestamp$1 = timestamp$1;
                this.host$1 = host$1;
                this.interval$1 = interval$1;
                this.seriesBuilder$1 = seriesBuilder$1;
            }
        });
        snapshot.gauges().foreach((Function1)new Serializable(this, timestamp, host, interval, seriesBuilder){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DatadogAPIReporter $outer;
            public final String timestamp$1;
            public final String host$1;
            public final long interval$1;
            public final java.lang.StringBuilder seriesBuilder$1;

            public final void apply(MetricSnapshot<Metric.Settings.ForValueInstrument, Object> snap) {
                snap.instruments().foreach((Function1)new Serializable(this, snap){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$buildRequestBody$2 $outer;
                    private final MetricSnapshot snap$2;

                    public final void apply(Instrument.Snapshot<Object> instrument) {
                        this.$outer.kamon$datadog$DatadogAPIReporter$$anonfun$$$outer().kamon$datadog$DatadogAPIReporter$$addMetric$1(this.snap$2.name(), this.$outer.kamon$datadog$DatadogAPIReporter$$anonfun$$$outer().kamon$datadog$DatadogAPIReporter$$valueFormat().format(this.$outer.kamon$datadog$DatadogAPIReporter$$anonfun$$$outer().kamon$datadog$DatadogAPIReporter$$scale(BoxesRunTime.unboxToDouble((Object)instrument.value()), ((Metric.Settings.ForValueInstrument)this.snap$2.settings()).unit())), DatadogAPIReporter$.MODULE$.gauge(), instrument.tags(), this.$outer.timestamp$1, this.$outer.host$1, this.$outer.interval$1, this.$outer.seriesBuilder$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.snap$2 = snap$2;
                    }
                });
            }

            public /* synthetic */ DatadogAPIReporter kamon$datadog$DatadogAPIReporter$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.timestamp$1 = timestamp$1;
                this.host$1 = host$1;
                this.interval$1 = interval$1;
                this.seriesBuilder$1 = seriesBuilder$1;
            }
        });
        ((IterableLike)((TraversableLike)snapshot.histograms().$plus$plus((GenTraversableOnce)snapshot.rangeSamplers(), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)snapshot.timers(), Seq$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(this, timestamp, host, interval, seriesBuilder){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DatadogAPIReporter $outer;
            private final String timestamp$1;
            private final String host$1;
            private final long interval$1;
            private final java.lang.StringBuilder seriesBuilder$1;

            public final void apply(MetricSnapshot<Metric.Settings$.ForDistributionInstrument, Distribution> metric) {
                this.$outer.kamon$datadog$DatadogAPIReporter$$addDistribution$1(metric, this.timestamp$1, this.host$1, this.interval$1, this.seriesBuilder$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.timestamp$1 = timestamp$1;
                this.host$1 = host$1;
                this.interval$1 = interval$1;
                this.seriesBuilder$1 = seriesBuilder$1;
            }
        });
        return seriesBuilder.insert(0, "{\"series\":[").append("]}").toString().getBytes(StandardCharsets.UTF_8);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public double kamon$datadog$DatadogAPIReporter$$scale(double value, MeasurementUnit unit) {
        MeasurementUnit.Dimension dimension = unit.dimension();
        MeasurementUnit.Dimension dimension2 = MeasurementUnit.Dimension$.MODULE$.Time();
        MeasurementUnit.Dimension dimension3 = dimension;
        if (!(dimension2 != null ? !dimension2.equals(dimension3) : dimension3 != null)) {
            MeasurementUnit.Magnitude magnitude = unit.magnitude();
            MeasurementUnit.Magnitude magnitude2 = this.kamon$datadog$DatadogAPIReporter$$configuration().timeUnit().magnitude();
            if (magnitude == null ? magnitude2 != null : !magnitude.equals(magnitude2)) {
                return MeasurementUnit$.MODULE$.convert(value, unit, this.kamon$datadog$DatadogAPIReporter$$configuration().timeUnit());
            }
        }
        MeasurementUnit.Dimension dimension4 = MeasurementUnit.Dimension$.MODULE$.Information();
        MeasurementUnit.Dimension dimension5 = dimension;
        if (dimension4 == null) {
            if (dimension5 != null) {
                return value;
            }
        } else if (!dimension4.equals(dimension5)) return value;
        MeasurementUnit.Magnitude magnitude = unit.magnitude();
        MeasurementUnit.Magnitude magnitude3 = this.kamon$datadog$DatadogAPIReporter$$configuration().informationUnit().magnitude();
        if (magnitude == null) {
            if (magnitude3 == null) return value;
            return MeasurementUnit$.MODULE$.convert(value, unit, this.kamon$datadog$DatadogAPIReporter$$configuration().informationUnit());
        } else if (magnitude.equals(magnitude3)) return value;
        return MeasurementUnit$.MODULE$.convert(value, unit, this.kamon$datadog$DatadogAPIReporter$$configuration().informationUnit());
    }

    public final void kamon$datadog$DatadogAPIReporter$$addDistribution$1(MetricSnapshot metric, String timestamp$1, String host$1, long interval$1, java.lang.StringBuilder seriesBuilder$1) {
        MeasurementUnit unit = ((Metric.Settings$.ForDistributionInstrument)metric.settings()).unit();
        metric.instruments().foreach((Function1)new Serializable(this, timestamp$1, host$1, interval$1, seriesBuilder$1, metric, unit){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DatadogAPIReporter $outer;
            private final String timestamp$1;
            private final String host$1;
            private final long interval$1;
            private final java.lang.StringBuilder seriesBuilder$1;
            private final MetricSnapshot metric$1;
            private final MeasurementUnit unit$1;

            public final void apply(Instrument.Snapshot<Distribution> d) {
                Distribution dist = (Distribution)d.value();
                long average = dist.count() > 0L ? dist.sum() / dist.count() : 0L;
                this.$outer.kamon$datadog$DatadogAPIReporter$$addMetric$1(new StringBuilder().append((Object)this.metric$1.name()).append((Object)".avg").toString(), this.$outer.kamon$datadog$DatadogAPIReporter$$valueFormat().format(this.$outer.kamon$datadog$DatadogAPIReporter$$scale(average, this.unit$1)), DatadogAPIReporter$.MODULE$.gauge(), d.tags(), this.timestamp$1, this.host$1, this.interval$1, this.seriesBuilder$1);
                this.$outer.kamon$datadog$DatadogAPIReporter$$addMetric$1(new StringBuilder().append((Object)this.metric$1.name()).append((Object)".count").toString(), this.$outer.kamon$datadog$DatadogAPIReporter$$valueFormat().format(dist.count()), DatadogAPIReporter$.MODULE$.count(), d.tags(), this.timestamp$1, this.host$1, this.interval$1, this.seriesBuilder$1);
                this.$outer.kamon$datadog$DatadogAPIReporter$$addMetric$1(new StringBuilder().append((Object)this.metric$1.name()).append((Object)".median").toString(), this.$outer.kamon$datadog$DatadogAPIReporter$$valueFormat().format(this.$outer.kamon$datadog$DatadogAPIReporter$$scale(dist.percentile(50.0).value(), this.unit$1)), DatadogAPIReporter$.MODULE$.gauge(), d.tags(), this.timestamp$1, this.host$1, this.interval$1, this.seriesBuilder$1);
                this.$outer.kamon$datadog$DatadogAPIReporter$$addMetric$1(new StringBuilder().append((Object)this.metric$1.name()).append((Object)".95percentile").toString(), this.$outer.kamon$datadog$DatadogAPIReporter$$valueFormat().format(this.$outer.kamon$datadog$DatadogAPIReporter$$scale(dist.percentile(95.0).value(), this.unit$1)), DatadogAPIReporter$.MODULE$.gauge(), d.tags(), this.timestamp$1, this.host$1, this.interval$1, this.seriesBuilder$1);
                this.$outer.kamon$datadog$DatadogAPIReporter$$addMetric$1(new StringBuilder().append((Object)this.metric$1.name()).append((Object)".max").toString(), this.$outer.kamon$datadog$DatadogAPIReporter$$valueFormat().format(this.$outer.kamon$datadog$DatadogAPIReporter$$scale(dist.max(), this.unit$1)), DatadogAPIReporter$.MODULE$.gauge(), d.tags(), this.timestamp$1, this.host$1, this.interval$1, this.seriesBuilder$1);
                this.$outer.kamon$datadog$DatadogAPIReporter$$addMetric$1(new StringBuilder().append((Object)this.metric$1.name()).append((Object)".min").toString(), this.$outer.kamon$datadog$DatadogAPIReporter$$valueFormat().format(this.$outer.kamon$datadog$DatadogAPIReporter$$scale(dist.min(), this.unit$1)), DatadogAPIReporter$.MODULE$.gauge(), d.tags(), this.timestamp$1, this.host$1, this.interval$1, this.seriesBuilder$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.timestamp$1 = timestamp$1;
                this.host$1 = host$1;
                this.interval$1 = interval$1;
                this.seriesBuilder$1 = seriesBuilder$1;
                this.metric$1 = metric$1;
                this.unit$1 = unit$1;
            }
        });
    }

    public final void kamon$datadog$DatadogAPIReporter$$addMetric$1(String metricName, String value, String metricType, TagSet tags, String timestamp$1, String host$1, long interval$1, java.lang.StringBuilder seriesBuilder$1) {
        Seq customTags = (Seq)((TraversableLike)this.kamon$datadog$DatadogAPIReporter$$configuration().extraTags().$plus$plus((GenTraversableOnce)tags.iterator((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Object x$1) {
                return x$1.toString();
            }
        }).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, String> apply(Tag.Pair<String> p) {
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)p.key()), p.value());
            }
        }).filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DatadogAPIReporter $outer;

            public final boolean apply(Tuple2<String, String> t) {
                return this.$outer.kamon$datadog$DatadogAPIReporter$$configuration().tagFilter().accept((String)t._1());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }), Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple2<String, String> x0$1) {
                Tuple2<String, String> tuple2 = x0$1;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    String v = (String)tuple2._2();
                    String string = DatadogAPIReporter$QuoteInterp$.MODULE$.quote$extension(DatadogAPIReporter$.MODULE$.QuoteInterp(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":", ""}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{k, v}));
                    return string;
                }
                throw new MatchError(tuple2);
            }
        }, Seq$.MODULE$.canBuildFrom());
        String allTagsString = customTags.mkString("[", ",", "]");
        Object object = seriesBuilder$1.length() > 0 ? seriesBuilder$1.append(",") : BoxedUnit.UNIT;
        seriesBuilder$1.append(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"{\"metric\":\"", "\",\"interval\":", ",\"points\":[[", ",", "]],\"type\":\"", "\",\"host\":\"", "\",\"tags\":", "}"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{metricName, BoxesRunTime.boxToLong((long)interval$1), timestamp$1, value, metricType, host$1, allTagsString})));
    }

    public DatadogAPIReporter(Configuration configuration, package.HttpClient httpClient) {
        this.kamon$datadog$DatadogAPIReporter$$configuration = configuration;
        this.httpClient = httpClient;
        this.logger = LoggerFactory.getLogger(DatadogAPIReporter.class);
        this.symbols = DecimalFormatSymbols.getInstance(Locale.US);
        this.symbols().setDecimalSeparator('.');
        this.kamon$datadog$DatadogAPIReporter$$valueFormat = new DecimalFormat("#0.#########", this.symbols());
        this.logger().info("Started the Datadog API reporter.");
    }

    public static final class QuoteInterp {
        private final StringContext sc;

        public StringContext sc() {
            return this.sc;
        }

        public String quote(Seq<Object> args) {
            return DatadogAPIReporter$QuoteInterp$.MODULE$.quote$extension(this.sc(), args);
        }

        public int hashCode() {
            return DatadogAPIReporter$QuoteInterp$.MODULE$.hashCode$extension(this.sc());
        }

        public boolean equals(Object x$1) {
            return DatadogAPIReporter$QuoteInterp$.MODULE$.equals$extension(this.sc(), x$1);
        }

        public QuoteInterp(StringContext sc) {
            this.sc = sc;
        }
    }

    public static class Configuration
    implements Product,
    Serializable {
        private final Config httpConfig;
        private final MeasurementUnit timeUnit;
        private final MeasurementUnit informationUnit;
        private final Seq<Tuple2<String, String>> extraTags;
        private final Filter tagFilter;

        public Config httpConfig() {
            return this.httpConfig;
        }

        public MeasurementUnit timeUnit() {
            return this.timeUnit;
        }

        public MeasurementUnit informationUnit() {
            return this.informationUnit;
        }

        public Seq<Tuple2<String, String>> extraTags() {
            return this.extraTags;
        }

        public Filter tagFilter() {
            return this.tagFilter;
        }

        public Configuration copy(Config httpConfig, MeasurementUnit timeUnit, MeasurementUnit informationUnit, Seq<Tuple2<String, String>> extraTags, Filter tagFilter) {
            return new Configuration(httpConfig, timeUnit, informationUnit, extraTags, tagFilter);
        }

        public Config copy$default$1() {
            return this.httpConfig();
        }

        public MeasurementUnit copy$default$2() {
            return this.timeUnit();
        }

        public MeasurementUnit copy$default$3() {
            return this.informationUnit();
        }

        public Seq<Tuple2<String, String>> copy$default$4() {
            return this.extraTags();
        }

        public Filter copy$default$5() {
            return this.tagFilter();
        }

        public String productPrefix() {
            return "Configuration";
        }

        public int productArity() {
            return 5;
        }

        public Object productElement(int x$1) {
            MeasurementUnit measurementUnit;
            int n = x$1;
            switch (n) {
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
                case 4: {
                    measurementUnit = this.tagFilter();
                    break;
                }
                case 3: {
                    measurementUnit = this.extraTags();
                    break;
                }
                case 2: {
                    measurementUnit = this.informationUnit();
                    break;
                }
                case 1: {
                    measurementUnit = this.timeUnit();
                    break;
                }
                case 0: {
                    measurementUnit = this.httpConfig();
                }
            }
            return measurementUnit;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof Configuration;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof Configuration)) return false;
            boolean bl = true;
            if (!bl) return false;
            Configuration configuration = (Configuration)x$1;
            Config config = this.httpConfig();
            Config config2 = configuration.httpConfig();
            if (config == null) {
                if (config2 != null) {
                    return false;
                }
            } else if (!config.equals(config2)) return false;
            MeasurementUnit measurementUnit = this.timeUnit();
            MeasurementUnit measurementUnit2 = configuration.timeUnit();
            if (measurementUnit == null) {
                if (measurementUnit2 != null) {
                    return false;
                }
            } else if (!measurementUnit.equals(measurementUnit2)) return false;
            MeasurementUnit measurementUnit3 = this.informationUnit();
            MeasurementUnit measurementUnit4 = configuration.informationUnit();
            if (measurementUnit3 == null) {
                if (measurementUnit4 != null) {
                    return false;
                }
            } else if (!measurementUnit3.equals(measurementUnit4)) return false;
            Seq<Tuple2<String, String>> seq = this.extraTags();
            Seq<Tuple2<String, String>> seq2 = configuration.extraTags();
            if (seq == null) {
                if (seq2 != null) {
                    return false;
                }
            } else if (!seq.equals(seq2)) return false;
            Filter filter = this.tagFilter();
            Filter filter2 = configuration.tagFilter();
            if (filter == null) {
                if (filter2 != null) {
                    return false;
                }
            } else if (!filter.equals(filter2)) return false;
            if (!configuration.canEqual(this)) return false;
            return true;
        }

        public Configuration(Config httpConfig, MeasurementUnit timeUnit, MeasurementUnit informationUnit, Seq<Tuple2<String, String>> extraTags, Filter tagFilter) {
            this.httpConfig = httpConfig;
            this.timeUnit = timeUnit;
            this.informationUnit = informationUnit;
            this.extraTags = extraTags;
            this.tagFilter = tagFilter;
            Product.class.$init$((Product)this);
        }
    }
}

