/*
 * Decompiled with CFR 0.152.
 */
package kamon.datadog;

import com.typesafe.config.Config;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.time.Duration;
import java.util.Locale;
import kamon.Kamon$;
import kamon.datadog.DatadogAPIReporter$;
import kamon.datadog.DatadogAPIReporter$QuoteInterp$;
import kamon.datadog.package;
import kamon.metric.Distribution;
import kamon.metric.Instrument;
import kamon.metric.MeasurementUnit;
import kamon.metric.MeasurementUnit$;
import kamon.metric.Metric;
import kamon.metric.MetricSnapshot;
import kamon.metric.PeriodSnapshot;
import kamon.module.MetricReporter;
import kamon.tag.TagSet;
import kamon.util.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001\r\u001dc\u0001B\u0001\u0003\u0001\u001d\u0011!\u0003R1uC\u0012|w-\u0011)J%\u0016\u0004xN\u001d;fe*\u00111\u0001B\u0001\bI\u0006$\u0018\rZ8h\u0015\u0005)\u0011!B6b[>t7\u0001A\n\u0004\u0001!q\u0001CA\u0005\r\u001b\u0005Q!\"A\u0006\u0002\u000bM\u001c\u0017\r\\1\n\u00055Q!AB!osJ+g\r\u0005\u0002\u0010%5\t\u0001C\u0003\u0002\u0012\t\u00051Qn\u001c3vY\u0016L!a\u0005\t\u0003\u001d5+GO]5d%\u0016\u0004xN\u001d;fe\"AQ\u0003\u0001BA\u0002\u0013%a#A\u0007d_:4\u0017nZ;sCRLwN\\\u000b\u0002/A\u0011\u0001D\u000f\b\u00033\u0001r!AG\u0010\u000f\u0005mqR\"\u0001\u000f\u000b\u0005u1\u0011A\u0002\u001fs_>$h(C\u0001\u0006\u0013\t\u0019AaB\u0003\"\u0005!%!%\u0001\nECR\fGm\\4B!&\u0013V\r]8si\u0016\u0014\bCA\u0012%\u001b\u0005\u0011a!B\u0001\u0003\u0011\u0013)3C\u0001\u0013\t\u0011\u00159C\u0005\"\u0001)\u0003\u0019a\u0014N\\5u}Q\t!\u0005C\u0004+I\t\u0007I\u0011A\u0016\u0002\u000b\r|WO\u001c;\u0016\u00031\u0002\"!\f\u001a\u000e\u00039R!a\f\u0019\u0002\t1\fgn\u001a\u0006\u0002c\u0005!!.\u0019<b\u0013\t\u0019dF\u0001\u0004TiJLgn\u001a\u0005\u0007k\u0011\u0002\u000b\u0011\u0002\u0017\u0002\r\r|WO\u001c;!\u0011\u001d9DE1A\u0005\u0002-\nQaZ1vO\u0016Da!\u000f\u0013!\u0002\u0013a\u0013AB4bk\u001e,\u0007E\u0002\u0003<I\u0001c$!D\"p]\u001aLw-\u001e:bi&|gn\u0005\u0003;\u0011u\u0002\u0005CA\u0005?\u0013\ty$BA\u0004Qe>$Wo\u0019;\u0011\u0005%\t\u0015B\u0001\"\u000b\u00051\u0019VM]5bY&T\u0018M\u00197f\u0011!!%H!f\u0001\n\u0003)\u0015A\u00035uiB\u001cuN\u001c4jOV\ta\t\u0005\u0002H\u001d6\t\u0001J\u0003\u0002J\u0015\u000611m\u001c8gS\u001eT!a\u0013'\u0002\u0011QL\b/Z:bM\u0016T\u0011!T\u0001\u0004G>l\u0017BA(I\u0005\u0019\u0019uN\u001c4jO\"A\u0011K\u000fB\tB\u0003%a)A\u0006iiR\u00048i\u001c8gS\u001e\u0004\u0003\u0002C*;\u0005+\u0007I\u0011\u0001+\u0002\u0011QLW.Z+oSR,\u0012!\u0016\t\u0003-fk\u0011a\u0016\u0006\u00031\u0012\ta!\\3ue&\u001c\u0017B\u0001.X\u0005=iU-Y:ve\u0016lWM\u001c;V]&$\b\u0002\u0003/;\u0005#\u0005\u000b\u0011B+\u0002\u0013QLW.Z+oSR\u0004\u0003\u0002\u00030;\u0005+\u0007I\u0011\u0001+\u0002\u001f%tgm\u001c:nCRLwN\\+oSRD\u0001\u0002\u0019\u001e\u0003\u0012\u0003\u0006I!V\u0001\u0011S:4wN]7bi&|g.\u00168ji\u0002B\u0001B\u0019\u001e\u0003\u0016\u0004%\taY\u0001\nKb$(/\u0019+bON,\u0012\u0001\u001a\t\u0004K*lgB\u00014i\u001d\tYr-C\u0001\f\u0013\tI'\"A\u0004qC\u000e\\\u0017mZ3\n\u0005-d'aA*fc*\u0011\u0011N\u0003\t\u0005\u00139\u0004\b/\u0003\u0002p\u0015\t1A+\u001e9mKJ\u0002\"!];\u000f\u0005I\u001c\bCA\u000e\u000b\u0013\t!(\"\u0001\u0004Qe\u0016$WMZ\u0005\u0003gYT!\u0001\u001e\u0006\t\u0011aT$\u0011#Q\u0001\n\u0011\f!\"\u001a=ue\u0006$\u0016mZ:!\u0011!Q(H!f\u0001\n\u0003Y\u0018!\u0003;bO\u001aKG\u000e^3s+\u0005a\bcA?\u0002\u00025\taP\u0003\u0002\u0000\t\u0005!Q\u000f^5m\u0013\r\t\u0019A \u0002\u0007\r&dG/\u001a:\t\u0013\u0005\u001d!H!E!\u0002\u0013a\u0018A\u0003;bO\u001aKG\u000e^3sA!1qE\u000fC\u0001\u0003\u0017!B\"!\u0004\u0002\u0012\u0005M\u0011QCA\f\u00033\u00012!a\u0004;\u001b\u0005!\u0003B\u0002#\u0002\n\u0001\u0007a\t\u0003\u0004T\u0003\u0013\u0001\r!\u0016\u0005\u0007=\u0006%\u0001\u0019A+\t\r\t\fI\u00011\u0001e\u0011\u0019Q\u0018\u0011\u0002a\u0001y\"I\u0011Q\u0004\u001e\u0002\u0002\u0013\u0005\u0011qD\u0001\u0005G>\u0004\u0018\u0010\u0006\u0007\u0002\u000e\u0005\u0005\u00121EA\u0013\u0003O\tI\u0003\u0003\u0005E\u00037\u0001\n\u00111\u0001G\u0011!\u0019\u00161\u0004I\u0001\u0002\u0004)\u0006\u0002\u00030\u0002\u001cA\u0005\t\u0019A+\t\u0011\t\fY\u0002%AA\u0002\u0011D\u0001B_A\u000e!\u0003\u0005\r\u0001 \u0005\n\u0003[Q\u0014\u0013!C\u0001\u0003_\tabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u00022)\u001aa)a\r,\u0005\u0005U\u0002\u0003BA\u001c\u0003\u0003j!!!\u000f\u000b\t\u0005m\u0012QH\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a\u0010\u000b\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003\u0007\nIDA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016D\u0011\"a\u0012;#\u0003%\t!!\u0013\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u00111\n\u0016\u0004+\u0006M\u0002\"CA(uE\u0005I\u0011AA%\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIMB\u0011\"a\u0015;#\u0003%\t!!\u0016\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%iU\u0011\u0011q\u000b\u0016\u0004I\u0006M\u0002\"CA.uE\u0005I\u0011AA/\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIU*\"!a\u0018+\u0007q\f\u0019\u0004\u0003\u0005\u0002di\n\t\u0011\"\u0011,\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jq\"I\u0011q\r\u001e\u0002\u0002\u0013\u0005\u0011\u0011N\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003W\u00022!CA7\u0013\r\tyG\u0003\u0002\u0004\u0013:$\b\"CA:u\u0005\u0005I\u0011AA;\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!a\u001e\u0002~A\u0019\u0011\"!\u001f\n\u0007\u0005m$BA\u0002B]fD!\"a \u0002r\u0005\u0005\t\u0019AA6\u0003\rAH%\r\u0005\n\u0003\u0007S\u0014\u0011!C!\u0003\u000b\u000bq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003\u000f\u0003b!!#\u0002\u0010\u0006]TBAAF\u0015\r\tiIC\u0001\u000bG>dG.Z2uS>t\u0017\u0002BAI\u0003\u0017\u0013\u0001\"\u0013;fe\u0006$xN\u001d\u0005\n\u0003+S\u0014\u0011!C\u0001\u0003/\u000b\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u00033\u000by\nE\u0002\n\u00037K1!!(\u000b\u0005\u001d\u0011un\u001c7fC:D!\"a \u0002\u0014\u0006\u0005\t\u0019AA<\u0011%\t\u0019KOA\u0001\n\u0003\n)+\u0001\u0005iCND7i\u001c3f)\t\tY\u0007C\u0005\u0002*j\n\t\u0011\"\u0011\u0002,\u0006AAo\\*ue&tw\rF\u0001-\u0011%\tyKOA\u0001\n\u0003\n\t,\u0001\u0004fcV\fGn\u001d\u000b\u0005\u00033\u000b\u0019\f\u0003\u0006\u0002\u0000\u00055\u0016\u0011!a\u0001\u0003o:\u0011\"a.%\u0003\u0003E\t!!/\u0002\u001b\r{gNZ5hkJ\fG/[8o!\u0011\ty!a/\u0007\u0011m\"\u0013\u0011!E\u0001\u0003{\u001bR!a/\u0002@\u0002\u00032\"!1\u0002H\u001a+V\u000b\u001a?\u0002\u000e5\u0011\u00111\u0019\u0006\u0004\u0003\u000bT\u0011a\u0002:v]RLW.Z\u0005\u0005\u0003\u0013\f\u0019MA\tBEN$(/Y2u\rVt7\r^5p]VBqaJA^\t\u0003\ti\r\u0006\u0002\u0002:\"Q\u0011\u0011VA^\u0003\u0003%)%a+\t\u0015\u0005M\u00171XA\u0001\n\u0003\u000b).A\u0003baBd\u0017\u0010\u0006\u0007\u0002\u000e\u0005]\u0017\u0011\\An\u0003;\fy\u000e\u0003\u0004E\u0003#\u0004\rA\u0012\u0005\u0007'\u0006E\u0007\u0019A+\t\ry\u000b\t\u000e1\u0001V\u0011\u0019\u0011\u0017\u0011\u001ba\u0001I\"1!0!5A\u0002qD!\"a9\u0002<\u0006\u0005I\u0011QAs\u0003\u001d)h.\u00199qYf$B!a:\u0002tB)\u0011\"!;\u0002n&\u0019\u00111\u001e\u0006\u0003\r=\u0003H/[8o!!I\u0011q\u001e$V+\u0012d\u0018bAAy\u0015\t1A+\u001e9mKVB!\"!>\u0002b\u0006\u0005\t\u0019AA\u0007\u0003\rAH\u0005\r\u0005\u000b\u0003s\fY,!A\u0005\n\u0005m\u0018a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"!!@\u0011\u00075\ny0C\u0002\u0003\u00029\u0012aa\u00142kK\u000e$hA\u0002B\u0003I\r\u00119AA\u0006Rk>$X-\u00138uKJ\u00048\u0003\u0002B\u0002\u0005\u0013\u00012!\u0003B\u0006\u0013\r\u0011iA\u0003\u0002\u0007\u0003:Lh+\u00197\t\u0017\tE!1\u0001BC\u0002\u0013\u0005!1C\u0001\u0003g\u000e,\"A!\u0006\u0011\u0007%\u00119\"C\u0002\u0003\u001a)\u0011Qb\u0015;sS:<7i\u001c8uKb$\bb\u0003B\u000f\u0005\u0007\u0011\t\u0011)A\u0005\u0005+\t1a]2!\u0011\u001d9#1\u0001C\u0001\u0005C!BAa\t\u0003&A!\u0011q\u0002B\u0002\u0011!\u0011\tBa\bA\u0002\tU\u0001\u0002\u0003B\u0015\u0005\u0007!\tAa\u000b\u0002\u000bE,x\u000e^3\u0015\u0007A\u0014i\u0003\u0003\u0005\u00030\t\u001d\u0002\u0019\u0001B\u0019\u0003\u0011\t'oZ:\u0011\u000b%\u0011\u0019$a\u001e\n\u0007\tU\"B\u0001\u0006=e\u0016\u0004X-\u0019;fIzB!\"a)\u0003\u0004\u0005\u0005I\u0011IAS\u0011)\tyKa\u0001\u0002\u0002\u0013\u0005#1\b\u000b\u0005\u00033\u0013i\u0004\u0003\u0006\u0002\u0000\te\u0012\u0011!a\u0001\u0003oB\u0011B!\u0011%\u0003\u0003%\u0019Aa\u0011\u0002\u0017E+x\u000e^3J]R,'\u000f\u001d\u000b\u0005\u0005G\u0011)\u0005\u0003\u0005\u0003\u0012\t}\u0002\u0019\u0001B\u000b\u0011\u001d\u0011I\u0005\nC\u0001\u0005\u0017\n\u0011C]3bI\u000e{gNZ5hkJ\fG/[8o)\u0011\tiA!\u0014\t\r%\u00139\u00051\u0001G\u000f%\u0011\t\u0005JA\u0001\u0012\u0003\u0011\t\u0006\u0005\u0003\u0002\u0010\tMc!\u0003B\u0003I\u0005\u0005\t\u0012\u0001B+'\r\u0011\u0019\u0006\u0003\u0005\bO\tMC\u0011\u0001B-)\t\u0011\t\u0006\u0003\u0005\u0003^\tMCQ\u0001B0\u0003=\tXo\u001c;fI\u0015DH/\u001a8tS>tG\u0003\u0002B1\u0005K\"2\u0001\u001dB2\u0011!\u0011yCa\u0017A\u0002\tE\u0002\u0002\u0003B4\u00057\u0002\rAa\t\u0002\u000b\u0011\"\b.[:\t\u0015\t-$1KA\u0001\n\u000b\u0011i'\u0001\niCND7i\u001c3fI\u0015DH/\u001a8tS>tG\u0003BAS\u0005_B\u0001Ba\u001a\u0003j\u0001\u0007!1\u0005\u0005\u000b\u0005g\u0012\u0019&!A\u0005\u0006\tU\u0014\u0001E3rk\u0006d7\u000fJ3yi\u0016t7/[8o)\u0011\u00119Ha\u001f\u0015\t\u0005e%\u0011\u0010\u0005\u000b\u0003\u007f\u0012\t(!AA\u0002\u0005]\u0004\u0002\u0003B4\u0005c\u0002\rAa\t\t\u0015\t}\u0004A!a\u0001\n\u0013\u0011\t)A\td_:4\u0017nZ;sCRLwN\\0%KF$BAa!\u0003\nB\u0019\u0011B!\"\n\u0007\t\u001d%B\u0001\u0003V]&$\b\"CA@\u0005{\n\t\u00111\u0001\u0018\u0011%\u0011i\t\u0001B\u0001B\u0003&q#\u0001\bd_:4\u0017nZ;sCRLwN\u001c\u0011)\t\t-%\u0011\u0013\t\u0004\u0013\tM\u0015b\u0001BK\u0015\tAao\u001c7bi&dW\r\u0003\u0006\u0003\u001a\u0002\u0011\t\u0019!C\u0005\u00057\u000b!\u0002\u001b;ua\u000ec\u0017.\u001a8u+\t\u0011i\n\u0005\u0003\u0003 \n\rfbA\u0012\u0003\"&\u0011\u0011NA\u0005\u0005\u0005K\u00139K\u0001\u0006IiR\u00048\t\\5f]RT!!\u001b\u0002\t\u0015\t-\u0006A!a\u0001\n\u0013\u0011i+\u0001\biiR\u00048\t\\5f]R|F%Z9\u0015\t\t\r%q\u0016\u0005\u000b\u0003\u007f\u0012I+!AA\u0002\tu\u0005B\u0003BZ\u0001\t\u0005\t\u0015)\u0003\u0003\u001e\u0006Y\u0001\u000e\u001e;q\u00072LWM\u001c;!Q\u0011\u0011\tL!%\t\r\u001d\u0002A\u0011\u0001B])\u0019\u0011YL!0\u0003@B\u00111\u0005\u0001\u0005\u0007+\t]\u0006\u0019A\f\t\u0011\te%q\u0017a\u0001\u0005;C\u0011Ba1\u0001\u0005\u0004%IA!2\u0002\r1|wmZ3s+\t\u00119\r\u0005\u0003\u0003J\nMWB\u0001Bf\u0015\u0011\u0011iMa4\u0002\u000bMdg\r\u000e6\u000b\u0005\tE\u0017aA8sO&!!Q\u001bBf\u0005\u0019aunZ4fe\"A!\u0011\u001c\u0001!\u0002\u0013\u00119-A\u0004m_\u001e<WM\u001d\u0011\t\u0013\tu\u0007A1A\u0005\n\t}\u0017aB:z[\n|Gn]\u000b\u0003\u0005C\u0004BAa9\u0003j6\u0011!Q\u001d\u0006\u0004\u0005O\u0004\u0014\u0001\u0002;fqRLAAa;\u0003f\n!B)Z2j[\u0006dgi\u001c:nCR\u001c\u00160\u001c2pYND\u0001Ba<\u0001A\u0003%!\u0011]\u0001\tgfl'm\u001c7tA!I!1\u001f\u0001C\u0002\u0013%!Q_\u0001\fm\u0006dW/\u001a$pe6\fG/\u0006\u0002\u0003xB!!1\u001dB}\u0013\u0011\u0011YP!:\u0003\u001b\u0011+7-[7bY\u001a{'/\\1u\u0011!\u0011y\u0010\u0001Q\u0001\n\t]\u0018\u0001\u0004<bYV,gi\u001c:nCR\u0004\u0003bBB\u0002\u0001\u0011\u00053QA\u0001\u0005gR|\u0007\u000f\u0006\u0002\u0003\u0004\"91\u0011\u0002\u0001\u0005B\r-\u0011a\u0003:fG>tg-[4ve\u0016$BAa!\u0004\u000e!1\u0011ja\u0002A\u0002\u0019Cqa!\u0005\u0001\t\u0003\u001a\u0019\"\u0001\u000bsKB|'\u000f\u001e)fe&|Gm\u00158baNDw\u000e\u001e\u000b\u0005\u0005\u0007\u001b)\u0002\u0003\u0005\u0004\u0018\r=\u0001\u0019AB\r\u0003!\u0019h.\u00199tQ>$\bc\u0001,\u0004\u001c%\u00191QD,\u0003\u001dA+'/[8e':\f\u0007o\u001d5pi\"A1\u0011\u0005\u0001\u0005\u0002\t\u0019\u0019#\u0001\tck&dGMU3rk\u0016\u001cHOQ8esR!1QEB\u0019!\u0015I1qEB\u0016\u0013\r\u0019IC\u0003\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0004\u0013\r5\u0012bAB\u0018\u0015\t!!)\u001f;f\u0011!\u00199ba\bA\u0002\re\u0001bBB\u001b\u0001\u0011%1qG\u0001\u0006g\u000e\fG.\u001a\u000b\u0007\u0007s\u0019yda\u0011\u0011\u0007%\u0019Y$C\u0002\u0004>)\u0011a\u0001R8vE2,\u0007\u0002CB!\u0007g\u0001\ra!\u000f\u0002\u000bY\fG.^3\t\u000f\r\u001531\u0007a\u0001+\u0006!QO\\5u\u0001")
public class DatadogAPIReporter
implements MetricReporter {
    private volatile Configuration configuration;
    private volatile package.HttpClient httpClient;
    private final Logger logger;
    private final DecimalFormatSymbols symbols;
    private final DecimalFormat valueFormat;

    public static Configuration readConfiguration(Config config) {
        return DatadogAPIReporter$.MODULE$.readConfiguration(config);
    }

    public static StringContext QuoteInterp(StringContext stringContext) {
        return DatadogAPIReporter$.MODULE$.QuoteInterp(stringContext);
    }

    public static String gauge() {
        return DatadogAPIReporter$.MODULE$.gauge();
    }

    public static String count() {
        return DatadogAPIReporter$.MODULE$.count();
    }

    private Configuration configuration() {
        return this.configuration;
    }

    private void configuration_$eq(Configuration x$1) {
        this.configuration = x$1;
    }

    private package.HttpClient httpClient() {
        return this.httpClient;
    }

    private void httpClient_$eq(package.HttpClient x$1) {
        this.httpClient = x$1;
    }

    private Logger logger() {
        return this.logger;
    }

    private DecimalFormatSymbols symbols() {
        return this.symbols;
    }

    private DecimalFormat valueFormat() {
        return this.valueFormat;
    }

    public void stop() {
        this.logger().info("Stopped the Datadog API reporter.");
    }

    public void reconfigure(Config config) {
        Configuration newConfiguration = DatadogAPIReporter$.MODULE$.readConfiguration(config);
        this.configuration_$eq(newConfiguration);
        this.httpClient_$eq(new package.HttpClient(this.configuration().httpConfig(), false));
    }

    public void reportPeriodSnapshot(PeriodSnapshot snapshot) {
        Try<String> try_ = this.httpClient().doPost("application/json; charset=utf-8", this.buildRequestBody(snapshot));
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            this.logger().error(e.getMessage());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (try_ instanceof Success) {
            Success success = (Success)try_;
            String response = (String)success.value();
            this.logger().trace(response);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError(try_);
        }
    }

    public byte[] buildRequestBody(PeriodSnapshot snapshot) {
        String timestamp = ((Object)BoxesRunTime.boxToLong((long)snapshot.from().getEpochSecond())).toString();
        String host = Kamon$.MODULE$.environment().host();
        long interval = Math.round((double)Duration.between(snapshot.from(), snapshot.to()).toMillis() / 1000.0);
        StringBuilder seriesBuilder = new StringBuilder();
        snapshot.counters().foreach((Function1 & Serializable & scala.Serializable)snap -> {
            DatadogAPIReporter.$anonfun$buildRequestBody$6(this, timestamp, host, interval, seriesBuilder, snap);
            return BoxedUnit.UNIT;
        });
        snapshot.gauges().foreach((Function1 & Serializable & scala.Serializable)snap -> {
            DatadogAPIReporter.$anonfun$buildRequestBody$8(this, timestamp, host, interval, seriesBuilder, snap);
            return BoxedUnit.UNIT;
        });
        ((IterableLike)snapshot.histograms().$plus$plus((GenTraversableOnce)snapshot.rangeSamplers(), Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)metric -> {
            this.addDistribution$1(metric, timestamp, host, interval, seriesBuilder);
            return BoxedUnit.UNIT;
        });
        return seriesBuilder.insert(0, "{\"series\":[").append("]}").toString().getBytes(StandardCharsets.UTF_8);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private double scale(double value, MeasurementUnit unit) {
        MeasurementUnit.Dimension dimension = unit.dimension();
        MeasurementUnit.Dimension dimension2 = MeasurementUnit.Dimension$.MODULE$.Time();
        MeasurementUnit.Dimension dimension3 = dimension;
        if (!(dimension2 != null ? !dimension2.equals(dimension3) : dimension3 != null)) {
            MeasurementUnit.Magnitude magnitude = unit.magnitude();
            MeasurementUnit.Magnitude magnitude2 = this.configuration().timeUnit().magnitude();
            if (magnitude == null ? magnitude2 != null : !magnitude.equals(magnitude2)) {
                return MeasurementUnit$.MODULE$.convert(value, unit, this.configuration().timeUnit());
            }
        }
        MeasurementUnit.Dimension dimension4 = MeasurementUnit.Dimension$.MODULE$.Information();
        MeasurementUnit.Dimension dimension5 = dimension;
        if (dimension4 == null) {
            if (dimension5 != null) {
                return value;
            }
        } else if (!dimension4.equals(dimension5)) return value;
        MeasurementUnit.Magnitude magnitude = unit.magnitude();
        MeasurementUnit.Magnitude magnitude3 = this.configuration().informationUnit().magnitude();
        if (magnitude == null) {
            if (magnitude3 == null) return value;
            return MeasurementUnit$.MODULE$.convert(value, unit, this.configuration().informationUnit());
        } else if (magnitude.equals(magnitude3)) return value;
        return MeasurementUnit$.MODULE$.convert(value, unit, this.configuration().informationUnit());
    }

    public static final /* synthetic */ void $anonfun$buildRequestBody$1(DatadogAPIReporter $this, String timestamp$1, String host$1, long interval$1, StringBuilder seriesBuilder$1, MetricSnapshot metric$1, MeasurementUnit unit$1, Instrument.Snapshot d) {
        Distribution dist = (Distribution)d.value();
        long average = dist.count() > 0L ? dist.sum() / dist.count() : 0L;
        $this.addMetric$1(new StringBuilder(4).append(metric$1.name()).append(".avg").toString(), $this.valueFormat().format($this.scale(average, unit$1)), DatadogAPIReporter$.MODULE$.gauge(), d.tags(), timestamp$1, host$1, interval$1, seriesBuilder$1);
        $this.addMetric$1(new StringBuilder(6).append(metric$1.name()).append(".count").toString(), $this.valueFormat().format(dist.count()), DatadogAPIReporter$.MODULE$.count(), d.tags(), timestamp$1, host$1, interval$1, seriesBuilder$1);
        $this.addMetric$1(new StringBuilder(7).append(metric$1.name()).append(".median").toString(), $this.valueFormat().format($this.scale(dist.percentile(50.0).value(), unit$1)), DatadogAPIReporter$.MODULE$.gauge(), d.tags(), timestamp$1, host$1, interval$1, seriesBuilder$1);
        $this.addMetric$1(new StringBuilder(13).append(metric$1.name()).append(".95percentile").toString(), $this.valueFormat().format($this.scale(dist.percentile(95.0).value(), unit$1)), DatadogAPIReporter$.MODULE$.gauge(), d.tags(), timestamp$1, host$1, interval$1, seriesBuilder$1);
        $this.addMetric$1(new StringBuilder(4).append(metric$1.name()).append(".max").toString(), $this.valueFormat().format($this.scale(dist.max(), unit$1)), DatadogAPIReporter$.MODULE$.gauge(), d.tags(), timestamp$1, host$1, interval$1, seriesBuilder$1);
        $this.addMetric$1(new StringBuilder(4).append(metric$1.name()).append(".min").toString(), $this.valueFormat().format($this.scale(dist.min(), unit$1)), DatadogAPIReporter$.MODULE$.gauge(), d.tags(), timestamp$1, host$1, interval$1, seriesBuilder$1);
    }

    private final void addDistribution$1(MetricSnapshot metric, String timestamp$1, String host$1, long interval$1, StringBuilder seriesBuilder$1) {
        MeasurementUnit unit = ((Metric.Settings$.ForDistributionInstrument)metric.settings()).unit();
        metric.instruments().foreach((Function1 & Serializable & scala.Serializable)d -> {
            DatadogAPIReporter.$anonfun$buildRequestBody$1(this, timestamp$1, host$1, interval$1, seriesBuilder$1, metric, unit, d);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$buildRequestBody$4(DatadogAPIReporter $this, Tuple2 t) {
        return $this.configuration().tagFilter().accept((String)t._1());
    }

    private final void addMetric$1(String metricName, String value, String metricType, TagSet tags, String timestamp$1, String host$1, long interval$1, StringBuilder seriesBuilder$1) {
        Seq customTags = (Seq)((TraversableLike)this.configuration().extraTags().$plus$plus((GenTraversableOnce)tags.iterator((Function1 & Serializable & scala.Serializable)x$1 -> x$1.toString()).map((Function1 & Serializable & scala.Serializable)p -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)p.key()), p.value())).filter((Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToBoolean((boolean)DatadogAPIReporter.$anonfun$buildRequestBody$4(this, t))), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            String string = DatadogAPIReporter$QuoteInterp$.MODULE$.quote$extension(DatadogAPIReporter$.MODULE$.QuoteInterp(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":", ""}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{k, v}));
            return string;
        }, Seq$.MODULE$.canBuildFrom());
        String allTagsString = customTags.mkString("[", ",", "]");
        Object object = seriesBuilder$1.length() > 0 ? seriesBuilder$1.append(",") : BoxedUnit.UNIT;
        seriesBuilder$1.append(new StringBuilder(68).append("{\"metric\":\"").append(metricName).append("\",\"interval\":").append(interval$1).append(",\"points\":[[").append(timestamp$1).append(",").append(value).append("]],\"type\":\"").append(metricType).append("\",\"host\":\"").append(host$1).append("\",\"tags\":").append(allTagsString).append("}").toString());
    }

    public static final /* synthetic */ void $anonfun$buildRequestBody$6(DatadogAPIReporter $this, String timestamp$1, String host$1, long interval$1, StringBuilder seriesBuilder$1, MetricSnapshot snap) {
        snap.instruments().foreach((Function1 & Serializable & scala.Serializable)instrument -> {
            $this.addMetric$1(snap.name(), $this.valueFormat().format($this.scale(BoxesRunTime.unboxToLong((Object)instrument.value()), ((Metric.Settings$.ForValueInstrument)snap.settings()).unit())), DatadogAPIReporter$.MODULE$.count(), instrument.tags(), timestamp$1, host$1, interval$1, seriesBuilder$1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$buildRequestBody$8(DatadogAPIReporter $this, String timestamp$1, String host$1, long interval$1, StringBuilder seriesBuilder$1, MetricSnapshot snap) {
        snap.instruments().foreach((Function1 & Serializable & scala.Serializable)instrument -> {
            $this.addMetric$1(snap.name(), $this.valueFormat().format($this.scale(BoxesRunTime.unboxToDouble((Object)instrument.value()), ((Metric.Settings$.ForValueInstrument)snap.settings()).unit())), DatadogAPIReporter$.MODULE$.gauge(), instrument.tags(), timestamp$1, host$1, interval$1, seriesBuilder$1);
            return BoxedUnit.UNIT;
        });
    }

    public DatadogAPIReporter(Configuration configuration, package.HttpClient httpClient) {
        this.configuration = configuration;
        this.httpClient = httpClient;
        this.logger = LoggerFactory.getLogger(DatadogAPIReporter.class);
        this.symbols = DecimalFormatSymbols.getInstance(Locale.US);
        this.symbols().setDecimalSeparator('.');
        this.valueFormat = new DecimalFormat("#0.#########", this.symbols());
        this.logger().info("Started the Datadog API reporter.");
    }

    public static class Configuration
    implements Product,
    scala.Serializable {
        private final Config httpConfig;
        private final MeasurementUnit timeUnit;
        private final MeasurementUnit informationUnit;
        private final Seq<Tuple2<String, String>> extraTags;
        private final Filter tagFilter;

        public Config httpConfig() {
            return this.httpConfig;
        }

        public MeasurementUnit timeUnit() {
            return this.timeUnit;
        }

        public MeasurementUnit informationUnit() {
            return this.informationUnit;
        }

        public Seq<Tuple2<String, String>> extraTags() {
            return this.extraTags;
        }

        public Filter tagFilter() {
            return this.tagFilter;
        }

        public Configuration copy(Config httpConfig, MeasurementUnit timeUnit, MeasurementUnit informationUnit, Seq<Tuple2<String, String>> extraTags, Filter tagFilter) {
            return new Configuration(httpConfig, timeUnit, informationUnit, extraTags, tagFilter);
        }

        public Config copy$default$1() {
            return this.httpConfig();
        }

        public MeasurementUnit copy$default$2() {
            return this.timeUnit();
        }

        public MeasurementUnit copy$default$3() {
            return this.informationUnit();
        }

        public Seq<Tuple2<String, String>> copy$default$4() {
            return this.extraTags();
        }

        public Filter copy$default$5() {
            return this.tagFilter();
        }

        public String productPrefix() {
            return "Configuration";
        }

        public int productArity() {
            return 5;
        }

        public Object productElement(int x$1) {
            Filter filter;
            int n = x$1;
            switch (n) {
                case 0: {
                    filter = this.httpConfig();
                    break;
                }
                case 1: {
                    filter = this.timeUnit();
                    break;
                }
                case 2: {
                    filter = this.informationUnit();
                    break;
                }
                case 3: {
                    filter = this.extraTags();
                    break;
                }
                case 4: {
                    filter = this.tagFilter();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return filter;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof Configuration;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof Configuration)) return false;
            boolean bl = true;
            if (!bl) return false;
            Configuration configuration = (Configuration)x$1;
            Config config = this.httpConfig();
            Config config2 = configuration.httpConfig();
            if (config == null) {
                if (config2 != null) {
                    return false;
                }
            } else if (!config.equals(config2)) return false;
            MeasurementUnit measurementUnit = this.timeUnit();
            MeasurementUnit measurementUnit2 = configuration.timeUnit();
            if (measurementUnit == null) {
                if (measurementUnit2 != null) {
                    return false;
                }
            } else if (!measurementUnit.equals(measurementUnit2)) return false;
            MeasurementUnit measurementUnit3 = this.informationUnit();
            MeasurementUnit measurementUnit4 = configuration.informationUnit();
            if (measurementUnit3 == null) {
                if (measurementUnit4 != null) {
                    return false;
                }
            } else if (!measurementUnit3.equals(measurementUnit4)) return false;
            Seq<Tuple2<String, String>> seq = this.extraTags();
            Seq<Tuple2<String, String>> seq2 = configuration.extraTags();
            if (seq == null) {
                if (seq2 != null) {
                    return false;
                }
            } else if (!seq.equals(seq2)) return false;
            Filter filter = this.tagFilter();
            Filter filter2 = configuration.tagFilter();
            if (filter == null) {
                if (filter2 != null) {
                    return false;
                }
            } else if (!filter.equals(filter2)) return false;
            if (!configuration.canEqual(this)) return false;
            return true;
        }

        public Configuration(Config httpConfig, MeasurementUnit timeUnit, MeasurementUnit informationUnit, Seq<Tuple2<String, String>> extraTags, Filter tagFilter) {
            this.httpConfig = httpConfig;
            this.timeUnit = timeUnit;
            this.informationUnit = informationUnit;
            this.extraTags = extraTags;
            this.tagFilter = tagFilter;
            Product.$init$((Product)this);
        }
    }

    public static final class QuoteInterp {
        private final StringContext sc;

        public StringContext sc() {
            return this.sc;
        }

        public String quote(Seq<Object> args) {
            return DatadogAPIReporter$QuoteInterp$.MODULE$.quote$extension(this.sc(), args);
        }

        public int hashCode() {
            return DatadogAPIReporter$QuoteInterp$.MODULE$.hashCode$extension(this.sc());
        }

        public boolean equals(Object x$1) {
            return DatadogAPIReporter$QuoteInterp$.MODULE$.equals$extension(this.sc(), x$1);
        }

        public QuoteInterp(StringContext sc) {
            this.sc = sc;
        }
    }
}

