/*
 * Decompiled with CFR 0.152.
 */
package kamon.datadog;

import java.util.zip.Deflater;
import kamon.lib.BufferedSink;
import kamon.lib.DeflaterSink;
import kamon.lib.Interceptor;
import kamon.lib.MediaType;
import kamon.lib.Okio;
import kamon.lib.Request;
import kamon.lib.RequestBody;
import kamon.lib.Response;
import kamon.lib.Sink;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005]2A\u0001B\u0003\u0001\u0015!)\u0011\u0004\u0001C\u00015!)Q\u0004\u0001C\u0001=!)\u0001\u0007\u0001C\u0005c\t\u0011B)\u001a4mCR,\u0017J\u001c;fe\u000e,\u0007\u000f^8s\u0015\t1q!A\u0004eCR\fGm\\4\u000b\u0003!\tQa[1n_:\u001c\u0001aE\u0002\u0001\u0017M\u0001\"\u0001D\t\u000e\u00035Q!AD\b\u0002\t1\fgn\u001a\u0006\u0002!\u0005!!.\u0019<b\u0013\t\u0011RB\u0001\u0004PE*,7\r\u001e\t\u0003)]i\u0011!\u0006\u0006\u0002-\u00059qn\u001b5uiB\u001c\u0014B\u0001\r\u0016\u0005-Ie\u000e^3sG\u0016\u0004Ho\u001c:\u0002\rqJg.\u001b;?)\u0005Y\u0002C\u0001\u000f\u0001\u001b\u0005)\u0011!C5oi\u0016\u00148-\u001a9u)\ty\"\u0005\u0005\u0002\u0015A%\u0011\u0011%\u0006\u0002\t%\u0016\u001c\bo\u001c8tK\")1E\u0001a\u0001I\u0005)1\r[1j]B\u0011Q%\f\b\u0003M-r!a\n\u0016\u000e\u0003!R!!K\u0005\u0002\rq\u0012xn\u001c;?\u0013\u00051\u0012B\u0001\u0017\u0016\u0003-Ie\u000e^3sG\u0016\u0004Ho\u001c:\n\u00059z#!B\"iC&t'B\u0001\u0017\u0016\u00035)gnY8eK\u0012+g\r\\1uKR\u0011!'\u000e\t\u0003)MJ!\u0001N\u000b\u0003\u0017I+\u0017/^3ti\n{G-\u001f\u0005\u0006m\r\u0001\rAM\u0001\u0005E>$\u0017\u0010")
public class DeflateInterceptor
implements Interceptor {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Response intercept(Interceptor.Chain chain) {
        Request originalRequest = chain.request();
        Option option = Option$.MODULE$.apply((Object)originalRequest.body());
        if (!(option instanceof Some)) return chain.proceed(originalRequest);
        Some some = (Some)option;
        RequestBody body = (RequestBody)some.value();
        if (!Option$.MODULE$.apply((Object)originalRequest.header("Content-Encoding")).isEmpty()) return chain.proceed(originalRequest);
        Request compressedRequest = originalRequest.newBuilder().header("Content-Encoding", "deflate").method(originalRequest.method(), this.encodeDeflate(body)).build();
        return chain.proceed(compressedRequest);
    }

    private RequestBody encodeDeflate(RequestBody body) {
        return new RequestBody(null, body){
            private final RequestBody body$1;

            public MediaType contentType() {
                return this.body$1.contentType();
            }

            public void writeTo(BufferedSink sink) {
                BufferedSink deflateSink = Okio.buffer(new DeflaterSink((Sink)sink, new Deflater()));
                this.body$1.writeTo(deflateSink);
                deflateSink.close();
            }
            {
                this.body$1 = body$1;
            }
        };
    }
}

