/*
 * Decompiled with CFR 0.152.
 */
package kamon.executors;

import java.lang.reflect.Field;
import java.time.Duration;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import kamon.Kamon$;
import kamon.executors.Executors;
import kamon.executors.Executors$;
import kamon.executors.Executors$JavaFJPMetrics$;
import kamon.executors.Executors$ScalaFJPMetrics$;
import kamon.executors.Metrics;
import kamon.executors.Metrics$;
import kamon.package;
import kamon.package$;
import kamon.util.DifferentialSource;
import kamon.util.DifferentialSource$;
import kamon.util.Registration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.util.Try$;

public final class Executors$ {
    public static final Executors$ MODULE$;
    private final Logger kamon$executors$Executors$$logger;
    private final Class<?> DelegatedExecutor;
    private final Class<?> FinalizableDelegated;
    private final Class<?> DelegateScheduled;
    private final Class<ForkJoinPool> JavaFJP;
    private final Class<scala.concurrent.forkjoin.ForkJoinPool> ScalaFJP;
    private final Class<Executors.InstrumentedExecutorService<?>> InstrumentedExecutor;
    private final Registration fakeRegistration;
    private final Field delegatedExecutorField;

    static {
        new Executors$();
    }

    public Logger kamon$executors$Executors$$logger() {
        return this.kamon$executors$Executors$$logger;
    }

    private Class<?> DelegatedExecutor() {
        return this.DelegatedExecutor;
    }

    private Class<?> FinalizableDelegated() {
        return this.FinalizableDelegated;
    }

    private Class<?> DelegateScheduled() {
        return this.DelegateScheduled;
    }

    private Class<ForkJoinPool> JavaFJP() {
        return this.JavaFJP;
    }

    private Class<scala.concurrent.forkjoin.ForkJoinPool> ScalaFJP() {
        return this.ScalaFJP;
    }

    private Class<Executors.InstrumentedExecutorService<?>> InstrumentedExecutor() {
        return this.InstrumentedExecutor;
    }

    public Registration register(String name, ExecutorService executor) {
        return this.register(name, (Map<String, String>)Predef$.MODULE$.Map().empty(), executor);
    }

    public Registration register(String name, Map<String, String> tags, ExecutorService executor) {
        ExecutorService executorService;
        Registration registration;
        ExecutorService executorService2;
        while (true) {
            ExecutorService executorService3;
            ExecutorService executorService4;
            ExecutorService executorService5;
            if ((executorService2 = executor) != null && this.isAssignableTo(executorService5 = executorService2, this.DelegatedExecutor())) {
                executor = this.unwrap(executorService5);
                continue;
            }
            if (executorService2 != null && this.isAssignableTo(executorService4 = executorService2, this.FinalizableDelegated())) {
                executor = this.unwrap(executorService4);
                continue;
            }
            if (executorService2 == null || !this.isAssignableTo(executorService3 = executorService2, this.DelegateScheduled())) break;
            executor = this.unwrap(executorService3);
        }
        if (executorService2 instanceof ThreadPoolExecutor) {
            ThreadPoolExecutor threadPoolExecutor = (ThreadPoolExecutor)executorService2;
            registration = this.register(name, tags, this.threadPoolSampler(name, tags, threadPoolExecutor));
        } else if (executorService2 != null && this.isAssignableTo(executorService = executorService2, Executors.InstrumentedExecutorService.class)) {
            registration = this.register(name, tags, this.forkJoinPoolSampler(name, tags, (Executors.InstrumentedExecutorService)executorService));
        } else {
            this.kamon$executors$Executors$$logger().error("Cannot register unsupported executor service [{}]", new Object[]{executorService2});
            registration = this.fakeRegistration();
        }
        return registration;
    }

    public Registration register(String name, Map<String, String> tags, Executors.ExecutorSampler sampler) {
        Duration samplingInterval = Kamon$.MODULE$.config().getDuration("kamon.executors.sample-interval");
        ScheduledFuture<?> scheduledFuture = Kamon$.MODULE$.scheduler().scheduleAtFixedRate(this.sampleTask(sampler), samplingInterval.toMillis(), samplingInterval.toMillis(), TimeUnit.MILLISECONDS);
        return new Registration(name, tags, sampler, scheduledFuture){
            public final String name$1;
            public final Map tags$1;
            public final Executors.ExecutorSampler sampler$1;
            public final ScheduledFuture scheduledFuture$1;

            public boolean cancel() {
                return Try$.MODULE$.apply((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anon.2 $outer;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.$outer.scheduledFuture$1.cancel(false);
                        this.$outer.sampler$1.cleanup();
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }).failed().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anon.2 $outer;

                    public final void apply(Throwable ex) {
                        Executors$.MODULE$.kamon$executors$Executors$$logger().error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to cancel registration for executor [name=", ", tags=", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.name$1, package.PrettyPrintTags$.MODULE$.prettyPrint$extension(package$.MODULE$.PrettyPrintTags(this.$outer.tags$1))})), ex);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }).isFailure();
            }
            {
                this.name$1 = name$1;
                this.tags$1 = tags$1;
                this.sampler$1 = sampler$1;
                this.scheduledFuture$1 = scheduledFuture$1;
            }
        };
    }

    private Registration fakeRegistration() {
        return this.fakeRegistration;
    }

    private boolean isAssignableTo(ExecutorService executor, Class<?> expectedClass) {
        return expectedClass.isAssignableFrom(executor.getClass());
    }

    private Executors.ExecutorSampler threadPoolSampler(String name, Map<String, String> tags, ThreadPoolExecutor pool) {
        return new Executors.ExecutorSampler(name, tags, pool){
            private final Metrics.ThreadPoolMetrics poolMetrics;
            private final DifferentialSource taskCountSource;
            private final DifferentialSource completedTaskCountSource;
            public final ThreadPoolExecutor pool$1;

            private Metrics.ThreadPoolMetrics poolMetrics() {
                return this.poolMetrics;
            }

            private DifferentialSource taskCountSource() {
                return this.taskCountSource;
            }

            private DifferentialSource completedTaskCountSource() {
                return this.completedTaskCountSource;
            }

            public void sample() {
                this.poolMetrics().poolMin().set((long)this.pool$1.getCorePoolSize());
                this.poolMetrics().poolMax().set((long)this.pool$1.getMaximumPoolSize());
                this.poolMetrics().poolSize().record((long)this.pool$1.getPoolSize());
                this.poolMetrics().activeThreads().record((long)this.pool$1.getActiveCount());
                this.poolMetrics().submittedTasks().increment(this.taskCountSource().get());
                this.poolMetrics().processedTasks().increment(this.completedTaskCountSource().get());
                this.poolMetrics().queuedTasks().record((long)this.pool$1.getQueue().size());
                this.poolMetrics().corePoolSize().set((long)this.pool$1.getCorePoolSize());
            }

            public void cleanup() {
                this.poolMetrics().cleanup();
            }
            {
                this.pool$1 = pool$1;
                this.poolMetrics = Metrics$.MODULE$.threadPool(name$2, (Map<String, String>)tags$2);
                this.taskCountSource = DifferentialSource$.MODULE$.apply((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anon.3 $outer;

                    public final long apply() {
                        return this.apply$mcJ$sp();
                    }

                    public long apply$mcJ$sp() {
                        return this.$outer.pool$1.getTaskCount();
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
                this.completedTaskCountSource = DifferentialSource$.MODULE$.apply((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anon.3 $outer;

                    public final long apply() {
                        return this.apply$mcJ$sp();
                    }

                    public long apply$mcJ$sp() {
                        return this.$outer.pool$1.getCompletedTaskCount();
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }
        };
    }

    private Executors.ExecutorSampler forkJoinPoolSampler(String name, Map<String, String> tags, Executors.InstrumentedExecutorService<?> pool) {
        return new Executors.ExecutorSampler(name, tags, pool){
            private final Metrics.ForkJoinPoolMetrics poolMetrics;
            private final DifferentialSource taskCountSource;
            private final DifferentialSource completedTaskCountSource;
            public final Executors.InstrumentedExecutorService pool$2;

            private Metrics.ForkJoinPoolMetrics poolMetrics() {
                return this.poolMetrics;
            }

            private DifferentialSource taskCountSource() {
                return this.taskCountSource;
            }

            private DifferentialSource completedTaskCountSource() {
                return this.completedTaskCountSource;
            }

            public void sample() {
                this.poolMetrics().poolMax().set((long)this.pool$2.maxThreads());
                this.poolMetrics().poolMin().set((long)this.pool$2.minThreads());
                this.poolMetrics().parallelism().set((long)this.pool$2.parallelism());
                this.poolMetrics().poolSize().record((long)this.pool$2.poolSize());
                this.poolMetrics().activeThreads().record((long)this.pool$2.activeThreads());
                this.poolMetrics().submittedTasks().increment(this.taskCountSource().get());
                this.poolMetrics().processedTasks().increment(this.completedTaskCountSource().get());
                this.poolMetrics().queuedTasks().record((long)this.pool$2.queuedTasks());
            }

            public void cleanup() {
                this.poolMetrics().cleanup();
            }
            {
                this.pool$2 = pool$2;
                this.poolMetrics = Metrics$.MODULE$.forkJoinPool(name$3, (Map<String, String>)tags$3);
                this.taskCountSource = DifferentialSource$.MODULE$.apply((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anon.4 $outer;

                    public final long apply() {
                        return this.apply$mcJ$sp();
                    }

                    public long apply$mcJ$sp() {
                        return this.$outer.pool$2.submittedTasks();
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
                this.completedTaskCountSource = DifferentialSource$.MODULE$.apply((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anon.4 $outer;

                    public final long apply() {
                        return this.apply$mcJ$sp();
                    }

                    public long apply$mcJ$sp() {
                        return this.$outer.pool$2.processedTasks();
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }
        };
    }

    private Runnable sampleTask(Executors.ExecutorSampler executorSampler) {
        return new Runnable(executorSampler){
            private final Executors.ExecutorSampler executorSampler$1;

            public void run() {
                this.executorSampler$1.sample();
            }
            {
                this.executorSampler$1 = executorSampler$1;
            }
        };
    }

    private Field delegatedExecutorField() {
        return this.delegatedExecutorField;
    }

    public ExecutorService unwrap(ExecutorService delegatedExecutor) {
        return (ExecutorService)this.delegatedExecutorField().get(delegatedExecutor);
    }

    public <A> Executors.PoolMetricsProvider<A> PoolMetricsProvider(A pool, Executors.ForkJoinPoolMetrics<A> evidence$2) {
        return new Executors.PoolMetricsProvider<A>(pool, evidence$2);
    }

    public ExecutorService instrument(ExecutorService inner) {
        Executors.InstrumentedExecutorService<ForkJoinPool> instrumentedExecutorService;
        Executors.InstrumentedExecutorService<ForkJoinPool> instrumentedExecutorService2 = inner;
        if (instrumentedExecutorService2 instanceof ForkJoinPool) {
            ForkJoinPool forkJoinPool = (ForkJoinPool)((Object)instrumentedExecutorService2);
            instrumentedExecutorService = new Executors.InstrumentedExecutorService<ForkJoinPool>(forkJoinPool, Executors$JavaFJPMetrics$.MODULE$);
        } else if (instrumentedExecutorService2 instanceof scala.concurrent.forkjoin.ForkJoinPool) {
            scala.concurrent.forkjoin.ForkJoinPool forkJoinPool = (scala.concurrent.forkjoin.ForkJoinPool)instrumentedExecutorService2;
            instrumentedExecutorService = new Executors.InstrumentedExecutorService<scala.concurrent.forkjoin.ForkJoinPool>(forkJoinPool, Executors$ScalaFJPMetrics$.MODULE$);
        } else {
            instrumentedExecutorService = inner;
        }
        return instrumentedExecutorService;
    }

    /*
     * WARNING - void declaration
     */
    private Executors$() {
        void var1_1;
        MODULE$ = this;
        this.kamon$executors$Executors$$logger = LoggerFactory.getLogger((String)"kamon.executors.Executors");
        this.DelegatedExecutor = Class.forName("java.util.concurrent.Executors$DelegatedExecutorService");
        this.FinalizableDelegated = Class.forName("java.util.concurrent.Executors$FinalizableDelegatedExecutorService");
        this.DelegateScheduled = Class.forName("java.util.concurrent.Executors$DelegatedScheduledExecutorService");
        this.JavaFJP = ForkJoinPool.class;
        this.ScalaFJP = scala.concurrent.forkjoin.ForkJoinPool.class;
        this.InstrumentedExecutor = Executors.InstrumentedExecutorService.class;
        this.fakeRegistration = new anon.1();
        Field field = this.DelegatedExecutor().getDeclaredField("e");
        field.setAccessible(true);
        this.delegatedExecutorField = var1_1;
    }
}

