/*
 * Decompiled with CFR 0.152.
 */
package kamon.executors.instrumentation;

import java.io.Serializable;
import java.util.Collection;
import java.util.concurrent.Callable;
import kamon.Kamon;
import kamon.context.Context;
import kamon.context.Storage;
import kamon.executors.instrumentation.ExecutorsInstrumentationAdvisors;
import kanela.agent.api.instrumentation.KanelaInstrumentation;
import kanela.agent.bootstrap.context.ContextHandler;
import kanela.agent.bootstrap.context.ContextProvider;
import kanela.agent.libs.io.vavr.Function1;
import kanela.agent.libs.net.bytebuddy.matcher.ElementMatcher;

public final class ExecutorInstrumentation
extends KanelaInstrumentation {
    public ExecutorInstrumentation() {
        ContextHandler.setContexProvider((ContextProvider)new KamonContextProvider());
        this.forSubtypeOf(() -> "java.util.concurrent.Executor", (Function1 & Serializable)builder -> builder.withAdvisorFor(this.method("execute").and((ElementMatcher)this.withArgument(Runnable.class)), () -> ExecutorsInstrumentationAdvisors.RunnableWrapperAdvisor.class).build());
        this.forSubtypeOf(() -> "java.util.concurrent.ExecutorService", (Function1 & Serializable)builder -> builder.withAdvisorFor(this.method("submit").and((ElementMatcher)this.withArgument(Runnable.class)), () -> ExecutorsInstrumentationAdvisors.RunnableWrapperAdvisor.class).withAdvisorFor(this.method("submit").and((ElementMatcher)this.withArgument(Callable.class)), () -> ExecutorsInstrumentationAdvisors.CallableWrapperAdvisor.class).withAdvisorFor(this.anyMethods(new String[]{"invokeAny", "invokeAll"}).and((ElementMatcher)this.withArgument(Collection.class)), () -> ExecutorsInstrumentationAdvisors.CallableCollectionWrapperAdvisor.class).build());
    }

    private static class KamonContextProvider
    implements ContextProvider {
        private KamonContextProvider() {
        }

        public Runnable wrapInContextAware(Runnable runnable) {
            return new ContextAwareRunnable(runnable);
        }

        public <A> Callable wrapInContextAware(Callable<A> callable) {
            return new ContextAwareCallable<A>(callable);
        }
    }

    private static class ContextAwareCallable<A>
    implements Callable<A> {
        private final Callable<A> underlying;
        private final Context context = Kamon.currentContext();

        ContextAwareCallable(Callable<A> callable) {
            this.underlying = callable;
        }

        @Override
        public A call() throws Exception {
            try (Storage.Scope scope = Kamon.storeContext((Context)this.context);){
                A a = this.underlying.call();
                return a;
            }
        }
    }

    private static class ContextAwareRunnable
    implements Runnable {
        private final Runnable underlying;
        private final Context context = Kamon.currentContext();

        ContextAwareRunnable(Runnable runnable) {
            this.underlying = runnable;
        }

        @Override
        public void run() {
            try (Storage.Scope scope = Kamon.storeContext((Context)this.context);){
                this.underlying.run();
            }
        }
    }
}

