/*
 * Decompiled with CFR 0.152.
 */
package kamon.fluentd;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.ExtendedActorSystem;
import akka.actor.Props$;
import akka.event.LogSource$;
import akka.event.Logging$;
import akka.event.LoggingAdapter;
import com.typesafe.config.Config;
import java.io.Serializable;
import kamon.Kamon;
import kamon.Kamon$;
import kamon.fluentd.FluentdMetricsSender;
import kamon.fluentd.HistogramStatsConfig;
import kamon.metric.TickMetricSnapshotBuffer$;
import kamon.util.ConfigTools;
import kamon.util.ConfigTools$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\rb\u0001B\u0001\u0003\u0001\u001d\u0011\u0001C\u00127vK:$H-\u0012=uK:\u001c\u0018n\u001c8\u000b\u0005\r!\u0011a\u00024mk\u0016tG\u000f\u001a\u0006\u0002\u000b\u0005)1.Y7p]\u000e\u00011c\u0001\u0001\t\u001dA\u0011\u0011\u0002D\u0007\u0002\u0015)\t1\"A\u0003tG\u0006d\u0017-\u0003\u0002\u000e\u0015\t1\u0011I\\=SK\u001a\u0004\"aD\n\u000f\u0005A\tR\"\u0001\u0003\n\u0005I!\u0011!B&b[>t\u0017B\u0001\u000b\u0016\u0005%)\u0005\u0010^3og&|gN\u0003\u0002\u0013\t!Aq\u0003\u0001B\u0001B\u0003%\u0001$\u0001\u0004tsN$X-\u001c\t\u00033yi\u0011A\u0007\u0006\u00037q\tQ!Y2u_JT\u0011!H\u0001\u0005C.\\\u0017-\u0003\u0002 5\t\u0019R\t\u001f;f]\u0012,G-Q2u_J\u001c\u0016p\u001d;f[\")\u0011\u0005\u0001C\u0001E\u00051A(\u001b8jiz\"\"aI\u0013\u0011\u0005\u0011\u0002Q\"\u0001\u0002\t\u000b]\u0001\u0003\u0019\u0001\r\t\u000f\u001d\u0002!\u0019!C\u0005Q\u0005ia\r\\;f]R$7i\u001c8gS\u001e,\u0012!\u000b\t\u0003UEj\u0011a\u000b\u0006\u0003Y5\naaY8oM&<'B\u0001\u00180\u0003!!\u0018\u0010]3tC\u001a,'\"\u0001\u0019\u0002\u0007\r|W.\u0003\u00023W\t11i\u001c8gS\u001eDa\u0001\u000e\u0001!\u0002\u0013I\u0013A\u00044mk\u0016tG\u000fZ\"p]\u001aLw\r\t\u0005\bm\u0001\u0011\r\u0011\"\u00018\u0003\u0011Awn\u001d;\u0016\u0003a\u0002\"!\u000f \u000e\u0003iR!a\u000f\u001f\u0002\t1\fgn\u001a\u0006\u0002{\u0005!!.\u0019<b\u0013\ty$H\u0001\u0004TiJLgn\u001a\u0005\u0007\u0003\u0002\u0001\u000b\u0011\u0002\u001d\u0002\u000b!|7\u000f\u001e\u0011\t\u000f\r\u0003!\u0019!C\u0001\t\u0006!\u0001o\u001c:u+\u0005)\u0005CA\u0005G\u0013\t9%BA\u0002J]RDa!\u0013\u0001!\u0002\u0013)\u0015!\u00029peR\u0004\u0003bB&\u0001\u0005\u0004%\taN\u0001\u0004i\u0006<\u0007BB'\u0001A\u0003%\u0001(\u0001\u0003uC\u001e\u0004\u0003bB(\u0001\u0005\u0004%\t\u0001U\u0001\u000eM2,8\u000f[%oi\u0016\u0014h/\u00197\u0016\u0003E\u0003\"AU,\u000e\u0003MS!\u0001V+\u0002\u0011\u0011,(/\u0019;j_:T!A\u0016\u0006\u0002\u0015\r|gnY;se\u0016tG/\u0003\u0002Y'\nqa)\u001b8ji\u0016$UO]1uS>t\u0007B\u0002.\u0001A\u0003%\u0011+\u0001\bgYV\u001c\b.\u00138uKJ4\u0018\r\u001c\u0011\t\u000fq\u0003!\u0019!C\u0001!\u0006aA/[2l\u0013:$XM\u001d<bY\"1a\f\u0001Q\u0001\nE\u000bQ\u0002^5dW&sG/\u001a:wC2\u0004\u0003b\u00021\u0001\u0005\u0004%\t\u0001K\u0001\u000egV\u00147o\u0019:jaRLwN\\:\t\r\t\u0004\u0001\u0015!\u0003*\u00039\u0019XOY:de&\u0004H/[8og\u0002Bq\u0001\u001a\u0001C\u0002\u0013\u0005Q-\u0001\u000biSN$xn\u001a:b[N#\u0018\r^:D_:4\u0017nZ\u000b\u0002MB\u0011AeZ\u0005\u0003Q\n\u0011A\u0003S5ti><'/Y7Ti\u0006$8oQ8oM&<\u0007B\u00026\u0001A\u0003%a-A\u000biSN$xn\u001a:b[N#\u0018\r^:D_:4\u0017n\u001a\u0011\t\u000f1\u0004!\u0019!C\u0001[\u0006\u0019An\\4\u0016\u00039\u0004\"a\u001c:\u000e\u0003AT!!\u001d\u000f\u0002\u000b\u00154XM\u001c;\n\u0005M\u0004(A\u0004'pO\u001eLgnZ!eCB$XM\u001d\u0005\u0007k\u0002\u0001\u000b\u0011\u00028\u0002\t1|w\r\t\u0005\bo\u0002\u0011\r\u0011\"\u0001y\u0003)\u0019XOY:de&\u0014WM]\u000b\u0002sB\u0011\u0011D_\u0005\u0003wj\u0011\u0001\"Q2u_J\u0014VM\u001a\u0005\u0007{\u0002\u0001\u000b\u0011B=\u0002\u0017M,(m]2sS\n,'\u000f\t\u0005\u0007\u007f\u0002!\t!!\u0001\u0002)\t,\u0018\u000e\u001c3NKR\u0014\u0018nY:MSN$XM\\3s)5I\u00181AA\u0003\u0003\u000f\ti\"a\b\u0002\"!)qJ a\u0001#\")AL a\u0001#\"11J a\u0001\u0003\u0013\u0001B!a\u0003\u0002\u001a9!\u0011QBA\u000b!\r\tyAC\u0007\u0003\u0003#Q1!a\u0005\u0007\u0003\u0019a$o\\8u}%\u0019\u0011q\u0003\u0006\u0002\rA\u0013X\rZ3g\u0013\ry\u00141\u0004\u0006\u0004\u0003/Q\u0001B\u0002\u001c\u007f\u0001\u0004\tI\u0001C\u0003D}\u0002\u0007Q\tC\u0003e}\u0002\u0007a\r")
public class FluentdExtension
implements Kamon.Extension {
    private final ExtendedActorSystem system;
    private final Config fluentdConfig;
    private final String host;
    private final int port;
    private final String tag;
    private final FiniteDuration flushInterval;
    private final FiniteDuration tickInterval;
    private final Config subscriptions;
    private final HistogramStatsConfig histogramStatsConfig;
    private final LoggingAdapter log;
    private final ActorRef subscriber;

    private Config fluentdConfig() {
        return this.fluentdConfig;
    }

    public String host() {
        return this.host;
    }

    public int port() {
        return this.port;
    }

    public String tag() {
        return this.tag;
    }

    public FiniteDuration flushInterval() {
        return this.flushInterval;
    }

    public FiniteDuration tickInterval() {
        return this.tickInterval;
    }

    public Config subscriptions() {
        return this.subscriptions;
    }

    public HistogramStatsConfig histogramStatsConfig() {
        return this.histogramStatsConfig;
    }

    public LoggingAdapter log() {
        return this.log;
    }

    public ActorRef subscriber() {
        return this.subscriber;
    }

    public ActorRef buildMetricsListener(FiniteDuration flushInterval, FiniteDuration tickInterval, String tag, String host, int port, HistogramStatsConfig histogramStatsConfig) {
        Predef$.MODULE$.assert(flushInterval.$greater$eq((Object)tickInterval), (Function0 & Serializable & scala.Serializable)() -> "Fluentd flush-interval needs to be equal or greater to the tick-interval");
        ActorRef metricsSender = this.system.actorOf(Props$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> new FluentdMetricsSender(tag, host, port, histogramStatsConfig), ClassTag$.MODULE$.apply(FluentdMetricsSender.class)), "kamon-fluentd");
        FiniteDuration finiteDuration = flushInterval;
        FiniteDuration finiteDuration2 = tickInterval;
        return !(finiteDuration != null ? !finiteDuration.equals(finiteDuration2) : finiteDuration2 != null) ? metricsSender : this.system.actorOf(TickMetricSnapshotBuffer$.MODULE$.props(flushInterval, metricsSender), "kamon-fluentd-buffer");
    }

    public static final /* synthetic */ void $anonfun$new$2(FluentdExtension $this, String subscriptionCategory$1, String pattern) {
        Kamon$.MODULE$.metrics().subscribe(subscriptionCategory$1, pattern, $this.subscriber(), true);
    }

    public static final /* synthetic */ void $anonfun$new$1(FluentdExtension $this, String subscriptionCategory) {
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter($this.subscriptions().getStringList(subscriptionCategory)).asScala()).foreach((Function1 & Serializable & scala.Serializable)pattern -> {
            FluentdExtension.$anonfun$new$2($this, subscriptionCategory, pattern);
            return BoxedUnit.UNIT;
        });
    }

    public FluentdExtension(ExtendedActorSystem system) {
        this.system = system;
        this.fluentdConfig = system.settings().config().getConfig("kamon.fluentd");
        this.host = this.fluentdConfig().getString("hostname");
        this.port = this.fluentdConfig().getInt("port");
        this.tag = this.fluentdConfig().getString("tag");
        this.flushInterval = ConfigTools.Syntax$.MODULE$.getFiniteDuration$extension(ConfigTools$.MODULE$.Syntax(this.fluentdConfig()), "flush-interval");
        this.tickInterval = Kamon$.MODULE$.metrics().settings().tickInterval();
        this.subscriptions = this.fluentdConfig().getConfig("subscriptions");
        this.histogramStatsConfig = new HistogramStatsConfig((List<String>)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(this.fluentdConfig().getStringList("histogram-stats.subscription")).asScala()).toList(), (List<Object>)((List)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(this.fluentdConfig().getDoubleList("histogram-stats.percentiles")).asScala()).toList().map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToDouble((double)Predef$.MODULE$.Double2double(x$1)), List$.MODULE$.canBuildFrom())));
        this.log = Logging$.MODULE$.apply((ActorSystem)system, FluentdExtension.class, LogSource$.MODULE$.fromAnyClass());
        this.log().info("Starting the Kamon(Fluentd) extension");
        this.subscriber = this.buildMetricsListener(this.flushInterval(), this.tickInterval(), this.tag(), this.host(), this.port(), this.histogramStatsConfig());
        ConfigTools.Syntax$.MODULE$.firstLevelKeys$extension(ConfigTools$.MODULE$.Syntax(this.subscriptions())).foreach((Function1 & Serializable & scala.Serializable)subscriptionCategory -> {
            FluentdExtension.$anonfun$new$1(this, subscriptionCategory);
            return BoxedUnit.UNIT;
        });
    }
}

