/*
 * Decompiled with CFR 0.152.
 */
package kamon.graphite;

import kamon.graphite.GraphiteSender$;
import kamon.graphite.GraphiteSenderConfig;
import kamon.graphite.MetricPacketBuilder;
import kamon.graphite.Sender;
import kamon.metric.Distribution;
import kamon.metric.MetricDistribution;
import kamon.metric.MetricValue;
import kamon.metric.PeriodSnapshot;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001%3Q!\u0001\u0002\u0002\n\u001d\u0011ab\u0012:ba\"LG/Z*f]\u0012,'O\u0003\u0002\u0004\t\u0005AqM]1qQ&$XMC\u0001\u0006\u0003\u0015Y\u0017-\\8o\u0007\u0001\u00192\u0001\u0001\u0005\u0011!\tIa\"D\u0001\u000b\u0015\tYA\"\u0001\u0003mC:<'\"A\u0007\u0002\t)\fg/Y\u0005\u0003\u001f)\u0011aa\u00142kK\u000e$\bCA\t\u0013\u001b\u0005\u0011\u0011BA\n\u0003\u0005\u0019\u0019VM\u001c3fe\"AQ\u0003\u0001BC\u0002\u0013\u0005a#\u0001\u0007tK:$WM]\"p]\u001aLw-F\u0001\u0018!\t\t\u0002$\u0003\u0002\u001a\u0005\t!rI]1qQ&$XmU3oI\u0016\u00148i\u001c8gS\u001eD\u0001b\u0007\u0001\u0003\u0002\u0003\u0006IaF\u0001\u000eg\u0016tG-\u001a:D_:4\u0017n\u001a\u0011\t\u000bu\u0001A\u0011\u0001\u0010\u0002\rqJg.\u001b;?)\ty\u0002\u0005\u0005\u0002\u0012\u0001!)Q\u0003\ba\u0001/!9!\u0005\u0001b\u0001\n\u0003\u0019\u0013a\u00017pOV\tA\u0005\u0005\u0002&U5\taE\u0003\u0002(Q\u0005)1\u000f\u001c45U*\t\u0011&A\u0002pe\u001eL!a\u000b\u0014\u0003\r1{wmZ3s\u0011\u0019i\u0003\u0001)A\u0005I\u0005!An\\4!\u0011\u0015y\u0003\u0001\"\u00011\u0003Q\u0011X\r]8siB+'/[8e':\f\u0007o\u001d5piR\u0011\u0011g\u000e\t\u0003eUj\u0011a\r\u0006\u0002i\u0005)1oY1mC&\u0011ag\r\u0002\u0005+:LG\u000fC\u00039]\u0001\u0007\u0011(\u0001\u0005t]\u0006\u00048\u000f[8u!\tQT(D\u0001<\u0015\taD!\u0001\u0004nKR\u0014\u0018nY\u0005\u0003}m\u0012a\u0002U3sS>$7K\\1qg\"|G\u000fC\u0003A\u0001\u0011%\u0011)A\u0004bm\u0016\u0014\u0018mZ3\u0015\u0007\t+u\t\u0005\u00023\u0007&\u0011Ai\r\u0002\u0005\u0019>tw\rC\u0003G\u007f\u0001\u0007!)A\u0002tk6DQ\u0001S A\u0002\t\u000bQaY8v]R\u0004")
public abstract class GraphiteSender
implements Sender {
    private final GraphiteSenderConfig senderConfig;
    private final Logger log;

    @Override
    public GraphiteSenderConfig senderConfig() {
        return this.senderConfig;
    }

    @Override
    public Logger log() {
        return this.log;
    }

    public void reportPeriodSnapshot(PeriodSnapshot snapshot) {
        this.log().debug("sending metrics for interval '{}->{}' to {}", new Object[]{snapshot.from(), snapshot.to(), this.senderConfig()});
        long timestamp = snapshot.to().getEpochSecond();
        MetricPacketBuilder packetBuilder = new MetricPacketBuilder(this.senderConfig().metricPrefix(), timestamp, this.senderConfig());
        snapshot.metrics().counters().foreach((Function1)new Serializable(this, packetBuilder){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GraphiteSender $outer;
            private final MetricPacketBuilder packetBuilder$1;

            public final void apply(MetricValue metric) {
                this.$outer.write(this.packetBuilder$1.build(metric.name(), "count", metric.value(), (Map<String, String>)metric.tags()));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.packetBuilder$1 = packetBuilder$1;
            }
        });
        snapshot.metrics().gauges().foreach((Function1)new Serializable(this, packetBuilder){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GraphiteSender $outer;
            private final MetricPacketBuilder packetBuilder$1;

            public final void apply(MetricValue metric) {
                this.$outer.write(this.packetBuilder$1.build(metric.name(), "value", metric.value(), (Map<String, String>)metric.tags()));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.packetBuilder$1 = packetBuilder$1;
            }
        });
        ((IterableLike)snapshot.metrics().histograms().$plus$plus((GenTraversableOnce)snapshot.metrics().rangeSamplers(), Seq$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(this, packetBuilder){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GraphiteSender $outer;
            public final MetricPacketBuilder packetBuilder$1;

            public final void apply(MetricDistribution metric) {
                Distribution distribution = metric.distribution();
                this.$outer.write(this.packetBuilder$1.build(metric.name(), "count", distribution.count(), (Map<String, String>)metric.tags()));
                this.$outer.write(this.packetBuilder$1.build(metric.name(), "min", distribution.min(), (Map<String, String>)metric.tags()));
                this.$outer.write(this.packetBuilder$1.build(metric.name(), "max", distribution.max(), (Map<String, String>)metric.tags()));
                this.$outer.senderConfig().percentiles().foreach((Function1)new Serializable(this, metric, distribution){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$reportPeriodSnapshot$3 $outer;
                    private final MetricDistribution metric$1;
                    private final Distribution distribution$1;

                    public final void apply(double p) {
                        this.apply$mcVD$sp(p);
                    }

                    public void apply$mcVD$sp(double p) {
                        this.$outer.kamon$graphite$GraphiteSender$$anonfun$$$outer().write(this.$outer.packetBuilder$1.build(this.metric$1.name(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"p", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)p)})), this.distribution$1.percentile(p).value(), (Map<String, String>)this.metric$1.tags()));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.metric$1 = metric$1;
                        this.distribution$1 = distribution$1;
                    }
                });
                this.$outer.write(this.packetBuilder$1.build(metric.name(), "average", this.$outer.kamon$graphite$GraphiteSender$$average(distribution.sum(), distribution.count()), (Map<String, String>)metric.tags()));
                this.$outer.write(this.packetBuilder$1.build(metric.name(), "sum", distribution.sum(), (Map<String, String>)metric.tags()));
            }

            public /* synthetic */ GraphiteSender kamon$graphite$GraphiteSender$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.packetBuilder$1 = packetBuilder$1;
            }
        });
        this.flush();
    }

    public long kamon$graphite$GraphiteSender$$average(long sum, long count) {
        return count > 0L ? sum / count : 0L;
    }

    public GraphiteSender(GraphiteSenderConfig senderConfig) {
        this.senderConfig = senderConfig;
        this.log = LoggerFactory.getLogger(GraphiteSender.class);
    }
}

