/*
 * Decompiled with CFR 0.152.
 */
package kamon.graphite;

import java.io.Serializable;
import java.nio.charset.Charset;
import kamon.graphite.GraphiteSender$;
import kamon.graphite.GraphiteSenderConfig;
import kamon.graphite.MetricPacketBuilder;
import kamon.graphite.Sender;
import kamon.metric.Distribution;
import kamon.metric.Instrument;
import kamon.metric.MetricSnapshot;
import kamon.metric.PeriodSnapshot;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u00014a!\u0004\b\u0002\u00029\u0011\u0002\u0002C\u0010\u0001\u0005\u000b\u0007I\u0011A\u0011\t\u0011\u0015\u0002!\u0011!Q\u0001\n\tBQA\n\u0001\u0005\u0002\u001dBqA\u000b\u0001C\u0002\u0013\u00051\u0006\u0003\u00045\u0001\u0001\u0006I\u0001\f\u0005\u0006k\u0001!\tA\u000e\u0005\u0006\u000b\u0002!IAR\u0004\u0006\u001d:A\ta\u0014\u0004\u0006\u001b9A\t\u0001\u0015\u0005\u0006M%!\t\u0001\u0016\u0005\b+&\u0011\r\u0011\"\u0002W\u0011\u0019y\u0016\u0002)A\u0007/\nqqI]1qQ&$XmU3oI\u0016\u0014(BA\b\u0011\u0003!9'/\u00199iSR,'\"A\t\u0002\u000b-\fWn\u001c8\u0014\u0007\u0001\u00192\u0004\u0005\u0002\u001535\tQC\u0003\u0002\u0017/\u0005!A.\u00198h\u0015\u0005A\u0012\u0001\u00026bm\u0006L!AG\u000b\u0003\r=\u0013'.Z2u!\taR$D\u0001\u000f\u0013\tqbB\u0001\u0004TK:$WM]\u0001\rg\u0016tG-\u001a:D_:4\u0017nZ\u0002\u0001+\u0005\u0011\u0003C\u0001\u000f$\u0013\t!cB\u0001\u000bHe\u0006\u0004\b.\u001b;f'\u0016tG-\u001a:D_:4\u0017nZ\u0001\u000eg\u0016tG-\u001a:D_:4\u0017n\u001a\u0011\u0002\rqJg.\u001b;?)\tA\u0013\u0006\u0005\u0002\u001d\u0001!)qd\u0001a\u0001E\u0005\u0019An\\4\u0016\u00031\u0002\"!\f\u001a\u000e\u00039R!a\f\u0019\u0002\u000bMdg\r\u000e6\u000b\u0003E\n1a\u001c:h\u0013\t\u0019dF\u0001\u0004M_\u001e<WM]\u0001\u0005Y><\u0007%\u0001\u000bsKB|'\u000f\u001e)fe&|Gm\u00158baNDw\u000e\u001e\u000b\u0003ou\u0002\"\u0001O\u001e\u000e\u0003eR\u0011AO\u0001\u0006g\u000e\fG.Y\u0005\u0003ye\u0012A!\u00168ji\")aH\u0002a\u0001\u007f\u0005A1O\\1qg\"|G\u000f\u0005\u0002A\u00076\t\u0011I\u0003\u0002C!\u00051Q.\u001a;sS\u000eL!\u0001R!\u0003\u001dA+'/[8e':\f\u0007o\u001d5pi\u00069\u0011M^3sC\u001e,GcA$K\u0019B\u0011\u0001\bS\u0005\u0003\u0013f\u0012A\u0001T8oO\")1j\u0002a\u0001\u000f\u0006\u00191/^7\t\u000b5;\u0001\u0019A$\u0002\u000b\r|WO\u001c;\u0002\u001d\u001d\u0013\u0018\r\u001d5ji\u0016\u001cVM\u001c3feB\u0011A$C\n\u0003\u0013E\u0003\"\u0001\u000f*\n\u0005MK$AB!osJ+g\rF\u0001P\u0003A9%/\u00199iSR,WI\\2pI&tw-F\u0001X!\tAV,D\u0001Z\u0015\tQ6,A\u0004dQ\u0006\u00148/\u001a;\u000b\u0005q;\u0012a\u00018j_&\u0011a,\u0017\u0002\b\u0007\"\f'o]3u\u0003E9%/\u00199iSR,WI\\2pI&tw\r\t")
public abstract class GraphiteSender
implements Sender {
    private final GraphiteSenderConfig senderConfig;
    private final Logger log;

    public static Charset GraphiteEncoding() {
        return GraphiteSender$.MODULE$.GraphiteEncoding();
    }

    @Override
    public GraphiteSenderConfig senderConfig() {
        return this.senderConfig;
    }

    @Override
    public Logger log() {
        return this.log;
    }

    public void reportPeriodSnapshot(PeriodSnapshot snapshot) {
        this.log().debug("sending metrics for interval '{}->{}' to {}", new Object[]{snapshot.from(), snapshot.to(), this.senderConfig()});
        long timestamp = snapshot.to().getEpochSecond();
        MetricPacketBuilder packetBuilder = new MetricPacketBuilder(this.senderConfig().metricPrefix(), timestamp, this.senderConfig());
        snapshot.counters().foreach((Function1 & Serializable)metric -> {
            GraphiteSender.$anonfun$reportPeriodSnapshot$1(this, packetBuilder, metric);
            return BoxedUnit.UNIT;
        });
        snapshot.gauges().foreach((Function1 & Serializable)metric -> {
            GraphiteSender.$anonfun$reportPeriodSnapshot$3(this, packetBuilder, metric);
            return BoxedUnit.UNIT;
        });
        ((IterableOnceOps)((IterableOps)snapshot.histograms().$plus$plus((IterableOnce)snapshot.rangeSamplers())).$plus$plus((IterableOnce)snapshot.timers())).foreach((Function1 & Serializable)metric -> {
            GraphiteSender.$anonfun$reportPeriodSnapshot$5(this, packetBuilder, metric);
            return BoxedUnit.UNIT;
        });
        this.flush();
    }

    private long average(long sum, long count) {
        return count > 0L ? sum / count : 0L;
    }

    public static final /* synthetic */ void $anonfun$reportPeriodSnapshot$1(GraphiteSender $this, MetricPacketBuilder packetBuilder$1, MetricSnapshot metric) {
        metric.instruments().foreach((Function1 & Serializable)instrument -> {
            $this.write(packetBuilder$1.build(metric.name(), "count", BoxesRunTime.unboxToLong((Object)instrument.value()), instrument.tags()));
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$reportPeriodSnapshot$3(GraphiteSender $this, MetricPacketBuilder packetBuilder$1, MetricSnapshot metric) {
        metric.instruments().foreach((Function1 & Serializable)instrument -> {
            $this.write(packetBuilder$1.build(metric.name(), "value", BoxesRunTime.unboxToDouble((Object)instrument.value()), instrument.tags()));
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$reportPeriodSnapshot$6(GraphiteSender $this, MetricPacketBuilder packetBuilder$1, MetricSnapshot metric$3, Instrument.Snapshot instrument) {
        $this.write(packetBuilder$1.build(metric$3.name(), "count", ((Distribution)instrument.value()).count(), instrument.tags()));
        $this.write(packetBuilder$1.build(metric$3.name(), "min", ((Distribution)instrument.value()).min(), instrument.tags()));
        $this.write(packetBuilder$1.build(metric$3.name(), "max", ((Distribution)instrument.value()).max(), instrument.tags()));
        $this.senderConfig().percentiles().foreach((Function1)(JFunction1.mcVD.sp & Serializable)p -> $this.write(packetBuilder$1.build(metric$3.name(), new StringBuilder(1).append("p").append(p).toString(), ((Distribution)instrument.value()).percentile(p).value(), instrument.tags())));
        $this.write(packetBuilder$1.build(metric$3.name(), "average", $this.average(((Distribution)instrument.value()).sum(), ((Distribution)instrument.value()).count()), instrument.tags()));
        $this.write(packetBuilder$1.build(metric$3.name(), "sum", ((Distribution)instrument.value()).sum(), instrument.tags()));
    }

    public static final /* synthetic */ void $anonfun$reportPeriodSnapshot$5(GraphiteSender $this, MetricPacketBuilder packetBuilder$1, MetricSnapshot metric) {
        metric.instruments().foreach((Function1 & Serializable)instrument -> {
            GraphiteSender.$anonfun$reportPeriodSnapshot$6($this, packetBuilder$1, metric, instrument);
            return BoxedUnit.UNIT;
        });
    }

    public GraphiteSender(GraphiteSenderConfig senderConfig) {
        this.senderConfig = senderConfig;
        this.log = LoggerFactory.getLogger(GraphiteSender.class);
    }
}

