/*
 * Decompiled with CFR 0.152.
 */
package kamon.graphite;

import com.typesafe.config.Config;
import java.io.Serializable;
import kamon.Kamon$;
import kamon.graphite.GraphiteSenderConfig;
import kamon.tag.TagSet;
import kamon.util.EnvironmentTags$;
import kamon.util.Filter;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple7;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.JavaConverters$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;

public final class GraphiteSenderConfig$
implements Serializable {
    public static final GraphiteSenderConfig$ MODULE$ = new GraphiteSenderConfig$();

    public GraphiteSenderConfig apply(Config config) {
        Config graphiteConfig = config.getConfig("kamon.graphite");
        String hostname = graphiteConfig.getString("hostname");
        int port = graphiteConfig.getInt("port");
        String metricPrefix = graphiteConfig.getString("metric-name-prefix");
        boolean legacySupport = graphiteConfig.getBoolean("legacy-support");
        TagSet envTags = EnvironmentTags$.MODULE$.from(Kamon$.MODULE$.environment(), graphiteConfig.getConfig("environment-tags"));
        Filter tagFilter = Kamon$.MODULE$.filter("kamon.graphite.tag-filter");
        Seq percentiles = ((IterableOnceOps)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(graphiteConfig.getDoubleList("percentiles")).asScala()).map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToDouble((double)Predef$.MODULE$.Double2double(x$1)))).toSeq();
        return new GraphiteSenderConfig(hostname, port, metricPrefix, legacySupport, envTags, tagFilter, (Seq<Object>)percentiles);
    }

    public GraphiteSenderConfig apply(String hostname, int port, String metricPrefix, boolean legacySupport, TagSet envTags, Filter tagFilter, Seq<Object> percentiles) {
        return new GraphiteSenderConfig(hostname, port, metricPrefix, legacySupport, envTags, tagFilter, percentiles);
    }

    public Option<Tuple7<String, Object, String, Object, TagSet, Filter, Seq<Object>>> unapply(GraphiteSenderConfig x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple7((Object)x$0.hostname(), (Object)BoxesRunTime.boxToInteger((int)x$0.port()), (Object)x$0.metricPrefix(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.legacySupport()), (Object)x$0.envTags(), (Object)x$0.tagFilter(), x$0.percentiles()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(GraphiteSenderConfig$.class);
    }

    private GraphiteSenderConfig$() {
    }
}

