/*
 * Decompiled with CFR 0.152.
 */
package kamon.graphite;

import java.io.Serializable;
import kamon.graphite.GraphiteSender$;
import kamon.graphite.GraphiteSenderConfig;
import kamon.tag.Tag$;
import kamon.tag.TagSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005ua\u0001\u0002\u000b\u0016\tiA\u0001\"\t\u0001\u0003\u0002\u0003\u0006IA\t\u0005\t[\u0001\u0011\t\u0011)A\u0005]!A\u0011\u0007\u0001B\u0001B\u0003%!\u0007C\u00037\u0001\u0011\u0005q\u0007C\u0004=\u0001\t\u0007I\u0011B\u001f\t\r\u0019\u0003\u0001\u0015!\u0003?\u0011\u001d9\u0005A1A\u0005\n!Ca!\u0015\u0001!\u0002\u0013I\u0005b\u0002*\u0001\u0005\u0004%Ia\u0015\u0005\u0007/\u0002\u0001\u000b\u0011\u0002+\t\u000fa\u0003!\u0019!C\u0005'\"1\u0011\f\u0001Q\u0001\nQCqA\u0017\u0001C\u0002\u0013%1\f\u0003\u0004e\u0001\u0001\u0006I\u0001\u0018\u0005\u0006K\u0002!\tA\u001a\u0005\u0006K\u0002!\ta\u001f\u0005\u0007K\u0002!\t!a\u0002\t\u000f\u0005E\u0001\u0001\"\u0003\u0002\u0014!9\u0011q\u0003\u0001\u0005\n\u0005e!aE'fiJL7\rU1dW\u0016$()^5mI\u0016\u0014(B\u0001\f\u0018\u0003!9'/\u00199iSR,'\"\u0001\r\u0002\u000b-\fWn\u001c8\u0004\u0001M\u0011\u0001a\u0007\t\u00039}i\u0011!\b\u0006\u0002=\u0005)1oY1mC&\u0011\u0001%\b\u0002\u0007\u0003:L(+\u001a4\u0002\u0011\t\f7/\u001a(b[\u0016\u0004\"a\t\u0016\u000f\u0005\u0011B\u0003CA\u0013\u001e\u001b\u00051#BA\u0014\u001a\u0003\u0019a$o\\8u}%\u0011\u0011&H\u0001\u0007!J,G-\u001a4\n\u0005-b#AB*ue&twM\u0003\u0002*;\u0005IA/[7fgR\fW\u000e\u001d\t\u00039=J!\u0001M\u000f\u0003\t1{gnZ\u0001\u0007G>tg-[4\u0011\u0005M\"T\"A\u000b\n\u0005U*\"\u0001F$sCBD\u0017\u000e^3TK:$WM]\"p]\u001aLw-\u0001\u0004=S:LGO\u0010\u000b\u0005qeR4\b\u0005\u00024\u0001!)\u0011\u0005\u0002a\u0001E!)Q\u0006\u0002a\u0001]!)\u0011\u0007\u0002a\u0001e\u0005\u0019An\\4\u0016\u0003y\u0002\"a\u0010#\u000e\u0003\u0001S!!\u0011\"\u0002\u000bMdg\r\u000e6\u000b\u0003\r\u000b1a\u001c:h\u0013\t)\u0005I\u0001\u0004M_\u001e<WM]\u0001\u0005Y><\u0007%A\u0004ck&dG-\u001a:\u0016\u0003%\u0003\"AS(\u000e\u0003-S!\u0001T'\u0002\t1\fgn\u001a\u0006\u0002\u001d\u0006!!.\u0019<b\u0013\t\u00016JA\u0007TiJLgn\u001a\"vS2$WM]\u0001\tEVLG\u000eZ3sA\u0005aA/Y4tKB,'/\u0019;peV\tA\u000b\u0005\u0002\u001d+&\u0011a+\b\u0002\u0005\u0007\"\f'/A\u0007uC\u001e\u001cX\r]3sCR|'\u000fI\u0001\u000fm\u0006dW/Z:fa\u0016\u0014\u0018\r^8s\u0003=1\u0018\r\\;fg\u0016\u0004XM]1u_J\u0004\u0013!\u0004:fg\u0016\u0014h/\u001a3DQ\u0006\u00148/F\u0001]!\ri&\rV\u0007\u0002=*\u0011q\fY\u0001\nS6lW\u000f^1cY\u0016T!!Y\u000f\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002d=\n\u00191+\u001a;\u0002\u001dI,7/\u001a:wK\u0012\u001c\u0005.\u0019:tA\u0005)!-^5mIR)q-\\8rgB\u0019A\u0004\u001b6\n\u0005%l\"!B!se\u0006L\bC\u0001\u000fl\u0013\taWD\u0001\u0003CsR,\u0007\"\u00028\u0010\u0001\u0004\u0011\u0013AC7fiJL7MT1nK\")\u0001o\u0004a\u0001E\u0005QQ.\u001a;sS\u000e$\u0016\u0010]3\t\u000bI|\u0001\u0019\u0001\u0018\u0002\u000bY\fG.^3\t\u000bQ|\u0001\u0019A;\u0002\u00155,GO]5d)\u0006<7\u000f\u0005\u0002ws6\tqO\u0003\u0002y/\u0005\u0019A/Y4\n\u0005i<(A\u0002+bON+G\u000f\u0006\u0004hyvt\u0018Q\u0001\u0005\u0006]B\u0001\rA\t\u0005\u0006aB\u0001\rA\t\u0005\u0006eB\u0001\ra \t\u00049\u0005\u0005\u0011bAA\u0002;\t1Ai\\;cY\u0016DQ\u0001\u001e\tA\u0002U$\u0012bZA\u0005\u0003\u0017\ti!a\u0004\t\u000b9\f\u0002\u0019\u0001\u0012\t\u000bA\f\u0002\u0019\u0001\u0012\t\u000bI\f\u0002\u0019\u0001\u0012\t\u000bQ\f\u0002\u0019A;\u0002\u0011M\fg.\u001b;ju\u0016$2AIA\u000b\u0011\u0015\u0011(\u00031\u0001#\u0003-\u0019\u0018M\\5uSj,G+Y4\u0015\u0007\t\nY\u0002C\u0003s'\u0001\u0007!\u0005")
public class MetricPacketBuilder {
    private final String baseName;
    private final long timestamp;
    private final GraphiteSenderConfig config;
    private final Logger log;
    private final StringBuilder builder;
    private final char tagseperator;
    private final char valueseperator;
    private final Set<Object> reservedChars;

    private Logger log() {
        return this.log;
    }

    private StringBuilder builder() {
        return this.builder;
    }

    private char tagseperator() {
        return this.tagseperator;
    }

    private char valueseperator() {
        return this.valueseperator;
    }

    private Set<Object> reservedChars() {
        return this.reservedChars;
    }

    public byte[] build(String metricName, String metricType, long value, TagSet metricTags) {
        return this.build(metricName, metricType, Long.toString(value), metricTags);
    }

    public byte[] build(String metricName, String metricType, double value, TagSet metricTags) {
        return this.build(metricName, metricType, Double.toString(value), metricTags);
    }

    public byte[] build(String metricName, String metricType, String value, TagSet metricTags) {
        this.builder().setLength(0);
        this.builder().append(this.baseName).append(".").append(this.sanitize(metricName)).append(".").append(metricType);
        Seq allTags = metricTags.withTags(this.config.envTags()).all();
        allTags.foreach((Function1 & Serializable)tag -> $this.config.tagFilter().accept(tag.key()) ? this.builder().append(this.tagseperator()).append(this.sanitizeTag(tag.key())).append(this.valueseperator()).append(this.sanitizeTag(Tag$.MODULE$.unwrapValue(tag).toString())) : BoxedUnit.UNIT);
        this.builder().append(" ").append(value).append(" ").append(this.timestamp).append("\n");
        String packet = this.builder().toString();
        this.log().debug("built packet '{}'", (Object)packet);
        return packet.getBytes(GraphiteSender$.MODULE$.GraphiteEncoding());
    }

    private String sanitize(String value) {
        return value.replace('/', '_').replace('.', '_');
    }

    private String sanitizeTag(String value) {
        return StringOps$.MODULE$.map$extension(Predef$.MODULE$.augmentString(value), (Function1 & Serializable)c -> BoxesRunTime.boxToCharacter((char)MetricPacketBuilder.$anonfun$sanitizeTag$1(this, BoxesRunTime.unboxToChar((Object)c))));
    }

    public static final /* synthetic */ char $anonfun$sanitizeTag$1(MetricPacketBuilder $this, char c) {
        return $this.reservedChars().contains((Object)BoxesRunTime.boxToCharacter((char)c)) ? (char)'_' : (char)c;
    }

    public MetricPacketBuilder(String baseName, long timestamp, GraphiteSenderConfig config) {
        this.baseName = baseName;
        this.timestamp = timestamp;
        this.config = config;
        this.log = LoggerFactory.getLogger(MetricPacketBuilder.class);
        this.builder = new StringBuilder();
        this.tagseperator = (char)(config.legacySupport() ? 46 : 59);
        this.valueseperator = (char)(config.legacySupport() ? 46 : 61);
        this.reservedChars = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapCharArray(new char[]{' ', this.tagseperator(), this.valueseperator()}));
    }
}

