/*
 * Decompiled with CFR 0.152.
 */
package kamon.otel;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.api.trace.TraceFlags;
import io.opentelemetry.api.trace.TraceState;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.trace.data.EventData;
import io.opentelemetry.sdk.trace.data.LinkData;
import io.opentelemetry.sdk.trace.data.SpanData;
import io.opentelemetry.sdk.trace.data.StatusData;
import java.io.Serializable;
import java.time.Instant;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import kamon.otel.SpanWrapper;
import kamon.tag.Lookups$;
import kamon.tag.Tag;
import kamon.tag.TagSet;
import kamon.trace.Identifier;
import kamon.trace.Span;
import kamon.trace.Trace;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;

public final class SpanConverter$ {
    public static final SpanConverter$ MODULE$ = new SpanConverter$();

    public long toEpocNano(Instant instant) {
        return TimeUnit.NANOSECONDS.convert(instant.getEpochSecond(), TimeUnit.SECONDS) + (long)instant.getNano();
    }

    public SpanKind toKind(Span.Kind kind) {
        Span.Kind kind2 = kind;
        if (Span.Kind$.Client$.MODULE$.equals(kind2)) {
            return SpanKind.CLIENT;
        }
        if (Span.Kind$.Consumer$.MODULE$.equals(kind2)) {
            return SpanKind.CONSUMER;
        }
        if (Span.Kind$.Internal$.MODULE$.equals(kind2)) {
            return SpanKind.INTERNAL;
        }
        if (Span.Kind$.Producer$.MODULE$.equals(kind2)) {
            return SpanKind.PRODUCER;
        }
        if (Span.Kind$.Server$.MODULE$.equals(kind2)) {
            return SpanKind.SERVER;
        }
        return SpanKind.INTERNAL;
    }

    public TraceFlags getTraceFlags(boolean sample) {
        if (sample) {
            return TraceFlags.getSampled();
        }
        return TraceFlags.getDefault();
    }

    public SpanContext mkSpanContext(boolean sample, Identifier traceId, Identifier spanId) {
        String paddedTraceId = traceId.string().length() == 16 ? new StringBuilder(16).append("0000000000000000").append(traceId.string()).toString() : traceId.string();
        return SpanContext.create((String)paddedTraceId, (String)spanId.string(), (TraceFlags)this.getTraceFlags(sample), (TraceState)TraceState.getDefault());
    }

    public StatusData getStatus(Span.Finished span) {
        if (span.hasError()) {
            String msg = (String)((Option)span.tags().get(Lookups$.MODULE$.option(Span.TagKeys$.MODULE$.ErrorMessage()))).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
            return StatusData.create((StatusCode)StatusCode.ERROR, (String)msg);
        }
        return StatusData.unset();
    }

    public EventData toEvent(Span.Mark mark) {
        return EventData.create((long)this.toEpocNano(mark.instant()), (String)mark.key(), (Attributes)Attributes.empty());
    }

    public LinkData toLink(Span.Link link) {
        Trace.SamplingDecision samplingDecision = link.trace().samplingDecision();
        Trace.SamplingDecision$.Sample$ sample$ = Trace.SamplingDecision$.Sample$.MODULE$;
        return LinkData.create((SpanContext)this.mkSpanContext(!(samplingDecision != null ? !samplingDecision.equals(sample$) : sample$ != null), link.trace().id(), link.spanId()));
    }

    public Attributes toAttributes(TagSet tags) {
        AttributesBuilder builder = Attributes.builder();
        tags.iterator().foreach((Function1 & Serializable)x0$1 -> {
            Tag tag = x0$1;
            if (tag instanceof Tag.String) {
                Tag.String string = (Tag.String)tag;
                return builder.put(string.key(), string.value());
            }
            if (tag instanceof Tag.Boolean) {
                Tag.Boolean boolean_ = (Tag.Boolean)tag;
                return builder.put(boolean_.key(), Predef$.MODULE$.Boolean2boolean(boolean_.value()));
            }
            if (tag instanceof Tag.Long) {
                Tag.Long longVal = (Tag.Long)tag;
                return builder.put(longVal.key(), Predef$.MODULE$.Long2long(longVal.value()));
            }
            throw new MatchError((Object)tag);
        });
        return builder.build();
    }

    public SpanData convertSpan(boolean includeErrorEvent, Resource resource, String kamonVersion, Span.Finished span) {
        return new SpanWrapper(includeErrorEvent, resource, kamonVersion, span);
    }

    public Collection<SpanData> convert(boolean includeErrorEvent, Resource resource, String kamonVersion, scala.collection.immutable.Seq<Span.Finished> spans) {
        return (Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)spans.map((Function1 & Serializable)span -> MODULE$.convertSpan(includeErrorEvent, resource, kamonVersion, (Span.Finished)span))).asJava();
    }

    private SpanConverter$() {
    }
}

