/*
 * Decompiled with CFR 0.152.
 */
package kamon.prometheus;

import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import kamon.metric.Bucket;
import kamon.metric.MeasurementUnit;
import kamon.metric.MeasurementUnit$;
import kamon.metric.MetricDistribution;
import kamon.metric.MetricValue;
import kamon.prometheus.PrometheusReporter;
import kamon.prometheus.ScrapeDataBuilder$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichChar$;

@ScalaSignature(bytes="\u0006\u0001\u0005=g\u0001B\u0001\u0003\u0001\u001d\u0011\u0011cU2sCB,G)\u0019;b\u0005VLG\u000eZ3s\u0015\t\u0019A!\u0001\u0006qe>lW\r\u001e5fkNT\u0011!B\u0001\u0006W\u0006lwN\\\u0002\u0001'\t\u0001\u0001\u0002\u0005\u0002\n\u00195\t!BC\u0001\f\u0003\u0015\u00198-\u00197b\u0013\ti!B\u0001\u0004B]f\u0014VM\u001a\u0005\t\u001f\u0001\u0011\t\u0011)A\u0005!\u0005\u0001\u0002O]8nKRDW-^:D_:4\u0017n\u001a\t\u0003#Uq!AE\n\u000e\u0003\tI!\u0001\u0006\u0002\u0002%A\u0013x.\\3uQ\u0016,8OU3q_J$XM]\u0005\u0003-]\u0011QbQ8oM&<WO]1uS>t'B\u0001\u000b\u0003\u0011!I\u0002A!A!\u0002\u0013Q\u0012aD3om&\u0014xN\\7f]R$\u0016mZ:\u0011\tm\u0011S%\n\b\u00039\u0001\u0002\"!\b\u0006\u000e\u0003yQ!a\b\u0004\u0002\rq\u0012xn\u001c;?\u0013\t\t#\"\u0001\u0004Qe\u0016$WMZ\u0005\u0003G\u0011\u00121!T1q\u0015\t\t#\u0002\u0005\u0002\u001cM%\u0011q\u0005\n\u0002\u0007'R\u0014\u0018N\\4\t\u000b%\u0002A\u0011\u0001\u0016\u0002\rqJg.\u001b;?)\rYC&\f\t\u0003%\u0001AQa\u0004\u0015A\u0002AAq!\u0007\u0015\u0011\u0002\u0003\u0007!\u0004C\u00040\u0001\t\u0007I\u0011\u0002\u0019\u0002\u000f\t,\u0018\u000e\u001c3feV\t\u0011\u0007\u0005\u00023o5\t1G\u0003\u00025k\u0005!A.\u00198h\u0015\u00051\u0014\u0001\u00026bm\u0006L!\u0001O\u001a\u0003\u001bM#(/\u001b8h\u0005VLG\u000eZ3s\u0011\u0019Q\u0004\u0001)A\u0005c\u0005A!-^5mI\u0016\u0014\b\u0005C\u0004=\u0001\t\u0007I\u0011B\u001f\u0002)\u0011,7-[7bY\u001a{'/\\1u'fl'm\u001c7t+\u0005q\u0004CA C\u001b\u0005\u0001%BA!6\u0003\u0011!X\r\u001f;\n\u0005\r\u0003%\u0001\u0006#fG&l\u0017\r\u001c$pe6\fGoU=nE>d7\u000f\u0003\u0004F\u0001\u0001\u0006IAP\u0001\u0016I\u0016\u001c\u0017.\\1m\r>\u0014X.\u0019;Ts6\u0014w\u000e\\:!\u0011\u001d9\u0005A1A\u0005\n!\u000bAB\\;nE\u0016\u0014hi\u001c:nCR,\u0012!\u0013\t\u0003\u007f)K!a\u0013!\u0003\u001b\u0011+7-[7bY\u001a{'/\\1u\u0011\u0019i\u0005\u0001)A\u0005\u0013\u0006ia.^7cKJ4uN]7bi\u0002BQa\u0014\u0001\u0005\u0002A\u000bQAY;jY\u0012$\u0012!\n\u0005\u0006%\u0002!\taU\u0001\u000fCB\u0004XM\u001c3D_VtG/\u001a:t)\tYC\u000bC\u0003V#\u0002\u0007a+\u0001\u0005d_VtG/\u001a:t!\r9Fl\u0018\b\u00031js!!H-\n\u0003-I!a\u0017\u0006\u0002\u000fA\f7m[1hK&\u0011QL\u0018\u0002\u0004'\u0016\f(BA.\u000b!\t\u00017-D\u0001b\u0015\t\u0011G!\u0001\u0004nKR\u0014\u0018nY\u0005\u0003I\u0006\u00141\"T3ue&\u001cg+\u00197vK\")a\r\u0001C\u0001O\u0006a\u0011\r\u001d9f]\u0012<\u0015-^4fgR\u00111\u0006\u001b\u0005\u0006S\u0016\u0004\rAV\u0001\u0007O\u0006,x-Z:\t\u000b-\u0004A\u0011\u00017\u0002!\u0005\u0004\b/\u001a8e\u0011&\u001cHo\\4sC6\u001cHCA\u0016n\u0011\u0015q'\u000e1\u0001p\u0003)A\u0017n\u001d;pOJ\fWn\u001d\t\u0004/r\u0003\bC\u00011r\u0013\t\u0011\u0018M\u0001\nNKR\u0014\u0018n\u0019#jgR\u0014\u0018NY;uS>t\u0007\"\u0002;\u0001\t\u0013)\u0018!E1qa\u0016tGMV1mk\u0016lU\r\u001e:jGR!ao`A\u0002)\t9(\u0010\u0005\u0002\nq&\u0011\u0011P\u0003\u0002\u0005+:LG\u000fC\u0003|g\u0002\u0007A0A\u0003he>,\b\u000f\u0005\u0003\n{\u00162\u0016B\u0001@\u000b\u0005\u0019!V\u000f\u001d7fe!1\u0011\u0011A:A\u0002\u0015\n!\"\\3ue&\u001cG+\u001f9f\u0011\u001d\t)a\u001da\u0001\u0003\u000f\t\u0001#\u00197xCf\u001c\u0018J\\2sK\u0006\u001c\u0018N\\4\u0011\u0007%\tI!C\u0002\u0002\f)\u0011qAQ8pY\u0016\fg\u000eC\u0004\u0002\u0010\u0001!I!!\u0005\u00021\u0005\u0004\b/\u001a8e\t&\u001cHO]5ckRLwN\\'fiJL7\rF\u0002x\u0003'Aqa_A\u0007\u0001\u0004\t)\u0002\u0005\u0003\n{\u0016z\u0007bBA\r\u0001\u0011%\u00111D\u0001\u0015CB\u0004XM\u001c3US6,7+\u001a:jKZ\u000bG.^3\u0015\u0013]\fi\"!\t\u0002&\u0005%\u0002bBA\u0010\u0003/\u0001\r!J\u0001\u0005]\u0006lW\rC\u0004\u0002$\u0005]\u0001\u0019\u0001\u000e\u0002\tQ\fwm\u001d\u0005\b\u0003O\t9\u00021\u0001&\u0003\u00151\u0018\r\\;f\u0011%\tY#a\u0006\u0011\u0002\u0003\u0007Q%\u0001\u0004tk\u001a4\u0017\u000e\u001f\u0005\b\u0003_\u0001A\u0011BA\u0019\u0003i\u0011Xm]8mm\u0016\u0014UoY6fi\u000e{gNZ5hkJ\fG/[8o)\u0011\t\u0019$a\u000f\u0011\t]c\u0016Q\u0007\t\u0004e\u0005]\u0012bAA\u001dg\t1Ai\\;cY\u0016DaAYA\u0017\u0001\u0004\u0001\bbBA \u0001\u0011%\u0011\u0011I\u0001\u0017CB\u0004XM\u001c3ISN$xn\u001a:b[\n+8m[3ugRIq/a\u0011\u0002F\u0005\u001d\u0013\u0011\n\u0005\b\u0003?\ti\u00041\u0001&\u0011\u001d\t\u0019#!\u0010A\u0002iAaAYA\u001f\u0001\u0004\u0001\b\u0002CA&\u0003{\u0001\r!a\r\u0002\u000f\t,8m[3ug\"9\u0011q\n\u0001\u0005\n\u0005E\u0013AC1qa\u0016tG\rV1hgR\u0019q/a\u0015\t\u000f\u0005\r\u0012Q\na\u00015!9\u0011q\u000b\u0001\u0005\n\u0005e\u0013a\u00058pe6\fG.\u001b>f\u001b\u0016$(/[2OC6,G#B\u0013\u0002\\\u0005}\u0003bBA/\u0003+\u0002\r!J\u0001\u000b[\u0016$(/[2OC6,\u0007\u0002CA1\u0003+\u0002\r!a\u0019\u0002\tUt\u0017\u000e\u001e\t\u0004A\u0006\u0015\u0014bAA4C\nyQ*Z1tkJ,W.\u001a8u+:LG\u000fC\u0004\u0002l\u0001!I!!\u001c\u0002%9|'/\\1mSj,G*\u00192fY:\u000bW.\u001a\u000b\u0004K\u0005=\u0004bBA9\u0003S\u0002\r!J\u0001\u0006Y\u0006\u0014W\r\u001c\u0005\b\u0003k\u0002A\u0011BA<\u0003A\u0019\u0007.\u0019:PeVsG-\u001a:tG>\u0014X\r\u0006\u0003\u0002z\u0005}\u0004cA\u0005\u0002|%\u0019\u0011Q\u0010\u0006\u0003\t\rC\u0017M\u001d\u0005\t\u0003\u0003\u000b\u0019\b1\u0001\u0002z\u0005!1\r[1s\u0011\u001d\t)\t\u0001C\u0005\u0003\u000f\u000baAZ8s[\u0006$HcA\u0013\u0002\n\"A\u0011qEAB\u0001\u0004\tY\tE\u0002\n\u0003\u001bK1!!\u000f\u000b\u0011\u001d\t\t\n\u0001C\u0005\u0003'\u000bQa]2bY\u0016$b!a#\u0002\u0016\u0006u\u0005\u0002CA\u0014\u0003\u001f\u0003\r!a&\u0011\u0007%\tI*C\u0002\u0002\u001c*\u0011A\u0001T8oO\"A\u0011\u0011MAH\u0001\u0004\t\u0019\u0007C\u0005\u0002\"\u0002\t\n\u0011\"\u0003\u0002$\u0006q\u0012\r\u001d9f]\u0012$\u0016.\\3TKJLWMV1mk\u0016$C-\u001a4bk2$H\u0005N\u000b\u0003\u0003KS3!JATW\t\tI\u000b\u0005\u0003\u0002,\u0006UVBAAW\u0015\u0011\ty+!-\u0002\u0013Ut7\r[3dW\u0016$'bAAZ\u0015\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005]\u0016Q\u0016\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,w!CA^\u0005\u0005\u0005\t\u0012AA_\u0003E\u00196M]1qK\u0012\u000bG/\u0019\"vS2$WM\u001d\t\u0004%\u0005}f\u0001C\u0001\u0003\u0003\u0003E\t!!1\u0014\u0007\u0005}\u0006\u0002C\u0004*\u0003\u007f#\t!!2\u0015\u0005\u0005u\u0006BCAe\u0003\u007f\u000b\n\u0011\"\u0001\u0002L\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uII*\"!!4+\u0007i\t9\u000b")
public class ScrapeDataBuilder {
    private final PrometheusReporter.Configuration prometheusConfig;
    private final Map<String, String> environmentTags;
    private final StringBuilder builder;
    private final DecimalFormatSymbols decimalFormatSymbols;
    private final DecimalFormat numberFormat;

    public static Map<String, String> $lessinit$greater$default$2() {
        return ScrapeDataBuilder$.MODULE$.$lessinit$greater$default$2();
    }

    private StringBuilder builder() {
        return this.builder;
    }

    private DecimalFormatSymbols decimalFormatSymbols() {
        return this.decimalFormatSymbols;
    }

    private DecimalFormat numberFormat() {
        return this.numberFormat;
    }

    public String build() {
        return this.builder().toString();
    }

    public ScrapeDataBuilder appendCounters(Seq<MetricValue> counters) {
        counters.groupBy((Function1 & Serializable & scala.Serializable)x$1 -> x$1.name()).foreach((Function1 & Serializable & scala.Serializable)group -> {
            this.appendValueMetric("counter", true, (Tuple2<String, Seq<MetricValue>>)group);
            return BoxedUnit.UNIT;
        });
        return this;
    }

    public ScrapeDataBuilder appendGauges(Seq<MetricValue> gauges) {
        gauges.groupBy((Function1 & Serializable & scala.Serializable)x$2 -> x$2.name()).foreach((Function1 & Serializable & scala.Serializable)group -> {
            this.appendValueMetric("gauge", false, (Tuple2<String, Seq<MetricValue>>)group);
            return BoxedUnit.UNIT;
        });
        return this;
    }

    public ScrapeDataBuilder appendHistograms(Seq<MetricDistribution> histograms) {
        histograms.groupBy((Function1 & Serializable & scala.Serializable)x$3 -> x$3.name()).foreach((Function1 & Serializable & scala.Serializable)group -> {
            this.appendDistributionMetric((Tuple2<String, Seq<MetricDistribution>>)group);
            return BoxedUnit.UNIT;
        });
        return this;
    }

    private void appendValueMetric(String metricType, boolean alwaysIncreasing, Tuple2<String, Seq<MetricValue>> group) {
        Tuple2<String, Seq<MetricValue>> tuple2 = group;
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String metricName = (String)tuple2._1();
        Seq snapshots = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)metricName, (Object)snapshots);
        Tuple2 tuple23 = tuple22;
        String metricName2 = (String)tuple23._1();
        Seq snapshots2 = (Seq)tuple23._2();
        MeasurementUnit unit = (MeasurementUnit)snapshots2.headOption().map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.unit()).getOrElse((Function0 & Serializable & scala.Serializable)() -> MeasurementUnit$.MODULE$.none());
        String normalizedMetricName = this.normalizeMetricName(metricName2, unit) + (alwaysIncreasing ? "_total" : "");
        this.builder().append("# TYPE ").append(normalizedMetricName).append(" ").append(metricType).append("\n");
        snapshots2.foreach((Function1 & Serializable & scala.Serializable)metric -> {
            this.builder().append(normalizedMetricName);
            this.appendTags((Map<String, String>)metric.tags());
            this.builder().append(" ");
            this.builder().append(this.format(this.scale(metric.value(), metric.unit())));
            return this.builder().append("\n");
        });
    }

    private void appendDistributionMetric(Tuple2<String, Seq<MetricDistribution>> group) {
        Tuple2<String, Seq<MetricDistribution>> tuple2 = group;
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String metricName = (String)tuple2._1();
        Seq snapshots = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)metricName, (Object)snapshots);
        Tuple2 tuple23 = tuple22;
        String metricName2 = (String)tuple23._1();
        Seq snapshots2 = (Seq)tuple23._2();
        MeasurementUnit unit = (MeasurementUnit)snapshots2.headOption().map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.unit()).getOrElse((Function0 & Serializable & scala.Serializable)() -> MeasurementUnit$.MODULE$.none());
        String normalizedMetricName = this.normalizeMetricName(metricName2, unit);
        this.builder().append("# TYPE ").append(normalizedMetricName).append(" histogram").append("\n");
        snapshots2.foreach((Function1 & Serializable & scala.Serializable)metric -> {
            ScrapeDataBuilder.$anonfun$appendDistributionMetric$3(this, normalizedMetricName, metric);
            return BoxedUnit.UNIT;
        });
    }

    private void appendTimeSerieValue(String name, Map<String, String> tags, String value, String suffix) {
        this.builder().append(name);
        this.builder().append(suffix);
        this.appendTags(tags);
        this.builder().append(" ");
        this.builder().append(value);
        this.builder().append("\n");
    }

    private String appendTimeSerieValue$default$4() {
        return "";
    }

    private Seq<Double> resolveBucketConfiguration(MetricDistribution metric) {
        return (Seq)this.prometheusConfig.customBuckets().getOrElse((Object)metric.name(), (Function0 & Serializable & scala.Serializable)() -> {
            Seq<Double> seq;
            MeasurementUnit.Dimension dimension = metric.unit().dimension();
            MeasurementUnit.Dimension dimension2 = MeasurementUnit.Dimension$.MODULE$.Time();
            MeasurementUnit.Dimension dimension3 = dimension;
            if (!(dimension2 != null ? !dimension2.equals(dimension3) : dimension3 != null)) {
                seq = $this.prometheusConfig.timeBuckets();
            } else {
                MeasurementUnit.Dimension dimension4 = MeasurementUnit.Dimension$.MODULE$.Information();
                MeasurementUnit.Dimension dimension5 = dimension;
                seq = !(dimension4 != null ? !dimension4.equals(dimension5) : dimension5 != null) ? $this.prometheusConfig.informationBuckets() : $this.prometheusConfig.defaultBuckets();
            }
            return seq;
        });
    }

    private void appendHistogramBuckets(String name, Map<String, String> tags, MetricDistribution metric, Seq<Double> buckets) {
        Iterator distributionBuckets = metric.distribution().bucketsIterator();
        ObjectRef currentDistributionBucket = ObjectRef.create((Object)((Bucket)distributionBuckets.next()));
        DoubleRef currentDistributionBucketValue = DoubleRef.create((double)this.scale(((Bucket)currentDistributionBucket.elem).value(), metric.unit()));
        LongRef inBucketCount = LongRef.create((long)0L);
        LongRef leftOver = LongRef.create((long)((Bucket)currentDistributionBucket.elem).frequency());
        buckets.foreach((Function1 & Serializable & scala.Serializable)configuredBucket -> {
            ScrapeDataBuilder.$anonfun$appendHistogramBuckets$1(this, name, tags, metric, distributionBuckets, currentDistributionBucket, currentDistributionBucketValue, inBucketCount, leftOver, configuredBucket);
            return BoxedUnit.UNIT;
        });
        while (distributionBuckets.hasNext()) {
            leftOver.elem += ((Bucket)distributionBuckets.next()).frequency();
        }
        this.appendTimeSerieValue(name, (Map<String, String>)tags.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"le"), (Object)"+Inf")), this.format(leftOver.elem + inBucketCount.elem), "_bucket");
    }

    private void appendTags(Map<String, String> tags) {
        block2: {
            Map allTags = tags.$plus$plus(this.environmentTags);
            Object object = allTags.nonEmpty() ? this.builder().append("{") : BoxedUnit.UNIT;
            Iterator tagIterator = allTags.iterator();
            int tagCount = 0;
            while (tagIterator.hasNext()) {
                Tuple2 tuple2 = (Tuple2)tagIterator.next();
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String key = (String)tuple2._1();
                String value = (String)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)key, (Object)value);
                Tuple2 tuple23 = tuple22;
                String key2 = (String)tuple23._1();
                String value2 = (String)tuple23._2();
                Object object2 = tagCount > 0 ? this.builder().append(",") : BoxedUnit.UNIT;
                this.builder().append(this.normalizeLabelName(key2)).append("=\"").append(value2).append('\"');
                ++tagCount;
            }
            if (!allTags.nonEmpty()) break block2;
            this.builder().append("}");
        }
    }

    private String normalizeMetricName(String metricName, MeasurementUnit unit) {
        String string;
        String normalizedMetricName = (String)new StringOps(Predef$.MODULE$.augmentString(metricName)).map((Function1 & Serializable & scala.Serializable)object -> BoxesRunTime.boxToCharacter((char)this.charOrUnderscore(BoxesRunTime.unboxToChar((Object)object))), Predef$.MODULE$.StringCanBuildFrom());
        MeasurementUnit.Dimension dimension = unit.dimension();
        MeasurementUnit.Dimension dimension2 = MeasurementUnit.Dimension$.MODULE$.Time();
        MeasurementUnit.Dimension dimension3 = dimension;
        if (!(dimension2 != null ? !dimension2.equals(dimension3) : dimension3 != null)) {
            string = normalizedMetricName + "_seconds";
        } else {
            MeasurementUnit.Dimension dimension4 = MeasurementUnit.Dimension$.MODULE$.Information();
            MeasurementUnit.Dimension dimension5 = dimension;
            string = !(dimension4 != null ? !dimension4.equals(dimension5) : dimension5 != null) ? normalizedMetricName + "_bytes" : normalizedMetricName;
        }
        return string;
    }

    private String normalizeLabelName(String label) {
        return (String)new StringOps(Predef$.MODULE$.augmentString(label)).map((Function1 & Serializable & scala.Serializable)object -> BoxesRunTime.boxToCharacter((char)this.charOrUnderscore(BoxesRunTime.unboxToChar((Object)object))), Predef$.MODULE$.StringCanBuildFrom());
    }

    private char charOrUnderscore(char n) {
        return (char)(RichChar$.MODULE$.isLetterOrDigit$extension(Predef$.MODULE$.charWrapper((char)n)) || n == 95 ? n : 95);
    }

    private String format(double value) {
        return this.numberFormat().format(value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private double scale(long value, MeasurementUnit unit) {
        MeasurementUnit.Dimension dimension = unit.dimension();
        MeasurementUnit.Dimension dimension2 = MeasurementUnit.Dimension$.MODULE$.Time();
        MeasurementUnit.Dimension dimension3 = dimension;
        if (!(dimension2 != null ? !dimension2.equals(dimension3) : dimension3 != null)) {
            MeasurementUnit.Magnitude magnitude = unit.magnitude();
            MeasurementUnit.Magnitude magnitude2 = MeasurementUnit$.MODULE$.time().seconds().magnitude();
            if (magnitude == null ? magnitude2 != null : !magnitude.equals(magnitude2)) {
                return MeasurementUnit$.MODULE$.scale(value, unit, MeasurementUnit$.MODULE$.time().seconds());
            }
        }
        MeasurementUnit.Dimension dimension4 = MeasurementUnit.Dimension$.MODULE$.Information();
        MeasurementUnit.Dimension dimension5 = dimension;
        if (dimension4 == null) {
            if (dimension5 != null) {
                return value;
            }
        } else if (!dimension4.equals(dimension5)) return value;
        MeasurementUnit.Magnitude magnitude = unit.magnitude();
        MeasurementUnit.Magnitude magnitude3 = MeasurementUnit$.MODULE$.information().bytes().magnitude();
        if (magnitude == null) {
            if (magnitude3 == null) return value;
            return MeasurementUnit$.MODULE$.scale(value, unit, MeasurementUnit$.MODULE$.information().bytes());
        } else if (magnitude.equals(magnitude3)) return value;
        return MeasurementUnit$.MODULE$.scale(value, unit, MeasurementUnit$.MODULE$.information().bytes());
    }

    public static final /* synthetic */ void $anonfun$appendDistributionMetric$3(ScrapeDataBuilder $this, String normalizedMetricName$2, MetricDistribution metric) {
        block0: {
            if (metric.distribution().count() <= 0L) break block0;
            $this.appendHistogramBuckets(normalizedMetricName$2, (Map<String, String>)metric.tags(), metric, $this.resolveBucketConfiguration(metric));
            String count = $this.format(metric.distribution().count());
            String sum = $this.format($this.scale(metric.distribution().sum(), metric.unit()));
            $this.appendTimeSerieValue(normalizedMetricName$2, (Map<String, String>)metric.tags(), count, "_count");
            $this.appendTimeSerieValue(normalizedMetricName$2, (Map<String, String>)metric.tags(), sum, "_sum");
        }
    }

    public static final /* synthetic */ void $anonfun$appendHistogramBuckets$1(ScrapeDataBuilder $this, String name$1, Map tags$1, MetricDistribution metric$1, Iterator distributionBuckets$1, ObjectRef currentDistributionBucket$1, DoubleRef currentDistributionBucketValue$1, LongRef inBucketCount$1, LongRef leftOver$1, Double configuredBucket) {
        Map bucketTags = tags$1.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"le"), (Object)String.valueOf(configuredBucket)));
        if (currentDistributionBucketValue$1.elem <= Predef$.MODULE$.Double2double(configuredBucket)) {
            inBucketCount$1.elem += leftOver$1.elem;
            leftOver$1.elem = 0L;
            while (distributionBuckets$1.hasNext() && currentDistributionBucketValue$1.elem <= Predef$.MODULE$.Double2double(configuredBucket)) {
                currentDistributionBucket$1.elem = (Bucket)distributionBuckets$1.next();
                currentDistributionBucketValue$1.elem = $this.scale(((Bucket)currentDistributionBucket$1.elem).value(), metric$1.unit());
                if (currentDistributionBucketValue$1.elem <= Predef$.MODULE$.Double2double(configuredBucket)) {
                    inBucketCount$1.elem += ((Bucket)currentDistributionBucket$1.elem).frequency();
                    continue;
                }
                leftOver$1.elem = ((Bucket)currentDistributionBucket$1.elem).frequency();
            }
        }
        $this.appendTimeSerieValue(name$1, (Map<String, String>)bucketTags, $this.format(inBucketCount$1.elem), "_bucket");
    }

    public ScrapeDataBuilder(PrometheusReporter.Configuration prometheusConfig, Map<String, String> environmentTags) {
        this.prometheusConfig = prometheusConfig;
        this.environmentTags = environmentTags;
        this.builder = new StringBuilder();
        this.decimalFormatSymbols = DecimalFormatSymbols.getInstance(Locale.ROOT);
        this.numberFormat = new DecimalFormat("#0.0########", this.decimalFormatSymbols());
    }
}

