/*
 * Decompiled with CFR 0.152.
 */
package kamon.prometheus;

import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import kamon.metric.Distribution;
import kamon.metric.Instrument;
import kamon.metric.MeasurementUnit;
import kamon.metric.MeasurementUnit$;
import kamon.metric.Metric;
import kamon.metric.MetricSnapshot;
import kamon.prometheus.PrometheusReporter;
import kamon.prometheus.ScrapeDataBuilder$;
import kamon.tag.Tag;
import kamon.tag.TagSet;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichChar$;

@ScalaSignature(bytes="\u0006\u0005\u0005]h\u0001\u0002\u0012$\u0001!B\u0001b\f\u0001\u0003\u0002\u0003\u0006I\u0001\r\u0005\tq\u0001\u0011\t\u0011)A\u0005s!)q\b\u0001C\u0001\u0001\"9A\t\u0001b\u0001\n\u0013)\u0005B\u0002(\u0001A\u0003%a\tC\u0004P\u0001\t\u0007I\u0011\u0002)\t\r]\u0003\u0001\u0015!\u0003R\u0011\u001dA\u0006A1A\u0005\neCa!\u0018\u0001!\u0002\u0013Q\u0006\"\u00020\u0001\t\u0003y\u0006\"B6\u0001\t\u0003a\u0007bBA\u0006\u0001\u0011\u0005\u0011Q\u0002\u0005\b\u0003;\u0001A\u0011AA\u0010\u0011\u001d\ti\u0003\u0001C\u0005\u0003_Aq!!\u000f\u0001\t\u0013\tY\u0004C\u0004\u0002@\u0001!I!!\u0011\t\u000f\u0005\u0015\u0003\u0001\"\u0003\u0002H!I\u0011\u0011\f\u0001\u0012\u0002\u0013%\u00111\f\u0005\b\u0003c\u0002A\u0011BA:\u0011\u001d\tI\t\u0001C\u0005\u0003\u0017Cq!!)\u0001\t\u0013\t\u0019\u000bC\u0004\u0002(\u0002!I!!+\t\u000f\u00055\u0006\u0001\"\u0003\u00020\"9\u0011q\u0017\u0001\u0005\n\u0005e\u0006bBA`\u0001\u0011%\u0011\u0011\u0019\u0005\b\u0003\u000f\u0004A\u0011BAe\u0011\u001d\t)\u000e\u0001C\u0005\u0003/Dq!a7\u0001\t\u0013\ti\u000eC\u0004\u0002b\u0002!I!a9\b\u0013\u0005%8%!A\t\u0002\u0005-h\u0001\u0003\u0012$\u0003\u0003E\t!!<\t\r}zB\u0011AAx\u0011%\t\tpHI\u0001\n\u0003\t\u0019PA\tTGJ\f\u0007/\u001a#bi\u0006\u0014U/\u001b7eKJT!\u0001J\u0013\u0002\u0015A\u0014x.\\3uQ\u0016,8OC\u0001'\u0003\u0015Y\u0017-\\8o\u0007\u0001\u0019\"\u0001A\u0015\u0011\u0005)jS\"A\u0016\u000b\u00031\nQa]2bY\u0006L!AL\u0016\u0003\r\u0005s\u0017PU3g\u0003A\u0001(o\\7fi\",Wo]\"p]\u001aLw\r\u0005\u00022k9\u0011!gM\u0007\u0002G%\u0011AgI\u0001\u0013!J|W.\u001a;iKV\u001c(+\u001a9peR,'/\u0003\u00027o\tA1+\u001a;uS:<7O\u0003\u00025G\u0005yQM\u001c<je>tW.\u001a8u)\u0006<7\u000f\u0005\u0002;{5\t1H\u0003\u0002=K\u0005\u0019A/Y4\n\u0005yZ$A\u0002+bON+G/\u0001\u0004=S:LGO\u0010\u000b\u0004\u0003\n\u001b\u0005C\u0001\u001a\u0001\u0011\u0015y3\u00011\u00011\u0011\u001dA4\u0001%AA\u0002e\n\u0001b\u00182vS2$WM]\u000b\u0002\rB\u0011q\tT\u0007\u0002\u0011*\u0011\u0011JS\u0001\u0005Y\u0006twMC\u0001L\u0003\u0011Q\u0017M^1\n\u00055C%!D*ue&twMQ;jY\u0012,'/A\u0005`EVLG\u000eZ3sA\u0005)r\fZ3dS6\fGNR8s[\u0006$8+_7c_2\u001cX#A)\u0011\u0005I+V\"A*\u000b\u0005QS\u0015\u0001\u0002;fqRL!AV*\u0003)\u0011+7-[7bY\u001a{'/\\1u'fl'm\u001c7t\u0003YyF-Z2j[\u0006dgi\u001c:nCR\u001c\u00160\u001c2pYN\u0004\u0013!D0ok6\u0014WM\u001d$pe6\fG/F\u0001[!\t\u00116,\u0003\u0002]'\niA)Z2j[\u0006dgi\u001c:nCR\fab\u00188v[\n,'OR8s[\u0006$\b%A\u0003ck&dG\rF\u0001a!\t\t\u0007N\u0004\u0002cMB\u00111mK\u0007\u0002I*\u0011QmJ\u0001\u0007yI|w\u000e\u001e \n\u0005\u001d\\\u0013A\u0002)sK\u0012,g-\u0003\u0002jU\n11\u000b\u001e:j]\u001eT!aZ\u0016\u0002\u001d\u0005\u0004\b/\u001a8e\u0007>,h\u000e^3sgR\u0011\u0011)\u001c\u0005\u0006].\u0001\ra\\\u0001\tG>,h\u000e^3sgB\u0019\u0001/\u001e=\u000f\u0005E\u001chBA2s\u0013\u0005a\u0013B\u0001;,\u0003\u001d\u0001\u0018mY6bO\u0016L!A^<\u0003\u0007M+\u0017O\u0003\u0002uWA!\u0011p`A\u0003\u001d\tQX0D\u0001|\u0015\taX%\u0001\u0004nKR\u0014\u0018nY\u0005\u0003}n\fa\"T3ue&\u001c7K\\1qg\"|G/\u0003\u0003\u0002\u0002\u0005\r!A\u0002,bYV,7O\u0003\u0002\u007fwB\u0019!&a\u0002\n\u0007\u0005%1F\u0001\u0003M_:<\u0017\u0001D1qa\u0016tGmR1vO\u0016\u001cHcA!\u0002\u0010!9\u0011\u0011\u0003\u0007A\u0002\u0005M\u0011AB4bk\u001e,7\u000f\u0005\u0003qk\u0006U\u0001\u0003B=\u0000\u0003/\u00012AKA\r\u0013\r\tYb\u000b\u0002\u0007\t>,(\r\\3\u0002!\u0005\u0004\b/\u001a8e\u0011&\u001cHo\\4sC6\u001cHcA!\u0002\"!9\u00111E\u0007A\u0002\u0005\u0015\u0012A\u00035jgR|wM]1ngB!\u0001/^A\u0014!\rI\u0018\u0011F\u0005\u0005\u0003W\t\u0019AA\u0007ESN$(/\u001b2vi&|gn]\u0001\u0014CB\u0004XM\u001c3D_VtG/\u001a:NKR\u0014\u0018n\u0019\u000b\u0005\u0003c\t9\u0004E\u0002+\u0003gI1!!\u000e,\u0005\u0011)f.\u001b;\t\u000bqt\u0001\u0019\u0001=\u0002#\u0005\u0004\b/\u001a8e\u000f\u0006,x-Z'fiJL7\r\u0006\u0003\u00022\u0005u\u0002B\u0002?\u0010\u0001\u0004\t)\"\u0001\rbaB,g\u000e\u001a#jgR\u0014\u0018NY;uS>tW*\u001a;sS\u000e$B!!\r\u0002D!1A\u0010\u0005a\u0001\u0003O\tA#\u00199qK:$G+[7f'\u0016\u0014\u0018.\u001a,bYV,GCCA\u0019\u0003\u0013\ni%!\u0015\u0002V!1\u00111J\tA\u0002\u0001\fAA\\1nK\"1\u0011qJ\tA\u0002e\nA\u0001^1hg\"1\u00111K\tA\u0002\u0001\fQA^1mk\u0016D\u0001\"a\u0016\u0012!\u0003\u0005\r\u0001Y\u0001\u0007gV4g-\u001b=\u0002=\u0005\u0004\b/\u001a8e)&lWmU3sS\u00164\u0016\r\\;fI\u0011,g-Y;mi\u0012\"TCAA/U\r\u0001\u0017qL\u0016\u0003\u0003C\u0002B!a\u0019\u0002n5\u0011\u0011Q\r\u0006\u0005\u0003O\nI'A\u0005v]\u000eDWmY6fI*\u0019\u00111N\u0016\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002p\u0005\u0015$!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006Q\"/Z:pYZ,')^2lKR\u001cuN\u001c4jOV\u0014\u0018\r^5p]R1\u0011QOA>\u0003\u007f\u0002B\u0001];\u0002xA\u0019q)!\u001f\n\u0007\u0005m\u0001\n\u0003\u0004\u0002~M\u0001\r\u0001Y\u0001\u000b[\u0016$(/[2OC6,\u0007bBAA'\u0001\u0007\u00111Q\u0001\u0005k:LG\u000fE\u0002{\u0003\u000bK1!a\"|\u0005=iU-Y:ve\u0016lWM\u001c;V]&$\u0018AF1qa\u0016tG\rS5ti><'/Y7Ck\u000e\\W\r^:\u0015\u0019\u0005E\u0012QRAH\u0003#\u000bY*!(\t\r\u0005-C\u00031\u0001a\u0011\u0019\ty\u0005\u0006a\u0001s!9\u00111\u0013\u000bA\u0002\u0005U\u0015\u0001\u00043jgR\u0014\u0018NY;uS>t\u0007c\u0001>\u0002\u0018&\u0019\u0011\u0011T>\u0003\u0019\u0011K7\u000f\u001e:jEV$\u0018n\u001c8\t\u000f\u0005\u0005E\u00031\u0001\u0002\u0004\"9\u0011q\u0014\u000bA\u0002\u0005U\u0014a\u00022vG.,Go]\u0001\u000bCB\u0004XM\u001c3UC\u001e\u001cH\u0003BA\u0019\u0003KCa!a\u0014\u0016\u0001\u0004I\u0014!D:ue&tw-\u001b4z)\u0006<7\u000f\u0006\u0003\u00022\u0005-\u0006BBA(-\u0001\u0007\u0011(\u0001\u0007baB,g\u000e\u001a+bON$v\u000e\u0006\u0004\u00022\u0005E\u00161\u0017\u0005\u0007\u0003\u001f:\u0002\u0019A\u001d\t\r\u0005Uv\u00031\u0001G\u0003\u0019\u0011WO\u001a4fe\u0006\u0019bn\u001c:nC2L'0Z'fiJL7MT1nKR)\u0001-a/\u0002>\"1\u0011Q\u0010\rA\u0002\u0001Dq!!!\u0019\u0001\u0004\t\u0019)\u0001\no_Jl\u0017\r\\5{K2\u000b'-\u001a7OC6,Gc\u00011\u0002D\"1\u0011QY\rA\u0002\u0001\fQ\u0001\\1cK2\faB^1mS\u0012d\u0015MY3m\u0007\"\f'\u000f\u0006\u0003\u0002L\u0006E\u0007c\u0001\u0016\u0002N&\u0019\u0011qZ\u0016\u0003\t\rC\u0017M\u001d\u0005\b\u0003'T\u0002\u0019AAf\u0003\u0011\u0019\u0007.\u0019:\u0002\u001bY\fG.\u001b3OC6,7\t[1s)\u0011\tY-!7\t\u000f\u0005M7\u00041\u0001\u0002L\u00061am\u001c:nCR$2\u0001YAp\u0011\u001d\t\u0019\u0006\ba\u0001\u0003/\tqaY8om\u0016\u0014H\u000f\u0006\u0004\u0002\u0018\u0005\u0015\u0018q\u001d\u0005\b\u0003'j\u0002\u0019AA\f\u0011\u001d\t\t)\ba\u0001\u0003\u0007\u000b\u0011cU2sCB,G)\u0019;b\u0005VLG\u000eZ3s!\t\u0011td\u0005\u0002 SQ\u0011\u00111^\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005U(fA\u001d\u0002`\u0001")
public class ScrapeDataBuilder {
    private final PrometheusReporter.Settings prometheusConfig;
    private final TagSet environmentTags;
    private final StringBuilder _builder;
    private final DecimalFormatSymbols _decimalFormatSymbols;
    private final DecimalFormat _numberFormat;

    public static TagSet $lessinit$greater$default$2() {
        return ScrapeDataBuilder$.MODULE$.$lessinit$greater$default$2();
    }

    private StringBuilder _builder() {
        return this._builder;
    }

    private DecimalFormatSymbols _decimalFormatSymbols() {
        return this._decimalFormatSymbols;
    }

    private DecimalFormat _numberFormat() {
        return this._numberFormat;
    }

    public String build() {
        return this._builder().toString();
    }

    public ScrapeDataBuilder appendCounters(Seq<MetricSnapshot<Metric.Settings.ForValueInstrument, Object>> counters) {
        counters.foreach((Function1 & Serializable)metric -> {
            this.appendCounterMetric((MetricSnapshot<Metric.Settings.ForValueInstrument, Object>)metric);
            return BoxedUnit.UNIT;
        });
        return this;
    }

    public ScrapeDataBuilder appendGauges(Seq<MetricSnapshot<Metric.Settings.ForValueInstrument, Object>> gauges) {
        gauges.foreach((Function1 & Serializable)metric -> {
            this.appendGaugeMetric((MetricSnapshot<Metric.Settings.ForValueInstrument, Object>)metric);
            return BoxedUnit.UNIT;
        });
        return this;
    }

    public ScrapeDataBuilder appendHistograms(Seq<MetricSnapshot<Metric.Settings.ForDistributionInstrument, Distribution>> histograms) {
        histograms.foreach((Function1 & Serializable)metric -> {
            this.appendDistributionMetric((MetricSnapshot<Metric.Settings.ForDistributionInstrument, Distribution>)metric);
            return BoxedUnit.UNIT;
        });
        return this;
    }

    private void appendCounterMetric(MetricSnapshot<Metric.Settings.ForValueInstrument, Object> metric) {
        MeasurementUnit unit = ((Metric.Settings.ForValueInstrument)metric.settings()).unit();
        String normalizedMetricName = new StringBuilder(6).append(this.normalizeMetricName(metric.name(), unit)).append("_total").toString();
        Object object = StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(metric.description())) ? this._builder().append("# HELP ").append(normalizedMetricName).append(" ").append(metric.description()).append("\n") : BoxedUnit.UNIT;
        this._builder().append("# TYPE ").append(normalizedMetricName).append(" counter\n");
        metric.instruments().foreach((Function1 & Serializable)instrument -> {
            this._builder().append(normalizedMetricName);
            this.appendTags(instrument.tags());
            this._builder().append(" ");
            this._builder().append(this.format(this.convert(BoxesRunTime.unboxToLong((Object)instrument.value()), unit)));
            return this._builder().append("\n");
        });
    }

    private void appendGaugeMetric(MetricSnapshot<Metric.Settings.ForValueInstrument, Object> metric) {
        MeasurementUnit unit = ((Metric.Settings.ForValueInstrument)metric.settings()).unit();
        String normalizedMetricName = this.normalizeMetricName(metric.name(), unit);
        Object object = StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(metric.description())) ? this._builder().append("# HELP ").append(normalizedMetricName).append(" ").append(metric.description()).append("\n") : BoxedUnit.UNIT;
        this._builder().append("# TYPE ").append(normalizedMetricName).append(" gauge\n");
        metric.instruments().foreach((Function1 & Serializable)instrument -> {
            this._builder().append(normalizedMetricName);
            this.appendTags(instrument.tags());
            this._builder().append(" ");
            this._builder().append(this.format(this.convert(BoxesRunTime.unboxToDouble((Object)instrument.value()), unit)));
            return this._builder().append("\n");
        });
    }

    private void appendDistributionMetric(MetricSnapshot<Metric.Settings.ForDistributionInstrument, Distribution> metric) {
        MeasurementUnit unit = ((Metric.Settings.ForDistributionInstrument)metric.settings()).unit();
        String normalizedMetricName = this.normalizeMetricName(metric.name(), unit);
        Object object = StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(metric.description())) ? this._builder().append("# HELP ").append(normalizedMetricName).append(" ").append(metric.description()).append("\n") : BoxedUnit.UNIT;
        this._builder().append("# TYPE ").append(normalizedMetricName).append(" histogram").append("\n");
        metric.instruments().foreach((Function1 & Serializable)instrument -> {
            ScrapeDataBuilder.$anonfun$appendDistributionMetric$1(this, normalizedMetricName, unit, metric, instrument);
            return BoxedUnit.UNIT;
        });
    }

    private void appendTimeSerieValue(String name, TagSet tags, String value, String suffix) {
        this._builder().append(name);
        this._builder().append(suffix);
        this.appendTags(tags);
        this._builder().append(" ");
        this._builder().append(value);
        this._builder().append("\n");
    }

    private String appendTimeSerieValue$default$4() {
        return "";
    }

    private Seq<Double> resolveBucketConfiguration(String metricName, MeasurementUnit unit) {
        return (Seq)this.prometheusConfig.customBuckets().getOrElse((Object)metricName, (Function0 & Serializable)() -> {
            Seq<Double> seq;
            MeasurementUnit.Dimension dimension = unit.dimension();
            MeasurementUnit.Dimension dimension2 = MeasurementUnit.Dimension$.MODULE$.Time();
            MeasurementUnit.Dimension dimension3 = dimension;
            if (!(dimension2 != null ? !dimension2.equals(dimension3) : dimension3 != null)) {
                seq = $this.prometheusConfig.timeBuckets();
            } else {
                MeasurementUnit.Dimension dimension4 = MeasurementUnit.Dimension$.MODULE$.Information();
                MeasurementUnit.Dimension dimension5 = dimension;
                seq = !(dimension4 != null ? !dimension4.equals(dimension5) : dimension5 != null) ? $this.prometheusConfig.informationBuckets() : $this.prometheusConfig.defaultBuckets();
            }
            return seq;
        });
    }

    private void appendHistogramBuckets(String name, TagSet tags, Distribution distribution, MeasurementUnit unit, Seq<Double> buckets) {
        Iterator distributionBuckets = distribution.bucketsIterator();
        ObjectRef currentDistributionBucket = ObjectRef.create((Object)((Distribution.Bucket)distributionBuckets.next()));
        DoubleRef currentDistributionBucketValue = DoubleRef.create((double)this.convert(((Distribution.Bucket)currentDistributionBucket.elem).value(), unit));
        LongRef inBucketCount = LongRef.create((long)0L);
        LongRef leftOver = LongRef.create((long)((Distribution.Bucket)currentDistributionBucket.elem).frequency());
        buckets.foreach((Function1 & Serializable)configuredBucket -> {
            ScrapeDataBuilder.$anonfun$appendHistogramBuckets$1(this, tags, currentDistributionBucketValue, inBucketCount, leftOver, distributionBuckets, currentDistributionBucket, unit, name, configuredBucket);
            return BoxedUnit.UNIT;
        });
        while (distributionBuckets.hasNext()) {
            leftOver.elem += ((Distribution.Bucket)distributionBuckets.next()).frequency();
        }
        this.appendTimeSerieValue(name, tags.withTag("le", "+Inf"), this.format(leftOver.elem + inBucketCount.elem), "_bucket");
    }

    private void appendTags(TagSet tags) {
        this.appendTagsTo(tags, this._builder());
    }

    private void stringifyTags(TagSet tags) {
        StringBuilder builder = new StringBuilder();
        this.appendTagsTo(tags, builder);
        builder.toString();
    }

    private void appendTagsTo(TagSet tags, StringBuilder buffer) {
        block1: {
            TagSet allTags = tags.withTags(this.environmentTags);
            Object object = allTags.nonEmpty() ? buffer.append("{") : BoxedUnit.UNIT;
            Iterator tagIterator = allTags.iterator((Function1 & Serializable)v -> v == null ? "" : v.toString());
            int tagCount = 0;
            while (tagIterator.hasNext()) {
                Tag.Pair pair = (Tag.Pair)tagIterator.next();
                Object object2 = tagCount > 0 ? buffer.append(",") : BoxedUnit.UNIT;
                buffer.append(this.normalizeLabelName(pair.key())).append("=\"").append((String)pair.value()).append('\"');
                ++tagCount;
            }
            if (!allTags.nonEmpty()) break block1;
            buffer.append("}");
        }
    }

    private String normalizeMetricName(String metricName, MeasurementUnit unit) {
        String string;
        String normalizedMetricName = StringOps$.MODULE$.map$extension(Predef$.MODULE$.augmentString(metricName), (Function1 & Serializable)object -> BoxesRunTime.boxToCharacter((char)this.validNameChar(BoxesRunTime.unboxToChar((Object)object))));
        MeasurementUnit.Dimension dimension = unit.dimension();
        MeasurementUnit.Dimension dimension2 = MeasurementUnit.Dimension$.MODULE$.Time();
        MeasurementUnit.Dimension dimension3 = dimension;
        if (!(dimension2 != null ? !dimension2.equals(dimension3) : dimension3 != null)) {
            string = new StringBuilder(8).append(normalizedMetricName).append("_seconds").toString();
        } else {
            MeasurementUnit.Dimension dimension4 = MeasurementUnit.Dimension$.MODULE$.Information();
            MeasurementUnit.Dimension dimension5 = dimension;
            string = !(dimension4 != null ? !dimension4.equals(dimension5) : dimension5 != null) ? new StringBuilder(6).append(normalizedMetricName).append("_bytes").toString() : normalizedMetricName;
        }
        return string;
    }

    private String normalizeLabelName(String label) {
        return StringOps$.MODULE$.map$extension(Predef$.MODULE$.augmentString(label), (Function1 & Serializable)object -> BoxesRunTime.boxToCharacter((char)this.validLabelChar(BoxesRunTime.unboxToChar((Object)object))));
    }

    private char validLabelChar(char n) {
        return (char)(RichChar$.MODULE$.isLetterOrDigit$extension(Predef$.MODULE$.charWrapper((char)n)) || n == 95 ? n : 95);
    }

    private char validNameChar(char n) {
        return (char)(RichChar$.MODULE$.isLetterOrDigit$extension(Predef$.MODULE$.charWrapper((char)n)) || n == 95 || n == 58 ? n : 95);
    }

    private String format(double value) {
        return this._numberFormat().format(value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private double convert(double value, MeasurementUnit unit) {
        MeasurementUnit.Dimension dimension = unit.dimension();
        MeasurementUnit.Dimension dimension2 = MeasurementUnit.Dimension$.MODULE$.Time();
        MeasurementUnit.Dimension dimension3 = dimension;
        if (!(dimension2 != null ? !dimension2.equals(dimension3) : dimension3 != null)) {
            MeasurementUnit.Magnitude magnitude = unit.magnitude();
            MeasurementUnit.Magnitude magnitude2 = MeasurementUnit$.MODULE$.time().seconds().magnitude();
            if (magnitude == null ? magnitude2 != null : !magnitude.equals(magnitude2)) {
                return MeasurementUnit$.MODULE$.convert(value, unit, MeasurementUnit$.MODULE$.time().seconds());
            }
        }
        MeasurementUnit.Dimension dimension4 = MeasurementUnit.Dimension$.MODULE$.Information();
        MeasurementUnit.Dimension dimension5 = dimension;
        if (dimension4 == null) {
            if (dimension5 != null) {
                return value;
            }
        } else if (!dimension4.equals(dimension5)) return value;
        MeasurementUnit.Magnitude magnitude = unit.magnitude();
        MeasurementUnit.Magnitude magnitude3 = MeasurementUnit$.MODULE$.information().bytes().magnitude();
        if (magnitude == null) {
            if (magnitude3 == null) return value;
            return MeasurementUnit$.MODULE$.convert(value, unit, MeasurementUnit$.MODULE$.information().bytes());
        } else if (magnitude.equals(magnitude3)) return value;
        return MeasurementUnit$.MODULE$.convert(value, unit, MeasurementUnit$.MODULE$.information().bytes());
    }

    public static final /* synthetic */ void $anonfun$appendDistributionMetric$1(ScrapeDataBuilder $this, String normalizedMetricName$3, MeasurementUnit unit$3, MetricSnapshot metric$1, Instrument.Snapshot instrument) {
        block0: {
            if (((Distribution)instrument.value()).count() <= 0L) break block0;
            $this.appendHistogramBuckets(normalizedMetricName$3, instrument.tags(), (Distribution)instrument.value(), unit$3, $this.resolveBucketConfiguration(metric$1.name(), unit$3));
            String count = $this.format(((Distribution)instrument.value()).count());
            String sum = $this.format($this.convert(((Distribution)instrument.value()).sum(), unit$3));
            $this.appendTimeSerieValue(normalizedMetricName$3, instrument.tags(), count, "_count");
            $this.appendTimeSerieValue(normalizedMetricName$3, instrument.tags(), sum, "_sum");
        }
    }

    public static final /* synthetic */ void $anonfun$appendHistogramBuckets$1(ScrapeDataBuilder $this, TagSet tags$1, DoubleRef currentDistributionBucketValue$1, LongRef inBucketCount$1, LongRef leftOver$1, Iterator distributionBuckets$1, ObjectRef currentDistributionBucket$1, MeasurementUnit unit$5, String name$1, Double configuredBucket) {
        TagSet bucketTags = tags$1.withTag("le", String.valueOf(configuredBucket));
        if (currentDistributionBucketValue$1.elem <= Predef$.MODULE$.Double2double(configuredBucket)) {
            inBucketCount$1.elem += leftOver$1.elem;
            leftOver$1.elem = 0L;
            while (distributionBuckets$1.hasNext() && currentDistributionBucketValue$1.elem <= Predef$.MODULE$.Double2double(configuredBucket)) {
                currentDistributionBucket$1.elem = (Distribution.Bucket)distributionBuckets$1.next();
                currentDistributionBucketValue$1.elem = $this.convert(((Distribution.Bucket)currentDistributionBucket$1.elem).value(), unit$5);
                if (currentDistributionBucketValue$1.elem <= Predef$.MODULE$.Double2double(configuredBucket)) {
                    inBucketCount$1.elem += ((Distribution.Bucket)currentDistributionBucket$1.elem).frequency();
                    continue;
                }
                leftOver$1.elem = ((Distribution.Bucket)currentDistributionBucket$1.elem).frequency();
            }
        }
        $this.appendTimeSerieValue(name$1, bucketTags, $this.format(inBucketCount$1.elem), "_bucket");
    }

    public ScrapeDataBuilder(PrometheusReporter.Settings prometheusConfig, TagSet environmentTags) {
        this.prometheusConfig = prometheusConfig;
        this.environmentTags = environmentTags;
        this._builder = new StringBuilder();
        this._decimalFormatSymbols = DecimalFormatSymbols.getInstance(Locale.ROOT);
        this._numberFormat = new DecimalFormat("#0.0########", this._decimalFormatSymbols());
    }
}

