/*
 * Decompiled with CFR 0.152.
 */
package kamon.prometheus;

import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import kamon.metric.Distribution;
import kamon.metric.Instrument;
import kamon.metric.MeasurementUnit;
import kamon.metric.MeasurementUnit$;
import kamon.metric.Metric;
import kamon.metric.MetricSnapshot;
import kamon.metric.MetricSnapshot$;
import kamon.prometheus.PrometheusSettings;
import kamon.prometheus.ScrapeDataBuilder$;
import kamon.tag.Tag;
import kamon.tag.TagSet;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.math.Ordering$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichChar$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\t\u0005c\u0001B\u0015+\u0001=B\u0001B\u000e\u0001\u0003\u0002\u0003\u0006Ia\u000e\u0005\t\u007f\u0001\u0011\t\u0011)A\u0005\u0001\")a\t\u0001C\u0001\u000f\"91\n\u0001b\u0001\n\u0013a\u0005BB+\u0001A\u0003%Q\nC\u0004W\u0001\t\u0007I\u0011B,\t\ry\u0003\u0001\u0015!\u0003Y\u0011\u001dy\u0006A1A\u0005\n\u0001Da\u0001\u001a\u0001!\u0002\u0013\t\u0007\"B3\u0001\t\u00031\u0007\"\u0002:\u0001\t\u0003\u0019\bbBA\r\u0001\u0011\u0005\u00111\u0004\u0005\b\u0003W\u0001A\u0011AA\u0017\u0011\u001d\tY\u0004\u0001C\u0001\u0003{Aq!a\u0011\u0001\t\u0013\t)\u0005C\u0004\u0002P\u0001!I!!\u0015\t\u000f\u0005U\u0003\u0001\"\u0003\u0002X!9\u00111\f\u0001\u0005\n\u0005u\u0003bBA1\u0001\u0011%\u00111\r\u0005\b\u0003O\u0002A\u0011BA5\u0011%\tY\bAI\u0001\n\u0013\ti\bC\u0004\u0002\u0014\u0002!I!!&\t\u000f\u0005-\u0006\u0001\"\u0003\u0002.\"9\u00111\u0019\u0001\u0005\n\u0005\u0015\u0007bBAj\u0001\u0011%\u0011Q\u001b\u0005\b\u00033\u0004A\u0011BAn\u0011\u001d\ty\u000e\u0001C\u0005\u0003CDq!!;\u0001\t\u0013\tY\u000fC\u0004\u0002r\u0002!I!a=\t\u000f\u0005e\b\u0001\"\u0003\u0002|\"9!1\u0001\u0001\u0005\n\t\u0015\u0001b\u0002B\u0006\u0001\u0011%!Q\u0002\u0005\b\u00053\u0001A\u0011\u0002B\u000e\u0011\u001d\u0011y\u0002\u0001C\u0005\u0005CAqA!\n\u0001\t\u0013\u00119\u0003C\u0004\u0003,\u0001!IA!\f\b\u0013\tM\"&!A\t\u0002\tUb\u0001C\u0015+\u0003\u0003E\tAa\u000e\t\r\u00193C\u0011\u0001B\u001d\u0011%\u0011YDJI\u0001\n\u0003\u0011iDA\tTGJ\f\u0007/\u001a#bi\u0006\u0014U/\u001b7eKJT!a\u000b\u0017\u0002\u0015A\u0014x.\\3uQ\u0016,8OC\u0001.\u0003\u0015Y\u0017-\\8o\u0007\u0001\u0019\"\u0001\u0001\u0019\u0011\u0005E\"T\"\u0001\u001a\u000b\u0003M\nQa]2bY\u0006L!!\u000e\u001a\u0003\r\u0005s\u0017PU3g\u0003A\u0001(o\\7fi\",Wo]\"p]\u001aLw\r\u0005\u00029y9\u0011\u0011HO\u0007\u0002U%\u00111HK\u0001\u0013!J|W.\u001a;iKV\u001c8+\u001a;uS:<7/\u0003\u0002>}\t9q)\u001a8fe&\u001c'BA\u001e+\u0003=)gN^5s_:lWM\u001c;UC\u001e\u001c\bCA!E\u001b\u0005\u0011%BA\"-\u0003\r!\u0018mZ\u0005\u0003\u000b\n\u0013a\u0001V1h'\u0016$\u0018A\u0002\u001fj]&$h\bF\u0002I\u0013*\u0003\"!\u000f\u0001\t\u000bY\u001a\u0001\u0019A\u001c\t\u000f}\u001a\u0001\u0013!a\u0001\u0001\u0006AqLY;jY\u0012,'/F\u0001N!\tq5+D\u0001P\u0015\t\u0001\u0016+\u0001\u0003mC:<'\"\u0001*\u0002\t)\fg/Y\u0005\u0003)>\u0013Qb\u0015;sS:<')^5mI\u0016\u0014\u0018!C0ck&dG-\u001a:!\u0003UyF-Z2j[\u0006dgi\u001c:nCR\u001c\u00160\u001c2pYN,\u0012\u0001\u0017\t\u00033rk\u0011A\u0017\u0006\u00037F\u000bA\u0001^3yi&\u0011QL\u0017\u0002\u0015\t\u0016\u001c\u0017.\\1m\r>\u0014X.\u0019;Ts6\u0014w\u000e\\:\u0002-}#WmY5nC24uN]7biNKXNY8mg\u0002\nQb\u00188v[\n,'OR8s[\u0006$X#A1\u0011\u0005e\u0013\u0017BA2[\u00055!UmY5nC24uN]7bi\u0006qqL\\;nE\u0016\u0014hi\u001c:nCR\u0004\u0013!\u00022vS2$G#A4\u0011\u0005!|gBA5n!\tQ''D\u0001l\u0015\tag&\u0001\u0004=e>|GOP\u0005\u0003]J\na\u0001\u0015:fI\u00164\u0017B\u00019r\u0005\u0019\u0019FO]5oO*\u0011aNM\u0001\u000fCB\u0004XM\u001c3D_VtG/\u001a:t)\tAE\u000fC\u0003v\u0017\u0001\u0007a/\u0001\u0005d_VtG/\u001a:t!\r9Hp \b\u0003qjt!A[=\n\u0003MJ!a\u001f\u001a\u0002\u000fA\f7m[1hK&\u0011QP \u0002\u0004'\u0016\f(BA>3!\u0019\t\t!!\u0004\u0002\u00149!\u00111AA\u0005\u001b\t\t)AC\u0002\u0002\b1\na!\\3ue&\u001c\u0017\u0002BA\u0006\u0003\u000b\ta\"T3ue&\u001c7K\\1qg\"|G/\u0003\u0003\u0002\u0010\u0005E!A\u0002,bYV,7O\u0003\u0003\u0002\f\u0005\u0015\u0001cA\u0019\u0002\u0016%\u0019\u0011q\u0003\u001a\u0003\t1{gnZ\u0001\rCB\u0004XM\u001c3HCV<Wm\u001d\u000b\u0004\u0011\u0006u\u0001bBA\u0010\u0019\u0001\u0007\u0011\u0011E\u0001\u0007O\u0006,x-Z:\u0011\t]d\u00181\u0005\t\u0007\u0003\u0003\ti!!\n\u0011\u0007E\n9#C\u0002\u0002*I\u0012a\u0001R8vE2,\u0017\u0001E1qa\u0016tG\rS5ti><'/Y7t)\rA\u0015q\u0006\u0005\b\u0003ci\u0001\u0019AA\u001a\u0003)A\u0017n\u001d;pOJ\fWn\u001d\t\u0005or\f)\u0004\u0005\u0003\u0002\u0002\u0005]\u0012\u0002BA\u001d\u0003#\u0011Q\u0002R5tiJL'-\u001e;j_:\u001c\u0018!I1qa\u0016tG\rR5tiJL'-\u001e;j_:lU\r\u001e:jGN\f5oR1vO\u0016\u001cHc\u0001%\u0002@!9\u0011\u0011\t\bA\u0002\u0005M\u0012!\u00043jgR\u0014\u0018NY;uS>t7/A\nbaB,g\u000eZ\"pk:$XM]'fiJL7\r\u0006\u0003\u0002H\u00055\u0003cA\u0019\u0002J%\u0019\u00111\n\u001a\u0003\tUs\u0017\u000e\u001e\u0005\u0007\u0003\u000fy\u0001\u0019A@\u0002#\u0005\u0004\b/\u001a8e\u000f\u0006,x-Z'fiJL7\r\u0006\u0003\u0002H\u0005M\u0003bBA\u0004!\u0001\u0007\u00111E\u0001\u0019CB\u0004XM\u001c3ESN$(/\u001b2vi&|g.T3ue&\u001cG\u0003BA$\u00033Bq!a\u0002\u0012\u0001\u0004\t)$A\u0012baB,g\u000e\u001a#jgR\u0014\u0018NY;uS>tW*\u001a;sS\u000e\f5\u000fS5ti><'/Y7\u0015\t\u0005\u001d\u0013q\f\u0005\b\u0003\u000f\u0011\u0002\u0019AA\u001b\u0003\u0005\n\u0007\u000f]3oI\u0012K7\u000f\u001e:jEV$\u0018n\u001c8NKR\u0014\u0018nY!t'VlW.\u0019:z)\u0011\t9%!\u001a\t\u000f\u0005\u001d1\u00031\u0001\u00026\u0005!\u0012\r\u001d9f]\u0012$\u0016.\\3TKJLWMV1mk\u0016$\"\"a\u0012\u0002l\u0005=\u00141OA<\u0011\u0019\ti\u0007\u0006a\u0001O\u0006!a.Y7f\u0011\u0019\t\t\b\u0006a\u0001\u0001\u0006!A/Y4t\u0011\u0019\t)\b\u0006a\u0001O\u0006)a/\u00197vK\"A\u0011\u0011\u0010\u000b\u0011\u0002\u0003\u0007q-\u0001\u0004tk\u001a4\u0017\u000e_\u0001\u001fCB\u0004XM\u001c3US6,7+\u001a:jKZ\u000bG.^3%I\u00164\u0017-\u001e7uIQ*\"!a +\u0007\u001d\f\ti\u000b\u0002\u0002\u0004B!\u0011QQAH\u001b\t\t9I\u0003\u0003\u0002\n\u0006-\u0015!C;oG\",7m[3e\u0015\r\tiIM\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAI\u0003\u000f\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003i\u0011Xm]8mm\u0016\u0014UoY6fi\u000e{gNZ5hkJ\fG/[8o)\u0019\t9*!(\u0002\"B!q\u000f`AM!\rq\u00151T\u0005\u0004\u0003Sy\u0005BBAP-\u0001\u0007q-\u0001\u0006nKR\u0014\u0018n\u0019(b[\u0016Dq!a)\u0017\u0001\u0004\t)+\u0001\u0003v]&$\b\u0003BA\u0002\u0003OKA!!+\u0002\u0006\tyQ*Z1tkJ,W.\u001a8u+:LG/\u0001\fbaB,g\u000eZ*v[6\f'/_)vC:$\u0018\u000e\\3t)1\t9%a,\u00022\u0006M\u0016QXA`\u0011\u0019\tig\u0006a\u0001O\"1\u0011\u0011O\fA\u0002\u0001Cq!!.\u0018\u0001\u0004\t9,\u0001\u0007eSN$(/\u001b2vi&|g\u000e\u0005\u0003\u0002\u0004\u0005e\u0016\u0002BA^\u0003\u000b\u0011A\u0002R5tiJL'-\u001e;j_:Dq!a)\u0018\u0001\u0004\t)\u000bC\u0004\u0002B^\u0001\r!a&\u0002\u0013E,\u0018M\u001c;jY\u0016\u001c\u0018AF1qa\u0016tG\rS5ti><'/Y7Ck\u000e\\W\r^:\u0015\u0019\u0005\u001d\u0013qYAe\u0003\u0017\fi-a4\t\r\u00055\u0004\u00041\u0001h\u0011\u0019\t\t\b\u0007a\u0001\u0001\"9\u0011Q\u0017\rA\u0002\u0005]\u0006bBAR1\u0001\u0007\u0011Q\u0015\u0005\b\u0003#D\u0002\u0019AAL\u0003\u001d\u0011WoY6fiN\f!\"\u00199qK:$G+Y4t)\u0011\t9%a6\t\r\u0005E\u0014\u00041\u0001A\u00035\u0019HO]5oO&4\u0017\u0010V1hgR!\u0011qIAo\u0011\u0019\t\tH\u0007a\u0001\u0001\u0006a\u0011\r\u001d9f]\u0012$\u0016mZ:U_R1\u0011qIAr\u0003KDa!!\u001d\u001c\u0001\u0004\u0001\u0005BBAt7\u0001\u0007Q*\u0001\u0004ck\u001a4WM]\u0001\u001b]>\u0014X.\u00197ju\u0016\u001cu.\u001e8uKJlU\r\u001e:jG:\u000bW.\u001a\u000b\u0006O\u00065\u0018q\u001e\u0005\u0007\u0003?c\u0002\u0019A4\t\u000f\u0005\rF\u00041\u0001\u0002&\u0006\u0019bn\u001c:nC2L'0Z'fiJL7MT1nKR)q-!>\u0002x\"1\u0011qT\u000fA\u0002\u001dDq!a)\u001e\u0001\u0004\t)+A\fbI\u0012\u0004vn\u001d;gSb|e\u000e\\=JM6K7o]5oOR)q-!@\u0002\u0000\"1\u0011q\u0014\u0010A\u0002\u001dDaA!\u0001\u001f\u0001\u00049\u0017a\u00029pgR4\u0017\u000e_\u0001\u0013]>\u0014X.\u00197ju\u0016d\u0015MY3m\u001d\u0006lW\rF\u0002h\u0005\u000fAaA!\u0003 \u0001\u00049\u0017!\u00027bE\u0016d\u0017A\u0004<bY&$G*\u00192fY\u000eC\u0017M\u001d\u000b\u0005\u0005\u001f\u0011)\u0002E\u00022\u0005#I1Aa\u00053\u0005\u0011\u0019\u0005.\u0019:\t\u000f\t]\u0001\u00051\u0001\u0003\u0010\u0005!1\r[1s\u000351\u0018\r\\5e\u001d\u0006lWm\u00115beR!!q\u0002B\u000f\u0011\u001d\u00119\"\ta\u0001\u0005\u001f\t1C\\8s[\u0006d\u0017N_3MC\n,GNV1mk\u0016$2a\u001aB\u0012\u0011\u0019\t)H\ta\u0001O\u00061am\u001c:nCR$2a\u001aB\u0015\u0011\u001d\t)h\ta\u0001\u0003K\tqaY8om\u0016\u0014H\u000f\u0006\u0004\u0002&\t=\"\u0011\u0007\u0005\b\u0003k\"\u0003\u0019AA\u0013\u0011\u001d\t\u0019\u000b\na\u0001\u0003K\u000b\u0011cU2sCB,G)\u0019;b\u0005VLG\u000eZ3s!\tIde\u0005\u0002'aQ\u0011!QG\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\t}\"f\u0001!\u0002\u0002\u0002")
public class ScrapeDataBuilder {
    private final PrometheusSettings.Generic prometheusConfig;
    private final TagSet environmentTags;
    private final StringBuilder _builder;
    private final DecimalFormatSymbols _decimalFormatSymbols;
    private final DecimalFormat _numberFormat;

    public static TagSet $lessinit$greater$default$2() {
        return ScrapeDataBuilder$.MODULE$.$lessinit$greater$default$2();
    }

    private StringBuilder _builder() {
        return this._builder;
    }

    private DecimalFormatSymbols _decimalFormatSymbols() {
        return this._decimalFormatSymbols;
    }

    private DecimalFormat _numberFormat() {
        return this._numberFormat;
    }

    public String build() {
        return this._builder().toString();
    }

    public ScrapeDataBuilder appendCounters(Seq<MetricSnapshot<Metric.Settings.ForValueInstrument, Object>> counters) {
        counters.foreach((Function1 & Serializable)metric -> {
            this.appendCounterMetric((MetricSnapshot<Metric.Settings.ForValueInstrument, Object>)metric);
            return BoxedUnit.UNIT;
        });
        return this;
    }

    public ScrapeDataBuilder appendGauges(Seq<MetricSnapshot<Metric.Settings.ForValueInstrument, Object>> gauges) {
        gauges.foreach((Function1 & Serializable)metric -> {
            this.appendGaugeMetric((MetricSnapshot<Metric.Settings.ForValueInstrument, Object>)metric);
            return BoxedUnit.UNIT;
        });
        return this;
    }

    public ScrapeDataBuilder appendHistograms(Seq<MetricSnapshot<Metric.Settings.ForDistributionInstrument, Distribution>> histograms) {
        histograms.foreach((Function1 & Serializable)metric -> {
            this.appendDistributionMetric((MetricSnapshot<Metric.Settings.ForDistributionInstrument, Distribution>)metric);
            return BoxedUnit.UNIT;
        });
        return this;
    }

    public ScrapeDataBuilder appendDistributionMetricsAsGauges(Seq<MetricSnapshot<Metric.Settings.ForDistributionInstrument, Distribution>> distributions) {
        ((IterableOnceOps)((IterableOps)((IterableOps)distributions.filter((Function1 & Serializable)metric -> BoxesRunTime.boxToBoolean((boolean)this.gaugeFilter$1(metric)))).map((Function1 & Serializable)metric -> {
            Metric.Settings.ForValueInstrument settings = new Metric.Settings.ForValueInstrument(((Metric.Settings.ForDistributionInstrument)metric.settings()).unit(), ((Metric.Settings.ForDistributionInstrument)metric.settings()).autoUpdateInterval());
            return (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MetricSnapshot[]{MetricSnapshot$.MODULE$.ofValues(new StringBuilder(4).append(metric.name()).append(".min").toString(), metric.description(), settings, (Seq)metric.instruments().map((Function1 & Serializable)snap -> new Instrument.Snapshot(snap.tags(), (Object)BoxesRunTime.boxToDouble((double)((Distribution)snap.value()).min())))), MetricSnapshot$.MODULE$.ofValues(new StringBuilder(4).append(metric.name()).append(".max").toString(), metric.description(), settings, (Seq)metric.instruments().map((Function1 & Serializable)snap -> new Instrument.Snapshot(snap.tags(), (Object)BoxesRunTime.boxToDouble((double)((Distribution)snap.value()).max())))), MetricSnapshot$.MODULE$.ofValues(new StringBuilder(4).append(metric.name()).append(".avg").toString(), metric.description(), settings, (Seq)metric.instruments().map((Function1 & Serializable)snap -> new Instrument.Snapshot(snap.tags(), (Object)BoxesRunTime.boxToDouble((double)ScrapeDataBuilder.avg$1(snap)))))}));
        })).flatten(Predef$.MODULE$.$conforms())).foreach((Function1 & Serializable)metric -> {
            this.appendGaugeMetric((MetricSnapshot<Metric.Settings.ForValueInstrument, Object>)metric);
            return BoxedUnit.UNIT;
        });
        return this;
    }

    private void appendCounterMetric(MetricSnapshot<Metric.Settings.ForValueInstrument, Object> metric) {
        MeasurementUnit unit = ((Metric.Settings.ForValueInstrument)metric.settings()).unit();
        String normalizedMetricName = this.normalizeCounterMetricName(metric.name(), unit);
        Object object = StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(metric.description())) ? this._builder().append("# HELP ").append(normalizedMetricName).append(" ").append(metric.description()).append("\n") : BoxedUnit.UNIT;
        this._builder().append("# TYPE ").append(normalizedMetricName).append(" counter\n");
        metric.instruments().foreach((Function1 & Serializable)instrument -> {
            this._builder().append(normalizedMetricName);
            this.appendTags(instrument.tags());
            this._builder().append(" ");
            this._builder().append(this.format(this.convert(BoxesRunTime.unboxToLong((Object)instrument.value()), unit)));
            return this._builder().append("\n");
        });
    }

    private void appendGaugeMetric(MetricSnapshot<Metric.Settings.ForValueInstrument, Object> metric) {
        MeasurementUnit unit = ((Metric.Settings.ForValueInstrument)metric.settings()).unit();
        String normalizedMetricName = this.normalizeMetricName(metric.name(), unit);
        Object object = StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(metric.description())) ? this._builder().append("# HELP ").append(normalizedMetricName).append(" ").append(metric.description()).append("\n") : BoxedUnit.UNIT;
        this._builder().append("# TYPE ").append(normalizedMetricName).append(" gauge\n");
        metric.instruments().foreach((Function1 & Serializable)instrument -> {
            this._builder().append(normalizedMetricName);
            this.appendTags(instrument.tags());
            this._builder().append(" ");
            this._builder().append(this.format(this.convert(BoxesRunTime.unboxToDouble((Object)instrument.value()), unit)));
            return this._builder().append("\n");
        });
    }

    private void appendDistributionMetric(MetricSnapshot<Metric.Settings.ForDistributionInstrument, Distribution> metric) {
        boolean reportAsSummary = this.prometheusConfig.summarySettings().metricMatchers().exists((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.accept(metric.name())));
        if (reportAsSummary) {
            this.appendDistributionMetricAsSummary(metric);
        } else {
            this.appendDistributionMetricAsHistogram(metric);
        }
    }

    private void appendDistributionMetricAsHistogram(MetricSnapshot<Metric.Settings.ForDistributionInstrument, Distribution> metric) {
        MeasurementUnit unit = ((Metric.Settings.ForDistributionInstrument)metric.settings()).unit();
        String normalizedMetricName = this.normalizeMetricName(metric.name(), unit);
        Object object = StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(metric.description())) ? this._builder().append("# HELP ").append(normalizedMetricName).append(" ").append(metric.description()).append("\n") : BoxedUnit.UNIT;
        this._builder().append("# TYPE ").append(normalizedMetricName).append(" histogram").append("\n");
        metric.instruments().foreach((Function1 & Serializable)instrument -> {
            ScrapeDataBuilder.$anonfun$appendDistributionMetricAsHistogram$1(this, normalizedMetricName, unit, metric, instrument);
            return BoxedUnit.UNIT;
        });
    }

    private void appendDistributionMetricAsSummary(MetricSnapshot<Metric.Settings.ForDistributionInstrument, Distribution> metric) {
        MeasurementUnit unit = ((Metric.Settings.ForDistributionInstrument)metric.settings()).unit();
        String normalizedMetricName = this.normalizeMetricName(metric.name(), unit);
        Object object = StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(metric.description())) ? this._builder().append("# HELP ").append(normalizedMetricName).append(" ").append(metric.description()).append("\n") : BoxedUnit.UNIT;
        this._builder().append("# TYPE ").append(normalizedMetricName).append(" summary").append("\n");
        metric.instruments().foreach((Function1 & Serializable)instrument -> {
            ScrapeDataBuilder.$anonfun$appendDistributionMetricAsSummary$1(this, normalizedMetricName, unit, instrument);
            return BoxedUnit.UNIT;
        });
    }

    private void appendTimeSerieValue(String name, TagSet tags, String value, String suffix) {
        this._builder().append(name);
        this._builder().append(suffix);
        this.appendTags(tags);
        this._builder().append(" ");
        this._builder().append(value);
        this._builder().append("\n");
    }

    private String appendTimeSerieValue$default$4() {
        return "";
    }

    private Seq<Double> resolveBucketConfiguration(String metricName, MeasurementUnit unit) {
        return (Seq)this.prometheusConfig.customBuckets().getOrElse((Object)metricName, (Function0 & Serializable)() -> {
            Seq<Double> seq;
            MeasurementUnit.Dimension dimension = unit.dimension();
            MeasurementUnit.Dimension dimension2 = MeasurementUnit.Dimension$.MODULE$.Time();
            MeasurementUnit.Dimension dimension3 = dimension;
            if (!(dimension2 != null ? !dimension2.equals(dimension3) : dimension3 != null)) {
                seq = $this.prometheusConfig.timeBuckets();
            } else {
                MeasurementUnit.Dimension dimension4 = MeasurementUnit.Dimension$.MODULE$.Information();
                MeasurementUnit.Dimension dimension5 = dimension;
                if (!(dimension4 != null ? !dimension4.equals(dimension5) : dimension5 != null)) {
                    seq = $this.prometheusConfig.informationBuckets();
                } else {
                    MeasurementUnit.Dimension dimension6 = MeasurementUnit.Dimension$.MODULE$.Percentage();
                    MeasurementUnit.Dimension dimension7 = dimension;
                    seq = !(dimension6 != null ? !dimension6.equals(dimension7) : dimension7 != null) ? $this.prometheusConfig.percentageBuckets() : $this.prometheusConfig.defaultBuckets();
                }
            }
            return seq;
        });
    }

    private void appendSummaryQuantiles(String name, TagSet tags, Distribution distribution, MeasurementUnit unit, Seq<Double> quantiles) {
        Iterator percentileIter = distribution.percentilesIterator();
        Seq percentiles = (Seq)((IterableOps)quantiles.sorted(Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()))).map((Function1 & Serializable)quant -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(quant), percentileIter.find((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)ScrapeDataBuilder.$anonfun$appendSummaryQuantiles$2(quant, x$3))).map((Function1 & Serializable)x$4 -> BoxesRunTime.boxToLong((long)x$4.value())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L)));
        percentiles.foreach((Function1 & Serializable)x0$1 -> {
            ScrapeDataBuilder.$anonfun$appendSummaryQuantiles$5(this, tags, name, unit, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    private void appendHistogramBuckets(String name, TagSet tags, Distribution distribution, MeasurementUnit unit, Seq<Double> buckets) {
        Iterator distributionBuckets = distribution.bucketsIterator();
        ObjectRef currentDistributionBucket = ObjectRef.create((Object)((Distribution.Bucket)distributionBuckets.next()));
        DoubleRef currentDistributionBucketValue = DoubleRef.create((double)this.convert(((Distribution.Bucket)currentDistributionBucket.elem).value(), unit));
        LongRef inBucketCount = LongRef.create((long)0L);
        LongRef leftOver = LongRef.create((long)((Distribution.Bucket)currentDistributionBucket.elem).frequency());
        buckets.foreach((Function1 & Serializable)configuredBucket -> {
            ScrapeDataBuilder.$anonfun$appendHistogramBuckets$1(this, tags, currentDistributionBucketValue, inBucketCount, leftOver, distributionBuckets, currentDistributionBucket, unit, name, configuredBucket);
            return BoxedUnit.UNIT;
        });
        while (distributionBuckets.hasNext()) {
            leftOver.elem += ((Distribution.Bucket)distributionBuckets.next()).frequency();
        }
        this.appendTimeSerieValue(name, tags.withTag("le", "+Inf"), this.format(leftOver.elem + inBucketCount.elem), "_bucket");
    }

    private void appendTags(TagSet tags) {
        this.appendTagsTo(tags, this._builder());
    }

    private void stringifyTags(TagSet tags) {
        StringBuilder builder = new StringBuilder();
        this.appendTagsTo(tags, builder);
        builder.toString();
    }

    private void appendTagsTo(TagSet tags, StringBuilder buffer) {
        block1: {
            TagSet allTags = tags.withTags(this.environmentTags);
            Object object = allTags.nonEmpty() ? buffer.append("{") : BoxedUnit.UNIT;
            Iterator tagIterator = allTags.iterator((Function1 & Serializable)v -> v == null ? "" : v.toString());
            int tagCount = 0;
            while (tagIterator.hasNext()) {
                Tag.Pair pair = (Tag.Pair)tagIterator.next();
                Object object2 = tagCount > 0 ? buffer.append(",") : BoxedUnit.UNIT;
                buffer.append(this.normalizeLabelName(pair.key())).append("=\"").append(this.normalizeLabelValue((String)pair.value())).append('\"');
                ++tagCount;
            }
            if (!allTags.nonEmpty()) break block1;
            buffer.append("}");
        }
    }

    private String normalizeCounterMetricName(String metricName, MeasurementUnit unit) {
        String string;
        String normalizedMetricName = StringOps$.MODULE$.map$extension(Predef$.MODULE$.augmentString(metricName), (Function1 & Serializable)x$5 -> BoxesRunTime.boxToCharacter((char)this.validNameChar(BoxesRunTime.unboxToChar((Object)x$5))));
        MeasurementUnit.Dimension dimension = unit.dimension();
        MeasurementUnit.Dimension dimension2 = MeasurementUnit.Dimension$.MODULE$.Time();
        MeasurementUnit.Dimension dimension3 = dimension;
        if (!(dimension2 != null ? !dimension2.equals(dimension3) : dimension3 != null)) {
            string = this.addPostfixOnlyIfMissing(normalizedMetricName, "_seconds_total");
        } else {
            MeasurementUnit.Dimension dimension4 = MeasurementUnit.Dimension$.MODULE$.Information();
            MeasurementUnit.Dimension dimension5 = dimension;
            string = !(dimension4 != null ? !dimension4.equals(dimension5) : dimension5 != null) ? this.addPostfixOnlyIfMissing(normalizedMetricName, "_bytes_total") : this.addPostfixOnlyIfMissing(normalizedMetricName, "_total");
        }
        return string;
    }

    private String normalizeMetricName(String metricName, MeasurementUnit unit) {
        String string;
        String normalizedMetricName = StringOps$.MODULE$.map$extension(Predef$.MODULE$.augmentString(metricName), (Function1 & Serializable)x$6 -> BoxesRunTime.boxToCharacter((char)this.validNameChar(BoxesRunTime.unboxToChar((Object)x$6))));
        MeasurementUnit.Dimension dimension = unit.dimension();
        MeasurementUnit.Dimension dimension2 = MeasurementUnit.Dimension$.MODULE$.Time();
        MeasurementUnit.Dimension dimension3 = dimension;
        if (!(dimension2 != null ? !dimension2.equals(dimension3) : dimension3 != null)) {
            string = this.addPostfixOnlyIfMissing(normalizedMetricName, "_seconds");
        } else {
            MeasurementUnit.Dimension dimension4 = MeasurementUnit.Dimension$.MODULE$.Information();
            MeasurementUnit.Dimension dimension5 = dimension;
            string = !(dimension4 != null ? !dimension4.equals(dimension5) : dimension5 != null) ? this.addPostfixOnlyIfMissing(normalizedMetricName, "_bytes") : normalizedMetricName;
        }
        return string;
    }

    private String addPostfixOnlyIfMissing(String metricName, String postfix) {
        return metricName.endsWith(postfix) ? metricName : new StringBuilder(0).append(metricName).append(postfix).toString();
    }

    private String normalizeLabelName(String label) {
        return StringOps$.MODULE$.map$extension(Predef$.MODULE$.augmentString(label), (Function1 & Serializable)object -> BoxesRunTime.boxToCharacter((char)this.validLabelChar(BoxesRunTime.unboxToChar((Object)object))));
    }

    private char validLabelChar(char n) {
        return (char)(RichChar$.MODULE$.isLetterOrDigit$extension(Predef$.MODULE$.charWrapper((char)n)) || n == 95 ? n : 95);
    }

    private char validNameChar(char n) {
        return (char)(RichChar$.MODULE$.isLetterOrDigit$extension(Predef$.MODULE$.charWrapper((char)n)) || n == 95 || n == 58 ? n : 95);
    }

    private String normalizeLabelValue(String value) {
        return value.contains("\\") ? value.replace("\\", "\\\\") : value;
    }

    private String format(double value) {
        return this._numberFormat().format(value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private double convert(double value, MeasurementUnit unit) {
        MeasurementUnit.Dimension dimension = unit.dimension();
        MeasurementUnit.Dimension dimension2 = MeasurementUnit.Dimension$.MODULE$.Time();
        MeasurementUnit.Dimension dimension3 = dimension;
        if (!(dimension2 != null ? !dimension2.equals(dimension3) : dimension3 != null)) {
            MeasurementUnit.Magnitude magnitude = unit.magnitude();
            MeasurementUnit.Magnitude magnitude2 = MeasurementUnit$.MODULE$.time().seconds().magnitude();
            if (magnitude == null ? magnitude2 != null : !magnitude.equals(magnitude2)) {
                return MeasurementUnit$.MODULE$.convert(value, unit, MeasurementUnit$.MODULE$.time().seconds());
            }
        }
        MeasurementUnit.Dimension dimension4 = MeasurementUnit.Dimension$.MODULE$.Information();
        MeasurementUnit.Dimension dimension5 = dimension;
        if (dimension4 == null) {
            if (dimension5 != null) {
                return value;
            }
        } else if (!dimension4.equals(dimension5)) return value;
        MeasurementUnit.Magnitude magnitude = unit.magnitude();
        MeasurementUnit.Magnitude magnitude3 = MeasurementUnit$.MODULE$.information().bytes().magnitude();
        if (magnitude == null) {
            if (magnitude3 == null) return value;
            return MeasurementUnit$.MODULE$.convert(value, unit, MeasurementUnit$.MODULE$.information().bytes());
        } else if (magnitude.equals(magnitude3)) return value;
        return MeasurementUnit$.MODULE$.convert(value, unit, MeasurementUnit$.MODULE$.information().bytes());
    }

    private final boolean gaugeFilter$1(MetricSnapshot metric) {
        return this.prometheusConfig.gaugeSettings().metricMatchers().exists((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.accept(metric.name())));
    }

    private static final double avg$1(Instrument.Snapshot snap) {
        return ((Distribution)snap.value()).count() == 0L ? 0.0 : (double)(((Distribution)snap.value()).sum() / ((Distribution)snap.value()).count());
    }

    public static final /* synthetic */ void $anonfun$appendDistributionMetricAsHistogram$1(ScrapeDataBuilder $this, String normalizedMetricName$3, MeasurementUnit unit$3, MetricSnapshot metric$3, Instrument.Snapshot instrument) {
        block0: {
            if (((Distribution)instrument.value()).count() <= 0L) break block0;
            $this.appendHistogramBuckets(normalizedMetricName$3, instrument.tags(), (Distribution)instrument.value(), unit$3, $this.resolveBucketConfiguration(metric$3.name(), unit$3));
            String count = $this.format(((Distribution)instrument.value()).count());
            String sum = $this.format($this.convert(((Distribution)instrument.value()).sum(), unit$3));
            $this.appendTimeSerieValue(normalizedMetricName$3, instrument.tags(), count, "_count");
            $this.appendTimeSerieValue(normalizedMetricName$3, instrument.tags(), sum, "_sum");
        }
    }

    public static final /* synthetic */ void $anonfun$appendDistributionMetricAsSummary$1(ScrapeDataBuilder $this, String normalizedMetricName$4, MeasurementUnit unit$4, Instrument.Snapshot instrument) {
        block0: {
            if (((Distribution)instrument.value()).count() <= 0L) break block0;
            $this.appendSummaryQuantiles(normalizedMetricName$4, instrument.tags(), (Distribution)instrument.value(), unit$4, $this.prometheusConfig.summarySettings().quantiles());
            $this.appendTimeSerieValue(normalizedMetricName$4, instrument.tags(), $this.format(((Distribution)instrument.value()).count()), "_count");
            $this.appendTimeSerieValue(normalizedMetricName$4, instrument.tags(), $this.format(((Distribution)instrument.value()).sum()), "_sum");
        }
    }

    public static final /* synthetic */ boolean $anonfun$appendSummaryQuantiles$2(Double quant$1, Distribution.Percentile x$3) {
        return x$3.rank() >= Predef$.MODULE$.Double2double(quant$1) * (double)100;
    }

    public static final /* synthetic */ void $anonfun$appendSummaryQuantiles$5(ScrapeDataBuilder $this, TagSet tags$1, String name$1, MeasurementUnit unit$6, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Double quantileRank = (Double)tuple2._1();
        long percentile = tuple2._2$mcJ$sp();
        TagSet percTags = tags$1.withTag("quantile", $this.format(Predef$.MODULE$.Double2double(quantileRank)));
        $this.appendTimeSerieValue(name$1, percTags, $this.format($this.convert(percentile, unit$6)), $this.appendTimeSerieValue$default$4());
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$appendHistogramBuckets$1(ScrapeDataBuilder $this, TagSet tags$2, DoubleRef currentDistributionBucketValue$1, LongRef inBucketCount$1, LongRef leftOver$1, Iterator distributionBuckets$1, ObjectRef currentDistributionBucket$1, MeasurementUnit unit$7, String name$2, Double configuredBucket) {
        TagSet bucketTags = tags$2.withTag("le", String.valueOf(configuredBucket));
        if (currentDistributionBucketValue$1.elem <= Predef$.MODULE$.Double2double(configuredBucket)) {
            inBucketCount$1.elem += leftOver$1.elem;
            leftOver$1.elem = 0L;
            while (distributionBuckets$1.hasNext() && currentDistributionBucketValue$1.elem <= Predef$.MODULE$.Double2double(configuredBucket)) {
                currentDistributionBucket$1.elem = (Distribution.Bucket)distributionBuckets$1.next();
                currentDistributionBucketValue$1.elem = $this.convert(((Distribution.Bucket)currentDistributionBucket$1.elem).value(), unit$7);
                if (currentDistributionBucketValue$1.elem <= Predef$.MODULE$.Double2double(configuredBucket)) {
                    inBucketCount$1.elem += ((Distribution.Bucket)currentDistributionBucket$1.elem).frequency();
                    continue;
                }
                leftOver$1.elem = ((Distribution.Bucket)currentDistributionBucket$1.elem).frequency();
            }
        }
        $this.appendTimeSerieValue(name$2, bucketTags, $this.format(inBucketCount$1.elem), "_bucket");
    }

    public ScrapeDataBuilder(PrometheusSettings.Generic prometheusConfig, TagSet environmentTags) {
        this.prometheusConfig = prometheusConfig;
        this.environmentTags = environmentTags;
        this._builder = new StringBuilder();
        this._decimalFormatSymbols = DecimalFormatSymbols.getInstance(Locale.ROOT);
        this._numberFormat = new DecimalFormat("#0.0########", this._decimalFormatSymbols());
    }
}

