/*
 * Decompiled with CFR 0.152.
 */
package kamon.riemann;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.ExtendedActorSystem;
import akka.event.LogSource$;
import akka.event.Logging$;
import akka.event.LoggingAdapter;
import com.typesafe.config.Config;
import java.io.Serializable;
import kamon.Kamon;
import kamon.Kamon$;
import kamon.metric.MetricsModuleImpl;
import kamon.metric.TickMetricSnapshotBuffer$;
import kamon.riemann.MetricsMapper;
import kamon.riemann.MetricsSenderFactory;
import kamon.riemann.TcpMetricsSender$;
import kamon.riemann.UdpMetricsSender$;
import kamon.util.ConfigTools;
import kamon.util.ConfigTools$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005b\u0001B\u0001\u0003\u0001\u001d\u0011\u0001CU5f[\u0006tg.\u0012=uK:\u001c\u0018n\u001c8\u000b\u0005\r!\u0011a\u0002:jK6\fgN\u001c\u0006\u0002\u000b\u0005)1.Y7p]\u000e\u00011c\u0001\u0001\t\u001dA\u0011\u0011\u0002D\u0007\u0002\u0015)\t1\"A\u0003tG\u0006d\u0017-\u0003\u0002\u000e\u0015\t1\u0011I\\=SK\u001a\u0004\"aD\n\u000f\u0005A\tR\"\u0001\u0003\n\u0005I!\u0011!B&b[>t\u0017B\u0001\u000b\u0016\u0005%)\u0005\u0010^3og&|gN\u0003\u0002\u0013\t!Aq\u0003\u0001B\u0001B\u0003%\u0001$\u0001\u0004tsN$X-\u001c\t\u00033yi\u0011A\u0007\u0006\u00037q\tQ!Y2u_JT\u0011!H\u0001\u0005C.\\\u0017-\u0003\u0002 5\t\u0019R\t\u001f;f]\u0012,G-Q2u_J\u001c\u0016p\u001d;f[\")\u0011\u0005\u0001C\u0001E\u00051A(\u001b8jiz\"\"aI\u0013\u0011\u0005\u0011\u0002Q\"\u0001\u0002\t\u000b]\u0001\u0003\u0019\u0001\r\t\u000f\u001d\u0002!\u0019!C\u0002Q\u0005\u0011\u0011m]\u000b\u00021!1!\u0006\u0001Q\u0001\na\t1!Y:!\u0011\u001da\u0003A1A\u0005\n5\n1\u0001\\8h+\u0005q\u0003CA\u00183\u001b\u0005\u0001$BA\u0019\u001d\u0003\u0015)g/\u001a8u\u0013\t\u0019\u0004G\u0001\bM_\u001e<\u0017N\\4BI\u0006\u0004H/\u001a:\t\rU\u0002\u0001\u0015!\u0003/\u0003\u0011awn\u001a\u0011\t\u000f]\u0002!\u0019!C\u0005q\u0005\u0001R.\u001a;sS\u000e\u001cX\t\u001f;f]NLwN\\\u000b\u0002sA\u0011!(P\u0007\u0002w)\u0011A\bB\u0001\u0007[\u0016$(/[2\n\u0005yZ$!E'fiJL7m]'pIVdW-S7qY\"1\u0001\t\u0001Q\u0001\ne\n\u0011#\\3ue&\u001c7/\u0012=uK:\u001c\u0018n\u001c8!\u0011\u001d\u0011\u0005A1A\u0005\n\r\u000bA\u0002^5dW&sG/\u001a:wC2,\u0012\u0001\u0012\t\u0003\u000b*k\u0011A\u0012\u0006\u0003\u000f\"\u000b\u0001\u0002Z;sCRLwN\u001c\u0006\u0003\u0013*\t!bY8oGV\u0014(/\u001a8u\u0013\tYeI\u0001\bGS:LG/\u001a#ve\u0006$\u0018n\u001c8\t\r5\u0003\u0001\u0015!\u0003E\u00035!\u0018nY6J]R,'O^1mA!9q\n\u0001b\u0001\n\u0013\u0001\u0016AB2p]\u001aLw-F\u0001R!\t\u0011\u0006,D\u0001T\u0015\tyEK\u0003\u0002V-\u0006AA/\u001f9fg\u00064WMC\u0001X\u0003\r\u0019w.\\\u0005\u00033N\u0013aaQ8oM&<\u0007BB.\u0001A\u0003%\u0011+A\u0004d_:4\u0017n\u001a\u0011\t\u000fu\u0003!\u0019!C\u0005!\u0006i!/[3nC:t7i\u001c8gS\u001eDaa\u0018\u0001!\u0002\u0013\t\u0016A\u0004:jK6\fgN\\\"p]\u001aLw\r\t\u0005\bC\u0002\u0011\r\u0011\"\u0003c\u00035iW\r\u001e:jGNl\u0015\r\u001d9feV\t1\r\u0005\u0002eS6\tQM\u0003\u0002gO\u0006!A.\u00198h\u0015\u0005A\u0017\u0001\u00026bm\u0006L!A[3\u0003\rM#(/\u001b8h\u0011\u0019a\u0007\u0001)A\u0005G\u0006qQ.\u001a;sS\u000e\u001cX*\u00199qKJ\u0004\u0003\"\u00028\u0001\t\u0013y\u0017\u0001E;eaN+(m]2sSB$\u0018n\u001c8t)\u0005\u0001\bCA\u0005r\u0013\t\u0011(B\u0001\u0003V]&$\b\"\u0002;\u0001\t\u0013y\u0017\u0001\u0005;daN+(m]2sSB$\u0018n\u001c8t\u0011\u00151\b\u0001\"\u0003x\u0003Q\u0011W/\u001b7e\u001b\u0016$(/[2t\u0019&\u001cH/\u001a8feRA\u0001p\u001f?\u007f\u0003\u000f\ty\u0002\u0005\u0002\u001as&\u0011!P\u0007\u0002\t\u0003\u000e$xN\u001d*fM\")!)\u001ea\u0001\t\")Q0\u001ea\u0001\t\u0006ia\r\\;tQ&sG/\u001a:wC2Daa`;A\u0002\u0005\u0005\u0011!D:f]\u0012,'OR1di>\u0014\u0018\u0010E\u0002%\u0003\u0007I1!!\u0002\u0003\u0005QiU\r\u001e:jGN\u001cVM\u001c3fe\u001a\u000b7\r^8ss\"9\u0011\u0011B;A\u0002\u0005-\u0011aC7baB,'o\u00117bgN\u0004B!!\u0004\u0002\u001c9!\u0011qBA\f!\r\t\tBC\u0007\u0003\u0003'Q1!!\u0006\u0007\u0003\u0019a$o\\8u}%\u0019\u0011\u0011\u0004\u0006\u0002\rA\u0013X\rZ3g\u0013\rQ\u0017Q\u0004\u0006\u0004\u00033Q\u0001\"B(v\u0001\u0004\t\u0006")
public class RiemannExtension
implements Kamon.Extension {
    private final ExtendedActorSystem system;
    private final ExtendedActorSystem as;
    private final LoggingAdapter log;
    private final MetricsModuleImpl metricsExtension;
    private final FiniteDuration tickInterval;
    private final Config config;
    private final Config riemannConfig;
    private final String metricsMapper;

    public ExtendedActorSystem as() {
        return this.as;
    }

    private LoggingAdapter log() {
        return this.log;
    }

    private MetricsModuleImpl metricsExtension() {
        return this.metricsExtension;
    }

    private FiniteDuration tickInterval() {
        return this.tickInterval;
    }

    private Config config() {
        return this.config;
    }

    private Config riemannConfig() {
        return this.riemannConfig;
    }

    private String metricsMapper() {
        return this.metricsMapper;
    }

    private void udpSubscriptions() {
        Config udpConfig = this.riemannConfig().getConfig("udp");
        FiniteDuration udpFlushInterval = ConfigTools.Syntax$.MODULE$.getFiniteDuration$extension(ConfigTools$.MODULE$.Syntax(udpConfig), "flush-interval");
        Config udpSubscriptions = udpConfig.getConfig("subscriptions");
        ActorRef udpMetricsListener = this.buildMetricsListener(this.tickInterval(), udpFlushInterval, UdpMetricsSender$.MODULE$, this.metricsMapper(), this.config());
        ConfigTools.Syntax$.MODULE$.firstLevelKeys$extension(ConfigTools$.MODULE$.Syntax(udpSubscriptions)).foreach((Function1 & Serializable & scala.Serializable)subscriptionCategory -> {
            RiemannExtension.$anonfun$udpSubscriptions$1(this, udpSubscriptions, udpMetricsListener, subscriptionCategory);
            return BoxedUnit.UNIT;
        });
    }

    private void tcpSubscriptions() {
        Config tcpConfig = this.riemannConfig().getConfig("tcp");
        FiniteDuration tcpFlushInterval = ConfigTools.Syntax$.MODULE$.getFiniteDuration$extension(ConfigTools$.MODULE$.Syntax(tcpConfig), "flush-interval");
        Config tcpSubscriptions = tcpConfig.getConfig("subscriptions");
        ActorRef tcpMetricsListener = this.buildMetricsListener(this.tickInterval(), tcpFlushInterval, TcpMetricsSender$.MODULE$, this.metricsMapper(), this.config());
        ConfigTools.Syntax$.MODULE$.firstLevelKeys$extension(ConfigTools$.MODULE$.Syntax(tcpSubscriptions)).foreach((Function1 & Serializable & scala.Serializable)subscriptionCategory -> {
            RiemannExtension.$anonfun$tcpSubscriptions$1(this, tcpSubscriptions, tcpMetricsListener, subscriptionCategory);
            return BoxedUnit.UNIT;
        });
    }

    private ActorRef buildMetricsListener(FiniteDuration tickInterval, FiniteDuration flushInterval, MetricsSenderFactory senderFactory, String mapperClass, Config config) {
        Predef$.MODULE$.assert(flushInterval.$greater$eq((Object)tickInterval), (Function0 & Serializable & scala.Serializable)() -> "Riemann flush-interval needs to be equal or greater to the tick-interval");
        Tuple2 tuple2 = new Tuple2(Config.class, (Object)config);
        MetricsMapper metricsMapper = (MetricsMapper)this.system.dynamicAccess().createInstanceFor(mapperClass, (scala.collection.immutable.Seq)Nil$.MODULE$.$colon$colon((Object)tuple2), ClassTag$.MODULE$.apply(MetricsMapper.class)).get();
        ActorRef metricsSender = this.system.actorOf(senderFactory.props(this.riemannConfig().getString("hostname"), this.riemannConfig().getInt("port"), metricsMapper), senderFactory.name());
        FiniteDuration finiteDuration = flushInterval;
        FiniteDuration finiteDuration2 = tickInterval;
        return !(finiteDuration != null ? !finiteDuration.equals(finiteDuration2) : finiteDuration2 != null) ? metricsSender : this.system.actorOf(TickMetricSnapshotBuffer$.MODULE$.props(flushInterval, metricsSender), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"buffered-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{senderFactory.name()})));
    }

    public static final /* synthetic */ void $anonfun$udpSubscriptions$2(RiemannExtension $this, ActorRef udpMetricsListener$1, String subscriptionCategory$1, String pattern) {
        $this.metricsExtension().subscribe(subscriptionCategory$1, pattern, udpMetricsListener$1, true);
    }

    public static final /* synthetic */ void $anonfun$udpSubscriptions$1(RiemannExtension $this, Config udpSubscriptions$1, ActorRef udpMetricsListener$1, String subscriptionCategory) {
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(udpSubscriptions$1.getStringList(subscriptionCategory)).asScala()).foreach((Function1 & Serializable & scala.Serializable)pattern -> {
            RiemannExtension.$anonfun$udpSubscriptions$2($this, udpMetricsListener$1, subscriptionCategory, pattern);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$tcpSubscriptions$2(RiemannExtension $this, ActorRef tcpMetricsListener$1, String subscriptionCategory$2, String pattern) {
        $this.metricsExtension().subscribe(subscriptionCategory$2, pattern, tcpMetricsListener$1, true);
    }

    public static final /* synthetic */ void $anonfun$tcpSubscriptions$1(RiemannExtension $this, Config tcpSubscriptions$1, ActorRef tcpMetricsListener$1, String subscriptionCategory) {
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(tcpSubscriptions$1.getStringList(subscriptionCategory)).asScala()).foreach((Function1 & Serializable & scala.Serializable)pattern -> {
            RiemannExtension.$anonfun$tcpSubscriptions$2($this, tcpMetricsListener$1, subscriptionCategory, pattern);
            return BoxedUnit.UNIT;
        });
    }

    public RiemannExtension(ExtendedActorSystem system) {
        this.system = system;
        this.as = system;
        this.log = Logging$.MODULE$.apply((ActorSystem)system, RiemannExtension.class, LogSource$.MODULE$.fromAnyClass());
        this.log().info("Starting the Kamon(Riemann) extension");
        this.metricsExtension = Kamon$.MODULE$.metrics();
        this.tickInterval = this.metricsExtension().settings().tickInterval();
        this.config = system.settings().config();
        this.riemannConfig = this.config().getConfig("kamon.riemann");
        this.metricsMapper = this.riemannConfig().getString("metrics-mapper");
        this.udpSubscriptions();
        this.tcpSubscriptions();
    }
}

