/*
 * Decompiled with CFR 0.152.
 */
package kamon.statsd;

import com.typesafe.config.Config;
import kamon.Kamon$;
import kamon.statsd.MetricKeyGenerator;
import kamon.statsd.PercentEncoder$;
import kamon.tag.Tag;
import kamon.tag.Tag$;
import kamon.tag.TagSet;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001Q4A!\u0001\u0002\u0001\u000f\tA2+[7qY\u0016lU\r\u001e:jG.+\u0017pR3oKJ\fGo\u001c:\u000b\u0005\r!\u0011AB:uCR\u001cHMC\u0001\u0006\u0003\u0015Y\u0017-\\8o\u0007\u0001\u00192\u0001\u0001\u0005\u000f!\tIA\"D\u0001\u000b\u0015\u0005Y\u0011!B:dC2\f\u0017BA\u0007\u000b\u0005\u0019\te.\u001f*fMB\u0011q\u0002E\u0007\u0002\u0005%\u0011\u0011C\u0001\u0002\u0013\u001b\u0016$(/[2LKf<UM\\3sCR|'\u000f\u0003\u0005\u0014\u0001\t\u0005\t\u0015!\u0003\u0015\u00031\u0019H/\u0019;t\t\u000e{gNZ5h!\t)B$D\u0001\u0017\u0015\t9\u0002$\u0001\u0004d_:4\u0017n\u001a\u0006\u00033i\t\u0001\u0002^=qKN\fg-\u001a\u0006\u00027\u0005\u00191m\\7\n\u0005u1\"AB\"p]\u001aLw\rC\u0003 \u0001\u0011\u0005\u0001%\u0001\u0004=S:LGO\u0010\u000b\u0003C\t\u0002\"a\u0004\u0001\t\u000bMq\u0002\u0019\u0001\u000b\u0006\t\u0011\u0002\u0001!\n\u0002\u000b\u001d>\u0014X.\u00197ju\u0016\u0014\b\u0003B\u0005'Q!J!a\n\u0006\u0003\u0013\u0019+hn\u0019;j_:\f\u0004CA\u0015-\u001d\tI!&\u0003\u0002,\u0015\u00051\u0001K]3eK\u001aL!!\f\u0018\u0003\rM#(/\u001b8h\u0015\tY#\u0002C\u00041\u0001\t\u0007I\u0011A\u0019\u0002\u001d\r|gNZ5h'\u0016$H/\u001b8hgV\tA\u0003\u0003\u00044\u0001\u0001\u0006I\u0001F\u0001\u0010G>tg-[4TKR$\u0018N\\4tA!9Q\u0007\u0001b\u0001\n\u00031\u0014aC:feZL7-\u001a(b[\u0016,\u0012\u0001\u000b\u0005\u0007q\u0001\u0001\u000b\u0011\u0002\u0015\u0002\u0019M,'O^5dK:\u000bW.\u001a\u0011\t\u000fi\u0002!\u0019!C\u0001w\u0005y\u0011N\\2mk\u0012,\u0007j\\:u]\u0006lW-F\u0001=!\tIQ(\u0003\u0002?\u0015\t9!i\\8mK\u0006t\u0007B\u0002!\u0001A\u0003%A(\u0001\tj]\u000edW\u000fZ3I_N$h.Y7fA!9!\t\u0001b\u0001\n\u00031\u0014\u0001\u00035pgRt\u0017-\\3\t\r\u0011\u0003\u0001\u0015!\u0003)\u0003%Awn\u001d;oC6,\u0007\u0005C\u0004G\u0001\t\u0007I\u0011A\u001e\u0002-%t7\r\\;eK\u0016sg/\u001b:p]6,g\u000e\u001e+bONDa\u0001\u0013\u0001!\u0002\u0013a\u0014aF5oG2,H-Z#om&\u0014xN\\7f]R$\u0016mZ:!\u0011\u001dQ\u0005A1A\u0005\u0002-\u000bq\"\u001a8wSJ|g.\\3oiR\u000bwm]\u000b\u0002\u0019B\u0011Q\nU\u0007\u0002\u001d*\u0011q\nB\u0001\u0004i\u0006<\u0017BA)O\u0005\u0019!\u0016mZ*fi\"11\u000b\u0001Q\u0001\n1\u000b\u0001#\u001a8wSJ|g.\\3oiR\u000bwm\u001d\u0011\t\u000fU\u0003!\u0019!C\u0001-\u0006Qan\u001c:nC2L'0\u001a:\u0016\u0003]\u0003\"\u0001W\u0012\u000e\u0003\u0001AaA\u0017\u0001!\u0002\u00139\u0016a\u00038pe6\fG.\u001b>fe\u0002Bq\u0001\u0018\u0001C\u0002\u0013\u0005a'\u0001\no_Jl\u0017\r\\5{K\u0012Dun\u001d;oC6,\u0007B\u00020\u0001A\u0003%\u0001&A\no_Jl\u0017\r\\5{K\u0012Dun\u001d;oC6,\u0007\u0005C\u0004a\u0001\t\u0007I\u0011\u0001\u001c\u0002\u0011\t\f7/\u001a(b[\u0016DaA\u0019\u0001!\u0002\u0013A\u0013!\u00032bg\u0016t\u0015-\\3!\u0011\u0015!\u0007\u0001\"\u0003f\u0003A\u0019'/Z1uK:{'/\\1mSj,'\u000f\u0006\u0002XM\")qm\u0019a\u0001Q\u0005A1\u000f\u001e:bi\u0016<\u0017\u0010C\u0003j\u0001\u0011\u0005!.A\u0006hK:,'/\u0019;f\u0017\u0016LHc\u0001\u0015l[\")A\u000e\u001ba\u0001Q\u0005!a.Y7f\u0011\u0015q\u0007\u000e1\u0001M\u0003)iW\r\u001e:jGR\u000bwm\u001d\u0005\u0006a\u0002!I!]\u0001\u0017g>\u0014H/\u00118e\u0007>t7-\u0019;f]\u0006$X\rV1hgR\u0011\u0001F\u001d\u0005\u0006g>\u0004\r\u0001T\u0001\u0005i\u0006<7\u000f")
public class SimpleMetricKeyGenerator
implements MetricKeyGenerator {
    private final Config configSettings;
    private final String serviceName;
    private final boolean includeHostname;
    private final String hostname;
    private final boolean includeEnvironmentTags;
    private final TagSet environmentTags;
    private final Function1<String, String> normalizer;
    private final String normalizedHostname;
    private final String baseName;

    public Config configSettings() {
        return this.configSettings;
    }

    public String serviceName() {
        return this.serviceName;
    }

    public boolean includeHostname() {
        return this.includeHostname;
    }

    public String hostname() {
        return this.hostname;
    }

    public boolean includeEnvironmentTags() {
        return this.includeEnvironmentTags;
    }

    public TagSet environmentTags() {
        return this.environmentTags;
    }

    public Function1<String, String> normalizer() {
        return this.normalizer;
    }

    public String normalizedHostname() {
        return this.normalizedHostname;
    }

    public String baseName() {
        return this.baseName;
    }

    private Function1<String, String> createNormalizer(String strategy) {
        String string;
        block4: {
            Object object;
            block3: {
                block2: {
                    string = strategy;
                    if (!"percent-encode".equals(string)) break block2;
                    object = new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply(String originalString) {
                            return PercentEncoder$.MODULE$.encode(originalString);
                        }
                    };
                    break block3;
                }
                if (!"normalize".equals(string)) break block4;
                object = new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(String s) {
                        return s.replace(": ", "-").replace(":", "-").replace(" ", "_").replace("/", "_").replace(".", "_");
                    }
                };
            }
            return object;
        }
        throw new MatchError((Object)string);
    }

    @Override
    public String generateKey(String name, TagSet metricTags) {
        TagSet tags = this.includeEnvironmentTags() ? metricTags.withTags(this.environmentTags()) : metricTags;
        String stringTags = tags.nonEmpty() ? new StringBuilder().append((Object)".").append((Object)this.sortAndConcatenateTags(tags)).toString() : "";
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".", "", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.baseName(), this.normalizer().apply((Object)name), stringTags}));
    }

    private String sortAndConcatenateTags(TagSet tags) {
        return ((TraversableOnce)((TraversableLike)((TraversableLike)tags.all().sortBy((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, String> apply(Tag tag) {
                return new Tuple2((Object)tag.key(), (Object)Tag$.MODULE$.unwrapValue(tag).toString());
            }
        }, Ordering$.MODULE$.Tuple2((Ordering)Ordering.String$.MODULE$, (Ordering)Ordering.String$.MODULE$))).flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final List<String> apply(Tag tag) {
                return List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{tag.key(), Tag$.MODULE$.unwrapValue(tag).toString()}));
            }
        }, Seq$.MODULE$.canBuildFrom())).map(this.normalizer(), Seq$.MODULE$.canBuildFrom())).mkString(".");
    }

    public SimpleMetricKeyGenerator(Config statsDConfig) {
        this.configSettings = statsDConfig.getConfig("simple-metric-key-generator");
        this.serviceName = Kamon$.MODULE$.environment().service();
        this.includeHostname = this.configSettings().getBoolean("include-hostname");
        this.hostname = Kamon$.MODULE$.environment().host();
        this.includeEnvironmentTags = this.configSettings().getBoolean("include-environment-tags");
        this.environmentTags = Kamon$.MODULE$.environment().tags();
        this.normalizer = this.createNormalizer(this.configSettings().getString("metric-name-normalization-strategy"));
        this.normalizedHostname = (String)this.normalizer().apply((Object)this.hostname());
        this.baseName = this.includeHostname() ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.serviceName(), this.normalizedHostname()})) : this.serviceName();
    }
}

