/*
 * Copyright 2013-2020 The Kamon Project <https://kamon.io>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package kamon

import kamon.metric.MeasurementUnit
import kamon.metric.MeasurementUnit.{information, time}

package object statsd {
  def readTimeUnit(unit: String): MeasurementUnit = unit match {
    case "s"    => time.seconds
    case "ms"   => time.milliseconds
    case "µs"   => time.microseconds
    case "ns"   => time.nanoseconds
    case other  => sys.error(s"Invalid time unit setting [$other], the possible values are [s, ms, µs, ns]")
  }

  def readInformationUnit(unit: String): MeasurementUnit = unit match {
    case "b"    => information.bytes
    case "kb"   => information.kilobytes
    case "mb"   => information.megabytes
    case "gb"   => information.gigabytes
    case other  => sys.error(s"Invalid information unit setting [$other], the possible values are [b, kb, mb, gb]")
  }
}


